/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.client;

import com.tom.cpl.math.MatrixStack;
import com.tom.cpl.math.Vec4f;
import com.tom.cpl.render.VBuffers;
import com.tom.cpm.client.RetroGL;
import com.tom.cpm.shared.model.PlayerModelParts;
import com.tom.cpm.shared.model.RootModelType;
import com.tom.cpm.shared.model.render.ModelRenderManager;
import com.tom.cpm.shared.model.render.VanillaModelPart;
import com.tom.cpm.shared.retro.RedirectHolderRetro;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelElytra;
import net.minecraft.client.model.ModelHumanoidHead;
import net.minecraft.client.model.ModelPlayer;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GlStateManager;

public class PlayerRenderManager
extends ModelRenderManager<Void, Void, ModelRenderer, ModelBase> {
    public static final float scale = 0.0625f;

    public PlayerRenderManager() {
        this.setFactory(new ModelRenderManager.RedirectHolderFactory<Void, Void, ModelRenderer>(){

            @Override
            public <M> ModelRenderManager.RedirectHolder<?, Void, Void, ModelRenderer> create(M model, String arg) {
                if ("api".equals(arg) && model instanceof ModelBiped) {
                    return new RedirectHolderApi(PlayerRenderManager.this, (ModelBiped)model);
                }
                if (model instanceof ModelPlayer) {
                    return new RedirectHolderPlayer(PlayerRenderManager.this, (ModelPlayer)model);
                }
                if (model instanceof ModelHumanoidHead) {
                    return new RedirectHolderSkull(PlayerRenderManager.this, (ModelHumanoidHead)model);
                }
                if (model instanceof ModelElytra) {
                    return new RedirectHolderElytra(PlayerRenderManager.this, (ModelElytra)model);
                }
                if (model instanceof ModelBiped && "armor1".equals(arg)) {
                    return new RedirectHolderArmor1(PlayerRenderManager.this, (ModelBiped)model);
                }
                if (model instanceof ModelBiped && "armor2".equals(arg)) {
                    return new RedirectHolderArmor2(PlayerRenderManager.this, (ModelBiped)model);
                }
                return null;
            }
        });
        this.setRedirectFactory(new ModelRenderManager.RedirectRendererFactory<ModelBase, Void, ModelRenderer>(){

            @Override
            public ModelRenderManager.RedirectRenderer<ModelRenderer> create(ModelBase model, ModelRenderManager.RedirectHolder<ModelBase, ?, Void, ModelRenderer> access, Supplier<ModelRenderer> modelPart, VanillaModelPart part) {
                return new RedirectModelRenderer((RDH)access, modelPart, part);
            }
        });
        this.setVis(m -> m.field_78806_j, (m, v) -> {
            m.field_78806_j = v;
        });
        this.setModelPosGetters(m -> m.field_78800_c, m -> m.field_78797_d, m -> m.field_78798_e);
        this.setModelRotGetters(m -> m.field_78795_f, m -> m.field_78796_g, m -> m.field_78808_h);
        this.setModelSetters((m, x, y, z) -> {
            m.field_78800_c = x;
            m.field_78797_d = y;
            m.field_78798_e = z;
        }, (m, x, y, z) -> {
            m.field_78795_f = x;
            m.field_78796_g = y;
            m.field_78808_h = z;
        });
        this.setRenderPart(new ModelRenderer(new ModelBase(){}));
    }

    public static void multiplyStacks(MatrixStack.Entry e) {
        e.getMatrix().multiplyNative(GlStateManager::func_179110_a);
    }

    public static class QuarkList
    extends ArrayList<ModelRenderer> {
        private static final long serialVersionUID = -1148099045785217885L;

        public QuarkList(List<ModelRenderer> l) {
            super(l);
        }

        @Override
        public int indexOf(Object o) {
            if (o instanceof RedirectModelRenderer) {
                return super.indexOf(((RedirectModelRenderer)o).getParent());
            }
            return super.indexOf(o);
        }
    }

    private static class RedirectModelRenderer
    extends ModelRenderer
    implements ModelRenderManager.RedirectRenderer<ModelRenderer> {
        private final RDH holder;
        private final VanillaModelPart part;
        private final Supplier<ModelRenderer> parentProvider;
        private ModelRenderer parent;
        private VBuffers buffers;

        public RedirectModelRenderer(RDH holder, Supplier<ModelRenderer> parent, VanillaModelPart part) {
            super((ModelBase)holder.model);
            this.holder = holder;
            ((ModelBase)holder.model).field_78092_r.remove(this);
            this.parentProvider = parent;
            this.part = part;
        }

        public void func_78785_a(float scale) {
            this.buffers = new VBuffers(RetroGL::buffer);
            this.render();
            this.buffers.finishAll();
        }

        @Override
        public ModelRenderer swapIn() {
            if (this.parent != null) {
                return this;
            }
            this.parent = this.parentProvider.get();
            RedirectModelRenderer.copyModel(this.parent, this);
            return this;
        }

        @Override
        public ModelRenderer swapOut() {
            if (this.parent == null) {
                return this.parentProvider.get();
            }
            ModelRenderer p = this.parent;
            this.parent = null;
            return p;
        }

        private static void copyModel(ModelRenderer s, ModelRenderer d) {
            d.field_78800_c = s.field_78800_c;
            d.field_78797_d = s.field_78797_d;
            d.field_78798_e = s.field_78798_e;
            d.field_78795_f = s.field_78795_f;
            d.field_78796_g = s.field_78796_g;
            d.field_78808_h = s.field_78808_h;
            d.field_78806_j = s.field_78806_j;
            d.field_78807_k = s.field_78807_k;
            d.field_82906_o = s.field_82906_o;
            d.field_82908_p = s.field_82908_p;
            d.field_82907_q = s.field_82907_q;
        }

        @Override
        public ModelRenderManager.RedirectHolder<?, ?, ?, ModelRenderer> getHolder() {
            return this.holder;
        }

        @Override
        public ModelRenderer getParent() {
            return this.parent;
        }

        @Override
        public VanillaModelPart getPart() {
            return this.part;
        }

        @Override
        public void renderParent() {
            this.parent.func_78785_a(0.0625f);
        }

        @Override
        public VBuffers getVBuffers() {
            return this.buffers;
        }

        @Override
        public Vec4f getColor() {
            return RetroGL.getColor();
        }

        public void func_78794_c(float scale) {
            MatrixStack.Entry e = this.getPartTransform();
            if (e != null) {
                PlayerRenderManager.multiplyStacks(e);
            } else {
                super.func_78794_c(scale);
            }
        }
    }

    private static abstract class RDH
    extends RedirectHolderRetro<ModelBase, ModelRenderer> {
        public RDH(ModelRenderManager<Void, Void, ModelRenderer, ModelBase> mngr, ModelBase model) {
            super(mngr, model);
            model.field_78092_r = new QuarkList(model.field_78092_r);
        }
    }

    private static class RedirectHolderArmor2
    extends RDH {
        public RedirectHolderArmor2(PlayerRenderManager mngr, ModelBiped model) {
            super(mngr, (ModelBase)model);
            this.register(new ModelRenderManager.Field<ModelRenderer>(() -> model.field_78115_e, v -> {
                model.field_78115_e = v;
            }, RootModelType.ARMOR_LEGGINGS_BODY));
            this.register(new ModelRenderManager.Field<ModelRenderer>(() -> model.field_178721_j, v -> {
                model.field_178721_j = v;
            }, RootModelType.ARMOR_RIGHT_LEG));
            this.register(new ModelRenderManager.Field<ModelRenderer>(() -> model.field_178722_k, v -> {
                model.field_178722_k = v;
            }, RootModelType.ARMOR_LEFT_LEG));
        }
    }

    private static class RedirectHolderArmor1
    extends RDH {
        public RedirectHolderArmor1(PlayerRenderManager mngr, ModelBiped model) {
            super(mngr, (ModelBase)model);
            this.register(new ModelRenderManager.Field<ModelRenderer>(() -> model.field_78116_c, v -> {
                model.field_78116_c = v;
            }, RootModelType.ARMOR_HELMET));
            this.register(new ModelRenderManager.Field<ModelRenderer>(() -> model.field_78115_e, v -> {
                model.field_78115_e = v;
            }, RootModelType.ARMOR_BODY));
            this.register(new ModelRenderManager.Field<ModelRenderer>(() -> model.field_178723_h, v -> {
                model.field_178723_h = v;
            }, RootModelType.ARMOR_RIGHT_ARM));
            this.register(new ModelRenderManager.Field<ModelRenderer>(() -> model.field_178724_i, v -> {
                model.field_178724_i = v;
            }, RootModelType.ARMOR_LEFT_ARM));
            this.register(new ModelRenderManager.Field<ModelRenderer>(() -> model.field_178721_j, v -> {
                model.field_178721_j = v;
            }, RootModelType.ARMOR_RIGHT_FOOT));
            this.register(new ModelRenderManager.Field<ModelRenderer>(() -> model.field_178722_k, v -> {
                model.field_178722_k = v;
            }, RootModelType.ARMOR_LEFT_FOOT));
            this.register(new ModelRenderManager.Field<ModelRenderer>(() -> model.field_178720_f, v -> {
                model.field_178720_f = v;
            }, null));
        }
    }

    private static class RedirectHolderElytra
    extends RDH {
        public RedirectHolderElytra(PlayerRenderManager mngr, ModelElytra model) {
            super(mngr, (ModelBase)model);
            this.register(new ModelRenderManager.Field<ModelRenderer>(() -> model.field_187060_a, v -> {
                model.field_187060_a = v;
            }, RootModelType.ELYTRA_RIGHT));
            this.register(new ModelRenderManager.Field<ModelRenderer>(() -> model.field_187061_b, v -> {
                model.field_187061_b = v;
            }, RootModelType.ELYTRA_LEFT));
        }
    }

    private static class RedirectHolderSkull
    extends RDH {
        public RedirectHolderSkull(PlayerRenderManager mngr, ModelHumanoidHead model) {
            super(mngr, (ModelBase)model);
            this.register(new ModelRenderManager.Field<ModelRenderer>(() -> model.field_82896_a, v -> {
                model.field_82896_a = v;
            }, PlayerModelParts.HEAD));
            this.register(new ModelRenderManager.Field<ModelRenderer>(() -> model.field_178717_b, v -> {
                model.field_178717_b = v;
            }, null));
        }
    }

    private static class RedirectHolderApi
    extends RDH {
        private ModelRenderManager.RedirectRenderer<ModelRenderer> bipedHead = this.registerHead(new ModelRenderManager.Field<ModelRenderer>(() -> model.field_78116_c, v -> {
            model.field_78116_c = v;
        }, PlayerModelParts.HEAD));

        public RedirectHolderApi(PlayerRenderManager mngr, ModelBiped model) {
            super(mngr, (ModelBase)model);
            this.register(new ModelRenderManager.Field<ModelRenderer>(() -> model.field_78115_e, v -> {
                model.field_78115_e = v;
            }, PlayerModelParts.BODY));
            this.register(new ModelRenderManager.Field<ModelRenderer>(() -> model.field_178723_h, v -> {
                model.field_178723_h = v;
            }, PlayerModelParts.RIGHT_ARM));
            this.register(new ModelRenderManager.Field<ModelRenderer>(() -> model.field_178724_i, v -> {
                model.field_178724_i = v;
            }, PlayerModelParts.LEFT_ARM));
            this.register(new ModelRenderManager.Field<ModelRenderer>(() -> model.field_178721_j, v -> {
                model.field_178721_j = v;
            }, PlayerModelParts.RIGHT_LEG));
            this.register(new ModelRenderManager.Field<ModelRenderer>(() -> model.field_178722_k, v -> {
                model.field_178722_k = v;
            }, PlayerModelParts.LEFT_LEG));
            this.register(new ModelRenderManager.Field<ModelRenderer>(() -> model.field_178720_f, v -> {
                model.field_178720_f = v;
            }, null)).setCopyFrom(this.bipedHead);
            if (model instanceof ModelPlayer) {
                ModelPlayer mp = (ModelPlayer)model;
                this.register(new ModelRenderManager.Field<ModelRenderer>(() -> mp.field_178734_a, v -> {
                    mp.field_178734_a = v;
                }, null));
                this.register(new ModelRenderManager.Field<ModelRenderer>(() -> mp.field_178732_b, v -> {
                    mp.field_178732_b = v;
                }, null));
                this.register(new ModelRenderManager.Field<ModelRenderer>(() -> mp.field_178733_c, v -> {
                    mp.field_178733_c = v;
                }, null));
                this.register(new ModelRenderManager.Field<ModelRenderer>(() -> mp.field_178731_d, v -> {
                    mp.field_178731_d = v;
                }, null));
                this.register(new ModelRenderManager.Field<ModelRenderer>(() -> mp.field_178730_v, v -> {
                    mp.field_178730_v = v;
                }, null));
                this.register(new ModelRenderManager.Field<ModelRenderer>(() -> mp.field_178729_w, v -> {
                    mp.field_178729_w = v;
                }, RootModelType.CAPE));
            }
        }
    }

    private static class RedirectHolderPlayer
    extends RDH {
        private ModelRenderManager.RedirectRenderer<ModelRenderer> bipedHead = this.registerHead(new ModelRenderManager.Field<ModelRenderer>(() -> model.field_78116_c, v -> {
            model.field_78116_c = v;
        }, PlayerModelParts.HEAD));

        public RedirectHolderPlayer(PlayerRenderManager mngr, ModelPlayer model) {
            super(mngr, (ModelBase)model);
            this.register(new ModelRenderManager.Field<ModelRenderer>(() -> model.field_78115_e, v -> {
                model.field_78115_e = v;
            }, PlayerModelParts.BODY));
            this.register(new ModelRenderManager.Field<ModelRenderer>(() -> model.field_178723_h, v -> {
                model.field_178723_h = v;
            }, PlayerModelParts.RIGHT_ARM));
            this.register(new ModelRenderManager.Field<ModelRenderer>(() -> model.field_178724_i, v -> {
                model.field_178724_i = v;
            }, PlayerModelParts.LEFT_ARM));
            this.register(new ModelRenderManager.Field<ModelRenderer>(() -> model.field_178721_j, v -> {
                model.field_178721_j = v;
            }, PlayerModelParts.RIGHT_LEG));
            this.register(new ModelRenderManager.Field<ModelRenderer>(() -> model.field_178722_k, v -> {
                model.field_178722_k = v;
            }, PlayerModelParts.LEFT_LEG));
            this.register(new ModelRenderManager.Field<ModelRenderer>(() -> model.field_178720_f, v -> {
                model.field_178720_f = v;
            }, null)).setCopyFrom(this.bipedHead);
            this.register(new ModelRenderManager.Field<ModelRenderer>(() -> model.field_178734_a, v -> {
                model.field_178734_a = v;
            }, null));
            this.register(new ModelRenderManager.Field<ModelRenderer>(() -> model.field_178732_b, v -> {
                model.field_178732_b = v;
            }, null));
            this.register(new ModelRenderManager.Field<ModelRenderer>(() -> model.field_178733_c, v -> {
                model.field_178733_c = v;
            }, null));
            this.register(new ModelRenderManager.Field<ModelRenderer>(() -> model.field_178731_d, v -> {
                model.field_178731_d = v;
            }, null));
            this.register(new ModelRenderManager.Field<ModelRenderer>(() -> model.field_178730_v, v -> {
                model.field_178730_v = v;
            }, null));
            this.register(new ModelRenderManager.Field<ModelRenderer>(() -> model.field_178729_w, v -> {
                model.field_178729_w = v;
            }, RootModelType.CAPE));
        }
    }
}

