/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.common;

import com.tom.cpm.shared.network.NetHandler;
import com.tom.cpm.shared.util.ScalingOptions;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayerMP;

public class AttributeScaler
implements NetHandler.ScalerInterface<EntityPlayerMP, List<IAttribute>> {
    private static final UUID CPM_ATTR_UUID = UUID.fromString("24bba381-9615-4530-8fcf-4fc42393a4b5");

    @Override
    public void setScale(List<IAttribute> key, EntityPlayerMP player, float value) {
        key.forEach(a -> {
            IAttributeInstance ai = player.func_110140_aT().func_111151_a(a);
            if (ai != null) {
                ai.func_188479_b(CPM_ATTR_UUID);
                if (Math.abs(value - 1.0f) > 0.01f) {
                    ai.func_111121_a(new AttributeModifier(CPM_ATTR_UUID, "cpm", (double)(value - 1.0f), 1).func_111168_a(false));
                }
            }
        });
    }

    @Override
    public List<IAttribute> toKey(ScalingOptions opt) {
        switch (opt) {
            case HEALTH: {
                return Collections.singletonList(SharedMonsterAttributes.field_111267_a);
            }
            case ATTACK_DMG: {
                return Collections.singletonList(SharedMonsterAttributes.field_111264_e);
            }
            case ATTACK_SPEED: {
                return Collections.singletonList(SharedMonsterAttributes.field_188790_f);
            }
            case DEFENSE: {
                return Collections.singletonList(SharedMonsterAttributes.field_188791_g);
            }
            case MOB_VISIBILITY: {
                return Collections.singletonList(SharedMonsterAttributes.field_111265_b);
            }
            case MOTION: {
                return Collections.singletonList(SharedMonsterAttributes.field_111263_d);
            }
            case KNOCKBACK_RESIST: {
                return Collections.singletonList(SharedMonsterAttributes.field_111266_c);
            }
            case REACH: {
                return Collections.singletonList(EntityPlayerMP.REACH_DISTANCE);
            }
        }
        return null;
    }

    @Override
    public String getMethodName() {
        return "attribute";
    }
}

