/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.common;

import com.tom.cpl.block.Biome;
import com.tom.cpl.block.BiomeHandler;
import com.tom.cpm.common.ItemStackHandlerImpl;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class BiomeHandlerImpl
extends BiomeHandler<net.minecraft.world.biome.Biome> {
    public static final BiomeHandlerImpl impl = new BiomeHandlerImpl();

    @Override
    public List<Biome> listNativeEntries(String tag) {
        ResourceLocation rl = ItemStackHandlerImpl.tryParse(tag);
        net.minecraft.world.biome.Biome b = (net.minecraft.world.biome.Biome)ForgeRegistries.BIOMES.getValue(rl);
        if (b != null) {
            return Collections.singletonList(this.wrap(b));
        }
        return Collections.emptyList();
    }

    @Override
    public List<String> listNativeTags() {
        return Collections.emptyList();
    }

    @Override
    public Biome emptyObject() {
        return this.wrap(null);
    }

    @Override
    public boolean isInTag(String tag, net.minecraft.world.biome.Biome state) {
        return this.getBiomeId(state).equals(tag);
    }

    @Override
    public List<String> listTags(net.minecraft.world.biome.Biome state) {
        return Collections.emptyList();
    }

    @Override
    public List<Biome> getAllElements() {
        return ForgeRegistries.BIOMES.getValuesCollection().stream().map(this::wrap).collect(Collectors.toList());
    }

    @Override
    public boolean equals(net.minecraft.world.biome.Biome a, net.minecraft.world.biome.Biome b) {
        return a == b;
    }

    @Override
    public String getBiomeId(net.minecraft.world.biome.Biome state) {
        return ForgeRegistries.BIOMES.getKey((IForgeRegistryEntry)state).toString();
    }

    @Override
    public float getTemperature(net.minecraft.world.biome.Biome state) {
        return state.func_185353_n();
    }

    @Override
    public float getHumidity(net.minecraft.world.biome.Biome state) {
        return state.func_76727_i();
    }

    @Override
    public BiomeHandler.RainType getRainType(net.minecraft.world.biome.Biome state) {
        return state.func_150559_j() ? BiomeHandler.RainType.SNOW : (state.func_76738_d() ? BiomeHandler.RainType.RAIN : BiomeHandler.RainType.NONE);
    }

    @Override
    public boolean isAvailable() {
        return true;
    }
}

