/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.parts.anim;

import com.tom.cpm.shared.animation.AnimationRegistry;
import com.tom.cpm.shared.animation.AnimationTrigger;
import com.tom.cpm.shared.animation.AnimationType;
import com.tom.cpm.shared.animation.IAnimation;
import com.tom.cpm.shared.animation.IPose;
import com.tom.cpm.shared.animation.VanillaPose;
import com.tom.cpm.shared.io.IOHelper;
import com.tom.cpm.shared.parts.anim.AnimLoaderState;
import com.tom.cpm.shared.parts.anim.StageType;
import com.tom.cpm.shared.parts.anim.TagType;
import java.io.IOException;
import java.util.Collections;
import java.util.List;

public class SerializedTrigger {
    public static final int LAYER_CTRL = 1;
    public static final int LOOPING = 2;
    public static final int BITMASK = 4;
    public static final int PARAM_INTERPOLATE = 8;
    public static final int MUST_FINISH = 16;
    private boolean init;
    public StageType stage;
    public int stagingID = -1;
    public AnimationType anim;
    public VanillaPose pose;
    public boolean looping;
    public boolean layerCtrl;
    public int parameter = -1;
    public int value;
    public int gid = -1;
    public boolean bitMask;
    public boolean parameterInterpolate;
    public boolean mustFinish;

    public static void newTrigger(IOHelper block, AnimLoaderState state) throws IOException {
        SerializedTrigger t = new SerializedTrigger();
        state.newTrigger(t);
    }

    public static void initBuiltin(IOHelper block, AnimLoaderState state) throws IOException {
        SerializedTrigger t = state.getTrigger();
        t.pose = (VanillaPose)block.readEnum(VanillaPose.values());
        t.anim = AnimationType.POSE;
        int flags = block.read();
        t.mustFinish = (flags & 0x10) != 0;
        t.looping = true;
        t.init = true;
    }

    public static void initNamed(IOHelper block, AnimLoaderState state) throws IOException {
        SerializedTrigger cT = state.getTrigger();
        cT.anim = (AnimationType)block.readEnum(AnimationType.VALUES);
        cT.parameter = cT.anim == AnimationType.GESTURE ? 1 : 0;
        int flags = block.read();
        cT.layerCtrl = (flags & 1) != 0;
        cT.looping = (flags & 2) != 0;
        cT.mustFinish = (flags & 0x10) != 0;
        cT.value = block.readUnsignedByte();
        if (cT.layerCtrl) {
            cT.gid = block.read();
        }
        cT.init = true;
    }

    public static void initParameter(IOHelper block, AnimLoaderState state) throws IOException {
        SerializedTrigger cT = state.getTrigger();
        cT.anim = (AnimationType)block.readEnum(AnimationType.VALUES);
        int flags = block.read();
        cT.looping = (flags & 2) != 0;
        cT.bitMask = (flags & 4) != 0;
        cT.parameterInterpolate = (flags & 8) != 0;
        cT.mustFinish = (flags & 0x10) != 0;
        cT.parameter = block.readVarInt();
        cT.value = block.readUnsignedByte();
        cT.init = true;
    }

    public static void initStaged(IOHelper block, AnimLoaderState state) throws IOException {
        SerializedTrigger cT = state.getTrigger();
        cT.anim = AnimationType.SETUP;
        cT.stage = (StageType)block.readEnum(StageType.values());
        cT.stagingID = block.readVarInt();
        int flags = block.read();
        cT.mustFinish = (flags & 0x10) != 0;
        cT.init = true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void write(IOHelper dout) throws IOException {
        IOHelper d = dout.writeNextObjectBlock(TagType.NEW_TRIGGER);
        if (d != null) {
            d.close();
        }
        if (this.pose != null) {
            d = dout.writeNextObjectBlock(TagType.INIT_BUILTIN_TRIGGER);
            try {
                d.writeEnum(this.pose);
                int flags = 0;
                if (this.mustFinish) {
                    flags |= 0x10;
                }
                d.write(flags);
                return;
            }
            finally {
                if (d != null) {
                    d.close();
                }
            }
        }
        if (this.anim == AnimationType.POSE || this.anim == AnimationType.GESTURE) {
            d = dout.writeNextObjectBlock(TagType.INIT_NAMED_TRIGGER);
            try {
                d.writeEnum(this.anim);
                int flags = 0;
                if (this.bitMask) {
                    flags |= 4;
                }
                if (this.looping) {
                    flags |= 2;
                }
                if (this.layerCtrl) {
                    flags |= 1;
                }
                if (this.mustFinish) {
                    flags |= 0x10;
                }
                d.write(flags);
                d.write(this.value);
                if (!this.layerCtrl) return;
                d.write(this.gid);
                return;
            }
            finally {
                if (d != null) {
                    d.close();
                }
            }
        }
        if (this.parameter != -1) {
            d = dout.writeNextObjectBlock(TagType.INIT_PARAMETER_TRIGGER);
            try {
                d.writeEnum(this.anim);
                int flags = 0;
                if (this.bitMask) {
                    flags |= 4;
                }
                if (this.looping) {
                    flags |= 2;
                }
                if (this.parameterInterpolate) {
                    flags |= 8;
                }
                if (this.mustFinish) {
                    flags |= 0x10;
                }
                d.write(flags);
                d.writeVarInt(this.parameter);
                d.write(this.value);
                return;
            }
            finally {
                if (d != null) {
                    d.close();
                }
            }
        }
        if (this.stage == null) return;
        d = dout.writeNextObjectBlock(TagType.INIT_STAGED_TRIGGER);
        try {
            d.writeEnum(this.stage);
            d.writeVarInt(this.stagingID);
            int flags = 0;
            if (this.mustFinish) {
                flags |= 0x10;
            }
            d.write(flags);
            return;
        }
        finally {
            if (d != null) {
                d.close();
            }
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.anim == null ? 0 : this.anim.hashCode());
        result = 31 * result + this.stagingID;
        result = 31 * result + this.parameter;
        result = 31 * result + this.value;
        result = 31 * result + (this.bitMask ? 1 : 0);
        result = 31 * result + (this.pose == null ? 0 : this.pose.hashCode());
        result = 31 * result + (this.stage == null ? 0 : this.stage.hashCode());
        result = 31 * result + this.stagingID;
        result = 31 * result + (this.mustFinish ? 1 : 0);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SerializedTrigger other = (SerializedTrigger)obj;
        if (this.anim != other.anim) {
            return false;
        }
        if (this.stagingID != other.stagingID) {
            return false;
        }
        if (this.stage != other.stage) {
            return false;
        }
        if (this.parameter != other.parameter) {
            return false;
        }
        if (this.value != other.value) {
            return false;
        }
        if (this.bitMask != other.bitMask) {
            return false;
        }
        if (this.mustFinish != other.mustFinish) {
            return false;
        }
        return !(this.pose == null ? other.pose != null : !this.pose.equals(other.pose));
    }

    public AnimationTrigger compileStaging(AnimationRegistry reg, List<IAnimation> animations) {
        return new AnimationTrigger(reg, Collections.singleton(VanillaPose.GLOBAL), this.pose, animations, this.looping, this.mustFinish);
    }

    public AnimationTrigger compile(AnimationRegistry reg, List<IAnimation> animations) {
        IPose p;
        switch (this.anim) {
            case CUSTOM_POSE: {
                p = reg.getPoseById(this.value, null);
                break;
            }
            case POSE: {
                p = this.pose;
                break;
            }
            case SETUP: 
            case FINISH: {
                return null;
            }
            case LAYER: {
                return new AnimationTrigger.LayerTrigger(reg, Collections.singleton(VanillaPose.GLOBAL), animations, this.parameter, this.value, this.bitMask, this.mustFinish);
            }
            case VALUE_LAYER: {
                return new AnimationTrigger.ValueTrigger(reg, Collections.singleton(VanillaPose.GLOBAL), animations, this.parameter, this.parameterInterpolate);
            }
            case GESTURE: {
                return new AnimationTrigger.GestureTrigger(reg, Collections.singleton(VanillaPose.GLOBAL), animations, this.value, this.gid, this.looping, this.mustFinish);
            }
            default: {
                p = VanillaPose.GLOBAL;
            }
        }
        if (p == null) {
            return null;
        }
        return new AnimationTrigger(reg, Collections.singleton(p), this.pose, animations, this.looping, this.mustFinish);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Trigger");
        if (this.pose != null) {
            sb.append(" Pose ");
            sb.append(this.pose.name());
        } else if (this.parameter != -1) {
            sb.append(" ");
            sb.append(this.anim.name());
            sb.append("\n\tParameter: ");
            sb.append(this.parameter);
            if (this.bitMask) {
                sb.append(" & ");
            } else {
                sb.append(" == ");
            }
            sb.append(this.value);
            if (this.bitMask) {
                sb.append(" == 0");
            }
            sb.append(" ");
            sb.append(this.looping);
        } else if (this.stage != null) {
            sb.append(" ");
            sb.append(this.stage.name());
            sb.append(" ");
            sb.append(this.stagingID);
            sb.append(" Staged");
        }
        return sb.toString();
    }
}

