/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.common;

import com.tom.cpm.common.AttributeScaler;
import com.tom.cpm.common.ByteArrayPayload;
import com.tom.cpm.common.PlayerAnimUpdater;
import com.tom.cpm.shared.network.NetHandler;
import java.util.Collections;
import java.util.function.Function;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.ClientboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.server.network.ServerPlayerConnection;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public class ServerHandlerBase {
    public static NetHandler<CustomPacketPayload.Type<ByteArrayPayload>, ServerPlayer, ServerGamePacketListenerImpl> init() {
        NetHandler<CustomPacketPayload.Type<ByteArrayPayload>, ServerPlayer, ServerGamePacketListenerImpl> netHandler = new NetHandler<CustomPacketPayload.Type<ByteArrayPayload>, ServerPlayer, ServerGamePacketListenerImpl>((k, v) -> new CustomPacketPayload.Type(new ResourceLocation(k, v)));
        netHandler.setGetPlayerUUID(Entity::getUUID);
        netHandler.setSendPacketServer(Function.identity(), (c, rl, pb) -> c.send((Packet)new ClientboundCustomPayloadPacket((CustomPacketPayload)new ByteArrayPayload((CustomPacketPayload.Type<ByteArrayPayload>)rl, (byte[])pb))), ent -> {
            ChunkMap.TrackedEntity tr = (ChunkMap.TrackedEntity)((ServerLevel)ent.level()).getChunkSource().chunkMap.entityMap.get(ent.getId());
            if (tr != null) {
                return tr.seenBy;
            }
            return Collections.emptyList();
        }, ServerPlayerConnection::getPlayer);
        netHandler.setFindTracking((p, f) -> {
            for (ChunkMap.TrackedEntity tr : ((ServerLevel)p.level()).getChunkSource().chunkMap.entityMap.values()) {
                if (!(tr.entity instanceof Player) || !tr.seenBy.contains(p.connection)) continue;
                f.accept((ServerPlayer)tr.entity);
            }
        });
        netHandler.setSendChat((p, m) -> p.displayClientMessage((Component)m.remap(), false));
        netHandler.setGetNet(spe -> spe.connection);
        netHandler.setGetPlayer(net -> net.player);
        netHandler.setGetPlayerId(Entity::getId);
        netHandler.setKickPlayer((p, m) -> p.connection.disconnect((Component)m.remap()));
        netHandler.setGetPlayerAnimGetters(new PlayerAnimUpdater());
        netHandler.addScaler(new AttributeScaler());
        return netHandler;
    }
}

