/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.config;

import com.tom.cpl.config.ConfigEntry;
import com.tom.cpm.shared.config.ConfigKeys;
import com.tom.cpm.shared.config.PlayerSpecificConfigKey;
import java.util.HashMap;
import java.util.Map;

public enum BuiltInSafetyProfiles {
    OFF(ConfigKeys.ENABLE_MODEL_LOADING, true, ConfigKeys.ENABLE_ANIMATED_TEXTURES, true, ConfigKeys.MAX_TEX_SHEET_SIZE, 8192, ConfigKeys.MAX_LINK_SIZE, 262144, ConfigKeys.MAX_CUBE_COUNT, Integer.MAX_VALUE),
    LOW(ConfigKeys.ENABLE_MODEL_LOADING, true, ConfigKeys.ENABLE_ANIMATED_TEXTURES, true, ConfigKeys.MAX_TEX_SHEET_SIZE, 512, ConfigKeys.MAX_LINK_SIZE, 1024, ConfigKeys.MAX_CUBE_COUNT, 1024),
    MEDIUM(ConfigKeys.ENABLE_MODEL_LOADING, true, ConfigKeys.ENABLE_ANIMATED_TEXTURES, false, ConfigKeys.MAX_TEX_SHEET_SIZE, 256, ConfigKeys.MAX_LINK_SIZE, 100, ConfigKeys.MAX_CUBE_COUNT, 256),
    HIGH(ConfigKeys.ENABLE_MODEL_LOADING, false, ConfigKeys.ENABLE_ANIMATED_TEXTURES, false, ConfigKeys.MAX_TEX_SHEET_SIZE, 0, ConfigKeys.MAX_LINK_SIZE, 0, ConfigKeys.MAX_CUBE_COUNT, 0),
    CUSTOM(new Object[0]);

    private final Map<String, Object> str2data = new HashMap<String, Object>();
    private final Map<PlayerSpecificConfigKey<?>, Object> key2data = new HashMap();
    public static final BuiltInSafetyProfiles[] VALUES;

    private BuiltInSafetyProfiles(Object ... dataIn) {
        if (dataIn.length > 0) {
            for (int i = 0; i < dataIn.length; i += 2) {
                PlayerSpecificConfigKey key = (PlayerSpecificConfigKey)dataIn[i];
                Object v = dataIn[i + 1];
                this.str2data.put(key.getName(), v);
                this.key2data.put(key, v);
            }
            for (PlayerSpecificConfigKey k : ConfigKeys.SAFETY_KEYS) {
                if (this.str2data.containsKey(k.getName())) continue;
                throw new RuntimeException("Missing value for '" + k.getName() + "' in '" + String.valueOf((Object)this) + "'");
            }
        }
    }

    public static BuiltInSafetyProfiles get(String name) {
        for (int i = 0; i < VALUES.length; ++i) {
            BuiltInSafetyProfiles v = VALUES[i];
            if (!v.name().equalsIgnoreCase(name)) continue;
            return v;
        }
        return null;
    }

    public <V> V getValue(String name) {
        return (V)this.str2data.get(name);
    }

    public void copyTo(ConfigEntry ce) {
        this.key2data.forEach((k, v) -> BuiltInSafetyProfiles.copyTo$setValue(ce, k, v));
    }

    private static <T> void copyTo$setValue(ConfigEntry ce, PlayerSpecificConfigKey<T> key, Object value) {
        key.setValue(ce, value);
    }

    static {
        VALUES = BuiltInSafetyProfiles.values();
    }
}

