/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.parts.anim.menu;

import com.tom.cpm.shared.MinecraftClientAccess;
import com.tom.cpm.shared.animation.AnimationEngine;
import com.tom.cpm.shared.config.ModConfig;
import com.tom.cpm.shared.config.Player;
import com.tom.cpm.shared.io.IOHelper;
import com.tom.cpm.shared.network.ServerCaps;
import com.tom.cpm.shared.parts.anim.AnimLoaderState;
import com.tom.cpm.shared.parts.anim.menu.AbstractGestureButtonData;
import com.tom.cpm.shared.parts.anim.menu.CommandAction;
import com.tom.cpm.shared.parts.anim.menu.GestureButtonType;
import com.tom.cpm.shared.parts.anim.menu.SimpleParameterValueAction;
import com.tom.cpm.shared.parts.anim.menu.SkinLayerParameterValueAction;
import java.io.IOException;

public class CustomPoseGestureButtonData
extends AbstractGestureButtonData.AbstractCommandTriggerableData {
    private boolean pose;
    public int id;
    public int gid;
    private CommandAction action;
    public int gestureTimeout;

    public CustomPoseGestureButtonData(boolean pose) {
        this.pose = pose;
    }

    @Override
    protected void parseData(IOHelper block, AnimLoaderState state) throws IOException {
        super.parseData(block, state);
        this.id = block.read();
        if (this.layerCtrl) {
            this.gid = block.read();
        }
        if (!this.pose) {
            this.gestureTimeout = block.readVarInt();
        }
    }

    @Override
    public void onRegistered() {
        super.onRegistered();
        if (this.layerCtrl) {
            this.action = new SkinLayerParameterValueAction(this.name, this.def, this.pose ? 0 : 1, this.id, this.pose, this.gid, this.command);
            this.commandActions.add(this.action);
        } else {
            this.action = new SimpleParameterValueAction(this.name, this.pose ? 0 : 1, this.id, this.command);
            this.commandActions.add(this.action);
        }
    }

    @Override
    public GestureButtonType getType() {
        return this.pose ? GestureButtonType.POSE : GestureButtonType.GESTURE;
    }

    @Override
    public void write(IOHelper block) throws IOException {
        super.write(block);
        block.write(this.id);
        if (this.layerCtrl) {
            block.write(this.gid);
        }
        if (!this.pose) {
            block.writeVarInt(this.gestureTimeout);
        }
    }

    public static CustomPoseGestureButtonData pose() {
        return new CustomPoseGestureButtonData(true);
    }

    public static CustomPoseGestureButtonData gesture() {
        return new CustomPoseGestureButtonData(false);
    }

    public boolean isPose() {
        return this.pose;
    }

    public void activate() {
        this.setValue(-1);
    }

    private void setValue(int val) {
        MinecraftClientAccess.ServerStatus status = MinecraftClientAccess.get().getServerSideStatus();
        if (status == MinecraftClientAccess.ServerStatus.OFFLINE || status == MinecraftClientAccess.ServerStatus.UNAVAILABLE) {
            return;
        }
        if (MinecraftClientAccess.get().getNetHandler().hasServerCap(ServerCaps.GESTURES)) {
            this.action.setValue(val);
        } else if (this.layerCtrl) {
            Player<?> pl = this.def.getPlayerObj();
            int id = val == 0 || val == -1 && pl.animState.encodedState == this.gid ? (this.pose ? this.def.getAnimations().getPoseResetId() : this.def.getAnimations().getBlankGesture()) : this.gid;
            MinecraftClientAccess.get().setEncodedGesture(id);
        }
        if (this.gestureTimeout > 0 && ModConfig.getCommonConfig().getBoolean("gestureAutoReset", true)) {
            AnimationEngine an = MinecraftClientAccess.get().getPlayerRenderManager().getAnimationEngine();
            an.setGestureTimeout(this.gestureTimeout);
        }
    }

    @Override
    public void onKeybind(String arg, boolean press, boolean toggleMode) {
        if (toggleMode) {
            this.setValue(-1);
        } else {
            this.setValue(press ? 1 : 0);
        }
    }

    @Override
    public String getKeybindId() {
        return (this.pose ? "p" : "g") + this.name;
    }
}

