/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.editor.gui.popup;

import com.tom.cpl.gui.IGui;
import com.tom.cpl.gui.elements.Button;
import com.tom.cpl.gui.elements.PopupPanel;
import com.tom.cpl.math.Box;
import com.tom.cpl.util.EmbeddedLocalization;
import com.tom.cpl.util.MarkdownRenderer;
import com.tom.cpm.shared.config.ModConfig;
import com.tom.cpm.shared.editor.gui.EditorGui;
import com.tom.cpm.shared.editor.gui.popup.WikiBrowserPopup;
import com.tom.cpm.shared.gui.panel.MouseControlsPanel;
import com.tom.cpm.shared.util.MdResourceLoader;
import java.util.Arrays;

public class FirstStartPopup
extends PopupPanel {
    private MarkdownRenderer mdr;
    private boolean loaded;

    public FirstStartPopup(IGui gui) {
        super(gui);
        this.mdr = new MarkdownRenderer(gui, new MdResourceLoader(gui::openURL, null, false), "Loading"){

            @Override
            public void browse(String url) {
                if (FirstStartPopup.this.loaded) {
                    if (url.startsWith("https://github.com/tom5454/CustomPlayerModels/wiki")) {
                        this.gui.getFrame().openPopup(new WikiBrowserPopup(this.gui, url));
                    } else {
                        this.gui.openURL(url);
                    }
                } else {
                    super.browse(url);
                }
            }
        };
        this.addElement(this.mdr.setBounds(new Box(5, 5, 100, 100)));
        this.mdr.registerCustomElement("mouseControls", (r, c, a) -> {
            MouseControlsPanel mcp = new MouseControlsPanel(gui, ModConfig.getCommonConfig());
            mcp.setBounds(c.bounds(5, 0, 250, 120));
            c.y += 120;
            return Arrays.asList(mcp);
        });
        this.mdr.registerCustomElement("guiScale", (r, c, a) -> {
            Button guiScale = new Button(gui, gui.i18nFormat("button.cpm.config.scale", this.getScale()), null);
            guiScale.setAction(() -> {
                int scale = ModConfig.getCommonConfig().getInt("editorScale", -1) + 1;
                if (scale >= gui.getMaxScale()) {
                    scale = gui.canScaleVanilla() ? -1 : 0;
                }
                ModConfig.getCommonConfig().setInt("editorScale", scale);
                try {
                    EditorGui.rescaleGui = false;
                    gui.setScale(scale);
                    guiScale.setText(gui.i18nFormat("button.cpm.config.scale", this.getScale()));
                }
                finally {
                    EditorGui.rescaleGui = true;
                }
            });
            guiScale.setBounds(c.bounds(5, 0, 250, 20));
            c.y += 25;
            return Arrays.asList(guiScale);
        });
        this.mdr.browse(EmbeddedLocalization.getLocalizedWikiPage(gui, "https://github.com/tom5454/CustomPlayerModels/wiki/FirstStartGuide"));
        this.loaded = true;
        this.onInit();
    }

    @Override
    public void onInit() {
        Box b = this.gui.getFrame().getBounds();
        int w = b.w * 2 / 3;
        int h = b.h * 3 / 4;
        this.setBounds(new Box(0, 0, w, h));
        this.mdr.setBounds(new Box(5, 5, w - 10, h - 10));
    }

    @Override
    public String getTitle() {
        return this.gui.i18nFormat("label.cpm.firstStart.title", new Object[0]);
    }

    @Override
    public void onClosed() {
        this.mdr.cleanup();
        ModConfig.getCommonConfig().save();
    }

    private String getScale() {
        int scale = ModConfig.getCommonConfig().getInt("editorScale", this.gui.canScaleVanilla() ? -1 : 0);
        return scale == -1 ? this.gui.i18nFormat("button.cpm.config.scale.vanilla", new Object[0]) : (scale == 0 ? this.gui.i18nFormat("button.cpm.config.scale.auto", new Object[0]) : Integer.toString(scale));
    }
}

