/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.client;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.tom.cpl.text.FormatText;
import com.tom.cpm.CommonProxy;
import com.tom.cpm.CustomPlayerModels;
import com.tom.cpm.client.GuiImpl;
import com.tom.cpm.client.KeyBindings;
import com.tom.cpm.client.MinecraftObject;
import com.tom.cpm.client.PlayerProfile;
import com.tom.cpm.common.Command;
import com.tom.cpm.common.PlayerAnimUpdater;
import com.tom.cpm.lefix.FixSSL;
import com.tom.cpm.shared.config.ModConfig;
import com.tom.cpm.shared.config.Player;
import com.tom.cpm.shared.definition.ModelDefinition;
import com.tom.cpm.shared.editor.gui.EditorGui;
import com.tom.cpm.shared.gui.GestureGui;
import com.tom.cpm.shared.model.RenderManager;
import com.tom.cpm.shared.model.TextureSheetType;
import com.tom.cpm.shared.network.NetHandler;
import io.netty.buffer.Unpooled;
import java.util.concurrent.Executor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiCustomizeSkin;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiSelectWorld;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelPlayer;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.client.C17PacketCustomPayload;
import net.minecraft.scoreboard.ScoreObjective;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraft.scoreboard.Team;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.ClientCommandHandler;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.lwjgl.opengl.GL11;

public class ClientProxy
extends CommonProxy {
    public static final ResourceLocation DEFAULT_CAPE = new ResourceLocation("cpm:textures/template/cape.png");
    public static MinecraftObject mc;
    private Minecraft minecraft;
    public static ClientProxy INSTANCE;
    public RenderManager<GameProfile, EntityPlayer, ModelBase, Void> manager;
    public NetHandler<ResourceLocation, EntityPlayer, NetHandlerPlayClient> netHandler;

    @Override
    public void init() {
        super.init();
        FixSSL.fixup();
        INSTANCE = this;
        this.minecraft = Minecraft.func_71410_x();
        mc = new MinecraftObject(this.minecraft);
        MinecraftForge.EVENT_BUS.register((Object)this);
        KeyBindings.init();
        this.manager = new RenderManager<GameProfile, EntityPlayer, ModelBase, Void>(mc.getPlayerRenderManager(), mc.getDefinitionLoader(), PlayerProfile::getPlayerProfile);
        this.manager.setGPGetters(GameProfile::getProperties, Property::getValue);
        this.netHandler = new NetHandler(ResourceLocation::new);
        Executor ex = arg_0 -> ((Minecraft)this.minecraft).func_152344_a(arg_0);
        this.netHandler.setExecutor(() -> ex);
        this.netHandler.setSendPacketClient(d -> new PacketBuffer(Unpooled.wrappedBuffer((byte[])d)), (c, rl, pb) -> c.func_147297_a((Packet)new C17PacketCustomPayload(rl.toString(), pb)));
        this.netHandler.setPlayerToLoader(EntityPlayer::func_146103_bH);
        this.netHandler.setGetPlayerById(id -> {
            Entity ent = Minecraft.func_71410_x().field_71441_e.func_73045_a(id);
            if (ent instanceof EntityPlayer) {
                return (AbstractClientPlayer)ent;
            }
            return null;
        });
        this.netHandler.setGetClient(() -> this.minecraft.field_71439_g);
        this.netHandler.setGetNet(c -> ((EntityPlayerSP)c).field_71174_a);
        this.netHandler.setDisplayText(f -> this.minecraft.field_71456_v.func_146158_b().func_146227_a((IChatComponent)f.remap()));
        this.netHandler.setGetPlayerAnimGetters(new PlayerAnimUpdater());
        new Command(arg_0 -> ((ClientCommandHandler)ClientCommandHandler.instance).func_71560_a(arg_0), true);
    }

    @Override
    public void apiInit() {
        CustomPlayerModels.api.buildClient().voicePlayer(EntityPlayer.class, Entity::func_110124_au).localModelApi(GameProfile::new).renderApi(ModelBase.class, GameProfile.class).init();
    }

    @SubscribeEvent
    public void playerRenderPre(RenderPlayerEvent.Pre event) {
        this.manager.bindPlayer(event.entityPlayer, null, (ModelBase)event.renderer.func_177087_b());
        this.manager.bindSkin((ModelBase)event.renderer.func_177087_b(), TextureSheetType.SKIN);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    public void playerRenderPreC(RenderPlayerEvent.Pre event) {
        if (event.isCanceled()) {
            this.manager.unbindClear((ModelBase)event.renderer.func_177087_b());
        }
    }

    @SubscribeEvent
    public void playerRenderPost(RenderPlayerEvent.Post event) {
        this.manager.unbindClear((ModelBase)event.renderer.func_177087_b());
    }

    @SubscribeEvent
    public void initGui(GuiScreenEvent.InitGuiEvent.Post evt) {
        if (evt.gui instanceof GuiMainMenu && ModConfig.getCommonConfig().getSetBoolean("titleScreenButton", true) || evt.gui instanceof GuiCustomizeSkin) {
            evt.buttonList.add(new Button(0, 0));
        }
    }

    @SubscribeEvent
    public void buttonPress(GuiScreenEvent.ActionPerformedEvent.Pre evt) {
        if (evt.button instanceof Button) {
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiImpl(EditorGui::new, evt.gui));
        }
    }

    @SubscribeEvent
    public void openGui(GuiOpenEvent openGui) {
        if (openGui.gui == null && this.minecraft.field_71462_r instanceof GuiImpl.Overlay) {
            openGui.gui = ((GuiImpl.Overlay)this.minecraft.field_71462_r).getGui();
        }
        if (openGui.gui instanceof GuiMainMenu && !(this.minecraft.field_71462_r instanceof GuiSelectWorld) && !(this.minecraft.field_71462_r instanceof GuiMainMenu) && EditorGui.doOpenEditor()) {
            openGui.gui = new GuiImpl(EditorGui::new, openGui.gui);
        }
        if (openGui.gui instanceof GuiImpl) {
            ((GuiImpl)openGui.gui).onOpened();
        }
    }

    @SubscribeEvent
    public void drawGuiPre(GuiScreenEvent.DrawScreenEvent.Pre evt) {
        PlayerProfile.inGui = true;
    }

    @SubscribeEvent
    public void drawGuiPost(GuiScreenEvent.DrawScreenEvent.Post evt) {
        PlayerProfile.inGui = false;
    }

    public void renderSkull(ModelBase skullModel, GameProfile profile) {
        this.manager.bindSkull(profile, null, skullModel);
        this.manager.bindSkin(skullModel, TextureSheetType.SKIN);
    }

    public void renderArmor(ModelBase modelArmor, ModelBase modelLeggings, ModelBiped player) {
        this.manager.bindArmor((ModelBase)player, modelArmor, 1);
        this.manager.bindArmor((ModelBase)player, modelLeggings, 2);
        this.manager.bindSkin(modelArmor, TextureSheetType.ARMOR1);
        this.manager.bindSkin(modelLeggings, TextureSheetType.ARMOR2);
    }

    @SubscribeEvent
    public void renderTick(TickEvent.RenderTickEvent evt) {
        if (evt.phase == TickEvent.Phase.START) {
            mc.getPlayerRenderManager().getAnimationEngine().update(evt.renderTickTime);
        }
    }

    @SubscribeEvent
    public void clientTick(TickEvent.ClientTickEvent evt) {
        if (evt.phase == TickEvent.Phase.START && !this.minecraft.func_147113_T()) {
            mc.getPlayerRenderManager().getAnimationEngine().tick();
            if (this.minecraft.field_71439_g != null && this.minecraft.field_71439_g.field_70122_E && this.minecraft.field_71474_y.field_74314_A.func_151470_d()) {
                this.manager.jump((EntityPlayer)this.minecraft.field_71439_g);
            }
        }
        if (this.minecraft.field_71439_g == null || evt.phase == TickEvent.Phase.START) {
            return;
        }
        if (KeyBindings.gestureMenuBinding.func_151468_f()) {
            this.minecraft.func_147108_a((GuiScreen)new GuiImpl(GestureGui::new, null));
        }
        if (KeyBindings.renderToggleBinding.func_151468_f()) {
            Player.setEnableRendering(!Player.isEnableRendering());
        }
        mc.getPlayerRenderManager().getAnimationEngine().updateKeys(KeyBindings.quickAccess);
    }

    @SubscribeEvent
    public void onRenderName(RenderLivingEvent.Specials.Pre<AbstractClientPlayer> evt) {
        if (evt.entity instanceof AbstractClientPlayer) {
            double d0;
            FormatText st;
            if (!Player.isEnableNames()) {
                evt.setCanceled(true);
            }
            if (Player.isEnableLoadingInfo() && this.canRenderName(evt.entity) && (st = ClientProxy.INSTANCE.manager.getStatus(((AbstractClientPlayer)evt.entity).func_146103_bH(), "player")) != null && (d0 = evt.entity.func_70068_e(this.minecraft.func_175606_aa())) < 1024.0) {
                Scoreboard scoreboard = ((EntityPlayer)evt.entity).func_96123_co();
                ScoreObjective scoreobjective = scoreboard.func_96539_a(2);
                double y = evt.y;
                if (scoreobjective != null) {
                    y += (double)((float)evt.renderer.func_76983_a().field_78288_b * 1.15f * 0.025f);
                }
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)0.0f, (float)0.125f, (float)0.0f);
                String str = ((IChatComponent)st.remap()).func_150254_d();
                GlStateManager.func_179092_a((int)516, (float)0.1f);
                if (evt.entity.func_70093_af()) {
                    FontRenderer fontrenderer = this.minecraft.field_71466_p;
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179109_b((float)((float)evt.x), (float)((float)y + evt.entity.field_70131_O + 0.5f - (evt.entity.func_70631_g_() ? evt.entity.field_70131_O / 2.0f : 0.0f)), (float)((float)evt.z));
                    GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
                    GlStateManager.func_179114_b((float)(-this.minecraft.func_175598_ae().field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
                    GlStateManager.func_179114_b((float)this.minecraft.func_175598_ae().field_78732_j, (float)1.0f, (float)0.0f, (float)0.0f);
                    GlStateManager.func_179152_a((float)-0.013333335f, (float)-0.013333335f, (float)0.013333335f);
                    GlStateManager.func_179109_b((float)0.0f, (float)9.374999f, (float)0.0f);
                    GlStateManager.func_179140_f();
                    GlStateManager.func_179132_a((boolean)false);
                    GlStateManager.func_179147_l();
                    GlStateManager.func_179090_x();
                    GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
                    int i = fontrenderer.func_78256_a(str) / 2;
                    Tessellator tessellator = Tessellator.func_178181_a();
                    WorldRenderer worldrenderer = tessellator.func_178180_c();
                    worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
                    worldrenderer.func_181662_b((double)(-i - 1), -1.0, 0.0).func_181666_a(0.0f, 0.0f, 0.0f, 0.25f).func_181675_d();
                    worldrenderer.func_181662_b((double)(-i - 1), 8.0, 0.0).func_181666_a(0.0f, 0.0f, 0.0f, 0.25f).func_181675_d();
                    worldrenderer.func_181662_b((double)(i + 1), 8.0, 0.0).func_181666_a(0.0f, 0.0f, 0.0f, 0.25f).func_181675_d();
                    worldrenderer.func_181662_b((double)(i + 1), -1.0, 0.0).func_181666_a(0.0f, 0.0f, 0.0f, 0.25f).func_181675_d();
                    tessellator.func_78381_a();
                    GlStateManager.func_179098_w();
                    GlStateManager.func_179132_a((boolean)true);
                    fontrenderer.func_78276_b(str, -fontrenderer.func_78256_a(str) / 2, 0, 0x20FFFFFF);
                    GlStateManager.func_179145_e();
                    GlStateManager.func_179084_k();
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    GlStateManager.func_179121_F();
                } else {
                    this.renderLivingLabel((Entity)evt.entity, str, evt.x, y - (evt.entity.func_70631_g_() ? (double)(evt.entity.field_70131_O / 2.0f) : 0.0), evt.z, 64);
                }
                GlStateManager.func_179121_F();
            }
        }
    }

    protected boolean canRenderName(EntityLivingBase entity) {
        EntityPlayerSP entityplayersp = Minecraft.func_71410_x().field_71439_g;
        if (entity instanceof EntityPlayer && entity != entityplayersp) {
            Team team = entity.func_96124_cp();
            Team team1 = entityplayersp.func_96124_cp();
            if (team != null) {
                Team.EnumVisible team$enumvisible = team.func_178770_i();
                switch (team$enumvisible) {
                    case ALWAYS: {
                        return true;
                    }
                    case NEVER: {
                        return false;
                    }
                    case HIDE_FOR_OTHER_TEAMS: {
                        return team1 == null || team.func_142054_a(team1);
                    }
                    case HIDE_FOR_OWN_TEAM: {
                        return team1 == null || !team.func_142054_a(team1);
                    }
                }
                return true;
            }
        }
        return Minecraft.func_71382_s() && !entity.func_98034_c((EntityPlayer)entityplayersp) && entity.field_70153_n == null;
    }

    protected void renderLivingLabel(Entity entityIn, String str, double x, double y, double z, int maxDistance) {
        double d0 = entityIn.func_70068_e(this.minecraft.func_175598_ae().field_78734_h);
        if (d0 <= (double)(maxDistance * maxDistance)) {
            FontRenderer fontrenderer = this.minecraft.field_71466_p;
            float f = 1.6f;
            float f1 = 0.016666668f * f / 2.0f;
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)((float)x + 0.0f), (float)((float)y + entityIn.field_70131_O + 0.5f), (float)((float)z));
            GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)(-this.minecraft.func_175598_ae().field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)this.minecraft.func_175598_ae().field_78732_j, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179152_a((float)(-f1), (float)(-f1), (float)f1);
            GlStateManager.func_179140_f();
            GlStateManager.func_179132_a((boolean)false);
            GlStateManager.func_179097_i();
            GlStateManager.func_179147_l();
            GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
            Tessellator tessellator = Tessellator.func_178181_a();
            WorldRenderer worldrenderer = tessellator.func_178180_c();
            int i = 0;
            if (str.equals("deadmau5")) {
                i = -10;
            }
            int j = fontrenderer.func_78256_a(str) / 2;
            GlStateManager.func_179090_x();
            worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
            worldrenderer.func_181662_b((double)(-j - 1), (double)(-1 + i), 0.0).func_181666_a(0.0f, 0.0f, 0.0f, 0.25f).func_181675_d();
            worldrenderer.func_181662_b((double)(-j - 1), (double)(8 + i), 0.0).func_181666_a(0.0f, 0.0f, 0.0f, 0.25f).func_181675_d();
            worldrenderer.func_181662_b((double)(j + 1), (double)(8 + i), 0.0).func_181666_a(0.0f, 0.0f, 0.0f, 0.25f).func_181675_d();
            worldrenderer.func_181662_b((double)(j + 1), (double)(-1 + i), 0.0).func_181666_a(0.0f, 0.0f, 0.0f, 0.25f).func_181675_d();
            tessellator.func_78381_a();
            GlStateManager.func_179098_w();
            fontrenderer.func_78276_b(str, -fontrenderer.func_78256_a(str) / 2, i, 0x20FFFFFF);
            GlStateManager.func_179126_j();
            GlStateManager.func_179132_a((boolean)true);
            fontrenderer.func_78276_b(str, -fontrenderer.func_78256_a(str) / 2, i, -1);
            GlStateManager.func_179145_e();
            GlStateManager.func_179084_k();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179121_F();
        }
    }

    public void onLogout() {
        mc.onLogOut();
    }

    public static void renderCape(AbstractClientPlayer playerIn, float partialTicks, ModelPlayer model, ModelDefinition modelDefinition) {
        float f3;
        float f2;
        float f1;
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)0.125f);
        if (playerIn != null) {
            double lvt_10_1_ = playerIn.field_71091_bM + (playerIn.field_71094_bP - playerIn.field_71091_bM) * (double)partialTicks - (playerIn.field_70169_q + (playerIn.field_70165_t - playerIn.field_70169_q) * (double)partialTicks);
            double lvt_12_1_ = playerIn.field_71096_bN + (playerIn.field_71095_bQ - playerIn.field_71096_bN) * (double)partialTicks - (playerIn.field_70167_r + (playerIn.field_70163_u - playerIn.field_70167_r) * (double)partialTicks);
            double lvt_14_1_ = playerIn.field_71097_bO + (playerIn.field_71085_bR - playerIn.field_71097_bO) * (double)partialTicks - (playerIn.field_70166_s + (playerIn.field_70161_v - playerIn.field_70166_s) * (double)partialTicks);
            float lvt_16_1_ = playerIn.field_70760_ar + (playerIn.field_70761_aq - playerIn.field_70760_ar) * partialTicks;
            double lvt_17_1_ = MathHelper.func_76126_a((float)(lvt_16_1_ * ((float)Math.PI / 180)));
            double lvt_19_1_ = -MathHelper.func_76134_b((float)(lvt_16_1_ * ((float)Math.PI / 180)));
            f1 = (float)lvt_12_1_ * 10.0f;
            f1 = MathHelper.func_76131_a((float)f1, (float)-6.0f, (float)32.0f);
            f2 = (float)(lvt_10_1_ * lvt_17_1_ + lvt_14_1_ * lvt_19_1_) * 100.0f;
            f3 = (float)(lvt_10_1_ * lvt_19_1_ - lvt_14_1_ * lvt_17_1_) * 100.0f;
            if (f2 < 0.0f) {
                f2 = 0.0f;
            }
            float lvt_24_1_ = playerIn.field_71107_bF + (playerIn.field_71109_bG - playerIn.field_71107_bF) * partialTicks;
            f1 += MathHelper.func_76126_a((float)((playerIn.field_70141_P + (playerIn.field_70140_Q - playerIn.field_70141_P) * partialTicks) * 6.0f)) * 32.0f * lvt_24_1_;
            if (playerIn.func_70093_af()) {
                f1 += 25.0f;
                model.field_178729_w.field_78797_d = 2.0f;
            } else {
                model.field_178729_w.field_78797_d = 0.0f;
            }
        } else {
            f1 = 0.0f;
            f2 = 0.0f;
            f3 = 0.0f;
        }
        model.field_178729_w.field_78795_f = (float)(-Math.toRadians(6.0f + f2 / 2.0f + f1));
        model.field_178729_w.field_78796_g = (float)Math.toRadians(180.0f - f3 / 2.0f);
        model.field_178729_w.field_78808_h = (float)Math.toRadians(f3 / 2.0f);
        mc.getPlayerRenderManager().setModelPose(model);
        model.field_178729_w.field_78795_f = 0.0f;
        model.field_178729_w.field_78796_g = 0.0f;
        model.field_178729_w.field_78808_h = 0.0f;
        model.func_178728_c(0.0625f);
        GlStateManager.func_179121_F();
    }

    public static class Button
    extends GuiButton {
        public Button(int x, int y) {
            super(99, x, y, 100, 20, I18n.func_135052_a((String)"button.cpm.open_editor", (Object[])new Object[0]));
        }
    }
}

