/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.client;

import com.tom.cpl.gui.Frame;
import com.tom.cpl.gui.IGui;
import com.tom.cpl.gui.KeyCodes;
import com.tom.cpl.gui.KeyboardEvent;
import com.tom.cpl.gui.MouseEvent;
import com.tom.cpl.gui.NativeGuiComponents;
import com.tom.cpl.gui.UIColors;
import com.tom.cpl.gui.elements.FileChooserPopup;
import com.tom.cpl.gui.elements.TextField;
import com.tom.cpl.item.Stack;
import com.tom.cpl.math.Box;
import com.tom.cpl.math.Vec2i;
import com.tom.cpl.text.IText;
import com.tom.cpl.util.AWTChooser;
import com.tom.cpm.client.LWJGLKeyCodes;
import com.tom.cpm.client.Panel3dImpl;
import com.tom.cpm.common.ItemStackHandlerImpl;
import com.tom.cpm.shared.gui.panel.Panel3d;
import com.tom.cpm.shared.util.Log;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.ClientBrandRetriever;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiChat;
import net.minecraft.client.gui.GuiErrorScreen;
import net.minecraft.client.gui.GuiPageButtonList;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.GuiIngameForge;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class GuiImpl
extends GuiScreen
implements IGui {
    private static final KeyCodes CODES = new LWJGLKeyCodes();
    private static final NativeGuiComponents nativeComponents = new NativeGuiComponents();
    private Frame gui;
    private GuiScreen parent;
    private IGui.CtxStack stack;
    private UIColors colors = new UIColors();
    private Consumer<Runnable> closeListener;
    private int vanillaScale = -1;

    public GuiImpl(Function<IGui, Frame> creator, GuiScreen parent) {
        this.parent = parent;
        try {
            this.gui = creator.apply(this);
        }
        catch (Throwable e) {
            this.onGuiException("Error creating gui", e, true);
        }
    }

    private static <G extends Supplier<IGui>, N> NativeGuiComponents.NativeConstructor<G, N> local(Function<GuiImpl, N> fac) {
        return f -> fac.apply((GuiImpl)f.get());
    }

    public boolean func_73868_f() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        try {
            GL11.glEnable((int)3089);
            this.stack = new IGui.CtxStack(this.field_146294_l, this.field_146295_m);
            this.gui.draw(mouseX, mouseY, partialTicks);
        }
        catch (Throwable e) {
            this.onGuiException("Error drawing gui", e, true);
        }
        finally {
            GL11.glDisable((int)3089);
            String s = "Minecraft 1.8.9 (" + this.field_146297_k.func_175600_c() + "/" + ClientBrandRetriever.getClientModName() + ") " + ((ModContainer)Loader.instance().getIndexedModList().get("customplayermodels")).getDisplayVersion();
            this.field_146289_q.func_78276_b(s, this.field_146294_l - this.field_146289_q.func_78256_a(s) - 4, 2, -16777216);
            s = "FPS: " + Minecraft.func_175610_ah();
            this.field_146289_q.func_78276_b(s, this.field_146294_l - this.field_146289_q.func_78256_a(s) - 4, 11, -16777216);
        }
        if (this.field_146297_k.field_71439_g != null && this.gui.enableChat()) {
            try {
                ScaledResolution res = new ScaledResolution(this.field_146297_k);
                Method m = GuiIngameForge.class.getDeclaredMethod("renderChat", Integer.TYPE, Integer.TYPE);
                m.setAccessible(true);
                m.invoke((Object)this.field_146297_k.field_71456_v, res.func_78326_a(), res.func_78328_b());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void func_146281_b() {
        Keyboard.enableRepeatEvents((boolean)false);
        if (this.vanillaScale != -1 && this.vanillaScale != this.field_146297_k.field_71474_y.field_74335_Z) {
            this.field_146297_k.field_71474_y.field_74335_Z = this.vanillaScale;
        }
        if (this.parent != null) {
            GuiScreen p = this.parent;
            this.parent = null;
            this.field_146297_k.func_147108_a(p);
        }
    }

    @Override
    public void drawBox(int x, int y, int w, int h, int color) {
        GuiImpl.func_73734_a((int)(x += this.getOffset().x), (int)(y += this.getOffset().y), (int)(x + w), (int)(y + h), (int)color);
    }

    public void func_73866_w_() {
        Keyboard.enableRepeatEvents((boolean)true);
        try {
            this.gui.init(this.field_146294_l, this.field_146295_m);
        }
        catch (Throwable e) {
            this.onGuiException("Error in init gui", e, true);
        }
    }

    @Override
    public void drawText(int x, int y, String text, int color) {
        this.field_146289_q.func_78276_b(text, x += this.getOffset().x, y += this.getOffset().y, color);
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        try {
            KeyboardEvent evt = new KeyboardEvent(keyCode, 0, typedChar, Keyboard.getKeyName((int)keyCode));
            this.gui.keyPressed(evt);
            if (!evt.isConsumed() && this.field_146297_k.field_71439_g != null && this.field_146297_k.field_71474_y.field_74310_D.func_151463_i() == keyCode && this.field_146297_k.field_71474_y.field_74343_n != EntityPlayer.EnumChatVisibility.HIDDEN) {
                this.field_146297_k.func_147108_a((GuiScreen)new Overlay());
            }
        }
        catch (Throwable e) {
            this.onGuiException("Error processing key event", e, false);
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        try {
            this.gui.mouseClick(new MouseEvent(mouseX, mouseY, mouseButton));
        }
        catch (Throwable e) {
            this.onGuiException("Error processing mouse event", e, false);
        }
    }

    protected void func_146273_a(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
        try {
            this.gui.mouseDrag(new MouseEvent(mouseX, mouseY, clickedMouseButton));
        }
        catch (Throwable e) {
            this.onGuiException("Error processing mouse event", e, false);
        }
    }

    protected void func_146286_b(int mouseX, int mouseY, int state) {
        try {
            this.gui.mouseRelease(new MouseEvent(mouseX, mouseY, state));
        }
        catch (Throwable e) {
            this.onGuiException("Error processing mouse event", e, false);
        }
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        int i = Mouse.getEventDWheel();
        if (i > 0) {
            i = 1;
        }
        if (i < 0) {
            i = -1;
        }
        if (i != 0) {
            try {
                int x = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
                int y = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
                this.gui.mouseWheel(new MouseEvent(x, y, i));
            }
            catch (Throwable e) {
                this.onGuiException("Error processing mouse event", e, false);
            }
        }
    }

    @Override
    public void displayError(String e) {
        final GuiScreen p = this.parent;
        this.parent = null;
        Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiErrorScreen("Custom Player Models", I18n.func_135052_a((String)"error.cpm.crash", (Object[])new Object[]{e})){
            private GuiScreen parent;
            {
                super(x0, x1);
                this.parent = p;
            }

            public void func_146281_b() {
                if (this.parent != null) {
                    GuiScreen p2 = this.parent;
                    this.parent = null;
                    this.field_146297_k.func_147108_a(p2);
                }
            }
        });
    }

    @Override
    public void closeGui() {
        if (this.closeListener != null) {
            this.closeListener.accept(() -> this.field_146297_k.func_147108_a((GuiScreen)null));
        } else {
            this.field_146297_k.func_147108_a((GuiScreen)null);
        }
    }

    @Override
    public void drawTexture(int x, int y, int w, int h, int u, int v, String texture) {
        this.field_146297_k.func_110434_K().func_110577_a(new ResourceLocation("cpm", "textures/gui/" + texture + ".png"));
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.func_73729_b(x += this.getOffset().x, y += this.getOffset().y, u, v, w, h);
    }

    @Override
    public void drawTexture(int x, int y, int w, int h, int u, int v, String texture, int color) {
        this.field_146297_k.func_110434_K().func_110577_a(new ResourceLocation("cpm", "textures/gui/" + texture + ".png"));
        x += this.getOffset().x;
        y += this.getOffset().y;
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        GlStateManager.func_179131_c((float)r, (float)g, (float)b, (float)a);
        this.func_73729_b(x, y, u, v, w, h);
    }

    @Override
    public void drawTexture(int x, int y, int width, int height, float u1, float v1, float u2, float v2) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Tessellator tessellator = Tessellator.func_178181_a();
        WorldRenderer bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_181662_b((double)(x += this.getOffset().x), (double)((y += this.getOffset().y) + height), 0.0).func_181673_a((double)u1, (double)v2).func_181675_d();
        bufferbuilder.func_181662_b((double)(x + width), (double)(y + height), 0.0).func_181673_a((double)u2, (double)v2).func_181675_d();
        bufferbuilder.func_181662_b((double)(x + width), (double)y, 0.0).func_181673_a((double)u2, (double)v1).func_181675_d();
        bufferbuilder.func_181662_b((double)x, (double)y, 0.0).func_181673_a((double)u1, (double)v1).func_181675_d();
        tessellator.func_78381_a();
    }

    @Override
    public String i18nFormat(String key, Object ... obj) {
        return I18n.func_135052_a((String)key, (Object[])obj);
    }

    @Override
    public void setupCut() {
        float multiplierX = (float)this.field_146297_k.field_71443_c / (float)this.field_146294_l;
        float multiplierY = (float)this.field_146297_k.field_71440_d / (float)this.field_146295_m;
        Box box = this.getContext().cutBox;
        GL11.glScissor((int)((int)((float)box.x * multiplierX)), (int)(this.field_146297_k.field_71440_d - (int)((float)(box.y + box.h) * multiplierY)), (int)((int)((float)box.w * multiplierX)), (int)((int)((float)box.h * multiplierY)));
    }

    @Override
    public int textWidth(String text) {
        return this.field_146289_q.func_78256_a(text);
    }

    private TextField.ITextField createTextField() {
        return new TxtField();
    }

    @Override
    public UIColors getColors() {
        return this.colors;
    }

    @Override
    public void setCloseListener(Consumer<Runnable> listener) {
        this.closeListener = listener;
    }

    @Override
    public boolean isShiftDown() {
        return GuiImpl.func_146272_n();
    }

    @Override
    public boolean isCtrlDown() {
        return GuiImpl.func_146271_m();
    }

    @Override
    public boolean isAltDown() {
        return GuiImpl.func_175283_s();
    }

    @Override
    public KeyCodes getKeyCodes() {
        return CODES;
    }

    @Override
    public void drawGradientBox(int x, int y, int w, int h, int topLeft, int topRight, int bottomLeft, int bottomRight) {
        int left = x;
        int top = y;
        int right = x + w;
        int bottom = y + h;
        float atr = (float)(topRight >> 24 & 0xFF) / 255.0f;
        float rtr = (float)(topRight >> 16 & 0xFF) / 255.0f;
        float gtr = (float)(topRight >> 8 & 0xFF) / 255.0f;
        float btr = (float)(topRight & 0xFF) / 255.0f;
        float atl = (float)(topLeft >> 24 & 0xFF) / 255.0f;
        float rtl = (float)(topLeft >> 16 & 0xFF) / 255.0f;
        float gtl = (float)(topLeft >> 8 & 0xFF) / 255.0f;
        float btl = (float)(topLeft & 0xFF) / 255.0f;
        float abl = (float)(bottomLeft >> 24 & 0xFF) / 255.0f;
        float rbl = (float)(bottomLeft >> 16 & 0xFF) / 255.0f;
        float gbl = (float)(bottomLeft >> 8 & 0xFF) / 255.0f;
        float bbl = (float)(bottomLeft & 0xFF) / 255.0f;
        float abr = (float)(bottomRight >> 24 & 0xFF) / 255.0f;
        float rbr = (float)(bottomRight >> 16 & 0xFF) / 255.0f;
        float gbr = (float)(bottomRight >> 8 & 0xFF) / 255.0f;
        float bbr = (float)(bottomRight & 0xFF) / 255.0f;
        GlStateManager.func_179090_x();
        GlStateManager.func_179147_l();
        GlStateManager.func_179118_c();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        GlStateManager.func_179103_j((int)7425);
        Tessellator tessellator = Tessellator.func_178181_a();
        WorldRenderer bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        bufferbuilder.func_181662_b((double)right, (double)top, (double)this.field_73735_i).func_181666_a(rtr, gtr, btr, atr).func_181675_d();
        bufferbuilder.func_181662_b((double)left, (double)top, (double)this.field_73735_i).func_181666_a(rtl, gtl, btl, atl).func_181675_d();
        bufferbuilder.func_181662_b((double)left, (double)bottom, (double)this.field_73735_i).func_181666_a(rbl, gbl, bbl, abl).func_181675_d();
        bufferbuilder.func_181662_b((double)right, (double)bottom, (double)this.field_73735_i).func_181666_a(rbr, gbr, bbr, abr).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179084_k();
        GlStateManager.func_179141_d();
        GlStateManager.func_179098_w();
    }

    @Override
    public NativeGuiComponents getNative() {
        return nativeComponents;
    }

    @Override
    public void setClipboardText(String text) {
        GuiImpl.func_146275_d((String)text);
    }

    @Override
    public Frame getFrame() {
        return this.gui;
    }

    @Override
    public String getClipboardText() {
        return GuiImpl.func_146277_j();
    }

    @Override
    public void setScale(int value) {
        if (value != this.field_146297_k.field_71474_y.field_74335_Z) {
            if (this.vanillaScale == -1) {
                this.vanillaScale = this.field_146297_k.field_71474_y.field_74335_Z;
            }
            if (value == -1) {
                if (this.field_146297_k.field_71474_y.field_74335_Z != this.vanillaScale) {
                    this.field_146297_k.field_71474_y.field_74335_Z = this.vanillaScale;
                    this.vanillaScale = -1;
                    ScaledResolution scaledresolution = new ScaledResolution(this.field_146297_k);
                    int j = scaledresolution.func_78326_a();
                    int k = scaledresolution.func_78328_b();
                    this.func_146280_a(this.field_146297_k, j, k);
                }
            } else {
                this.field_146297_k.field_71474_y.field_74335_Z = value;
                ScaledResolution scaledresolution = new ScaledResolution(this.field_146297_k);
                int j = scaledresolution.func_78326_a();
                int k = scaledresolution.func_78328_b();
                this.func_146280_a(this.field_146297_k, j, k);
            }
        }
    }

    @Override
    public int getScale() {
        return this.field_146297_k.field_71474_y.field_74335_Z;
    }

    @Override
    public int getMaxScale() {
        return 4;
    }

    @Override
    public IGui.CtxStack getStack() {
        return this.stack;
    }

    public void func_73876_c() {
        try {
            this.gui.tick();
        }
        catch (Throwable e) {
            this.onGuiException("Error in tick gui", e, true);
        }
    }

    @Override
    public void drawFormattedText(float x, float y, IText text, int color, float scale) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)(x += (float)this.getOffset().x), (float)(y += (float)this.getOffset().y), (float)0.0f);
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
        this.field_146289_q.func_78276_b(((IChatComponent)text.remap()).func_150254_d(), 0, 0, color);
        GlStateManager.func_179121_F();
    }

    @Override
    public int textWidthFormatted(IText text) {
        return this.field_146289_q.func_78256_a(((IChatComponent)text.remap()).func_150254_d());
    }

    @Override
    public void openURL0(String url) {
        try {
            Class<?> oclass = Class.forName("java.awt.Desktop");
            Object object = oclass.getMethod("getDesktop", new Class[0]).invoke(null, new Object[0]);
            oclass.getMethod("browse", URI.class).invoke(object, new URI(url));
        }
        catch (Throwable throwable1) {
            Throwable throwable = throwable1.getCause();
            Log.error("Couldn't open link: " + (throwable == null ? "<UNKNOWN>" : throwable.getMessage()));
        }
    }

    public void onOpened() {
        this.vanillaScale = -1;
    }

    @Override
    public void drawStack(int x, int y, Stack stack) {
        ItemStack s = (ItemStack)ItemStackHandlerImpl.impl.unwrap(stack);
        GlStateManager.func_179126_j();
        RenderHelper.func_74520_c();
        this.field_146296_j.func_180450_b(s, x += this.getOffset().x, y += this.getOffset().y);
        this.field_146296_j.func_180453_a(this.field_146289_q, s, x, y, null);
        GlStateManager.func_179097_i();
    }

    @Override
    public void drawStackTooltip(int mx, int my, Stack stack) {
        ItemStack s = (ItemStack)ItemStackHandlerImpl.impl.unwrap(stack);
        this.func_146285_a(s, mx, my);
    }

    static {
        nativeComponents.register(TextField.class, GuiImpl.local(GuiImpl::createTextField));
        nativeComponents.register(FileChooserPopup.class, AWTChooser::new);
        nativeComponents.register(Panel3d.class, Panel3dImpl::new);
    }

    public class Overlay
    extends GuiChat {
        public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
            GuiImpl.this.func_73863_a(Integer.MIN_VALUE, Integer.MIN_VALUE, partialTicks);
            super.func_73863_a(mouseX, mouseY, partialTicks);
        }

        public GuiScreen getGui() {
            return GuiImpl.this;
        }
    }

    private class TxtField
    implements TextField.ITextField,
    GuiPageButtonList.GuiResponder {
        private GuiTextField field;
        private Runnable eventListener;
        private Vec2i currentOff = new Vec2i(0, 0);
        private Box bounds = new Box(0, 0, 0, 0);
        private boolean refreshTextBox;

        public TxtField() {
            this.field = new GuiTextField(0, GuiImpl.this.field_146289_q, 0, 0, 0, 0);
            this.field.func_146203_f(0x100000);
            this.field.func_146185_a(false);
            this.field.func_146189_e(true);
            this.field.func_146193_g(((GuiImpl)GuiImpl.this).colors.label_text_color);
            this.field.func_175207_a((GuiPageButtonList.GuiResponder)this);
        }

        @Override
        public void draw(int mouseX, int mouseY, float partialTicks, Box bounds) {
            Vec2i off = GuiImpl.this.getOffset();
            this.field.field_146209_f = bounds.x + off.x + 4;
            this.field.field_146210_g = bounds.y + off.y + 6;
            this.currentOff.x = off.x;
            this.currentOff.y = off.y;
            this.bounds.x = bounds.x;
            this.bounds.y = bounds.y;
            this.bounds.w = bounds.w;
            this.bounds.h = bounds.h;
            this.field.field_146218_h = bounds.w - 5;
            this.field.field_146219_i = bounds.h - 12;
            if (this.refreshTextBox) {
                this.field.func_146202_e();
                this.refreshTextBox = false;
            }
            this.field.func_146194_f();
        }

        @Override
        public void keyPressed(KeyboardEvent e) {
            if (e.isConsumed()) {
                return;
            }
            if (this.field.func_146201_a(e.charTyped, e.keyCode)) {
                e.consume();
            }
        }

        @Override
        public void mouseClick(MouseEvent e) {
            if (e.isConsumed()) {
                this.field.func_146192_a(Integer.MIN_VALUE, Integer.MIN_VALUE, e.btn);
                return;
            }
            this.field.field_146209_f = this.bounds.x + this.currentOff.x;
            this.field.field_146210_g = this.bounds.y + this.currentOff.y;
            this.field.field_146218_h = this.bounds.w;
            this.field.field_146219_i = this.bounds.h;
            this.field.func_146192_a(e.x + this.currentOff.x, e.y + this.currentOff.y, e.btn);
            if (this.bounds.isInBounds(e.x, e.y)) {
                e.consume();
            }
        }

        @Override
        public String getText() {
            return this.field.func_146179_b();
        }

        @Override
        public void setText(String txt) {
            this.field.func_146180_a(txt);
            this.refreshTextBox = true;
        }

        @Override
        public void setEventListener(Runnable eventListener) {
            this.eventListener = eventListener;
        }

        public void func_175321_a(int id, boolean value) {
        }

        public void func_175320_a(int id, float value) {
        }

        public void func_175319_a(int id, String value) {
            if (this.eventListener != null) {
                this.eventListener.run();
            }
        }

        @Override
        public void setEnabled(boolean enabled) {
            this.field.func_146184_c(enabled);
        }

        @Override
        public boolean isFocused() {
            return this.field.func_146206_l();
        }

        @Override
        public void setFocused(boolean focused) {
            this.field.func_146195_b(focused);
        }

        @Override
        public int getCursorPos() {
            return this.field.func_146198_h();
        }

        @Override
        public void setCursorPos(int pos) {
            this.field.func_146190_e(pos);
        }
    }
}

