/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.client;

import com.tom.cpl.math.Vec4f;
import com.tom.cpl.render.DirectBuffer;
import com.tom.cpl.render.VBuffers;
import com.tom.cpl.render.VertexBuffer;
import com.tom.cpm.client.MinecraftObject;
import com.tom.cpm.shared.retro.RetroGLAccess;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.ResourceLocation;

public class RetroGL
implements RetroGLAccess<ResourceLocation> {
    private static final RenderStage lines = new RenderStage(true, false, false, () -> {
        GlStateManager.func_179097_i();
        GlStateManager.func_179090_x();
    }, () -> {
        GlStateManager.func_179098_w();
        GlStateManager.func_179126_j();
    }, 1, DefaultVertexFormats.field_181706_f);
    private static final RenderStage color = new RenderStage(true, false, false, () -> GlStateManager.func_179090_x(), () -> GlStateManager.func_179098_w(), 7, DefaultVertexFormats.field_181706_f);
    private static float lx;
    private static float ly;
    private static Vec4f colorHold;
    private static boolean drawingGlint;

    public RenderStage texture(ResourceLocation tex) {
        return new RenderStage(true, true, true, () -> {
            RetroGL.bindTex(tex);
            if (!drawingGlint) {
                GlStateManager.func_179147_l();
                GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
            }
        }, () -> {}, 7, DefaultVertexFormats.field_181712_l);
    }

    public RenderStage eyes(ResourceLocation tex) {
        return new RenderStage(true, true, true, () -> {
            lx = OpenGlHelper.lastBrightnessX;
            ly = OpenGlHelper.lastBrightnessY;
            GlStateManager.func_179147_l();
            GlStateManager.func_179118_c();
            GlStateManager.func_179112_b((int)1, (int)1);
            GlStateManager.func_179132_a((boolean)true);
            int i = 240;
            int j = i % 65536;
            int k = i / 65536;
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)j, (float)k);
            RetroGL.bindTex(tex);
        }, () -> {
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)lx, (float)ly);
            GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
            GlStateManager.func_179141_d();
        }, 7, DefaultVertexFormats.field_181712_l);
    }

    @Override
    public RenderStage linesNoDepth() {
        return lines;
    }

    @Override
    public RenderStage color() {
        return color;
    }

    private static void bindTex(ResourceLocation tex) {
        if (tex != null) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(tex);
        }
    }

    public static VertexBuffer buffer(VBuffers.NativeRenderType type) {
        RenderStage stage = (RenderStage)type.getNativeType();
        return new RetroBuffer(Tessellator.func_178181_a(), stage);
    }

    public static Vec4f getColor() {
        if (colorHold != null) {
            return colorHold;
        }
        GlStateManager.Color c = GlStateManager.field_179170_t;
        return new Vec4f(RetroGL.val(c.field_179195_a), RetroGL.val(c.field_179193_b), RetroGL.val(c.field_179194_c), RetroGL.val(c.field_179192_d));
    }

    public static void colorHold() {
        colorHold = RetroGL.getColor();
    }

    public static void colorHoldEnd() {
        colorHold = null;
    }

    private static float val(float color) {
        return color == -1.0f ? 1.0f : color;
    }

    @Override
    public ResourceLocation getDynTexture() {
        return MinecraftObject.DynTexture.getBoundLoc();
    }

    public static void enableGlint() {
        RetroGL.colorHold();
        drawingGlint = true;
    }

    public static void disableGlint() {
        RetroGL.colorHoldEnd();
        drawingGlint = false;
    }

    private static class RetroBuffer
    extends DirectBuffer<WorldRenderer> {
        private RenderStage stage;
        private Tessellator tes;

        public RetroBuffer(Tessellator tes, RenderStage stage) {
            super(tes.func_178180_c());
            this.tes = tes;
            this.stage = stage;
            stage.begin((WorldRenderer)this.buffer);
        }

        @Override
        protected void pushVertex(float x, float y, float z, float red, float green, float blue, float alpha, float u, float v, float nx, float ny, float nz) {
            ((WorldRenderer)this.buffer).func_181662_b((double)x, (double)y, (double)z);
            if (this.stage.texture) {
                ((WorldRenderer)this.buffer).func_181673_a((double)u, (double)v);
            }
            if (this.stage.color) {
                ((WorldRenderer)this.buffer).func_181666_a(red, green, blue, alpha);
            }
            if (this.stage.normal) {
                ((WorldRenderer)this.buffer).func_181663_c(nx, ny, nz);
            }
            ((WorldRenderer)this.buffer).func_181675_d();
        }

        @Override
        public void finish() {
            this.tes.func_78381_a();
            this.stage.end();
        }
    }

    private static class RenderStage
    implements RetroGLAccess.RetroLayer {
        private boolean color;
        private boolean texture;
        private boolean normal;
        private Runnable begin;
        private Runnable end;
        private int glMode;
        private VertexFormat format;

        public RenderStage(boolean color, boolean texture, boolean normal, Runnable begin, Runnable end, int glMode, VertexFormat format) {
            this.color = color;
            this.texture = texture;
            this.normal = normal;
            this.begin = begin;
            this.end = end;
            this.glMode = glMode;
            this.format = format;
        }

        public void begin(WorldRenderer buf) {
            this.begin.run();
            buf.func_181668_a(this.glMode, this.format);
        }

        public void end() {
            this.end.run();
        }
    }
}

