/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.common;

import com.tom.cpl.block.BlockState;
import com.tom.cpl.block.BlockStateHandler;
import com.tom.cpl.item.Stack;
import com.tom.cpm.common.ItemStackHandlerImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.GameData;

public class BlockStateHandlerImpl
extends BlockStateHandler<IBlockState> {
    public static final BlockStateHandlerImpl impl = new BlockStateHandlerImpl();

    @Override
    public String getBlockId(IBlockState stack) {
        return stack.func_177230_c().delegate.getResourceName().toString();
    }

    @Override
    public List<String> getBlockStates(IBlockState stack) {
        return stack.func_177227_a().stream().map(p -> p.func_177701_a()).collect(Collectors.toList());
    }

    private Stream<Map.Entry<IProperty, Comparable>> getProp(IBlockState state, String property) {
        return state.func_177228_b().entrySet().stream().filter(e -> ((IProperty)e.getKey()).func_177701_a().equals(property));
    }

    @Override
    public String getPropertyValue(IBlockState state, String property) {
        return this.getProp(state, property).map(this::propValue).findFirst().orElse(null);
    }

    private String propValue(Map.Entry<IProperty, Comparable> e) {
        IProperty p = e.getKey();
        return p.func_177702_a(e.getValue());
    }

    @Override
    public int getPropertyValueInt(IBlockState state, String property) {
        return this.getProp(state, property).mapToInt(e -> {
            Comparable o = state.func_177229_b((IProperty)e.getKey());
            return o instanceof Number ? ((Number)((Object)o)).intValue() : -1;
        }).findFirst().orElse(-1);
    }

    @Override
    public List<String> getAllValuesFor(IBlockState state, String property) {
        return this.getProp(state, property).flatMap(e -> ((IProperty)e.getKey()).func_177700_c().stream().map(v -> {
            IProperty p = (IProperty)e.getKey();
            return p.func_177702_a((Comparable)v);
        })).collect(Collectors.toList());
    }

    @Override
    public List<String> listTags(IBlockState stack) {
        return Collections.emptyList();
    }

    @Override
    public List<BlockState> listNativeEntries(String tag) {
        if (tag.charAt(0) == '#') {
            return Collections.emptyList();
        }
        ArrayList<BlockState> stacks = new ArrayList<BlockState>();
        ResourceLocation rl = ItemStackHandlerImpl.tryParse(tag);
        Block item = (Block)GameData.getBlockRegistry().getObject(rl);
        if (item != null) {
            stacks.add(this.wrap(item.func_176223_P()));
        }
        return stacks;
    }

    @Override
    public List<String> listNativeTags() {
        return Collections.emptyList();
    }

    @Override
    public List<BlockState> getAllElements() {
        Iterator itr = GameData.getBlockRegistry().iterator();
        ArrayList<BlockState> list = new ArrayList<BlockState>();
        while (itr.hasNext()) {
            Block block = (Block)itr.next();
            list.add(this.wrap(block.func_176223_P()));
        }
        return list;
    }

    @Override
    public boolean isInTag(String tag, IBlockState stack) {
        if (tag.charAt(0) == '#') {
            return false;
        }
        return this.getBlockId(stack).equals(tag);
    }

    @Override
    public boolean equals(IBlockState a, IBlockState b) {
        return a.func_177230_c() == b.func_177230_c();
    }

    @Override
    public Stack getStackFromState(IBlockState state) {
        return ItemStackHandlerImpl.impl.wrap(new ItemStack(state.func_177230_c()));
    }

    @Override
    public boolean equalsFull(IBlockState a, IBlockState b) {
        return a.equals(b);
    }

    @Override
    public BlockState emptyObject() {
        return this.wrap(Blocks.field_150350_a.func_176223_P());
    }
}

