/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.common;

import com.tom.cpl.item.ItemStackHandler;
import com.tom.cpl.item.NbtMapper;
import com.tom.cpl.item.Stack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.GameData;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.ArrayUtils;

public class ItemStackHandlerImpl
extends ItemStackHandler<ItemStack> {
    private static final String AIR = "minecraft:air";
    public static final ItemStackHandlerImpl impl = new ItemStackHandlerImpl();
    public static final NBT nbt = new NBT();

    @Override
    public int getCount(ItemStack stack) {
        return stack == null ? 0 : stack.field_77994_a;
    }

    @Override
    public int getMaxCount(ItemStack stack) {
        return stack == null ? 0 : stack.func_77976_d();
    }

    @Override
    public int getDamage(ItemStack stack) {
        return stack == null ? 0 : stack.func_77952_i();
    }

    @Override
    public int getMaxDamage(ItemStack stack) {
        return stack == null ? 0 : stack.func_77958_k();
    }

    @Override
    public boolean itemEquals(ItemStack a, ItemStack b) {
        return a == null && b == null ? true : (a != null && b != null ? (!a.func_77984_f() ? a.func_77969_a(b) : a.func_77973_b() == b.func_77973_b()) : false);
    }

    @Override
    public boolean itemEqualsFull(ItemStack a, ItemStack b) {
        return ItemStack.func_179545_c((ItemStack)a, (ItemStack)b) && ItemStack.func_77970_a((ItemStack)a, (ItemStack)b);
    }

    @Override
    public List<String> listNativeTags() {
        return Arrays.stream(OreDictionary.getOreNames()).map(t -> "#oredict:" + t).collect(Collectors.toList());
    }

    @Override
    public List<Stack> getAllElements() {
        ArrayList stacks = new ArrayList();
        for (Item item : GameData.getItemRegistry()) {
            item.func_150895_a(item, CreativeTabs.field_78027_g, stacks);
        }
        return stacks.stream().map(this::wrap).collect(Collectors.toList());
    }

    @Override
    public com.tom.cpl.nbt.NBTTagCompound getTag(ItemStack stack) {
        return stack != null && stack.func_77942_o() ? nbt.wrap(stack.func_77978_p()) : null;
    }

    @Override
    public List<Stack> listNativeEntries(String tag) {
        if (tag.charAt(0) == '#') {
            if (tag.startsWith("#oredict:") && OreDictionary.doesOreNameExist((String)(tag = tag.substring(9)))) {
                return OreDictionary.getOres((String)tag).stream().map(this::wrap).collect(Collectors.toList());
            }
        } else {
            ResourceLocation rl = ItemStackHandlerImpl.tryParse(tag);
            Item item = (Item)GameData.getItemRegistry().getObject(rl);
            if (item != null) {
                return Collections.singletonList(this.wrap(new ItemStack(item)));
            }
        }
        return Collections.emptyList();
    }

    public static ResourceLocation tryParse(String tag) {
        try {
            return new ResourceLocation(tag);
        }
        catch (Exception var2) {
            return null;
        }
    }

    @Override
    public boolean isInTag(String tag, ItemStack stack) {
        if (tag.charAt(0) == '#') {
            if (tag.startsWith("#oredict:") && OreDictionary.doesOreNameExist((String)(tag = tag.substring(9)))) {
                return ArrayUtils.contains((int[])OreDictionary.getOreIDs((ItemStack)stack), (int)OreDictionary.getOreID((String)tag));
            }
            return false;
        }
        if (stack == null) {
            return false;
        }
        return this.getItemId(stack).equals(tag);
    }

    @Override
    public List<String> listTags(ItemStack stack) {
        if (stack == null) {
            return Collections.emptyList();
        }
        return IntStream.of(OreDictionary.getOreIDs((ItemStack)stack)).mapToObj(i -> "#oredict:" + OreDictionary.getOreName((int)i)).collect(Collectors.toList());
    }

    @Override
    public String getItemId(ItemStack stack) {
        if (stack == null) {
            return AIR;
        }
        return stack.func_77973_b().delegate.getResourceName().toString();
    }

    @Override
    public Stack emptyObject() {
        return this.wrap(null);
    }

    @Override
    public String getItemDisplayName(ItemStack stack) {
        return stack.func_82833_r();
    }

    public static class NBT
    extends NbtMapper<NBTBase, NBTTagCompound, NBTTagList, NBTBase.NBTPrimitive> {
        @Override
        public long getLong(NBTBase.NBTPrimitive t) {
            return t.func_150291_c();
        }

        @Override
        public int getInt(NBTBase.NBTPrimitive t) {
            return t.func_150287_d();
        }

        @Override
        public short getShort(NBTBase.NBTPrimitive t) {
            return t.func_150289_e();
        }

        @Override
        public byte getByte(NBTBase.NBTPrimitive t) {
            return t.func_150290_f();
        }

        @Override
        public double getDouble(NBTBase.NBTPrimitive t) {
            return t.func_150286_g();
        }

        @Override
        public float getFloat(NBTBase.NBTPrimitive t) {
            return t.func_150288_h();
        }

        @Override
        public NBTBase.NBTPrimitive asNumber(NBTBase t) {
            return t instanceof NBTBase.NBTPrimitive ? (NBTBase.NBTPrimitive)t : null;
        }

        @Override
        public String getString(NBTBase t) {
            return t.toString();
        }

        @Override
        public NBTBase getTag(NBTTagCompound t, String name) {
            return t.func_74781_a(name);
        }

        @Override
        public NBTTagList asList(NBTBase t) {
            return t instanceof NBTTagList ? (NBTTagList)t : null;
        }

        @Override
        public NBTTagCompound asCompound(NBTBase t) {
            return t instanceof NBTTagCompound ? (NBTTagCompound)t : null;
        }

        @Override
        public int listSize(NBTTagList t) {
            return t.func_74745_c();
        }

        @Override
        public NBTBase getAt(NBTTagList t, int i) {
            return t.func_179238_g(i);
        }

        @Override
        public boolean contains(NBTTagCompound t, String name, int type) {
            return t.func_150297_b(name, type);
        }

        @Override
        public NBTTagCompound newCompound() {
            return new NBTTagCompound();
        }

        @Override
        public NBTTagList newList() {
            return new NBTTagList();
        }

        @Override
        public Iterable<String> keys(NBTTagCompound t) {
            return t.func_150296_c();
        }

        @Override
        public int getId(NBTBase t) {
            return t.func_74732_a();
        }

        @Override
        public byte[] getByteArray(NBTBase t) {
            return t instanceof NBTTagByteArray ? ((NBTTagByteArray)t).func_150292_c() : new byte[]{};
        }

        @Override
        public int[] getIntArray(NBTBase t) {
            return t instanceof NBTTagIntArray ? ((NBTTagIntArray)t).func_150302_c() : new int[]{};
        }

        @Override
        public long[] getLongArray(NBTBase t) {
            return new long[0];
        }
    }
}

