/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.common;

import com.tom.cpm.common.AttributeScaler;
import com.tom.cpm.common.PlayerAnimUpdater;
import com.tom.cpm.shared.network.NetH;
import com.tom.cpm.shared.network.NetHandler;
import io.netty.buffer.Unpooled;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityTrackerEntry;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.server.S02PacketChat;
import net.minecraft.network.play.server.S3FPacketCustomPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.WorldServer;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class ServerHandler {
    public static NetHandler<ResourceLocation, EntityPlayerMP, NetHandlerPlayServer> netHandler = new NetHandler(ResourceLocation::new);

    @SubscribeEvent
    public void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent evt) {
        netHandler.onJoin((EntityPlayerMP)evt.player);
    }

    @SubscribeEvent
    public void onTrackingStart(PlayerEvent.StartTracking evt) {
        NetHandlerPlayServer handler = ((EntityPlayerMP)evt.entityPlayer).field_71135_a;
        if (((NetH.ServerNetH)handler).cpm$hasMod() && evt.target instanceof EntityPlayer) {
            netHandler.sendPlayerData((EntityPlayerMP)evt.target, (EntityPlayerMP)evt.entityPlayer);
        }
    }

    @SubscribeEvent
    public void onTick(TickEvent.ServerTickEvent evt) {
        if (evt.phase == TickEvent.Phase.END) {
            netHandler.tick();
        }
    }

    @SubscribeEvent
    public void onJump(LivingEvent.LivingJumpEvent evt) {
        if (evt.entityLiving instanceof EntityPlayerMP) {
            netHandler.onJump((EntityPlayerMP)evt.entityLiving);
        }
    }

    static {
        netHandler.setGetPlayerUUID(Entity::func_110124_au);
        netHandler.setSendPacketServer(d -> new PacketBuffer(Unpooled.wrappedBuffer((byte[])d)), (c, rl, pb) -> c.func_147359_a((Packet)new S3FPacketCustomPayload(rl.toString(), pb)), ent -> ((WorldServer)ent.field_70170_p).func_73039_n().getTrackingPlayers((Entity)ent), e -> (EntityPlayerMP)e);
        netHandler.setFindTracking((p, f) -> {
            for (EntityTrackerEntry tr : ((WorldServer)p.field_70170_p).func_73039_n().field_72793_b) {
                if (!(tr.field_73132_a instanceof EntityPlayer) || !tr.field_73134_o.contains(p)) continue;
                f.accept((EntityPlayerMP)tr.field_73132_a);
            }
        });
        netHandler.setSendChat((p, m) -> p.field_71135_a.func_147359_a((Packet)new S02PacketChat((IChatComponent)m.remap())));
        netHandler.setExecutor(() -> arg_0 -> ((MinecraftServer)FMLCommonHandler.instance().getMinecraftServerInstance()).func_152344_a(arg_0));
        netHandler.setGetNet(spe -> spe.field_71135_a);
        netHandler.setGetPlayer(net -> net.field_147369_b);
        netHandler.setGetPlayerId(Entity::func_145782_y);
        netHandler.setGetOnlinePlayers(() -> FMLCommonHandler.instance().getMinecraftServerInstance().func_71203_ab().func_181057_v());
        netHandler.setKickPlayer((p, m) -> p.field_71135_a.func_147360_c(m.toString()));
        netHandler.setGetPlayerAnimGetters(new PlayerAnimUpdater());
        netHandler.addScaler(new AttributeScaler());
    }
}

