/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.editor.template;

import com.tom.cpl.gui.IGui;
import com.tom.cpl.gui.elements.Tooltip;
import com.tom.cpm.shared.MinecraftClientAccess;
import com.tom.cpm.shared.config.ResourceLoader;
import com.tom.cpm.shared.definition.Link;
import com.tom.cpm.shared.editor.ETextures;
import com.tom.cpm.shared.editor.Editor;
import com.tom.cpm.shared.editor.EditorTexture;
import com.tom.cpm.shared.editor.project.JsonMap;
import com.tom.cpm.shared.editor.project.JsonMapImpl;
import com.tom.cpm.shared.editor.template.TemplateArgHandler;
import com.tom.cpm.shared.editor.template.TemplateArgType;
import com.tom.cpm.shared.editor.template.args.TexEditorArg;
import com.tom.cpm.shared.editor.tree.TreeElement;
import com.tom.cpm.shared.model.RenderedCube;
import com.tom.cpm.shared.model.TextureSheetType;
import com.tom.cpm.shared.model.render.VanillaModelPart;
import com.tom.cpm.shared.skin.TextureProvider;
import com.tom.cpm.shared.template.Template;
import com.tom.cpm.shared.util.TextureStitcher;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

public class EditorTemplate
extends Template
implements TreeElement {
    private Editor editor;
    private String name;
    private List<TreeElement> elems;
    private List<TemplateArgHandler.TemplateArg<?>> editorArgs;
    private EditorTexture tex;
    private TexEditorArg textureArg;
    private Tooltip tooltip;

    private EditorTemplate(Editor editor, Link link, InputStreamReader rd, JsonMap data) throws IOException {
        super(link, rd, data, null, null);
        this.editor = editor;
        this.loadPartToCubes();
        this.name = (String)this.data.get("name");
        this.elems = new ArrayList<TreeElement>();
        this.editorArgs = new ArrayList();
        List argsList = (List)this.data.get("args");
        HashMap<String, TemplateArgType> types = new HashMap<String, TemplateArgType>();
        types.put("__tex", TemplateArgType.TEX);
        for (Map arg2 : argsList) {
            String name = (String)arg2.get("name");
            types.put(name, TemplateArgType.lookup((String)arg2.get("elem_type")));
        }
        this.templateArgs.forEach((n, arg) -> {
            TemplateArgType type = (TemplateArgType)((Object)((Object)types.get(n)));
            TemplateArgHandler.TemplateArg<?> a = type.factory.get();
            if (type == TemplateArgType.TEX) {
                this.textureArg = (TexEditorArg)a;
            }
            EditorTemplate.loadArg(a, arg);
            this.editorArgs.add(a);
            ArrayList<TreeElement> options = new ArrayList<TreeElement>();
            a.createTreeElements(options, editor);
            this.elems.add(new TreeElement((String)n, editor, options){
                final /* synthetic */ String val$n;
                final /* synthetic */ Editor val$editor;
                final /* synthetic */ List val$options;
                {
                    this.val$n = string;
                    this.val$editor = editor;
                    this.val$options = list;
                }

                @Override
                public String getName() {
                    if (this.val$n.equals("__tex")) {
                        return this.val$editor.ui.i18nFormat("label.cpm.template_arg_tex", new Object[0]);
                    }
                    return this.val$n;
                }

                @Override
                public void getTreeElements(Consumer<TreeElement> c) {
                    this.val$options.forEach(c);
                }
            });
        });
        if (this.texture != null) {
            this.tex = new EditorTexture(this.texture);
            this.textureArg.bind(this);
        }
    }

    private static <T extends Template.IArg> void loadArg(TemplateArgHandler.TemplateArg<T> arg, Template.IArg value) {
        arg.loadTemplate(value);
    }

    public static EditorTemplate load(Editor editor, JsonMap data) throws IOException {
        Link link = new Link(data.getString("link"));
        try (InputStreamReader rd = new InputStreamReader(MinecraftClientAccess.get().getDefinitionLoader().load(link, ResourceLoader.ResourceEncoding.NO_ENCODING, null));){
            EditorTemplate editorTemplate = new EditorTemplate(editor, link, rd, data.getMap("data"));
            return editorTemplate;
        }
    }

    public static EditorTemplate create(Editor editor, String linkIn) throws IOException {
        Link link = new Link(linkIn);
        try (InputStreamReader rd = new InputStreamReader(MinecraftClientAccess.get().getDefinitionLoader().load(link, ResourceLoader.ResourceEncoding.NO_ENCODING, null));){
            EditorTemplate editorTemplate = new EditorTemplate(editor, link, rd, new JsonMapImpl());
            return editorTemplate;
        }
    }

    @Override
    public String getName() {
        return this.editor.ui.i18nFormat("label.cpm.template_name", this.name);
    }

    @Override
    public void getTreeElements(Consumer<TreeElement> c) {
        this.elems.forEach(c);
    }

    public List<RenderedCube> getForPart(VanillaModelPart type) {
        return this.partToCubes.getOrDefault(type, Collections.emptyList());
    }

    public void store(Map<String, Object> map) {
        this.editorArgs.forEach(TemplateArgHandler.TemplateArg::applyToArg);
        HashMap data = new HashMap();
        map.put("data", data);
        map.put("link", this.link.toString());
        for (Map.Entry e : this.templateArgs.entrySet()) {
            HashMap<String, Object> dt = new HashMap<String, Object>();
            data.put(e.getKey(), dt);
            ((Template.IArg)e.getValue()).write(dt);
        }
    }

    public void applyToModel() {
        this.editorArgs.forEach(TemplateArgHandler.TemplateArg::applyToArg);
        this.loadModelData();
        this.loadPartToCubes();
        if (this.texArg != null && !this.texArg.isTextureMerged() && this.tex != null && this.tex.stitchPos != null) {
            this.getCubes().forEach(c -> {
                c.getCube().u += this.tex.stitchPos.x;
                c.getCube().v += this.tex.stitchPos.y;
            });
        }
    }

    @Override
    public ETextures getTexture() {
        return this.texArg != null ? (this.texArg.isTextureMerged() ? this.editor.textures.get((Object)TextureSheetType.SKIN) : new ETextures(this.editor, this.tex)) : null;
    }

    @Override
    public TextureProvider getTemplateDefaultTexture() {
        ETextures tex = this.getTexture();
        return tex != null ? tex.provider : null;
    }

    public EditorTexture getTemplateTexture() {
        return this.tex;
    }

    public void stitch(TextureStitcher stitcher) {
        if (this.texArg != null && !this.texArg.isTextureMerged()) {
            stitcher.stitchImage(this.tex);
        }
    }

    @Override
    public void delete() {
        this.editor.action("remove", "action.cpm.template").removeFromList(this.editor.templates, this).onAction(this.editor::restitchTextures).onRun(() -> {
            this.editor.selectedElement = null;
        }).execute();
        this.editor.updateGui();
    }

    @Override
    public void updateGui() {
        this.editor.setDelEn.accept(true);
    }

    @Override
    public Tooltip getTooltip(IGui gui) {
        if (this.data.containsKey("desc") && this.tooltip == null) {
            this.tooltip = new Tooltip(gui.getFrame(), (String)this.data.get("desc"));
        }
        return this.tooltip;
    }
}

