/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.editor.util;

import com.tom.cpl.gui.IGui;
import com.tom.cpl.gui.elements.Button;
import com.tom.cpl.gui.elements.Panel;
import com.tom.cpl.gui.elements.Tooltip;
import com.tom.cpl.math.Box;
import com.tom.cpm.shared.gui.Keybinds;
import java.util.ArrayList;
import java.util.List;

public class QuickTask {
    private List<Task> tasks = new ArrayList<Task>();
    private boolean noAct;

    public QuickTask(String name, String tooltip, Runnable run) {
        this.tasks.add(new Task(name, tooltip, run));
    }

    public QuickTask(String name, String tooltip, Runnable run, boolean noAct) {
        this.tasks.add(new Task(name, tooltip, run));
        this.noAct = noAct;
    }

    public QuickTask add(String name, String tooltip, Runnable run) {
        this.tasks.add(new Task(name, tooltip, run));
        return this;
    }

    public void initButtons(IGui gui, Panel p) {
        for (int i = 0; i < this.tasks.size(); ++i) {
            Task t = this.tasks.get(i);
            String name = t.name;
            if (i == 0 && !this.noAct) {
                name = name + " (" + Keybinds.RUN_QUICK_ACTION.getSetKey(gui) + ")";
            }
            Button b = new Button(gui, name, t.action);
            if (t.tooltip != null) {
                b.setTooltip(new Tooltip(gui.getFrame(), t.tooltip));
            }
            b.setBounds(new Box(0, 0, p.getBounds().w, 20));
            p.addElement(b);
        }
    }

    public void runTask() {
        if (!this.noAct) {
            this.tasks.get((int)0).action.run();
        }
    }

    private static class Task {
        public final String name;
        public final String tooltip;
        public final Runnable action;

        public Task(String name, String tooltip, Runnable run) {
            this.name = name;
            this.tooltip = tooltip;
            this.action = run;
        }
    }
}

