/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpmcore;

import com.tom.cpm.shared.config.PlayerData;
import com.tom.cpm.shared.network.NetH;
import java.util.HashMap;
import java.util.Map;
import java.util.function.UnaryOperator;
import net.minecraft.launchwrapper.IClassTransformer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class CPMTransformerService
implements IClassTransformer {
    public static final Logger LOG = LogManager.getLogger((String)"CPM Core");
    private static final String HOOKS_CLASS = "com/tom/cpmcore/CPMASMClientHooks";
    private static final String HOOKS_CLASS_SERVER = "com/tom/cpmcore/CPMASMServerHooks";
    private static final String NO_MODEL_SETUP_FIELD = "cpm$noModelSetup";
    private static final String RENDER_PLAYER_FIELD = "cpm$renderPlayer";
    private static final String HAS_MOD_FIELD = "cpm$hasMod";
    private static final String DATA_FIELD = "cpm$data";
    private static Map<String, UnaryOperator<ClassNode>> transformers;

    public static void init() {
        transformers = new HashMap<String, UnaryOperator<ClassNode>>();
        transformers.put("net.minecraft.client.renderer.tileentity.TileEntitySkullRenderer", new UnaryOperator<ClassNode>(){

            @Override
            public ClassNode apply(ClassNode input) {
                InsnList lst = new InsnList();
                int modelBase = 9;
                lst.add((AbstractInsnNode)new VarInsnNode(25, modelBase));
                lst.add((AbstractInsnNode)new VarInsnNode(25, 7));
                lst.add((AbstractInsnNode)new MethodInsnNode(184, CPMTransformerService.HOOKS_CLASS, "renderSkull", "(Lnet/minecraft/client/model/ModelBase;Lcom/mojang/authlib/GameProfile;)V", false));
                InsnList lst2 = new InsnList();
                lst2.add((AbstractInsnNode)new VarInsnNode(25, modelBase));
                lst2.add((AbstractInsnNode)new VarInsnNode(25, 7));
                lst2.add((AbstractInsnNode)new MethodInsnNode(184, CPMTransformerService.HOOKS_CLASS, "renderSkullPost", "(Lnet/minecraft/client/model/ModelBase;Lcom/mojang/authlib/GameProfile;)V", false));
                MethodNode m = null;
                for (MethodNode method : input.methods) {
                    if (!method.desc.equals("(FFFLnet/minecraft/util/EnumFacing;FILcom/mojang/authlib/GameProfile;I)V") && !method.desc.equals("(FFFLcq;FILcom/mojang/authlib/GameProfile;I)V")) continue;
                    m = method;
                    LOG.info("CPM Skull Hook: found method");
                    break;
                }
                for (AbstractInsnNode insnNode : m.instructions) {
                    if (insnNode instanceof VarInsnNode) {
                        VarInsnNode nd = (VarInsnNode)insnNode;
                        if (nd.getOpcode() != 25 || nd.var != modelBase) continue;
                        m.instructions.insertBefore((AbstractInsnNode)nd, lst);
                        LOG.info("CPM Skull Hook: injected (Pre)");
                        continue;
                    }
                    if (!(insnNode instanceof InsnNode) || insnNode.getOpcode() != 177) continue;
                    m.instructions.insertBefore(insnNode, lst2);
                    LOG.info("CPM Skull Hook: injected (Post)");
                }
                return input;
            }
        });
        transformers.put("net.minecraft.client.model.ModelBiped", new UnaryOperator<ClassNode>(){

            @Override
            public ClassNode apply(ClassNode input) {
                input.fields.add(new FieldNode(1, CPMTransformerService.NO_MODEL_SETUP_FIELD, "Z", null, (Object)0));
                for (MethodNode method : input.methods) {
                    if ((!method.name.equals("a") || !method.desc.equals("(FFFFFFLpk;)V")) && !method.name.equals("setRotationAngles")) continue;
                    LOG.info("CPM Armor Hook/No setup: found setRotationAngles method");
                    InsnList lst = new InsnList();
                    lst.add((AbstractInsnNode)new VarInsnNode(25, 0));
                    lst.add((AbstractInsnNode)new FieldInsnNode(180, input.name, CPMTransformerService.NO_MODEL_SETUP_FIELD, "Z"));
                    LabelNode lbln = new LabelNode();
                    lst.add((AbstractInsnNode)new JumpInsnNode(153, lbln));
                    lst.add((AbstractInsnNode)new InsnNode(177));
                    lst.add((AbstractInsnNode)lbln);
                    method.instructions.insertBefore(method.instructions.getFirst(), lst);
                    LOG.info("CPM Armor Hook/No setup: injected");
                }
                return input;
            }
        });
        transformers.put("gg.essential.mixins.impl.client.model.ModelBipedUtil", new UnaryOperator<ClassNode>(){

            @Override
            public ClassNode apply(ClassNode input) {
                for (MethodNode method : input.methods) {
                    if (!method.name.equals("resetPose")) continue;
                    LOG.info("CPM Armor Hook (Essential)/No setup: found resetPose method");
                    InsnList lst = new InsnList();
                    lst.add((AbstractInsnNode)new VarInsnNode(25, 0));
                    lst.add((AbstractInsnNode)new FieldInsnNode(180, "net/minecraft/client/model/ModelBiped", CPMTransformerService.NO_MODEL_SETUP_FIELD, "Z"));
                    LabelNode lbln = new LabelNode();
                    lst.add((AbstractInsnNode)new JumpInsnNode(153, lbln));
                    lst.add((AbstractInsnNode)new InsnNode(177));
                    lst.add((AbstractInsnNode)lbln);
                    method.instructions.insertBefore(method.instructions.getFirst(), lst);
                    LOG.info("CPM Armor Hook (Essential)/No setup: injected");
                }
                return input;
            }
        });
        transformers.put("net.minecraft.client.renderer.entity.layers.LayerArmorBase", new UnaryOperator<ClassNode>(){

            @Override
            public ClassNode apply(ClassNode input) {
                FieldNode rendererField = null;
                for (FieldNode fn : input.fields) {
                    if (!fn.name.equals("a") && !fn.name.equals("renderer")) continue;
                    rendererField = fn;
                    LOG.info("CPM Armor Hook/Layer: Found renderer field");
                }
                Type renderer = Type.getType((String)rendererField.desc);
                for (MethodNode method : input.methods) {
                    Type[] args;
                    Type[] argsD;
                    MethodInsnNode mn;
                    if (method.name.equals("a") && method.desc.equals("(Lpr;FFFFFFFI)V") || method.name.equals("renderLayer")) {
                        LOG.info("CPM Armor Hook/Layer: Found renderLayer method");
                        for (AbstractInsnNode insnNode : method.instructions) {
                            if (!(insnNode instanceof MethodInsnNode)) continue;
                            mn = (MethodInsnNode)insnNode;
                            if ((!mn.name.equals("a") || !mn.desc.equals("(Lpk;FFFFFF)V")) && !mn.name.equals("render")) continue;
                            LOG.info("CPM Armor Hook/Layer: Found render call");
                            argsD = Type.getArgumentTypes((String)mn.desc);
                            args = new Type[argsD.length + 2];
                            args[0] = Type.getObjectType((String)mn.owner);
                            System.arraycopy(argsD, 0, args, 1, argsD.length);
                            args[args.length - 1] = renderer;
                            mn.desc = Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])args);
                            mn.name = "renderArmor";
                            mn.setOpcode(184);
                            mn.owner = CPMTransformerService.HOOKS_CLASS;
                            InsnList lst = new InsnList();
                            lst.add((AbstractInsnNode)new VarInsnNode(25, 0));
                            lst.add((AbstractInsnNode)new FieldInsnNode(180, input.name, rendererField.name, rendererField.desc));
                            method.instructions.insertBefore(insnNode, lst);
                            LOG.info("CPM Armor Hook/Layer: injected");
                        }
                        continue;
                    }
                    if (method.name.equals("a") && method.desc.equals("(Lpr;FFFFFFF)V") || method.name.equals("doRenderLayer")) {
                        LOG.info("CPM Armor Hook/Bind: Found doRenderLayer method");
                        Type[] argsD2 = Type.getArgumentTypes((String)method.desc);
                        Type[] args2 = new Type[]{Type.getObjectType((String)input.name), argsD2[0]};
                        InsnList lst = new InsnList();
                        lst.add((AbstractInsnNode)new VarInsnNode(25, 0));
                        lst.add((AbstractInsnNode)new VarInsnNode(25, 1));
                        lst.add((AbstractInsnNode)new MethodInsnNode(184, CPMTransformerService.HOOKS_CLASS, "onArmorPre", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])args2), false));
                        method.instructions.insertBefore(method.instructions.getFirst(), lst);
                        for (AbstractInsnNode insnNode : method.instructions) {
                            if (!(insnNode instanceof InsnNode) || insnNode.getOpcode() != 177) continue;
                            InsnList lst2 = new InsnList();
                            lst2.add((AbstractInsnNode)new VarInsnNode(25, 0));
                            lst2.add((AbstractInsnNode)new VarInsnNode(25, 1));
                            lst2.add((AbstractInsnNode)new MethodInsnNode(184, CPMTransformerService.HOOKS_CLASS, "onArmorPost", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])args2), false));
                            method.instructions.insertBefore(insnNode, lst2);
                        }
                        LOG.info("CPM Armor Hook/Bind: injected");
                        continue;
                    }
                    if ((!method.name.equals("a") || !method.desc.equals("(Lpr;Lbbo;FFFFFFF)V")) && !method.name.equals("func_177183_a")) continue;
                    LOG.info("CPM Armor Hook/LayerGlint: Found renderEnchantedGlint method");
                    for (AbstractInsnNode insnNode : method.instructions) {
                        if (!(insnNode instanceof MethodInsnNode)) continue;
                        mn = (MethodInsnNode)insnNode;
                        if ((!mn.name.equals("a") || !mn.desc.equals("(Lpk;FFFFFF)V")) && !mn.name.equals("render")) continue;
                        LOG.info("CPM Armor Hook/LayerGlint: Found render call");
                        argsD = Type.getArgumentTypes((String)mn.desc);
                        args = new Type[argsD.length + 1];
                        args[0] = Type.getObjectType((String)mn.owner);
                        System.arraycopy(argsD, 0, args, 1, argsD.length);
                        mn.desc = Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])args);
                        mn.name = "renderArmorGlint";
                        mn.setOpcode(184);
                        mn.owner = CPMTransformerService.HOOKS_CLASS;
                        LOG.info("CPM Armor Hook/LayerGlint: injected");
                    }
                }
                return input;
            }
        });
        transformers.put("com.tom.cpmcore.CPMClientAccess", new UnaryOperator<ClassNode>(){

            @Override
            public ClassNode apply(ClassNode input) {
                for (MethodNode method : input.methods) {
                    if (!method.name.equals("setNoSetup")) continue;
                    method.instructions.clear();
                    method.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
                    method.instructions.add((AbstractInsnNode)new VarInsnNode(21, 1));
                    method.instructions.add((AbstractInsnNode)new FieldInsnNode(181, Type.getArgumentTypes((String)method.desc)[0].getInternalName(), CPMTransformerService.NO_MODEL_SETUP_FIELD, "Z"));
                    method.instructions.add((AbstractInsnNode)new InsnNode(177));
                    LOG.info("CPM ASM fields/No Render: injected");
                }
                return input;
            }
        });
        transformers.put("net.minecraft.client.renderer.entity.layers.LayerCustomHead", new UnaryOperator<ClassNode>(){

            @Override
            public ClassNode apply(ClassNode input) {
                input.fields.add(new FieldNode(1, CPMTransformerService.RENDER_PLAYER_FIELD, "Lnet/minecraft/client/renderer/entity/RenderPlayer;", null, null));
                for (MethodNode method : input.methods) {
                    if (!method.name.equals("a") && !method.name.equals("doRenderLayer")) continue;
                    LOG.info("CPM Armor Hook/Skull: Found doRenderLayer method");
                    for (AbstractInsnNode insnNode : method.instructions) {
                        if (!(insnNode instanceof MethodInsnNode)) continue;
                        MethodInsnNode mn = (MethodInsnNode)insnNode;
                        if (!mn.name.equals("c") && !mn.name.equals("postRender") || !mn.desc.equals("(F)V")) continue;
                        LOG.info("CPM Armor Hook/Skull: Found postRender call");
                        InsnList lst = new InsnList();
                        lst.add((AbstractInsnNode)new VarInsnNode(25, 0));
                        lst.add((AbstractInsnNode)new FieldInsnNode(180, input.name, CPMTransformerService.RENDER_PLAYER_FIELD, "Lnet/minecraft/client/renderer/entity/RenderPlayer;"));
                        Type[] argsD = Type.getArgumentTypes((String)mn.desc);
                        Type[] args = new Type[argsD.length + 2];
                        args[0] = Type.getObjectType((String)mn.owner);
                        System.arraycopy(argsD, 0, args, 1, argsD.length);
                        args[args.length - 1] = Type.getType((String)"Lnet/minecraft/client/renderer/entity/RenderPlayer;");
                        mn.desc = Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])args);
                        mn.name = "postRenderSkull";
                        mn.setOpcode(184);
                        mn.owner = CPMTransformerService.HOOKS_CLASS;
                        method.instructions.insertBefore(insnNode, lst);
                        LOG.info("CPM Armor Hook/Skull: injected");
                    }
                }
                return input;
            }
        });
        transformers.put("net.minecraft.client.renderer.entity.RenderPlayer", new UnaryOperator<ClassNode>(){

            @Override
            public ClassNode apply(ClassNode input) {
                boolean isDeobf = false;
                input.interfaces.add("com/tom/cpmcore/IPlayerRenderer");
                for (MethodNode method : input.methods) {
                    InsnList lst2;
                    InsnList lst;
                    if (method.name.equals("<init>")) {
                        LOG.info("CPM RenderPlayer Hook: Found constructor");
                        for (AbstractInsnNode insnNode : method.instructions) {
                            if (!(insnNode instanceof FieldInsnNode)) continue;
                            FieldInsnNode fn = (FieldInsnNode)insnNode;
                            if (!fn.name.equals("e") && !fn.name.equals("bipedHead")) continue;
                            LOG.info("CPM RenderPlayer Hook: Found bipedHead field insn");
                            InsnList lst3 = new InsnList();
                            lst3.add((AbstractInsnNode)new InsnNode(89));
                            lst3.add((AbstractInsnNode)new VarInsnNode(25, 0));
                            lst3.add((AbstractInsnNode)new FieldInsnNode(181, "net/minecraft/client/renderer/entity/layers/LayerCustomHead", CPMTransformerService.RENDER_PLAYER_FIELD, "Lnet/minecraft/client/renderer/entity/RenderPlayer;"));
                            method.instructions.insert(fn.getNext(), lst3);
                            LOG.info("CPM RenderPlayer Hook: injected");
                        }
                    }
                    if (method.name.equals("renderRightArm") || method.name.equals("b") && method.desc.equals("(Lbet;)V")) {
                        LOG.info("CPM Render Hand Hook: Found renderRightArm");
                        if (method.name.equals("renderRightArm")) {
                            isDeobf = true;
                        }
                        lst = new InsnList();
                        lst.add((AbstractInsnNode)new VarInsnNode(25, 0));
                        lst.add((AbstractInsnNode)new VarInsnNode(25, 1));
                        lst.add((AbstractInsnNode)new MethodInsnNode(184, CPMTransformerService.HOOKS_CLASS, "onHandRightPre", "(Lnet/minecraft/client/renderer/entity/RenderPlayer;Lnet/minecraft/client/entity/AbstractClientPlayer;)V", false));
                        method.instructions.insertBefore(method.instructions.getFirst(), lst);
                        LOG.info("CPM Render Hand Hook/Right Pre: injected");
                        lst2 = new InsnList();
                        lst2.add((AbstractInsnNode)new VarInsnNode(25, 0));
                        lst2.add((AbstractInsnNode)new VarInsnNode(25, 1));
                        lst2.add((AbstractInsnNode)new MethodInsnNode(184, CPMTransformerService.HOOKS_CLASS, "onHandRightPost", "(Lnet/minecraft/client/renderer/entity/RenderPlayer;Lnet/minecraft/client/entity/AbstractClientPlayer;)V", false));
                        for (AbstractInsnNode insnNode : method.instructions) {
                            if (!(insnNode instanceof InsnNode) || insnNode.getOpcode() != 177) continue;
                            method.instructions.insertBefore(insnNode, lst2);
                            LOG.info("CPM Render Hand Hook/Right Post: injected");
                        }
                    }
                    if (!method.name.equals("renderLeftArm") && (!method.name.equals("c") || !method.desc.equals("(Lbet;)V"))) continue;
                    LOG.info("CPM Render Hand Hook: Found renderLeftArm");
                    lst = new InsnList();
                    lst.add((AbstractInsnNode)new VarInsnNode(25, 0));
                    lst.add((AbstractInsnNode)new VarInsnNode(25, 1));
                    lst.add((AbstractInsnNode)new MethodInsnNode(184, CPMTransformerService.HOOKS_CLASS, "onHandLeftPre", "(Lnet/minecraft/client/renderer/entity/RenderPlayer;Lnet/minecraft/client/entity/AbstractClientPlayer;)V", false));
                    method.instructions.insertBefore(method.instructions.getFirst(), lst);
                    LOG.info("CPM Render Hand Hook/Left Pre: injected");
                    lst2 = new InsnList();
                    lst2.add((AbstractInsnNode)new VarInsnNode(25, 0));
                    lst2.add((AbstractInsnNode)new VarInsnNode(25, 1));
                    lst2.add((AbstractInsnNode)new MethodInsnNode(184, CPMTransformerService.HOOKS_CLASS, "onHandLeftPost", "(Lnet/minecraft/client/renderer/entity/RenderPlayer;Lnet/minecraft/client/entity/AbstractClientPlayer;)V", false));
                    for (AbstractInsnNode insnNode : method.instructions) {
                        if (!(insnNode instanceof InsnNode) || insnNode.getOpcode() != 177) continue;
                        method.instructions.insertBefore(insnNode, lst2);
                        LOG.info("CPM Render Hand Hook/Left Post: injected");
                    }
                }
                String name = isDeobf ? "renderModel" : "func_77036_a";
                LOG.info("CPM Render Invis Hook: Injecting method " + (isDeobf ? "deobf" : ""));
                MethodNode mn = new MethodNode(1, name, "(Lnet/minecraft/entity/EntityLivingBase;FFFFFF)V", null, null);
                mn.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
                mn.instructions.add((AbstractInsnNode)new VarInsnNode(25, 1));
                mn.instructions.add((AbstractInsnNode)new VarInsnNode(23, 2));
                mn.instructions.add((AbstractInsnNode)new VarInsnNode(23, 3));
                mn.instructions.add((AbstractInsnNode)new VarInsnNode(23, 4));
                mn.instructions.add((AbstractInsnNode)new VarInsnNode(23, 5));
                mn.instructions.add((AbstractInsnNode)new VarInsnNode(23, 6));
                mn.instructions.add((AbstractInsnNode)new VarInsnNode(23, 7));
                mn.instructions.add((AbstractInsnNode)new MethodInsnNode(184, CPMTransformerService.HOOKS_CLASS, "onRenderPlayerModel", "(Lnet/minecraft/client/renderer/entity/RenderPlayer;Lnet/minecraft/entity/EntityLivingBase;FFFFFF)Z", false));
                LabelNode lbln = new LabelNode();
                mn.instructions.add((AbstractInsnNode)new JumpInsnNode(153, lbln));
                mn.instructions.add((AbstractInsnNode)new InsnNode(177));
                mn.instructions.add((AbstractInsnNode)lbln);
                mn.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
                mn.instructions.add((AbstractInsnNode)new VarInsnNode(25, 1));
                mn.instructions.add((AbstractInsnNode)new VarInsnNode(23, 2));
                mn.instructions.add((AbstractInsnNode)new VarInsnNode(23, 3));
                mn.instructions.add((AbstractInsnNode)new VarInsnNode(23, 4));
                mn.instructions.add((AbstractInsnNode)new VarInsnNode(23, 5));
                mn.instructions.add((AbstractInsnNode)new VarInsnNode(23, 6));
                mn.instructions.add((AbstractInsnNode)new VarInsnNode(23, 7));
                mn.instructions.add((AbstractInsnNode)new MethodInsnNode(183, "net/minecraft/client/renderer/entity/RendererLivingEntity", name, "(Lnet/minecraft/entity/EntityLivingBase;FFFFFF)V", false));
                mn.instructions.add((AbstractInsnNode)new InsnNode(177));
                input.methods.add(mn);
                LOG.info("CPM Render Invis Hook: injected");
                name = isDeobf ? "bindEntityTexture" : "func_180548_c";
                mn = new MethodNode(1, "cpm$bindEntityTexture", "(Lnet/minecraft/client/entity/AbstractClientPlayer;)Z", null, null);
                mn.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
                mn.instructions.add((AbstractInsnNode)new VarInsnNode(25, 1));
                mn.instructions.add((AbstractInsnNode)new MethodInsnNode(182, input.name, name, "(Lnet/minecraft/entity/Entity;)Z", false));
                mn.instructions.add((AbstractInsnNode)new InsnNode(172));
                input.methods.add(mn);
                LOG.info("CPM Render Invis Hook/Bind Texture: injected");
                return input;
            }
        });
        transformers.put("net.minecraft.client.Minecraft", new UnaryOperator<ClassNode>(){

            @Override
            public ClassNode apply(ClassNode input) {
                InsnList lst = new InsnList();
                lst.add((AbstractInsnNode)new MethodInsnNode(184, CPMTransformerService.HOOKS_CLASS, "onLogout", "()V", false));
                for (MethodNode method : input.methods) {
                    if (!method.name.equals("loadWorld") && (!method.name.equals("a") || !method.desc.equals("(Lbdb;Ljava/lang/String;)V"))) continue;
                    LOG.info("CPM ClientLogout Hook: Found loadWorld");
                    for (AbstractInsnNode insnNode : method.instructions) {
                        if (!(insnNode instanceof MethodInsnNode)) continue;
                        MethodInsnNode mn = (MethodInsnNode)insnNode;
                        if ((!mn.name.equals("b") || !mn.desc.equals("()V") || !(mn.getPrevious() instanceof FieldInsnNode) || !((FieldInsnNode)mn.getPrevious()).name.equals("p")) && !mn.name.equals("clearAchievements")) continue;
                        method.instructions.insert((AbstractInsnNode)mn, lst);
                        LOG.info("CPM ClientLogout Hook: injected");
                    }
                }
                return input;
            }
        });
        transformers.put("net.minecraft.client.network.NetHandlerPlayClient", new UnaryOperator<ClassNode>(){

            @Override
            public ClassNode apply(ClassNode input) {
                InsnList lst = new InsnList();
                lst.add((AbstractInsnNode)new VarInsnNode(25, 1));
                lst.add((AbstractInsnNode)new VarInsnNode(25, 0));
                lst.add((AbstractInsnNode)new MethodInsnNode(184, CPMTransformerService.HOOKS_CLASS, "onClientPacket", "(Lnet/minecraft/network/play/server/S3FPacketCustomPayload;Lnet/minecraft/client/network/NetHandlerPlayClient;)Z", false));
                LabelNode lbln = new LabelNode();
                lst.add((AbstractInsnNode)new JumpInsnNode(153, lbln));
                lst.add((AbstractInsnNode)new InsnNode(177));
                lst.add((AbstractInsnNode)lbln);
                input.interfaces.add(Type.getInternalName(NetH.class));
                input.fields.add(new FieldNode(1, CPMTransformerService.HAS_MOD_FIELD, "Z", null, (Object)0));
                for (MethodNode method : input.methods) {
                    if (!method.name.equals("handleCustomPayload") && (!method.name.equals("a") || !method.desc.equals("(Lgg;)V"))) continue;
                    LOG.info("CPM ClientNet Hook: Found handleCustomPayload");
                    method.instructions.insertBefore(method.instructions.getFirst(), lst);
                    LOG.info("CPM ClientNet Hook: injected");
                }
                CPMTransformerService.injectHasMod("ClientNet", input);
                return input;
            }
        });
        transformers.put("net.minecraft.network.NetHandlerPlayServer", new UnaryOperator<ClassNode>(){

            @Override
            public ClassNode apply(ClassNode input) {
                InsnList lst = new InsnList();
                lst.add((AbstractInsnNode)new VarInsnNode(25, 1));
                lst.add((AbstractInsnNode)new VarInsnNode(25, 0));
                lst.add((AbstractInsnNode)new MethodInsnNode(184, CPMTransformerService.HOOKS_CLASS_SERVER, "onServerPacket", "(Lnet/minecraft/network/play/client/C17PacketCustomPayload;Lnet/minecraft/network/NetHandlerPlayServer;)Z", false));
                LabelNode lbln = new LabelNode();
                lst.add((AbstractInsnNode)new JumpInsnNode(153, lbln));
                lst.add((AbstractInsnNode)new InsnNode(177));
                lst.add((AbstractInsnNode)lbln);
                input.interfaces.add(Type.getInternalName(NetH.ServerNetH.class));
                input.fields.add(new FieldNode(1, CPMTransformerService.HAS_MOD_FIELD, "Z", null, (Object)0));
                input.fields.add(new FieldNode(1, CPMTransformerService.DATA_FIELD, Type.getDescriptor(PlayerData.class), null, null));
                for (MethodNode method : input.methods) {
                    if (!method.name.equals("processVanilla250Packet") && (!method.name.equals("a") || !method.desc.equals("(Lim;)V"))) continue;
                    LOG.info("CPM ServerNet Hook: Found processCustomPayload");
                    method.instructions.insertBefore(method.instructions.getFirst(), lst);
                    LOG.info("CPM ServerNet Hook: injected");
                }
                CPMTransformerService.injectHasMod("ServerNet", input);
                MethodNode method = new MethodNode(1, "cpm$getEncodedModelData", Type.getMethodDescriptor((Type)Type.getType(PlayerData.class), (Type[])new Type[0]), null, null);
                input.methods.add(method);
                method.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
                method.instructions.add((AbstractInsnNode)new FieldInsnNode(180, input.name, CPMTransformerService.DATA_FIELD, Type.getDescriptor(PlayerData.class)));
                method.instructions.add((AbstractInsnNode)new InsnNode(176));
                LOG.info("CPM ServerNet/getData: injected");
                method = new MethodNode(1, "cpm$setEncodedModelData", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(PlayerData.class)}), null, null);
                input.methods.add(method);
                method.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
                method.instructions.add((AbstractInsnNode)new VarInsnNode(25, 1));
                method.instructions.add((AbstractInsnNode)new FieldInsnNode(181, input.name, CPMTransformerService.DATA_FIELD, Type.getDescriptor(PlayerData.class)));
                method.instructions.add((AbstractInsnNode)new InsnNode(177));
                LOG.info("CPM ServerNet/setData: injected");
                return input;
            }
        });
        transformers.put("net.minecraft.client.renderer.entity.layers.LayerCape", new UnaryOperator<ClassNode>(){

            @Override
            public ClassNode apply(ClassNode input) {
                for (MethodNode method : input.methods) {
                    if ((!method.name.equals("a") || !method.desc.equals("(Lpr;FFFFFFF)V")) && !method.name.equals("doRenderLayer")) continue;
                    LOG.info("CPM Cape Hook/Bind: Found doRenderLayer method");
                    Type[] argsD = Type.getArgumentTypes((String)method.desc);
                    Type[] args = new Type[]{Type.getObjectType((String)input.name), argsD[0], Type.FLOAT_TYPE};
                    InsnList lst = new InsnList();
                    lst.add((AbstractInsnNode)new VarInsnNode(25, 0));
                    lst.add((AbstractInsnNode)new VarInsnNode(25, 1));
                    lst.add((AbstractInsnNode)new VarInsnNode(23, 4));
                    lst.add((AbstractInsnNode)new MethodInsnNode(184, CPMTransformerService.HOOKS_CLASS, "renderCape", Type.getMethodDescriptor((Type)Type.BOOLEAN_TYPE, (Type[])args), false));
                    LabelNode lbln = new LabelNode();
                    lst.add((AbstractInsnNode)new JumpInsnNode(153, lbln));
                    lst.add((AbstractInsnNode)new InsnNode(177));
                    lst.add((AbstractInsnNode)lbln);
                    method.instructions.insertBefore(method.instructions.getFirst(), lst);
                }
                return input;
            }
        });
    }

    private static void injectHasMod(String name, ClassNode input) {
        MethodNode method = new MethodNode(1, HAS_MOD_FIELD, "()Z", null, null);
        input.methods.add(method);
        method.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        method.instructions.add((AbstractInsnNode)new FieldInsnNode(180, input.name, HAS_MOD_FIELD, "Z"));
        method.instructions.add((AbstractInsnNode)new InsnNode(172));
        LOG.info("CPM " + name + "/hasMod: injected");
        method = new MethodNode(1, "cpm$setHasMod", "(Z)V", null, null);
        input.methods.add(method);
        method.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        method.instructions.add((AbstractInsnNode)new VarInsnNode(21, 1));
        method.instructions.add((AbstractInsnNode)new FieldInsnNode(181, input.name, HAS_MOD_FIELD, "Z"));
        method.instructions.add((AbstractInsnNode)new InsnNode(177));
        LOG.info("CPM " + name + "/setHasMod: injected");
    }

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (transformers == null) {
            return basicClass;
        }
        UnaryOperator<ClassNode> tr = transformers.get(transformedName);
        if (tr != null) {
            ClassNode classNode = new ClassNode();
            ClassReader classReader = new ClassReader(basicClass);
            classReader.accept((ClassVisitor)classNode, 0);
            LOG.info("Applying cpm transformer: " + transformedName);
            classNode = (ClassNode)tr.apply(classNode);
            ClassWriter writer = new ClassWriter(3);
            classNode.accept((ClassVisitor)writer);
            return writer.toByteArray();
        }
        return basicClass;
    }
}

