/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.client;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.tom.cpm.CustomPlayerModels;
import com.tom.cpm.client.CustomPlayerModelsClient;
import com.tom.cpm.client.IrisPipelineSetup;
import com.tom.cpm.client.MinecraftObject;
import com.tom.cpm.client.Platform;
import com.tom.cpm.client.PlayerProfile;
import com.tom.cpm.client.PlayerRenderStateAccess;
import com.tom.cpm.common.ByteArrayPayload;
import com.tom.cpm.common.PlayerAnimUpdater;
import com.tom.cpm.mixinplugin.IrisDetector;
import com.tom.cpm.mixinplugin.OFDetector;
import com.tom.cpm.shared.model.RenderManager;
import com.tom.cpm.shared.network.NetHandler;
import com.tom.cpm.shared.util.Log;
import java.util.function.Function;
import net.minecraft.class_10034;
import net.minecraft.class_10055;
import net.minecraft.class_11677;
import net.minecraft.class_11890;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2817;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3879;
import net.minecraft.class_563;
import net.minecraft.class_572;
import net.minecraft.class_591;
import net.minecraft.class_634;
import net.minecraft.class_742;
import net.minecraft.class_746;
import net.minecraft.class_8710;

public abstract class ClientBase {
    public static final class_2960 DEFAULT_CAPE = class_2960.method_60654((String)"cpm:textures/template/cape.png");
    public static boolean optifineLoaded;
    public static boolean irisLoaded;
    public static boolean vrLoaded;
    public static MinecraftObject mc;
    public RenderManager<GameProfile, class_11890, class_3879, Void> manager;
    public NetHandler<class_8710.class_9154<ByteArrayPayload>, class_11890, class_634> netHandler;

    public void init0() {
        mc = new MinecraftObject();
        optifineLoaded = OFDetector.doApply();
        vrLoaded = Platform.isModLoaded("vivecraft");
        irisLoaded = IrisDetector.doApply();
        if (optifineLoaded) {
            Log.info("Optifine detected, enabling optifine compatibility");
        }
        if (vrLoaded) {
            Log.info("ViveCraft detected, enabling ViveCraft compatibility");
        }
        if (irisLoaded) {
            Log.info("Iris detected, enabling iris compatibility");
        }
    }

    public void init1() {
        this.manager = new RenderManager<GameProfile, class_11890, class_3879, Void>(mc.getPlayerRenderManager(), mc.getDefinitionLoader(), PlayerProfile::getPlayerProfile);
        this.manager.setGPGetters(GameProfile::properties, Property::value);
        this.netHandler = new NetHandler((k, v) -> new class_8710.class_9154(class_2960.method_43902((String)k, (String)v)));
        this.netHandler.setExecutor(class_310::method_1551);
        this.netHandler.setSendPacketClient(Function.identity(), (c, rl, pb) -> c.method_52787((class_2596)new class_2817((class_8710)new ByteArrayPayload((class_8710.class_9154<ByteArrayPayload>)rl, (byte[])pb))));
        this.netHandler.setPlayerToLoader(PlayerProfile::getPlayerProfile);
        this.netHandler.setGetPlayerById(id -> {
            class_1297 ent = class_310.method_1551().field_1687.method_8469(id);
            if (ent instanceof class_11890) {
                class_11890 a = (class_11890)ent;
                return a;
            }
            return null;
        });
        this.netHandler.setGetClient(() -> class_310.method_1551().field_1724);
        this.netHandler.setGetNet(c -> ((class_746)c).field_3944);
        this.netHandler.setDisplayText(t -> class_310.method_1551().field_1724.method_7353((class_2561)t.remap(), false));
        this.netHandler.setGetPlayerAnimGetters(new PlayerAnimUpdater());
        if (irisLoaded) {
            IrisPipelineSetup.setup();
        }
    }

    public static void apiInit() {
        CustomPlayerModels.api.buildClient().voicePlayer(class_1657.class, class_1297::method_5667).localModelApi(GameProfile::new).init();
    }

    public void playerRenderPre(PlayerRenderStateAccess sa, class_591 model, class_10055 renderState) {
        CustomPlayerModelsClient.INSTANCE.manager.bindPlayerState(sa.cpm$getPlayer(), null, model, null);
        model.method_62110(renderState);
        mc.getPlayerRenderManager().setModelPose(model);
    }

    public void playerRenderPost(class_591 model) {
        this.manager.unbindClear((class_3879)model);
    }

    public void renderHand(class_591 model) {
        this.renderHand((class_742)class_310.method_1551().field_1724, model);
    }

    public void renderHand(class_742 pl, class_591 model) {
        this.manager.bindHand((class_11890)pl, null, (class_3879)model);
    }

    public void renderHandPost(class_572 model) {
        this.manager.unbindClear((class_3879)model);
    }

    public void renderElytra(class_572<class_10034> player, class_563 model) {
        this.manager.bindElytra((class_3879)player, (class_3879)model);
    }

    public void renderArmor(class_11677<class_572<class_10034>> modelSet, class_572<class_10034> player) {
        this.manager.bindArmor((class_3879)player, (class_3879)modelSet.comp_4542(), 1);
        this.manager.bindArmor((class_3879)player, (class_3879)modelSet.comp_4544(), 2);
        this.manager.bindArmor((class_3879)player, (class_3879)modelSet.comp_4543(), 3);
        this.manager.bindArmor((class_3879)player, (class_3879)modelSet.comp_4545(), 4);
    }

    public void updateJump() {
        class_310 minecraft = class_310.method_1551();
        if (minecraft.field_1724.method_24828() && minecraft.field_1724.field_3913.field_54155.comp_3163()) {
            this.manager.jump((class_11890)minecraft.field_1724);
        }
    }
}

