/*
 * Decompiled with CFR 0.152.
 */
package com.nebby1999.firmacivplus;

import com.alekiponi.alekiships.common.entity.vehicle.AbstractVehicle;
import com.alekiponi.alekiships.util.BoatMaterial;
import com.alekiponi.firmaciv.common.entity.vehicle.CanoeEntity;
import com.eerussianguy.beneath.common.blocks.Stem;
import com.eerussianguy.beneath.common.items.BeneathItems;
import com.nebby1999.firmacivplus.FirmaCivPlusEntities;
import com.nebby1999.firmacivplus.WatercraftMaterial;
import java.util.Optional;
import net.dries007.tfc.common.blocks.wood.Wood;
import net.dries007.tfc.util.registry.RegistryWood;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.RegistryObject;

public enum BeneathWatercraftMaterial implements WatercraftMaterial
{
    CRIMSON(Stem.CRIMSON, true),
    WARPED(Stem.WARPED, false);

    public final boolean isSoftwood;
    public final Stem wood;

    private BeneathWatercraftMaterial(Stem wood, boolean isSoftwood) {
        this.wood = wood;
        this.isSoftwood = isSoftwood;
    }

    public Item getRailing() {
        return (Item)((RegistryObject)BeneathItems.LUMBER.get(this.wood)).get();
    }

    public Item getStrippedLog() {
        return ((Block)this.wood.getBlock(Wood.BlockType.STRIPPED_LOG).get()).m_5456_();
    }

    public boolean withstandsLava() {
        return false;
    }

    public BlockState getDeckBlock() {
        return ((Block)this.wood.getBlock(Wood.BlockType.PLANKS).get()).m_49966_();
    }

    public Optional<EntityType<? extends AbstractVehicle>> getEntityType(BoatMaterial.BoatType boatType) {
        return switch (boatType) {
            default -> throw new IncompatibleClassChangeError();
            case BoatMaterial.BoatType.ROWBOAT -> Optional.of((EntityType)FirmaCivPlusEntities.getRowboats().get(this).get());
            case BoatMaterial.BoatType.SLOOP -> Optional.of((EntityType)FirmaCivPlusEntities.getSloops().get(this).get());
            case BoatMaterial.BoatType.CONSTRUCTION_SLOOP -> Optional.of((EntityType)FirmaCivPlusEntities.getSloopsUnderConstruction().get(this).get());
        };
    }

    public Optional<EntityType<? extends CanoeEntity>> getCanoeType() {
        return Optional.of((EntityType)FirmaCivPlusEntities.getCanoes().get(this).get());
    }

    public String m_7912_() {
        return this.wood.m_7912_();
    }

    @Override
    public RegistryWood getWood() {
        return this.wood;
    }

    @Override
    public boolean isSoftwood() {
        return this.isSoftwood;
    }
}

