/*
 * Decompiled with CFR 0.152.
 */
package com.nebby1999.firmacivplus;

import com.alekiponi.alekiships.util.BoatMaterial;
import com.alekiponi.firmaciv.common.entity.vehicle.CanoeEntity;
import com.alekiponi.firmaciv.common.entity.vehicle.FirmacivRowboatEntity;
import com.alekiponi.firmaciv.common.entity.vehicle.FirmacivSloopEntity;
import com.alekiponi.firmaciv.common.entity.vehicle.FirmacivSloopUnderConstructionEntity;
import com.nebby1999.firmacivplus.WatercraftMaterial;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class FirmaCivPlusEntities {
    public static final DeferredRegister<EntityType<?>> ENTITY_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITY_TYPES, (String)"firmacivplus");
    private static final Map<WatercraftMaterial, RegistryObject<EntityType<CanoeEntity>>> _CANOES = new HashMap<WatercraftMaterial, RegistryObject<EntityType<CanoeEntity>>>();
    private static final Map<WatercraftMaterial, RegistryObject<EntityType<FirmacivRowboatEntity>>> _ROWBOATS = new HashMap<WatercraftMaterial, RegistryObject<EntityType<FirmacivRowboatEntity>>>();
    private static final Map<WatercraftMaterial, RegistryObject<EntityType<FirmacivSloopUnderConstructionEntity>>> _SLOOPS_UNDER_CONSTRUCTION = new HashMap<WatercraftMaterial, RegistryObject<EntityType<FirmacivSloopUnderConstructionEntity>>>();
    private static final Map<WatercraftMaterial, RegistryObject<EntityType<FirmacivSloopEntity>>> _SLOOPS = new HashMap<WatercraftMaterial, RegistryObject<EntityType<FirmacivSloopEntity>>>();

    public static Map<WatercraftMaterial, RegistryObject<EntityType<CanoeEntity>>> getCanoes() {
        return Collections.unmodifiableMap(_CANOES);
    }

    public static Map<WatercraftMaterial, RegistryObject<EntityType<FirmacivRowboatEntity>>> getRowboats() {
        return Collections.unmodifiableMap(_ROWBOATS);
    }

    public static Map<WatercraftMaterial, RegistryObject<EntityType<FirmacivSloopUnderConstructionEntity>>> getSloopsUnderConstruction() {
        return Collections.unmodifiableMap(_SLOOPS_UNDER_CONSTRUCTION);
    }

    public static Map<WatercraftMaterial, RegistryObject<EntityType<FirmacivSloopEntity>>> getSloops() {
        return Collections.unmodifiableMap(_SLOOPS);
    }

    static void init(IEventBus eventBus) {
        for (WatercraftMaterial woodEntry : WatercraftMaterial._ALL_WATERCRAFT_MATERIALS) {
            if (woodEntry.isSoftwood()) {
                FirmaCivPlusEntities.putCanoeEntity(woodEntry);
                continue;
            }
            FirmaCivPlusEntities.putRowboatEntity(woodEntry);
            FirmaCivPlusEntities.putSloopEntity(woodEntry);
            FirmaCivPlusEntities.putSloopUnderConstructionEntity(woodEntry);
        }
        if (!ENTITY_TYPES.getEntries().isEmpty()) {
            ENTITY_TYPES.register(eventBus);
        }
    }

    private static void putCanoeEntity(WatercraftMaterial watercraftMaterial) {
        String name = "dugout_canoe/" + watercraftMaterial.m_7912_();
        EntityType.Builder builder = EntityType.Builder.m_20704_((entityType, level) -> new CanoeEntity(entityType, level, (BoatMaterial)watercraftMaterial), (MobCategory)MobCategory.MISC).m_20699_(1.125f, 0.625f);
        RegistryObject entry = FirmaCivPlusEntities.registerEntity(name, builder);
        _CANOES.put(watercraftMaterial, entry);
    }

    private static void putRowboatEntity(WatercraftMaterial watercraftMaterial) {
        String name = "rowboat/" + watercraftMaterial.m_7912_();
        EntityType.Builder builder = EntityType.Builder.m_20704_((entityType, level) -> new FirmacivRowboatEntity(entityType, level, (BoatMaterial)watercraftMaterial), (MobCategory)MobCategory.MISC).m_20699_(1.875f, 0.625f);
        RegistryObject entry = FirmaCivPlusEntities.registerEntity(name, builder);
        _ROWBOATS.put(watercraftMaterial, entry);
    }

    private static void putSloopUnderConstructionEntity(WatercraftMaterial watercraftMaterial) {
        String name = "sloop_construction/" + watercraftMaterial.m_7912_();
        EntityType.Builder builder = EntityType.Builder.m_20704_((entityType, level) -> new FirmacivSloopUnderConstructionEntity(entityType, level, (BoatMaterial)watercraftMaterial), (MobCategory)MobCategory.MISC).m_20699_(4.0f, 0.75f).setTrackingRange(20).m_20719_().m_20698_();
        RegistryObject entry = FirmaCivPlusEntities.registerEntity(name, builder);
        _SLOOPS_UNDER_CONSTRUCTION.put(watercraftMaterial, entry);
    }

    private static void putSloopEntity(WatercraftMaterial watercraftMaterial) {
        String name = "sloop/" + watercraftMaterial.m_7912_();
        EntityType.Builder builder = EntityType.Builder.m_20704_((entityType, level) -> new FirmacivSloopEntity(entityType, level, (BoatMaterial)watercraftMaterial), (MobCategory)MobCategory.MISC).m_20699_(3.0f, 0.75f).setTrackingRange(20).m_20719_();
        RegistryObject entry = FirmaCivPlusEntities.registerEntity(name, builder);
        _SLOOPS.put(watercraftMaterial, entry);
    }

    private static <E extends Entity> RegistryObject<EntityType<E>> registerEntity(String name, EntityType.Builder<E> builder) {
        String id = name.toLowerCase(Locale.ROOT);
        return ENTITY_TYPES.register(id, () -> builder.m_20712_("firmacivplus:" + id));
    }
}

