/*
 * Decompiled with CFR 0.152.
 */
package com.nebby1999.firmacivplus.datagen;

import com.alekiponi.alekiroofs.SquaredAngleBlock;
import com.alekiponi.alekiships.common.block.AngledWoodenBoatFrameBlock;
import com.alekiponi.alekiships.common.block.FlatWoodenBoatFrameBlock;
import com.alekiponi.firmaciv.common.block.CanoeComponentBlock;
import com.nebby1999.firmacivplus.FirmaCivPlusBlocks;
import com.nebby1999.firmacivplus.WatercraftMaterial;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import net.dries007.tfc.common.blocks.wood.Wood;
import net.dries007.tfc.util.registry.RegistryWood;
import net.minecraft.core.Direction;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.MultiPartBlockStateBuilder;
import net.minecraftforge.client.model.generators.VariantBlockStateBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;

public class FirmaCivPlusBlockStateProvider
extends BlockStateProvider {
    private static final String[] BOAT_FRAME_PROGRESS_STRINGS = new String[]{"first", "second", "third", "fourth"};
    private static final Map<String, List<Integer>> CANOE_SECTION_TO_STEP_RANGE = Map.of("all", List.of(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4), Integer.valueOf(5), Integer.valueOf(6), Integer.valueOf(7)), "end", List.of(Integer.valueOf(8), Integer.valueOf(9), Integer.valueOf(10), Integer.valueOf(11), Integer.valueOf(12)), "middle", List.of(Integer.valueOf(8), Integer.valueOf(9), Integer.valueOf(10), Integer.valueOf(11), Integer.valueOf(12)));
    private static final Direction[] VALID_CANOE_DIRECTIONS = new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST};

    public FirmaCivPlusBlockStateProvider(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "firmacivplus", existingFileHelper);
    }

    static BiConsumer<WatercraftMaterial, Supplier<? extends Block>> canoeComponentBlock(FirmaCivPlusBlockStateProvider stateProvider) {
        return (wood, registryObject) -> {
            if (!wood.isSoftwood()) {
                return;
            }
            String namespace = stateProvider.blockTexture(Block.m_49814_((Item)wood.getStrippedLog())).m_135827_();
            VariantBlockStateBuilder variantBlockStateBuilder = stateProvider.getVariantBuilder((Block)registryObject.get());
            CANOE_SECTION_TO_STEP_RANGE.forEach((section, canoeCarvedSteps) -> {
                for (Direction validDirection : VALID_CANOE_DIRECTIONS) {
                    Iterator iterator = canoeCarvedSteps.iterator();
                    while (iterator.hasNext()) {
                        int step = (Integer)iterator.next();
                        VariantBlockStateBuilder.PartialBlockstate whenFacingAndStep = variantBlockStateBuilder.partialState().with((Property)CanoeComponentBlock.FACING, (Comparable)validDirection).with((Property)CanoeComponentBlock.CANOE_CARVED, (Comparable)Integer.valueOf(step + 1));
                        VariantBlockStateBuilder.PartialBlockstate postSectionSelection = null;
                        switch (section) {
                            case "end": {
                                postSectionSelection = whenFacingAndStep.with((Property)CanoeComponentBlock.END, (Comparable)Boolean.valueOf(true));
                                break;
                            }
                            case "middle": {
                                postSectionSelection = whenFacingAndStep.with((Property)CanoeComponentBlock.END, (Comparable)Boolean.valueOf(false));
                                break;
                            }
                            case "all": {
                                postSectionSelection = whenFacingAndStep;
                            }
                        }
                        ResourceLocation strippedLogSideTexture = new ResourceLocation(namespace, String.format(Locale.ROOT, "block/wood/stripped_log/%s", wood.m_7912_()));
                        ResourceLocation strippedLogTopTexture = new ResourceLocation(namespace, String.format(Locale.ROOT, "block/wood/stripped_log_top/%s", wood.m_7912_()));
                        String modelName = String.format(Locale.ROOT, "block/wood/canoe_component_block/%s/%s/%s", wood.m_7912_(), section, step);
                        String parentName = String.format(Locale.ROOT, "block/canoe_component_block/template/%s/%s", section, step);
                        BlockModelBuilder modelFile = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)stateProvider.models().withExistingParent(modelName, new ResourceLocation("firmaciv", parentName))).texture("0", strippedLogSideTexture)).texture("1", strippedLogTopTexture)).texture("particle", strippedLogSideTexture);
                        ConfiguredModel.Builder configuredModel = postSectionSelection.modelForState().modelFile((ModelFile)modelFile);
                        if (validDirection != Direction.NORTH) {
                            configuredModel.rotationY(FirmaCivPlusBlockStateProvider.directionToYRot(validDirection));
                        }
                        configuredModel.addModel();
                    }
                }
            });
        };
    }

    private BiConsumer<WatercraftMaterial, Supplier<? extends SquaredAngleBlock>> woodRoofing(FirmaCivPlusBlockStateProvider stateProvider) {
        return (watercraftMaterial, registryObject) -> {
            RegistryWood registryWood = watercraftMaterial.getWood();
            String namespace = stateProvider.blockTexture((Block)registryWood.getBlock(Wood.BlockType.PLANKS).get()).m_135827_();
            VariantBlockStateBuilder variantBlockStateBuilder = stateProvider.getVariantBuilder((Block)registryObject.get());
            SquaredAngleBlock.f_56841_.m_6908_().forEach(facing -> SquaredAngleBlock.f_56843_.m_6908_().forEach(shape -> {
                int yRot = (int)((switch (shape) {
                    default -> throw new IncompatibleClassChangeError();
                    case StairsShape.OUTER_LEFT, StairsShape.INNER_LEFT -> facing.m_122435_();
                    case StairsShape.INNER_RIGHT, StairsShape.STRAIGHT, StairsShape.OUTER_RIGHT -> facing.m_122435_() + 90.0f;
                }) % 360.0f);
                VariantBlockStateBuilder.PartialBlockstate whenFacingAndShape = variantBlockStateBuilder.partialState().with((Property)SquaredAngleBlock.f_56841_, (Comparable)facing).with((Property)SquaredAngleBlock.f_56843_, (Comparable)shape);
                String parentModelShape = null;
                switch (shape) {
                    case INNER_RIGHT: 
                    case INNER_LEFT: {
                        parentModelShape = "_inner";
                        break;
                    }
                    case OUTER_LEFT: 
                    case OUTER_RIGHT: {
                        parentModelShape = "_outer";
                        break;
                    }
                    case STRAIGHT: {
                        parentModelShape = "";
                    }
                }
                ResourceLocation planksTexture = new ResourceLocation(namespace, String.format(Locale.ROOT, "block/wood/planks/%s", registryWood.m_7912_()));
                String modelName = "block/wood/" + registryWood.m_7912_() + "_roofing" + parentModelShape;
                String parentName = "block/roofing" + parentModelShape;
                BlockModelBuilder modelFile = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)stateProvider.models().withExistingParent(modelName, new ResourceLocation("alekiroofs", parentName))).texture("bottom", planksTexture)).texture("top", planksTexture)).texture("side", planksTexture);
                ConfiguredModel.Builder configuredModel = whenFacingAndShape.modelForState().modelFile((ModelFile)modelFile).rotationY(yRot).uvLock(yRot != 0);
                configuredModel.addModel();
            }));
            this.itemModels().withExistingParent("item/wood/" + registryWood.m_7912_() + "_roofing", this.modLoc("block/wood/" + registryWood.m_7912_() + "_roofing"));
        };
    }

    static BiConsumer<WatercraftMaterial, Supplier<? extends Block>> woodenBoatFrameFlat(BlockStateProvider blockStateProvider, ModelFile.ExistingModelFile frameFlat) {
        return (wood, registryObject) -> {
            if (wood.isSoftwood()) {
                return;
            }
            ResourceLocation plankTexture = blockStateProvider.blockTexture(wood.getDeckBlock().m_60734_());
            MultiPartBlockStateBuilder multipartBuilder = ((MultiPartBlockStateBuilder.PartBuilder)blockStateProvider.getMultipartBuilder((Block)registryObject.get()).part().modelFile((ModelFile)frameFlat).addModel()).end();
            IntStream.range(0, 8).forEach(progress -> {
                if (progress < 4) {
                    BlockModelBuilder plankModel = (BlockModelBuilder)((BlockModelBuilder)blockStateProvider.models().withExistingParent(String.format(Locale.ROOT, "block/wood/watercraft_frame/flat/%s/%s", wood.m_7912_(), BOAT_FRAME_PROGRESS_STRINGS[progress]), new ResourceLocation("alekiships", String.format(Locale.ROOT, "block/watercraft_frame/flat/template/%s", BOAT_FRAME_PROGRESS_STRINGS[progress])))).texture("plank", plankTexture);
                    ((MultiPartBlockStateBuilder.PartBuilder)multipartBuilder.part().modelFile((ModelFile)plankModel).addModel()).condition((Property)FlatWoodenBoatFrameBlock.FRAME_PROCESSED, (Comparable[])((Integer[])IntStream.range(progress, 8).boxed().toArray(Integer[]::new)));
                } else {
                    ModelFile.ExistingModelFile plankModel = blockStateProvider.models().getExistingFile(new ResourceLocation("firmaciv", String.format(Locale.ROOT, "block/watercraft_frame/flat/bolt/%s", BOAT_FRAME_PROGRESS_STRINGS[progress % 4])));
                    ((MultiPartBlockStateBuilder.PartBuilder)multipartBuilder.part().modelFile((ModelFile)plankModel).addModel()).condition((Property)FlatWoodenBoatFrameBlock.FRAME_PROCESSED, (Comparable[])((Integer[])IntStream.range(progress, 8).boxed().toArray(Integer[]::new)));
                }
            });
        };
    }

    static BiConsumer<WatercraftMaterial, Supplier<? extends Block>> woodenBoatFrameAngled(BlockStateProvider blockStateProvider, ModelFile.ExistingModelFile straight, ModelFile.ExistingModelFile inner, ModelFile.ExistingModelFile outer) {
        return (wood, registryObject) -> {
            if (wood.isSoftwood()) {
                return;
            }
            ResourceLocation plankTexture = blockStateProvider.blockTexture(wood.getDeckBlock().m_60734_());
            AngledWoodenBoatFrameBlock.FACING.m_6908_().forEach(arg_0 -> FirmaCivPlusBlockStateProvider.lambda$woodenBoatFrameAngled$13(blockStateProvider, (Supplier)registryObject, straight, inner, outer, wood, plankTexture, arg_0));
        };
    }

    static int angledBoatFrameYRot(StairsShape shape, Direction facing) {
        return (switch (shape) {
            default -> throw new IncompatibleClassChangeError();
            case StairsShape.INNER_RIGHT, StairsShape.STRAIGHT -> (int)facing.m_122435_();
            case StairsShape.OUTER_LEFT -> (int)facing.m_122435_() + 90;
            case StairsShape.OUTER_RIGHT -> (int)facing.m_122435_() + 180;
            case StairsShape.INNER_LEFT -> (int)facing.m_122435_() + 270;
        }) % 360;
    }

    static int directionToYRot(Direction direction) {
        return switch (direction) {
            case Direction.NORTH -> 0;
            case Direction.EAST -> 90;
            case Direction.SOUTH -> 180;
            case Direction.WEST -> 270;
            default -> throw new IllegalArgumentException("Invalid direction provided, Direction was \"" + String.valueOf(direction) + "\" when it should conform to NORTH, EAST, SOUTH or WEST");
        };
    }

    protected void registerStatesAndModels() {
        this.models().generatedModels.get(new ResourceLocation("firmaciv", "block/watercraft_frame/flat/frame"));
        ModelFile.ExistingModelFile frameFlat = this.models().getExistingFile(new ResourceLocation("firmaciv", "block/watercraft_frame/flat/frame"));
        FirmaCivPlusBlocks.getWoodenBoatFrameFlatBlocks().forEach(FirmaCivPlusBlockStateProvider.woodenBoatFrameFlat(this, frameFlat));
        ModelFile.ExistingModelFile angledFrameStraight = this.models().getExistingFile(new ResourceLocation("firmaciv", "block/watercraft_frame/angled/straight"));
        ModelFile.ExistingModelFile angledFrameInner = this.models().getExistingFile(new ResourceLocation("firmaciv", "block/watercraft_frame/angled/inner"));
        ModelFile.ExistingModelFile angledFrameOuter = this.models().getExistingFile(new ResourceLocation("firmaciv", "block/watercraft_frame/angled/outer"));
        FirmaCivPlusBlocks.getWoodenBoatFrameAngledBlocks().forEach(FirmaCivPlusBlockStateProvider.woodenBoatFrameAngled(this, angledFrameStraight, angledFrameInner, angledFrameOuter));
        FirmaCivPlusBlocks.getCanoeComponentBlocks().forEach(FirmaCivPlusBlockStateProvider.canoeComponentBlock(this));
        FirmaCivPlusBlocks.getWoodRoofings().forEach(this.woodRoofing(this));
    }

    private static /* synthetic */ void lambda$woodenBoatFrameAngled$13(BlockStateProvider blockStateProvider, Supplier registryObject, ModelFile.ExistingModelFile straight, ModelFile.ExistingModelFile inner, ModelFile.ExistingModelFile outer, WatercraftMaterial wood, ResourceLocation plankTexture, Direction facing) {
        AngledWoodenBoatFrameBlock.SHAPE.m_6908_().forEach(arg_0 -> FirmaCivPlusBlockStateProvider.lambda$woodenBoatFrameAngled$12(blockStateProvider, (Supplier)registryObject, facing, straight, inner, outer, wood, plankTexture, arg_0));
    }

    private static /* synthetic */ void lambda$woodenBoatFrameAngled$12(BlockStateProvider blockStateProvider, Supplier registryObject, Direction facing, ModelFile.ExistingModelFile straight, ModelFile.ExistingModelFile inner, ModelFile.ExistingModelFile outer, WatercraftMaterial wood, ResourceLocation plankTexture, StairsShape shape) {
        MultiPartBlockStateBuilder multipartBuilder = blockStateProvider.getMultipartBuilder((Block)registryObject.get());
        int yRot = FirmaCivPlusBlockStateProvider.angledBoatFrameYRot(shape, facing);
        ((MultiPartBlockStateBuilder.PartBuilder)multipartBuilder.part().modelFile((ModelFile)(shape == StairsShape.STRAIGHT ? straight : (shape == StairsShape.INNER_LEFT || shape == StairsShape.INNER_RIGHT ? inner : outer))).rotationY(yRot).addModel()).condition((Property)AngledWoodenBoatFrameBlock.FACING, (Comparable[])new Direction[]{facing}).condition((Property)AngledWoodenBoatFrameBlock.SHAPE, (Comparable[])new StairsShape[]{shape});
        IntStream.range(0, 8).forEach(progress -> {
            String modelShape;
            String string = shape == StairsShape.STRAIGHT ? "straight" : (modelShape = shape == StairsShape.INNER_LEFT || shape == StairsShape.INNER_RIGHT ? "inner" : "outer");
            if (progress < 4) {
                BlockModelBuilder plankModel = (BlockModelBuilder)((BlockModelBuilder)blockStateProvider.models().withExistingParent(String.format(Locale.ROOT, "block/wood/watercraft_frame/angled/%s/%s/%s", wood.m_7912_(), modelShape, BOAT_FRAME_PROGRESS_STRINGS[progress]), new ResourceLocation("alekiships", String.format(Locale.ROOT, "block/watercraft_frame/angled/template/%s/%s", modelShape, BOAT_FRAME_PROGRESS_STRINGS[progress])))).texture("plank", plankTexture);
                ((MultiPartBlockStateBuilder.PartBuilder)multipartBuilder.part().modelFile((ModelFile)plankModel).rotationY(yRot).uvLock(yRot != 0).addModel()).condition((Property)AngledWoodenBoatFrameBlock.FACING, (Comparable[])new Direction[]{facing}).condition((Property)AngledWoodenBoatFrameBlock.SHAPE, (Comparable[])new StairsShape[]{shape}).condition((Property)AngledWoodenBoatFrameBlock.FRAME_PROCESSED, (Comparable[])((Integer[])IntStream.range(progress, 8).boxed().toArray(Integer[]::new)));
            } else {
                ModelFile.ExistingModelFile plankModel = blockStateProvider.models().getExistingFile(new ResourceLocation("firmaciv", String.format(Locale.ROOT, "block/watercraft_frame/angled/bolt/%s/%s", modelShape, BOAT_FRAME_PROGRESS_STRINGS[progress % 4])));
                ((MultiPartBlockStateBuilder.PartBuilder)multipartBuilder.part().modelFile((ModelFile)plankModel).rotationY(yRot).addModel()).condition((Property)AngledWoodenBoatFrameBlock.FACING, (Comparable[])new Direction[]{facing}).condition((Property)AngledWoodenBoatFrameBlock.SHAPE, (Comparable[])new StairsShape[]{shape}).condition((Property)AngledWoodenBoatFrameBlock.FRAME_PROCESSED, (Comparable[])((Integer[])IntStream.range(progress, 8).boxed().toArray(Integer[]::new)));
            }
        });
    }
}

