/*
 * Decompiled with CFR 0.152.
 */
package com.nebby1999.firmacivplus.datagen;

import com.nebby1999.firmacivplus.FirmaCivPlusBlocks;
import com.nebby1999.firmacivplus.FirmaCivPlusEntities;
import java.util.Arrays;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.data.PackOutput;
import net.minecraftforge.common.data.LanguageProvider;

public class FirmaCivPlus_en_us_LanguageProvider
extends LanguageProvider {
    public FirmaCivPlus_en_us_LanguageProvider(PackOutput output) {
        super(output, "firmacivplus", "en_us");
    }

    protected void addTranslations() {
        this.addBlockTranslations();
        this.addEntityTranslations();
    }

    private void addBlockTranslations() {
        FirmaCivPlusBlocks.getWoodRoofings().forEach((material, registryObject) -> this.addBlock((Supplier)registryObject, this.langify(material.m_7912_()) + " Roofing"));
        FirmaCivPlusBlocks.getCanoeComponentBlocks().forEach((watercraftMaterial, canoeComponentBlockRegistryObject) -> this.addBlock((Supplier)canoeComponentBlockRegistryObject, this.langify(watercraftMaterial.m_7912_()) + " Canoe Component"));
        FirmaCivPlusBlocks.getWoodenBoatFrameFlatBlocks().forEach((watercraftMaterial, firmacivFlatWoodenBoatFrameBlockRegistryObject) -> this.addBlock((Supplier)firmacivFlatWoodenBoatFrameBlockRegistryObject, this.langify(watercraftMaterial.m_7912_()) + " Flat Shipwright's Scaffolding"));
        FirmaCivPlusBlocks.getWoodenBoatFrameAngledBlocks().forEach((watercraftMaterial, firmacivAngledWoodenBoatFrameBlockRegistryObject) -> this.addBlock((Supplier)firmacivAngledWoodenBoatFrameBlockRegistryObject, this.langify(watercraftMaterial.m_7912_()) + " Sloped Shipwright's Scaffolding"));
    }

    private void addEntityTranslations() {
        FirmaCivPlusEntities.getCanoes().forEach((watercraftMaterial, entityTypeRegistryObject) -> this.addEntityType((Supplier)entityTypeRegistryObject, this.langify(watercraftMaterial.m_7912_()) + " Dugout Canoe"));
        FirmaCivPlusEntities.getSloops().forEach((watercraftMaterial, entityTypeRegistryObject) -> this.addEntityType((Supplier)entityTypeRegistryObject, this.langify(watercraftMaterial.m_7912_()) + " Sloop"));
        FirmaCivPlusEntities.getSloopsUnderConstruction().forEach((watercraftMaterial, entityTypeRegistryObject) -> this.addEntityType((Supplier)entityTypeRegistryObject, this.langify(watercraftMaterial.m_7912_()) + " Sloop"));
        FirmaCivPlusEntities.getRowboats().forEach((watercraftMaterial, entityTypeRegistryObject) -> this.addEntityType((Supplier)entityTypeRegistryObject, this.langify(watercraftMaterial.m_7912_()) + " Rowboat"));
    }

    public String langify(String serializedName) {
        return Arrays.stream(serializedName.split("_")).map(s -> Character.toUpperCase(s.charAt(0)) + s.substring(1)).collect(Collectors.joining(" "));
    }
}

