/*
 * Decompiled with CFR 0.152.
 */
package com.nebby1999.firmacivplus.datagen.loot;

import com.alekiponi.firmaciv.common.block.FirmacivAngledWoodenBoatFrameBlock;
import com.alekiponi.firmaciv.common.block.FirmacivBlocks;
import com.alekiponi.firmaciv.common.block.FirmacivFlatWoodenBoatFrameBlock;
import com.alekiponi.firmaciv.common.item.FirmacivItems;
import com.nebby1999.firmacivplus.FirmaCivPlusBlocks;
import com.nebby1999.firmacivplus.WatercraftMaterial;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.AlternativesEntry;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.predicates.ConditionUserBuilder;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;

public class FirmaCivPlusBlockLootTables
extends BlockLootSubProvider {
    public FirmaCivPlusBlockLootTables() {
        super(Set.of(), FeatureFlags.f_244280_.m_247355_());
    }

    protected void m_245660_() {
        this.getKnownBlocks().forEach(x$0 -> this.m_245724_((Block)x$0));
        FirmaCivPlusBlocks.getCanoeComponentBlocks().forEach((watercraftMaterial, canoeComponentBlockRegistryObject) -> this.m_246481_((Block)canoeComponentBlockRegistryObject.get(), block -> this.m_247033_((ItemLike)watercraftMaterial.getRailing())));
        FirmaCivPlusBlocks.getWoodenBoatFrameFlatBlocks().forEach((watercraftMaterial, firmacivFlatWoodenBoatFrameBlockRegistryObject) -> this.m_246481_((Block)firmacivFlatWoodenBoatFrameBlockRegistryObject.get(), block -> this.createBoatFrameFlatTable((Block)block, (WatercraftMaterial)watercraftMaterial)));
        FirmaCivPlusBlocks.getWoodenBoatFrameAngledBlocks().forEach((watercraftMaterial, firmacivAngledWoodenBoatFrameBlockRegistryObject) -> this.m_246481_((Block)firmacivAngledWoodenBoatFrameBlockRegistryObject.get(), block -> this.createBoatFrameAngledTable((Block)block, (WatercraftMaterial)watercraftMaterial)));
    }

    protected <T extends Comparable<T> & StringRepresentable> LootTable.Builder createBoatFrameFlatTable(Block pBlock, WatercraftMaterial material) {
        int count;
        int frameProcessed;
        LootTable.Builder lootTable = LootTable.m_79147_();
        lootTable.m_79161_(((LootPool.Builder)this.m_247733_((ItemLike)pBlock, (ConditionUserBuilder)LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)FirmacivBlocks.BOAT_FRAME_FLAT.get()))));
        ArrayList<LootPoolSingletonContainer.Builder> alternatives = new ArrayList<LootPoolSingletonContainer.Builder>();
        Iterator iterator = FirmacivFlatWoodenBoatFrameBlock.FRAME_PROCESSED.m_6908_().iterator();
        while (iterator.hasNext()) {
            frameProcessed = (Integer)iterator.next();
            count = Math.min(frameProcessed + 1, 4);
            alternatives.add(((LootPoolSingletonContainer.Builder)LootItem.m_79579_((ItemLike)material.getDeckItem()).m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)pBlock).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)FirmacivFlatWoodenBoatFrameBlock.FRAME_PROCESSED, frameProcessed)))).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)count))));
        }
        lootTable.m_79161_((LootPool.Builder)this.m_247733_((ItemLike)pBlock, (ConditionUserBuilder)LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)AlternativesEntry.m_230933_(alternatives, func -> func))));
        alternatives.clear();
        iterator = FirmacivFlatWoodenBoatFrameBlock.FRAME_PROCESSED.m_6908_().iterator();
        while (iterator.hasNext()) {
            frameProcessed = (Integer)iterator.next();
            if (frameProcessed + 1 <= 4) continue;
            count = frameProcessed % 4;
            alternatives.add(((LootPoolSingletonContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)FirmacivItems.COPPER_BOLT.get())).m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)pBlock).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)FirmacivFlatWoodenBoatFrameBlock.FRAME_PROCESSED, frameProcessed)))).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)(count + 1)))));
        }
        lootTable.m_79161_((LootPool.Builder)this.m_247733_((ItemLike)pBlock, (ConditionUserBuilder)LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)AlternativesEntry.m_230933_(alternatives, func -> func))));
        return lootTable;
    }

    protected <T extends Comparable<T> & StringRepresentable> LootTable.Builder createBoatFrameAngledTable(Block pBlock, WatercraftMaterial material) {
        int count;
        int frameProcessed;
        LootTable.Builder lootTable = LootTable.m_79147_();
        lootTable.m_79161_(((LootPool.Builder)this.m_247733_((ItemLike)pBlock, (ConditionUserBuilder)LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)FirmacivBlocks.BOAT_FRAME_ANGLED.get()))));
        ArrayList<LootPoolSingletonContainer.Builder> alternatives = new ArrayList<LootPoolSingletonContainer.Builder>();
        Iterator iterator = FirmacivAngledWoodenBoatFrameBlock.FRAME_PROCESSED.m_6908_().iterator();
        while (iterator.hasNext()) {
            frameProcessed = (Integer)iterator.next();
            count = Math.min(frameProcessed + 1, 4);
            alternatives.add(((LootPoolSingletonContainer.Builder)LootItem.m_79579_((ItemLike)material.getDeckItem()).m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)pBlock).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)FirmacivAngledWoodenBoatFrameBlock.FRAME_PROCESSED, frameProcessed)))).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)count))));
        }
        lootTable.m_79161_((LootPool.Builder)this.m_247733_((ItemLike)pBlock, (ConditionUserBuilder)LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)AlternativesEntry.m_230933_(alternatives, func -> func))));
        alternatives.clear();
        iterator = FirmacivAngledWoodenBoatFrameBlock.FRAME_PROCESSED.m_6908_().iterator();
        while (iterator.hasNext()) {
            frameProcessed = (Integer)iterator.next();
            if (frameProcessed + 1 <= 4) continue;
            count = frameProcessed % 4;
            alternatives.add(((LootPoolSingletonContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)FirmacivItems.COPPER_BOLT.get())).m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)pBlock).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)FirmacivAngledWoodenBoatFrameBlock.FRAME_PROCESSED, frameProcessed)))).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)(count + 1)))));
        }
        lootTable.m_79161_((LootPool.Builder)this.m_247733_((ItemLike)pBlock, (ConditionUserBuilder)LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)AlternativesEntry.m_230933_(alternatives, func -> func))));
        return lootTable;
    }

    @NotNull
    protected Iterable<Block> getKnownBlocks() {
        return FirmaCivPlusBlocks.BLOCKS.getEntries().stream().filter(b -> {
            boolean flag1 = FirmaCivPlusBlocks.getCanoeComponentBlocks().containsValue(b);
            boolean flag2 = FirmaCivPlusBlocks.getWoodenBoatFrameFlatBlocks().containsValue(b);
            boolean flag3 = FirmaCivPlusBlocks.getWoodenBoatFrameAngledBlocks().containsValue(b);
            return flag1 || flag2 || flag3;
        }).map(RegistryObject::get)::iterator;
    }
}

