/*
 * Decompiled with CFR 0.152.
 */
package com.wdiscute.starcatcher;

import com.mojang.logging.LogUtils;
import com.wdiscute.starcatcher.Config;
import com.wdiscute.starcatcher.ModCreativeModeTabs;
import com.wdiscute.starcatcher.ModEntities;
import com.wdiscute.starcatcher.ModItemProperties;
import com.wdiscute.starcatcher.ModItems;
import com.wdiscute.starcatcher.ModMenuTypes;
import com.wdiscute.starcatcher.ModParticles;
import com.wdiscute.starcatcher.ModSounds;
import com.wdiscute.starcatcher.bob.FishingBobModel;
import com.wdiscute.starcatcher.bob.FishingBobRenderer;
import com.wdiscute.starcatcher.fishentity.FishEntity;
import com.wdiscute.starcatcher.fishentity.FishRenderer;
import com.wdiscute.starcatcher.fishspotter.FishTrackerLayer;
import com.wdiscute.starcatcher.guide.FishCaughtToast;
import com.wdiscute.starcatcher.networkandcodecs.FishProperties;
import com.wdiscute.starcatcher.networkandcodecs.ModDataAttachments;
import com.wdiscute.starcatcher.networkandcodecs.ModDataComponents;
import com.wdiscute.starcatcher.networkandcodecs.PayloadReceiver;
import com.wdiscute.starcatcher.networkandcodecs.Payloads;
import com.wdiscute.starcatcher.networkandcodecs.TrophyProperties;
import com.wdiscute.starcatcher.particles.FishingBitingParticles;
import com.wdiscute.starcatcher.particles.FishingNotificationParticles;
import com.wdiscute.starcatcher.rod.FishingRodScreen;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterGuiLayersEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.client.event.RegisterParticleProvidersEvent;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import net.neoforged.neoforge.registries.DataPackRegistryEvent;
import org.slf4j.Logger;

@Mod(value="starcatcher")
public class Starcatcher {
    public static final String MOD_ID = "starcatcher";
    public static final ResourceKey<Registry<FishProperties>> FISH_REGISTRY = ResourceKey.createRegistryKey((ResourceLocation)Starcatcher.rl("fish"));
    public static final ResourceKey<Registry<TrophyProperties>> TROPHY_REGISTRY = ResourceKey.createRegistryKey((ResourceLocation)Starcatcher.rl("trophy"));
    private static final Logger LOGGER = LogUtils.getLogger();

    public static ResourceLocation rl(String s) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)s);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void fishCaughtToast(FishProperties fp) {
        Minecraft.getInstance().getToasts().addToast((Toast)new FishCaughtToast(fp));
    }

    public Starcatcher(IEventBus modEventBus, ModContainer modContainer) {
        ModCreativeModeTabs.register(modEventBus);
        ModItems.register(modEventBus);
        ModDataComponents.register(modEventBus);
        ModSounds.register(modEventBus);
        ModEntities.register(modEventBus);
        ModParticles.register(modEventBus);
        ModMenuTypes.register(modEventBus);
        ModDataAttachments.register(modEventBus);
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC);
    }

    @OnlyIn(value=Dist.CLIENT)
    @EventBusSubscriber(modid="starcatcher", value={Dist.CLIENT})
    public static class ModClientEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            EntityRenderers.register(ModEntities.FISHING_BOB.get(), FishingBobRenderer::new);
            EntityRenderers.register(ModEntities.FISH.get(), FishRenderer::new);
            ModItemProperties.addCustomItemProperties();
        }

        @SubscribeEvent
        public static void FishSpotterLayer(RegisterGuiLayersEvent event) {
            event.registerAboveAll(Starcatcher.rl("fish_tracker"), (LayeredDraw.Layer)new FishTrackerLayer());
        }

        @SubscribeEvent
        public static void registerParticleFactories(RegisterParticleProvidersEvent event) {
            event.registerSpriteSet((ParticleType)ModParticles.FISHING_NOTIFICATION.get(), FishingNotificationParticles.Provider::new);
            event.registerSpriteSet((ParticleType)ModParticles.FISHING_BITING.get(), FishingBitingParticles.Provider::new);
        }

        @SubscribeEvent
        public static void registerScreens(RegisterMenuScreensEvent event) {
            event.register(ModMenuTypes.FISHING_ROD_MENU.get(), FishingRodScreen::new);
        }

        @SubscribeEvent
        public static void registerLayers(EntityRenderersEvent.RegisterLayerDefinitions event) {
            event.registerLayerDefinition(FishingBobModel.LAYER_LOCATION, FishingBobModel::createBodyLayer);
        }
    }

    @EventBusSubscriber(modid="starcatcher")
    public static class ModEvents {
        @SubscribeEvent
        public static void addRegistry(DataPackRegistryEvent.NewRegistry event) {
            event.dataPackRegistry(FISH_REGISTRY, FishProperties.CODEC, FishProperties.CODEC, builder -> builder.maxId(256));
            event.dataPackRegistry(TROPHY_REGISTRY, TrophyProperties.CODEC, TrophyProperties.CODEC, builder -> builder.maxId(256));
        }

        @SubscribeEvent
        public static void registerAttributed(EntityAttributeCreationEvent event) {
            event.put(ModEntities.FISH.get(), FishEntity.createAttributes().build());
        }

        @SubscribeEvent
        public static void registerPayloads(RegisterPayloadHandlersEvent event) {
            PayloadRegistrar registrar = event.registrar("1");
            registrar.playToClient(Payloads.FishingPayload.TYPE, Payloads.FishingPayload.STREAM_CODEC, PayloadReceiver::receiveFishingClient);
            registrar.playToServer(Payloads.FishingCompletedPayload.TYPE, Payloads.FishingCompletedPayload.STREAM_CODEC, PayloadReceiver::receiveFishingCompletedServer);
            registrar.playToClient(Payloads.FishCaughtPayload.TYPE, Payloads.FishCaughtPayload.STREAM_CODEC, PayloadReceiver::receiveFishCaught);
            registrar.playToServer(Payloads.FPsSeen.TYPE, Payloads.FPsSeen.STREAM_CODEC, PayloadReceiver::receiveFPsSeen);
        }
    }
}

