/*
 * Decompiled with CFR 0.152.
 */
package com.wdiscute.starcatcher.guide;

import com.wdiscute.starcatcher.Starcatcher;
import com.wdiscute.starcatcher.networkandcodecs.FishProperties;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.components.toasts.ToastComponent;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.ItemStack;

public class FishCaughtToast
implements Toast {
    private static final ResourceLocation BACKGROUND_SPRITE = Starcatcher.rl("toast/fish_caught");
    private final Component title;
    private final String description;
    private static final String gibberish = "\u00a7kaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa";
    private int old;
    private static final Random r = new Random();
    private final ItemStack is;

    public FishCaughtToast(FishProperties fp) {
        this.is = new ItemStack(fp.fish());
        this.title = Component.translatable((String)"gui.starcatcher.toast.fish_caught");
        if (fp.customName().isEmpty()) {
            String compName = I18n.get((String)("item." + fp.fish().getRegisteredName().replace(":", ".")), (Object[])new Object[0]);
        } else {
            String compName = I18n.get((String)("item.starcatcher." + fp.customName()), (Object[])new Object[0]);
        }
        this.description = this.is.getHoverName().getString();
    }

    public Toast.Visibility render(GuiGraphics guiGraphics, ToastComponent toastComponent, long timeSinceLastVisible) {
        guiGraphics.blitSprite(BACKGROUND_SPRITE, 0, 0, this.width(), this.height());
        guiGraphics.renderItem(this.is, 8, 8);
        guiGraphics.drawString(toastComponent.getMinecraft().font, this.title, 30, 7, 0, false);
        int lettersRevealed = Math.clamp((timeSinceLastVisible - 500L) / 150L, 0, this.description.length());
        if (this.old != lettersRevealed) {
            Minecraft.getInstance().player.playSound(SoundEvents.BAMBOO_WOOD_BUTTON_CLICK_ON, 0.4f, r.nextFloat(0.2f) + 1.3f);
            this.old = lettersRevealed;
        }
        MutableComponent comp = Component.literal((String)this.description.substring(0, lettersRevealed)).append((Component)Component.literal((String)gibberish.substring(0, this.description.length() - lettersRevealed + 2)));
        guiGraphics.drawString(toastComponent.getMinecraft().font, (Component)comp, 30, 18, 0, false);
        if (timeSinceLastVisible < 10000L) {
            return Toast.Visibility.SHOW;
        }
        return Toast.Visibility.HIDE;
    }
}

