/*
 * Decompiled with CFR 0.152.
 */
package com.wdiscute.starcatcher.guide;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.wdiscute.libtooltips.Tooltips;
import com.wdiscute.starcatcher.ModItems;
import com.wdiscute.starcatcher.Starcatcher;
import com.wdiscute.starcatcher.networkandcodecs.FishCaughtCounter;
import com.wdiscute.starcatcher.networkandcodecs.FishProperties;
import com.wdiscute.starcatcher.networkandcodecs.ModDataAttachments;
import com.wdiscute.starcatcher.networkandcodecs.Payloads;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.PacketDistributor;

public class FishingGuideScreen
extends Screen {
    private static final ResourceLocation BACKGROUND = Starcatcher.rl("textures/gui/guide/background.png");
    private static final ResourceLocation ARROW_PREVIOUS = Starcatcher.rl("textures/gui/guide/arrow_previous.png");
    private static final ResourceLocation ARROW_PREVIOUS_PRESSED = Starcatcher.rl("textures/gui/guide/arrow_previous_pressed.png");
    private static final ResourceLocation ARROW_PREVIOUS_HIGHLIGHT = Starcatcher.rl("textures/gui/guide/arrow_previous_highlight.png");
    private static final ResourceLocation ARROW_NEXT = Starcatcher.rl("textures/gui/guide/arrow_next.png");
    private static final ResourceLocation ARROW_NEXT_PRESSED = Starcatcher.rl("textures/gui/guide/arrow_next_pressed.png");
    private static final ResourceLocation ARROW_NEXT_HIGHLIGHT = Starcatcher.rl("textures/gui/guide/arrow_next_highlight.png");
    private static final ResourceLocation ARROW_INDEX = Starcatcher.rl("textures/gui/guide/arrow_index.png");
    private static final ResourceLocation ARROW_INDEX_PRESSED = Starcatcher.rl("textures/gui/guide/arrow_index_pressed.png");
    private static final ResourceLocation ARROW_INDEX_HIGHLIGHT = Starcatcher.rl("textures/gui/guide/arrow_index_highlight.png");
    private static final ResourceLocation STAR = Starcatcher.rl("textures/gui/guide/star.png");
    private static final ResourceLocation GLOW = Starcatcher.rl("textures/gui/guide/glow.png");
    int uiX;
    int uiY;
    int imageWidth;
    int imageHeight;
    int clickedX;
    int clickedY;
    int clickedXDown;
    int clickedYDown;
    boolean arrowPreviousPressed;
    boolean arrowNextPressed;
    boolean arrowIndexPressed;
    int currentMenu = 0;
    int currentPage = 0;
    boolean hasNextEntryPage;
    ClientLevel level;
    LocalPlayer player;
    List<FishProperties> fpsSeen = new ArrayList<FishProperties>();
    List<FishProperties> entries = new ArrayList<FishProperties>(999);
    List<FishProperties> fishInArea = new ArrayList<FishProperties>();
    List<FishCaughtCounter> fishCaughtCounterList = new ArrayList<FishCaughtCounter>();

    protected void init() {
        super.init();
        this.entries = new ArrayList<FishProperties>(999);
        this.imageWidth = 512;
        this.imageHeight = 256;
        this.uiX = (this.width - this.imageWidth) / 2;
        this.uiY = (this.height - this.imageHeight) / 2;
        this.level = Minecraft.getInstance().level;
        this.player = Minecraft.getInstance().player;
        for (FishProperties fp : FishProperties.getFPs((Level)this.level)) {
            if (!fp.hasGuideEntry()) continue;
            this.entries.add(fp);
        }
        this.fishInArea = FishProperties.getFpsWithGuideEntryForArea((Entity)this.player);
        this.fishCaughtCounterList = (List)this.player.getData(ModDataAttachments.FISHES_CAUGHT);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        InputConstants.Key key = InputConstants.getKey((int)keyCode, (int)scanCode);
        if (this.minecraft.options.keyInventory.isActiveAndMatches(key)) {
            this.onClose();
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        double x = mouseX - (double)this.uiX;
        double y = mouseY - (double)this.uiY;
        this.arrowIndexPressed = false;
        this.arrowNextPressed = false;
        this.arrowPreviousPressed = false;
        if (x > 65.0 && x < 95.0 && y > 225.0 && y < 240.0) {
            if (this.currentMenu == 0 && this.currentPage != 0) {
                this.minecraft.player.playSound(SoundEvents.BOOK_PAGE_TURN);
                --this.currentPage;
                return true;
            }
            if (this.currentMenu == 1 && this.currentPage == 0) {
                this.minecraft.player.playSound(SoundEvents.BOOK_PAGE_TURN);
                this.currentMenu = 0;
                this.currentPage = 0;
                return true;
            }
            if (this.currentMenu == 1) {
                this.minecraft.player.playSound(SoundEvents.BOOK_PAGE_TURN);
                --this.currentPage;
                return true;
            }
        }
        if (x > 420.0 && x < 440.0 && y > 230.0 && y < 240.0) {
            if (this.currentMenu == 0 && this.hasNextEntryPage) {
                this.minecraft.player.playSound(SoundEvents.BOOK_PAGE_TURN);
                ++this.currentPage;
                return true;
            }
            if (this.currentMenu == 0) {
                this.minecraft.player.playSound(SoundEvents.BOOK_PAGE_TURN);
                this.currentMenu = 1;
                this.currentPage = 0;
                return true;
            }
            if (this.currentMenu == 1 && this.currentPage <= this.entries.size() / 2 - 1) {
                this.minecraft.player.playSound(SoundEvents.BOOK_PAGE_TURN);
                ++this.currentPage;
                return true;
            }
        }
        if (x > 225.0 && x < 245.0 && y > 223.0 && y < 243.0) {
            this.minecraft.player.playSound(SoundEvents.BOOK_PAGE_TURN);
            this.currentMenu = 0;
            this.currentPage = 0;
            return true;
        }
        if (this.currentPage == 0 && button == 0) {
            this.clickedX = (int)mouseX;
            this.clickedY = (int)mouseY;
            this.clickedXDown = 0;
            this.clickedYDown = 0;
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        double x = mouseX - (double)this.uiX;
        double y = mouseY - (double)this.uiY;
        if (x > 65.0 && x < 95.0 && y > 225.0 && y < 240.0 && (this.currentMenu != 0 || this.currentPage != 0)) {
            this.arrowPreviousPressed = true;
        }
        if (x > 420.0 && x < 440.0 && y > 230.0 && y < 240.0 && this.currentPage <= this.entries.size() / 2 - 1) {
            this.arrowNextPressed = true;
        }
        if (x > 225.0 && x < 245.0 && y > 223.0 && y < 243.0) {
            this.arrowIndexPressed = true;
        }
        if (this.currentPage == 0 && button == 0) {
            this.clickedXDown = (int)mouseX;
            this.clickedYDown = (int)mouseY;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        this.renderImage(guiGraphics, BACKGROUND);
        if (this.currentMenu == 0) {
            this.renderIndex(guiGraphics, mouseX, mouseY);
        } else {
            this.renderEntry(guiGraphics, mouseX, mouseY, 70, this.currentPage * 2);
            this.renderEntry(guiGraphics, mouseX, mouseY, 276, this.currentPage * 2 + 1);
        }
        double x = mouseX - this.uiX;
        double y = mouseY - this.uiY;
        if (this.currentMenu != 0 || this.currentPage != 0) {
            if (x > 65.0 && x < 95.0 && y > 225.0 && y < 240.0) {
                guiGraphics.blit(ARROW_PREVIOUS_HIGHLIGHT, this.uiX + 65, this.uiY + 227, 0.0f, 0.0f, 23, 13, 23, 13);
            }
            ResourceLocation previous = this.arrowPreviousPressed ? ARROW_PREVIOUS_PRESSED : ARROW_PREVIOUS;
            guiGraphics.blit(previous, this.uiX + 65, this.uiY + 227, 0.0f, 0.0f, 23, 13, 23, 13);
            if (x > 225.0 && x < 245.0 && y > 223.0 && y < 243.0) {
                guiGraphics.blit(ARROW_INDEX_HIGHLIGHT, this.uiX + 225, this.uiY + 223, 0.0f, 0.0f, 20, 20, 20, 20);
            }
            ResourceLocation index = this.arrowIndexPressed ? ARROW_INDEX_PRESSED : ARROW_INDEX;
            guiGraphics.blit(index, this.uiX + 225, this.uiY + 223, 0.0f, 0.0f, 20, 20, 20, 20);
        }
        if (this.currentPage <= this.entries.size() / 2 - 1) {
            if (x > 420.0 && x < 442.0 && y > 227.0 && y < 242.0) {
                guiGraphics.blit(ARROW_NEXT_HIGHLIGHT, this.uiX + 420, this.uiY + 227, 0.0f, 0.0f, 23, 13, 23, 13);
            }
            ResourceLocation next = this.arrowNextPressed ? ARROW_NEXT_PRESSED : ARROW_NEXT;
            guiGraphics.blit(next, this.uiX + 420, this.uiY + 227, 0.0f, 0.0f, 23, 13, 23, 13);
        }
        this.clickedX = 0;
        this.clickedY = 0;
    }

    private void renderIndex(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        int x = this.uiX + 70;
        int y = this.uiY + 30;
        int columnNumber = -1;
        int rowNumber = -1;
        int semiPageNumber = -this.currentPage * 2;
        this.hasNextEntryPage = false;
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.guide.available"), x + 25 + columnNumber * 25 + semiPageNumber * 205, y + 10 + rowNumber * 25, 0, false);
        ++rowNumber;
        for (FishProperties fp : this.fishInArea) {
            if (++columnNumber > 6) {
                ++rowNumber;
                columnNumber = 0;
            }
            if (rowNumber > 7) {
                ++semiPageNumber;
                rowNumber = 0;
            }
            if (semiPageNumber > 1) break;
            if (semiPageNumber < 0) continue;
            this.renderFishIndex(guiGraphics, x + columnNumber * 25 + semiPageNumber * 205, y + rowNumber * 25, mouseX, mouseY, fp);
        }
        columnNumber = -1;
        if (++rowNumber > 6) {
            rowNumber = 0;
            ++semiPageNumber;
        }
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.guide.all"), x + 25 + columnNumber * 25 + semiPageNumber * 205, y + 10 + rowNumber * 25, 0, false);
        ++rowNumber;
        for (FishProperties fp : this.entries) {
            if (++columnNumber > 6) {
                ++rowNumber;
                columnNumber = 0;
            }
            if (rowNumber > 7) {
                ++semiPageNumber;
                rowNumber = 0;
            }
            if (semiPageNumber > 1) break;
            if (semiPageNumber < 0) continue;
            this.renderFishIndex(guiGraphics, x + columnNumber * 25 + semiPageNumber * 205, y + rowNumber * 25, mouseX, mouseY, fp);
        }
        if (semiPageNumber > 1) {
            this.hasNextEntryPage = true;
        }
    }

    private void renderFishIndex(GuiGraphics guiGraphics, int xOffset, int yOffset, int mouseX, int mouseY, FishProperties fp) {
        List fishCounterList = (List)this.player.getData(ModDataAttachments.FISHES_CAUGHT);
        ItemStack is = new ItemStack(fp.fish());
        int caught = 0;
        for (FishCaughtCounter f : fishCounterList) {
            if (!fp.equals(f.fp())) continue;
            caught = f.count();
            break;
        }
        if (this.clickedX > xOffset - 3 && this.clickedX < xOffset + 21 - 3 && this.clickedY > yOffset - 3 && this.clickedY < yOffset + 21 - 3) {
            this.currentMenu = 1;
            this.currentPage = this.entries.indexOf(fp) / 2;
        }
        int outlineColor = -15654349;
        if (this.clickedXDown > xOffset - 3 && this.clickedXDown < xOffset + 21 - 3 && this.clickedYDown > yOffset - 3 && this.clickedYDown < yOffset + 21 - 3) {
            outlineColor = -12277180;
        }
        guiGraphics.renderOutline(xOffset - 2, yOffset - 2, 20, 20, outlineColor);
        switch (fp.rarity()) {
            case COMMON: {
                guiGraphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
                break;
            }
            case UNCOMMON: {
                guiGraphics.setColor(0.7f, 1.0f, 0.7f, 1.0f);
                break;
            }
            case RARE: {
                guiGraphics.setColor(0.2f, 0.4f, 0.7f, 0.7f);
                break;
            }
            case EPIC: {
                guiGraphics.setColor(1.0f, 0.0f, 1.0f, 0.5f);
                break;
            }
            case LEGENDARY: {
                Color color = Color.getHSBColor(Tooltips.hue * 2.0f, 1.0f, 1.0f);
                float r = (float)color.getRed() / 255.0f;
                float g = (float)color.getGreen() / 255.0f;
                float b = (float)color.getBlue() / 255.0f;
                guiGraphics.setColor(r, g, b, 0.7f);
            }
        }
        RenderSystem.enableBlend();
        guiGraphics.blit(GLOW, xOffset - 1, yOffset - 1, 0.0f, 0.0f, 18, 18, 18, 18);
        RenderSystem.disableBlend();
        guiGraphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        if (caught != 0) {
            this.renderItem(is, xOffset, yOffset, 1);
        } else {
            this.renderItem(new ItemStack((ItemLike)ModItems.MISSINGNO.get()), xOffset, yOffset, 1);
        }
        for (FishProperties fpNotif : (List)this.player.getData(ModDataAttachments.FISHES_NOTIFICATION)) {
            if (!fp.equals(fpNotif)) continue;
            guiGraphics.blit(STAR, xOffset + 10, yOffset + 7, 0.0f, 0.0f, 10, 10, 10, 10);
        }
        if (this.clickedX > xOffset - 3 && this.clickedX < xOffset + 21 - 3 && this.clickedY > yOffset - 3 && this.clickedY < yOffset + 21 - 3) {
            this.currentMenu = 1;
            this.currentPage = this.entries.indexOf(fp) / 2;
        }
        if (mouseX > xOffset - 3 && mouseX < xOffset + 21 - 3 && mouseY > yOffset - 3 && mouseY < yOffset + 21 - 3) {
            ArrayList<MutableComponent> components = new ArrayList<MutableComponent>();
            if (caught == 0) {
                components.add(Component.translatable((String)"gui.guide.not_caught_fish_name"));
                components.add(Component.translatable((String)"gui.guide.not_caught").withColor(0xAA0000));
            } else {
                if (fp.customName().isEmpty()) {
                    components.add(Component.translatable((String)("item." + fp.fish().getRegisteredName().replace(":", "."))));
                } else {
                    components.add(Component.translatable((String)("item.starcatcher." + fp.customName())));
                }
                components.add(Component.translatable((String)"gui.guide.caught").append((Component)Component.literal((String)("[" + caught + "]"))).withColor(43520));
            }
            guiGraphics.renderTooltip(this.font, components, Optional.empty(), mouseX, mouseY);
        }
    }

    private void renderEntry(GuiGraphics guiGraphics, int mouseX, int mouseY, int xOffset, int entry) {
        ResourceLocation rl;
        MutableComponent comp;
        MutableComponent comp2;
        Object c;
        if (this.level == null) {
            this.level = this.getMinecraft().level;
        }
        double x = mouseX - this.uiX;
        double y = mouseY - this.uiY;
        if (this.entries.size() <= entry) {
            return;
        }
        ItemStack is = new ItemStack(this.entries.get(entry).fish());
        FishProperties fp = this.entries.get(entry);
        if (!this.fpsSeen.contains(fp)) {
            this.fpsSeen.add(fp);
        }
        FishCaughtCounter fcc = null;
        for (FishCaughtCounter fccAll : this.fishCaughtCounterList) {
            if (!fp.equals(fccAll.fp())) continue;
            fcc = fccAll;
            break;
        }
        if (fcc == null) {
            guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.guide.not_caught_fish_name"), this.uiX + xOffset + 46, this.uiY + 60, 0, false);
            guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.guide.not_caught").withColor(0xAA0000), this.uiX + xOffset + 46, this.uiY + 70, 0, false);
            this.renderItem(new ItemStack((ItemLike)ModItems.MISSINGNO.get()), this.uiX + xOffset + 10, this.uiY + 60);
        } else {
            MutableComponent compName = fp.customName().isEmpty() ? Component.translatable((String)("item." + fp.fish().getRegisteredName().replace(":", "."))) : Component.translatable((String)("item.starcatcher." + fp.customName()));
            guiGraphics.drawString(this.font, (Component)compName, this.uiX + xOffset + 46, this.uiY + 55, 0, false);
            c = Component.literal((String)("[" + fcc.count() + "]")).withColor(43520);
            guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.guide.caught").append((Component)c).withColor(43520), this.uiX + xOffset + 46, this.uiY + 65, 0, false);
            Component rarity = Tooltips.DecodeTranslationKeyTags((String)("gui.guide.rarity." + fp.rarity().getSerializedName()));
            guiGraphics.drawString(this.font, rarity, this.uiX + xOffset + 46, this.uiY + 75, 0, false);
            this.renderItem(is, this.uiX + xOffset + 10, this.uiY + 60);
            switch (fp.rarity()) {
                case COMMON: {
                    guiGraphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
                    break;
                }
                case UNCOMMON: {
                    guiGraphics.setColor(0.7f, 1.0f, 0.7f, 1.0f);
                    break;
                }
                case RARE: {
                    guiGraphics.setColor(0.2f, 0.4f, 0.7f, 0.7f);
                    break;
                }
                case EPIC: {
                    guiGraphics.setColor(1.0f, 0.0f, 1.0f, 0.5f);
                    break;
                }
                case LEGENDARY: {
                    Color color = Color.getHSBColor(Tooltips.hue, 1.0f, 1.0f);
                    float r = (float)color.getRed() / 255.0f;
                    float g = (float)color.getGreen() / 255.0f;
                    float b = (float)color.getBlue() / 255.0f;
                    guiGraphics.setColor(r, g, b, 0.7f);
                }
            }
            RenderSystem.enableBlend();
            guiGraphics.blit(GLOW, this.uiX + xOffset - 6, this.uiY + 40, 0.0f, 0.0f, 48, 48, 48, 48);
            RenderSystem.disableBlend();
            guiGraphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
            if (mouseX > this.uiX + xOffset + 46 && mouseX < this.uiX + xOffset + 150 && mouseY > this.uiY + 57 && mouseY < this.uiY + 80) {
                ArrayList<MutableComponent> components = new ArrayList<MutableComponent>();
                components.add(Component.literal((String)("Fastest Catch: " + (float)(fcc.fastestTicks() / 20) + "s")));
                components.add(Component.literal((String)("Average: " + fcc.averageTicks() / 20.0f + "s")));
                guiGraphics.renderTooltip(this.font, components, Optional.empty(), mouseX, mouseY);
            }
        }
        int yOffset = 110;
        if (fp.wr().dims().isEmpty()) {
            comp2 = Component.translatable((String)"gui.guide.no_restriction");
        } else if (fp.wr().dims().size() == 1) {
            comp2 = Component.translatable((String)("dimension." + fp.wr().dims().getFirst().toLanguageKey()));
        } else {
            comp2 = Component.translatable((String)"gui.guide.hover");
            if (x > (double)xOffset && x < (double)(xOffset + 100) && y > (double)(yOffset - 2) && y < (double)(yOffset + 10)) {
                ArrayList<MutableComponent> c2 = new ArrayList<MutableComponent>();
                c2.add(Component.translatable((String)"gui.guide.dimensions"));
                for (int i = 0; i < fp.wr().dims().size(); ++i) {
                    c2.add(Component.translatable((String)("dimension." + fp.wr().dims().get(i).toLanguageKey())));
                }
                guiGraphics.renderTooltip(this.font, c2, Optional.empty(), mouseX, mouseY);
            }
        }
        comp2 = fp.wr().dims().isEmpty() ? comp2.copy().withColor(43520) : (fp.wr().dims().contains(this.level.dimension().location()) ? comp2.copy().withColor(43520) : comp2.copy().withColor(0xAA0000));
        MutableComponent start = Component.translatable((String)"gui.guide.dimension");
        guiGraphics.drawString(this.font, (Component)start.copy().append((Component)comp2), this.uiX + xOffset, this.uiY + yOffset, 0, false);
        if (!fp.wr().dimsBlacklist().isEmpty()) {
            guiGraphics.drawString(this.font, (Component)Component.literal((String)"[!]").withColor(0xAA0000), this.uiX + xOffset + 160, this.uiY + yOffset, 0, false);
            if (x > (double)(xOffset + 155) && x < (double)(xOffset + 175) && y > (double)(yOffset - 4) && y < (double)(yOffset + 12)) {
                c = new ArrayList();
                c.add(Component.translatable((String)"gui.guide.blacklisted_dimensions"));
                for (int i = 0; i < fp.wr().dimsBlacklist().size(); ++i) {
                    c.add(Component.literal((String)fp.wr().dimsBlacklist().get(i).toString()));
                }
                guiGraphics.renderTooltip(this.font, (List)c, Optional.empty(), mouseX, mouseY);
            }
        }
        yOffset += 15;
        List<ResourceLocation> biomesBL = FishProperties.getBiomesBlacklistAsList(fp, (Level)this.level);
        List<ResourceLocation> biomes = FishProperties.getBiomesAsList(fp, (Level)this.level);
        if (biomes.isEmpty()) {
            comp = Component.translatable((String)"gui.guide.no_restriction");
            if (!biomesBL.isEmpty()) {
                comp.append("*");
            }
        } else if (biomes.size() == 1) {
            comp = Component.translatable((String)("biome." + biomes.getFirst().toLanguageKey()));
        } else if (fp.wr().biomesTags().size() == 1) {
            comp = Component.translatable((String)("tag." + fp.wr().biomesTags().getFirst().toLanguageKey()));
            if (x > (double)xOffset && x < (double)(xOffset + 100) && y > (double)(yOffset - 2) && y < (double)(yOffset + 10)) {
                ArrayList<MutableComponent> c3 = new ArrayList<MutableComponent>();
                c3.add(Component.translatable((String)"gui.guide.biomes"));
                for (ResourceLocation rl2 : biomes) {
                    c3.add(Component.translatable((String)("biome." + rl2.toLanguageKey())));
                }
                guiGraphics.renderTooltip(this.font, c3, Optional.empty(), mouseX, mouseY);
            }
        } else {
            comp = Component.translatable((String)"gui.guide.hover");
            if (x > (double)xOffset && x < (double)(xOffset + 100) && y > (double)(yOffset - 2) && y < (double)(yOffset + 10)) {
                ArrayList<MutableComponent> c4 = new ArrayList<MutableComponent>();
                c4.add(Component.translatable((String)"gui.guide.biome"));
                for (ResourceLocation rl3 : biomes) {
                    c4.add(Component.translatable((String)("biome." + rl3.toLanguageKey())));
                }
                guiGraphics.renderTooltip(this.font, c4, Optional.empty(), mouseX, mouseY);
            }
        }
        comp = biomes.isEmpty() ? comp.copy().withColor(43520) : (biomes.contains(rl = ResourceLocation.parse((String)this.level.getBiome(Minecraft.getInstance().player.blockPosition()).getRegisteredName())) ? comp.copy().withColor(43520) : comp.copy().withColor(0xAA0000));
        Object start2 = Component.translatable((String)"gui.guide.biome");
        guiGraphics.drawString(this.font, (Component)start2.copy().append((Component)comp), this.uiX + xOffset, this.uiY + yOffset, 0, false);
        if (!biomesBL.isEmpty()) {
            guiGraphics.drawString(this.font, (Component)Component.literal((String)"[!]").withColor(0xAA0000), this.uiX + xOffset + 160, this.uiY + yOffset, 0, false);
            if (x > (double)(xOffset + 155) && x < (double)(xOffset + 175) && y > (double)(yOffset - 4) && y < (double)(yOffset + 12)) {
                ArrayList<MutableComponent> c5 = new ArrayList<MutableComponent>();
                c5.add(Component.translatable((String)"gui.guide.blacklisted_biomes"));
                for (ResourceLocation rl4 : biomesBL) {
                    c5.add(Component.translatable((String)("biome." + rl4.toLanguageKey())));
                }
                guiGraphics.renderTooltip(this.font, c5, Optional.empty(), mouseX, mouseY);
            }
        }
        if (!fp.br().correctBait().isEmpty()) {
            ItemStack stack = new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(fp.br().correctBait().getFirst()));
            guiGraphics.drawString(this.font, I18n.get((String)"gui.guide.bait", (Object[])new Object[0]) + I18n.get((String)stack.getDescriptionId(), (Object[])new Object[0]), this.uiX + xOffset, this.uiY + (yOffset += 15), 0, false);
            if (x > (double)xOffset && x < (double)(xOffset + 100) && y > (double)(yOffset - 2) && y < (double)(yOffset + 10)) {
                guiGraphics.renderTooltip(this.font, stack, mouseX, mouseY);
            }
        }
        yOffset += 15;
        if (fp.weather() == FishProperties.Weather.ALL) {
            comp = Component.translatable((String)"gui.guide.no_restriction").withColor(43520);
        } else {
            comp = Component.translatable((String)"gui.guide.no_restriction");
            if (fp.weather() == FishProperties.Weather.RAIN) {
                comp = (double)this.level.getRainLevel(0.0f) > 0.5 ? Component.translatable((String)"gui.guide.raining").withColor(43520) : Component.translatable((String)"gui.guide.raining").withColor(0xAA0000);
            }
            if (fp.weather() == FishProperties.Weather.THUNDER) {
                comp = (double)this.level.getThunderLevel(0.0f) > 0.5 ? Component.translatable((String)"gui.guide.thundering").withColor(43520) : Component.translatable((String)"gui.guide.thundering").withColor(0xAA0000);
            }
            if (fp.weather() == FishProperties.Weather.CLEAR) {
                comp = (double)this.level.getRainLevel(0.0f) > 0.5 || (double)this.level.getThunderLevel(0.0f) > 0.5 ? Component.translatable((String)"gui.guide.clear").withColor(0xAA0000) : Component.translatable((String)"gui.guide.clear").withColor(43520);
            }
        }
        start2 = Component.translatable((String)"gui.guide.weather");
        guiGraphics.drawString(this.font, (Component)start2.copy().append((Component)comp), this.uiX + xOffset, this.uiY + yOffset, 0, false);
        yOffset += 15;
        if (fp.daytime() == FishProperties.Daytime.ALL) {
            comp = Component.translatable((String)"gui.guide.no_restriction").withColor(43520);
        } else {
            long time = this.level.getDayTime() % 24000L;
            comp = switch (fp.daytime()) {
                case FishProperties.Daytime.DAY -> {
                    if (time <= 23000L && time >= 12700L) {
                        yield Component.translatable((String)"gui.guide.day").withColor(0xAA0000);
                    }
                    yield Component.translatable((String)"gui.guide.day").withColor(43520);
                }
                case FishProperties.Daytime.NOON -> {
                    if (time <= 3500L || time >= 8500L) {
                        yield Component.translatable((String)"gui.guide.noon").withColor(0xAA0000);
                    }
                    yield Component.translatable((String)"gui.guide.noon").withColor(43520);
                }
                case FishProperties.Daytime.NIGHT -> {
                    if (time >= 23000L || time <= 12700L) {
                        yield Component.translatable((String)"gui.guide.night").withColor(0xAA0000);
                    }
                    yield Component.translatable((String)"gui.guide.night").withColor(43520);
                }
                case FishProperties.Daytime.MIDNIGHT -> {
                    if (time <= 16500L || time >= 19500L) {
                        yield Component.translatable((String)"gui.guide.midnight").withColor(0xAA0000);
                    }
                    yield Component.translatable((String)"gui.guide.midnight").withColor(43520);
                }
                default -> Component.empty();
            };
        }
        MutableComponent start22 = Component.translatable((String)"gui.guide.daytime");
        guiGraphics.drawString(this.font, (Component)start22.copy().append((Component)comp), this.uiX + xOffset, this.uiY + yOffset, 0, false);
        yOffset += 15;
        int above = fp.mustBeCaughtAboveY();
        int below = fp.mustBeCaughtBelowY();
        if (above != Integer.MIN_VALUE || below != Integer.MAX_VALUE) {
            MutableComponent belowAbove = Component.empty();
            if (above != Integer.MIN_VALUE) {
                belowAbove.append((Component)Component.translatable((String)"gui.guide.above")).append("" + above);
            }
            if (above != Integer.MIN_VALUE && below != Integer.MAX_VALUE) {
                belowAbove.append(", ");
            }
            if (below != Integer.MAX_VALUE) {
                belowAbove.append((Component)Component.translatable((String)"gui.guide.below")).append("" + below);
            }
            MutableComponent comp3 = belowAbove;
            if (above == 100 && below == Integer.MAX_VALUE) {
                comp3 = Component.translatable((String)"gui.guide.mountain");
            } else if (above == 50 && below == 100) {
                comp3 = Component.translatable((String)"gui.guide.surface");
            } else if (above == 0 && below == Integer.MAX_VALUE) {
                comp3 = Component.translatable((String)"gui.guide.surface");
            } else if (above == Integer.MIN_VALUE && below == 50) {
                comp3 = Component.translatable((String)"gui.guide.underground");
            } else if (above == 0 && below == 50) {
                comp3 = Component.translatable((String)"gui.guide.caves");
            } else if (above == Integer.MIN_VALUE && below == 0) {
                comp3 = Component.translatable((String)"gui.guide.deepslate");
            }
            if (this.player.getY() > (double)above && this.player.getY() < (double)below) {
                comp3.withColor(43520);
            } else {
                comp3.withColor(0xAA0000);
            }
            if (x > (double)xOffset && x < (double)(xOffset + 140) && y > (double)(yOffset - 2) && y < (double)(yOffset + 10) && comp3 != belowAbove) {
                guiGraphics.renderTooltip(this.font, (Component)belowAbove, mouseX, mouseY);
            }
            guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.guide.elevation").append((Component)comp3), this.uiX + xOffset, this.uiY + yOffset, 0, false);
        }
    }

    private void renderImage(GuiGraphics guiGraphics, ResourceLocation rl) {
        guiGraphics.blit(rl, this.uiX, this.uiY, 0.0f, 0.0f, 512, 256, 512, 256);
    }

    private void renderImage(GuiGraphics guiGraphics, ResourceLocation rl, int yOffset) {
        guiGraphics.blit(rl, this.uiX, this.uiY + yOffset, 0.0f, 0.0f, 512, 256, 512, 256);
    }

    private void renderItem(ItemStack stack, int x, int y) {
        this.renderItem(stack, x, y, 3);
    }

    private void renderItem(ItemStack stack, int x, int y, int scale) {
        ClientLevel level = Minecraft.getInstance().level;
        LocalPlayer entity = Minecraft.getInstance().player;
        if (!stack.isEmpty()) {
            boolean usesBlockLight;
            BakedModel bakedmodel = this.minecraft.getItemRenderer().getModel(stack, (Level)level, (LivingEntity)entity, 234234);
            PoseStack pose = new PoseStack();
            pose.pushPose();
            pose.translate((float)(x + 8), (float)(y + 8), 150.0f);
            pose.scale(16.0f * (float)scale, -16.0f * (float)scale, 16.0f * (float)scale);
            boolean bl = usesBlockLight = !bakedmodel.usesBlockLight();
            if (usesBlockLight) {
                Lighting.setupForFlatItems();
            }
            this.minecraft.getItemRenderer().render(stack, ItemDisplayContext.GUI, false, pose, (MultiBufferSource)Minecraft.getInstance().renderBuffers().bufferSource(), 0xF000F0, OverlayTexture.NO_OVERLAY, bakedmodel);
            RenderSystem.disableDepthTest();
            Minecraft.getInstance().renderBuffers().bufferSource().endBatch();
            RenderSystem.enableDepthTest();
            if (usesBlockLight) {
                Lighting.setupFor3DItems();
            }
            pose.popPose();
        }
    }

    public void onClose() {
        PacketDistributor.sendToServer((CustomPacketPayload)new Payloads.FPsSeen(this.fpsSeen), (CustomPacketPayload[])new CustomPacketPayload[0]);
        super.onClose();
    }

    public boolean isPauseScreen() {
        return false;
    }

    protected boolean shouldNarrateNavigation() {
        return false;
    }

    public FishingGuideScreen() {
        super((Component)Component.empty());
    }
}

