/*
 * Decompiled with CFR 0.152.
 */
package com.wdiscute.starcatcher.guide;

import com.wdiscute.starcatcher.Starcatcher;
import com.wdiscute.starcatcher.networkandcodecs.FishCaughtCounter;
import com.wdiscute.starcatcher.networkandcodecs.FishProperties;
import com.wdiscute.starcatcher.networkandcodecs.ModDataAttachments;
import com.wdiscute.starcatcher.networkandcodecs.Payloads;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.PacketDistributor;

public class TrophySilver
extends Item {
    public TrophySilver() {
        super(new Item.Properties().stacksTo(1));
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        if (!player.isCreative()) {
            return InteractionResultHolder.pass((Object)player.getItemInHand(usedHand));
        }
        ArrayList<FishProperties> fishes = new ArrayList<FishProperties>((Collection)player.getData(ModDataAttachments.FISHES_NOTIFICATION));
        ArrayList<FishCaughtCounter> fishCounter = new ArrayList<FishCaughtCounter>((Collection)player.getData(ModDataAttachments.FISHES_CAUGHT));
        Optional optional = level.registryAccess().registryOrThrow(Starcatcher.FISH_REGISTRY).getRandom(level.random);
        if (optional.isPresent()) {
            FishProperties fp = (FishProperties)((Holder.Reference)optional.get()).value();
            fishCounter.add(new FishCaughtCounter(fp, 1, Integer.MAX_VALUE, 99999.0f));
            fishes.add(fp);
            if (player instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)player;
                PacketDistributor.sendToPlayer((ServerPlayer)sp, (CustomPacketPayload)new Payloads.FishCaughtPayload(fp), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
        player.setData(ModDataAttachments.FISHES_CAUGHT, fishCounter);
        player.setData(ModDataAttachments.FISHES_NOTIFICATION, fishes);
        return InteractionResultHolder.success((Object)player.getItemInHand(usedHand));
    }
}

