/*
 * Decompiled with CFR 0.152.
 */
package com.wdiscute.starcatcher.networkandcodecs;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.wdiscute.starcatcher.Starcatcher;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;
import net.neoforged.neoforge.network.codec.NeoForgeStreamCodecs;
import org.jetbrains.annotations.NotNull;

public record TrophyProperties(TrophyType type, ResourceLocation rl, int UniqueFishCount, int TotalCaughtCount) {
    public static final Codec<TrophyProperties> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)TrophyType.CODEC.fieldOf("trophy_type").forGetter(TrophyProperties::type), (App)ResourceLocation.CODEC.fieldOf("resource_location").forGetter(TrophyProperties::rl), (App)Codec.INT.optionalFieldOf("unique_fishes", (Object)Integer.MIN_VALUE).forGetter(TrophyProperties::UniqueFishCount), (App)Codec.INT.optionalFieldOf("total_fishes", (Object)Integer.MIN_VALUE).forGetter(TrophyProperties::TotalCaughtCount)).apply((Applicative)instance, TrophyProperties::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, TrophyProperties> STREAM_CODEC = StreamCodec.composite(TrophyType.STREAM_CODEC, TrophyProperties::type, (StreamCodec)ResourceLocation.STREAM_CODEC, TrophyProperties::rl, (StreamCodec)ByteBufCodecs.VAR_INT, TrophyProperties::UniqueFishCount, (StreamCodec)ByteBufCodecs.VAR_INT, TrophyProperties::TotalCaughtCount, TrophyProperties::new);
    public static final StreamCodec<RegistryFriendlyByteBuf, List<TrophyProperties>> LIST_STREAM_CODEC = STREAM_CODEC.apply(ByteBufCodecs.list());
    public static final Codec<List<TrophyProperties>> LIST_CODEC = CODEC.listOf();
    public static final TrophyProperties DEFAULT = new TrophyProperties(TrophyType.ITEM, Starcatcher.rl("missingno"), Integer.MAX_VALUE, Integer.MAX_VALUE);

    public static enum TrophyType implements StringRepresentable
    {
        ITEM("item"),
        ENTITY("entity"),
        ADVANCEMENT("advancement");

        public static final Codec<TrophyType> CODEC;
        public static final StreamCodec<FriendlyByteBuf, TrophyType> STREAM_CODEC;
        private final String key;

        private TrophyType(String key) {
            this.key = key;
        }

        @NotNull
        public String getSerializedName() {
            return this.key;
        }

        static {
            CODEC = StringRepresentable.fromEnum(TrophyType::values);
            STREAM_CODEC = NeoForgeStreamCodecs.enumCodec(TrophyType.class);
        }
    }
}

