/*
 * Decompiled with CFR 0.152.
 */
package com.wdiscute.starcatcher.fishspotter;

import com.mojang.blaze3d.systems.RenderSystem;
import com.wdiscute.starcatcher.ModItems;
import com.wdiscute.starcatcher.Starcatcher;
import com.wdiscute.starcatcher.networkandcodecs.DataAttachments;
import com.wdiscute.starcatcher.networkandcodecs.FishCaughtCounter;
import com.wdiscute.starcatcher.networkandcodecs.FishProperties;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;

public class FishTrackerLayer
implements IGuiOverlay {
    private static final ResourceLocation BACKGROUND = Starcatcher.rl("textures/gui/fish_tracker.png");
    int uiX;
    int uiY;
    float offScreen = -150.0f;
    double oldmil = 0.0;
    double mil = 0.0;
    Font font;
    int imageWidth = 150;
    int imageHeight = 100;
    float counterSinceLastRefresh = 999.0f;
    Player player;
    ClientLevel level;
    List<FishProperties> fpsInArea = new ArrayList<FishProperties>();
    List<FishProperties> fishesCaught;

    private void recalculate() {
        this.fpsInArea = FishProperties.getFpsWithGuideEntryForArea((Entity)this.player);
        this.fishesCaught = new ArrayList<FishProperties>();
        for (FishCaughtCounter fishes : DataAttachments.get(this.player).fishesCaught()) {
            this.fishesCaught.add(fishes.fp());
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void render(ForgeGui forgeGui, GuiGraphics guiGraphics, float partialTick, int screenWidth, int screenHeight) {
        this.font = Minecraft.m_91087_().f_91062_;
        this.uiX = Minecraft.m_91087_().m_91268_().m_85445_() - this.imageWidth;
        this.uiY = Minecraft.m_91087_().m_91268_().m_85446_() - this.imageHeight - 80;
        if (Minecraft.m_91087_().f_91073_ == null) {
            return;
        }
        this.level = Minecraft.m_91087_().f_91073_;
        if (Minecraft.m_91087_().f_91074_ == null) {
            return;
        }
        this.player = Minecraft.m_91087_().f_91074_;
        boolean shouldShow = this.player.m_21205_().m_150930_((Item)ModItems.FISH_SPOTTER.get()) || this.player.m_21206_().m_150930_((Item)ModItems.FISH_SPOTTER.get());
        this.mil = (double)Util.m_137550_() - this.oldmil;
        this.oldmil = Util.m_137550_();
        if (!shouldShow) {
            if (!(this.offScreen > -150.0f)) {
                this.offScreen = -150.0f;
                return;
            }
            this.offScreen = (float)((double)this.offScreen - 15.0 * (this.mil / 70.0));
        } else {
            this.offScreen = this.offScreen < 0.0f ? (float)((double)this.offScreen + 15.0 * (this.mil / 70.0)) : 0.0f;
        }
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_(-this.offScreen, 0.0f, 0.0f);
        RenderSystem.enableBlend();
        this.renderImage(guiGraphics, BACKGROUND);
        RenderSystem.disableBlend();
        this.counterSinceLastRefresh += 1.0f * partialTick;
        if (this.counterSinceLastRefresh > 100.0f) {
            this.recalculate();
        }
        for (int i = 0; i < this.fpsInArea.size(); ++i) {
            ItemStack is = new ItemStack((ItemLike)ModItems.MISSINGNO.get());
            if (this.fishesCaught.contains(this.fpsInArea.get(i))) {
                is = new ItemStack(this.fpsInArea.get(i).fish());
            }
            guiGraphics.m_280480_(is, this.uiX + 50 + i * 20 % 100, this.uiY + 10 + i / 5 * 20);
            if (i > 8) break;
        }
        guiGraphics.m_280168_().m_85849_();
    }

    private void renderImage(GuiGraphics guiGraphics, ResourceLocation rl) {
        guiGraphics.m_280163_(rl, this.uiX, this.uiY, 0.0f, 0.0f, this.imageWidth, this.imageHeight, this.imageWidth, this.imageHeight);
    }

    private void drawComp(GuiGraphics guiGraphics, Component comp, int xOffset, int yOffset) {
        guiGraphics.m_280614_(this.font, comp, this.uiX + xOffset, this.uiY + yOffset, 0, false);
    }
}

