/*
 * Decompiled with CFR 0.152.
 */
package com.wdiscute.starcatcher.guide;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.wdiscute.starcatcher.Config;
import com.wdiscute.starcatcher.ModItems;
import com.wdiscute.starcatcher.Starcatcher;
import com.wdiscute.starcatcher.Tooltips;
import com.wdiscute.starcatcher.blocks.ModBlocks;
import com.wdiscute.starcatcher.guide.SettingsScreen;
import com.wdiscute.starcatcher.networkandcodecs.DataAttachments;
import com.wdiscute.starcatcher.networkandcodecs.DataComponents;
import com.wdiscute.starcatcher.networkandcodecs.FishCaughtCounter;
import com.wdiscute.starcatcher.networkandcodecs.FishProperties;
import com.wdiscute.starcatcher.networkandcodecs.Payloads;
import com.wdiscute.starcatcher.networkandcodecs.TrophyProperties;
import com.wdiscute.starcatcher.secretnotes.NoteContainer;
import com.wdiscute.starcatcher.secretnotes.SecretNoteScreen;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.PacketDistributor;

public class FishingGuideScreen
extends Screen {
    private static final ResourceLocation BACKGROUND_INDEX_FIRST = Starcatcher.rl("textures/gui/guide/background_index_first.png");
    private static final ResourceLocation BACKGROUND_INDEX_SECOND = Starcatcher.rl("textures/gui/guide/background_index_second.png");
    private static final ResourceLocation BACKGROUND_ENTRY = Starcatcher.rl("textures/gui/guide/background_entry.png");
    private static final ResourceLocation BACKGROUND_BASICS = Starcatcher.rl("textures/gui/guide/background_basics.png");
    private static final ResourceLocation FISHES_IN_AREA_TOP_RIGHT_DECORATION = Starcatcher.rl("textures/gui/guide/fishes_in_area_top_right_decoration.png");
    private static final ResourceLocation FISHES_IN_AREA_BOTTOM_LEFT_DECORATION = Starcatcher.rl("textures/gui/guide/fishes_in_area_bottom_left_decoration.png");
    private static final ResourceLocation FISHES_IN_AREA_FISH_DECORATION = Starcatcher.rl("textures/gui/guide/fishes_in_area_fish_decoration.png");
    private static final ResourceLocation ALL_FISHES_1_ROW = Starcatcher.rl("textures/gui/guide/all_fishes_1_rows.png");
    private static final ResourceLocation ALL_FISHES_2_ROW = Starcatcher.rl("textures/gui/guide/all_fishes_2_rows.png");
    private static final ResourceLocation ALL_FISHES_3_ROW = Starcatcher.rl("textures/gui/guide/all_fishes_3_rows.png");
    private static final ResourceLocation ALL_FISHES_4_ROW = Starcatcher.rl("textures/gui/guide/all_fishes_4_rows.png");
    private static final ResourceLocation HELP_PAGE_1 = Starcatcher.rl("textures/gui/guide/help_1.png");
    private static final ResourceLocation HELP_PAGE_2 = Starcatcher.rl("textures/gui/guide/help_2.png");
    private static final ResourceLocation HELP_PAGE_3 = Starcatcher.rl("textures/gui/guide/help_3.png");
    private static final ResourceLocation HELP_PAGE_4 = Starcatcher.rl("textures/gui/guide/help_4.png");
    private static final ResourceLocation HELP_PAGE_5 = Starcatcher.rl("textures/gui/guide/help_5.png");
    private static final ResourceLocation ARROW_PREVIOUS = Starcatcher.rl("textures/gui/guide/arrow_previous.png");
    private static final ResourceLocation ARROW_PREVIOUS_PRESSED = Starcatcher.rl("textures/gui/guide/arrow_previous_pressed.png");
    private static final ResourceLocation ARROW_PREVIOUS_HIGHLIGHT = Starcatcher.rl("textures/gui/guide/arrow_previous_highlight.png");
    private static final ResourceLocation ARROW_NEXT = Starcatcher.rl("textures/gui/guide/arrow_next.png");
    private static final ResourceLocation ARROW_NEXT_PRESSED = Starcatcher.rl("textures/gui/guide/arrow_next_pressed.png");
    private static final ResourceLocation ARROW_NEXT_HIGHLIGHT = Starcatcher.rl("textures/gui/guide/arrow_next_highlight.png");
    private static final ResourceLocation ARROW_INDEX = Starcatcher.rl("textures/gui/guide/arrow_index.png");
    private static final ResourceLocation ARROW_INDEX_PRESSED = Starcatcher.rl("textures/gui/guide/arrow_index_pressed.png");
    private static final ResourceLocation ARROW_INDEX_HIGHLIGHT = Starcatcher.rl("textures/gui/guide/arrow_index_highlight.png");
    private static final ResourceLocation NEW_FISH = Starcatcher.rl("textures/gui/guide/new_fish.png");
    private static final ResourceLocation STAR = Starcatcher.rl("textures/gui/guide/star.png");
    private static final ResourceLocation GLOW = Starcatcher.rl("textures/gui/guide/glow.png");
    private static final int MAX_HELP_PAGES = 4;
    final boolean advancedTooltips;
    private final ItemStack basics;
    private final ItemStack treasures;
    private final ItemStack ironHook;
    private final ItemStack shinyHook;
    private final ItemStack goldHook;
    private final ItemStack mossyHook;
    private final ItemStack crystalHook;
    private final ItemStack heavyHook;
    private final ItemStack stoneHook;
    private final ItemStack splitHook;
    private final ItemStack stabHook;
    private final ItemStack frugalBobber;
    private final ItemStack creeperBobber;
    private final ItemStack glitterBobber;
    private final ItemStack colorfulBobber;
    private final ItemStack steadyBobber;
    private final ItemStack impatientBobber;
    private final ItemStack frogBobber;
    private final ItemStack kimbeBobber;
    private final ItemStack clearBobber;
    private final ItemStack cherryBait;
    private final ItemStack lushBait;
    private final ItemStack sculkBait;
    private final ItemStack dripstoneBait;
    private final ItemStack murkwaterBait;
    private final ItemStack legendaryBait;
    private final ItemStack meteorologicalBait;
    private final ItemStack fishSpotter;
    private final ItemStack trophies;
    private final ItemStack secrets;
    private final ItemStack settings;
    int uiX;
    int uiY;
    int imageWidth;
    int imageHeight;
    int clickedX;
    int clickedY;
    boolean arrowPreviousPressed;
    boolean arrowNextPressed;
    boolean arrowIndexPressed;
    int menu = 0;
    int page = 0;
    boolean hasNextEntryPage;
    ClientLevel level;
    LocalPlayer player;
    List<FishProperties> fpsSeen = new ArrayList<FishProperties>();
    List<FishProperties> entries = new ArrayList<FishProperties>(999);
    List<TrophyProperties> trophiesTps = new ArrayList<TrophyProperties>();
    List<TrophyProperties> secretsTps = new ArrayList<TrophyProperties>();
    List<FishProperties> fishInArea = new ArrayList<FishProperties>();
    List<FishCaughtCounter> fishCaughtCounterList = new ArrayList<FishCaughtCounter>();
    TrophyProperties.RarityProgress all;
    TrophyProperties.RarityProgress common;
    TrophyProperties.RarityProgress uncommon;
    TrophyProperties.RarityProgress rare;
    TrophyProperties.RarityProgress epic;
    TrophyProperties.RarityProgress legendary;

    private void sortEntries() {
        List<String> entriesString;
        HashMap<String, FishProperties> map;
        ArrayList<FishProperties> entriesSorted;
        Sort sort = (Sort)((Object)Config.SORT.get());
        if (sort.equals((Object)Sort.RARITY_DOWN) || sort.equals((Object)Sort.RARITY_UP)) {
            entriesSorted = new ArrayList<FishProperties>();
            this.entries.forEach(e -> {
                if (e.rarity().equals((Object)FishProperties.Rarity.COMMON)) {
                    entriesSorted.add((FishProperties)e);
                }
            });
            this.entries.forEach(e -> {
                if (e.rarity().equals((Object)FishProperties.Rarity.UNCOMMON)) {
                    entriesSorted.add((FishProperties)e);
                }
            });
            this.entries.forEach(e -> {
                if (e.rarity().equals((Object)FishProperties.Rarity.RARE)) {
                    entriesSorted.add((FishProperties)e);
                }
            });
            this.entries.forEach(e -> {
                if (e.rarity().equals((Object)FishProperties.Rarity.EPIC)) {
                    entriesSorted.add((FishProperties)e);
                }
            });
            this.entries.forEach(e -> {
                if (e.rarity().equals((Object)FishProperties.Rarity.LEGENDARY)) {
                    entriesSorted.add((FishProperties)e);
                }
            });
            if (!sort.equals((Object)Sort.RARITY_UP)) {
                Collections.reverse(entriesSorted);
            }
            this.entries = entriesSorted;
        }
        if (sort.equals((Object)Sort.ALPHABETICAL_DOWN) || sort.equals((Object)Sort.ALPHABETICAL_UP)) {
            entriesSorted = new ArrayList();
            map = new HashMap<String, FishProperties>();
            entriesString = new ArrayList();
            for (FishProperties fp2 : this.entries) {
                String path = ((ResourceKey)fp2.fish().m_203543_().get()).m_135782_().m_135815_();
                map.put(path, fp2);
                entriesString.add(path);
            }
            entriesString = entriesString.stream().sorted().toList();
            for (String s : entriesString) {
                entriesSorted.add((FishProperties)map.get(s));
            }
            if (!sort.equals((Object)Sort.ALPHABETICAL_UP)) {
                Collections.reverse(entriesSorted);
            }
            this.entries = entriesSorted;
        }
        if (sort.equals((Object)Sort.MOD_DOWN) || sort.equals((Object)Sort.MOD_UP)) {
            entriesSorted = new ArrayList();
            map = new HashMap();
            entriesString = new ArrayList();
            for (FishProperties fp2 : this.entries) {
                String namespace = ((ResourceKey)fp2.fish().m_203543_().get()).m_135782_().m_135815_();
                map.put(namespace, fp2);
                entriesString.add(namespace);
            }
            entriesString = entriesString.stream().sorted().toList();
            for (String s : entriesString) {
                entriesSorted.add((FishProperties)map.get(s));
            }
            if (!sort.equals((Object)Sort.MOD_UP)) {
                Collections.reverse(entriesSorted);
            }
            this.entries = entriesSorted;
        }
        if (sort.equals((Object)Sort.FLUID_DOWN) || sort.equals((Object)Sort.FLUID_UP)) {
            Config.SORT.set((Object)Sort.ALPHABETICAL_UP);
            Config.SORT.save();
            this.sortEntries();
            Config.SORT.set((Object)sort);
            Config.SORT.save();
            entriesSorted = new ArrayList();
            ArrayList<FishProperties> entriesRemaining = new ArrayList<FishProperties>(this.entries);
            while (!entriesRemaining.isEmpty()) {
                ResourceLocation rlBeingSorted = ((FishProperties)entriesRemaining.get(0)).wr().fluids().get(0);
                ArrayList<FishProperties> temp = new ArrayList<FishProperties>(entriesRemaining);
                temp.forEach(e -> {
                    if (e.wr().fluids().get(0).equals((Object)rlBeingSorted)) {
                        entriesSorted.add((FishProperties)e);
                        entriesRemaining.remove(e);
                    }
                });
            }
            if (!sort.equals((Object)Sort.FLUID_UP)) {
                Collections.reverse(entriesSorted);
            }
            this.entries = entriesSorted;
        }
        if (sort.equals((Object)Sort.CAUGHT_UP) || sort.equals((Object)Sort.CAUGHT_DOWN)) {
            Config.SORT.set((Object)Sort.ALPHABETICAL_UP);
            Config.SORT.save();
            this.sortEntries();
            Config.SORT.set((Object)sort);
            Config.SORT.save();
            entriesSorted = new ArrayList();
            this.entries.forEach(fp -> {
                FishCaughtCounter fcc = null;
                for (FishCaughtCounter fccAll : this.fishCaughtCounterList) {
                    if (!fp.equals(fccAll.fp())) continue;
                    fcc = fccAll;
                    break;
                }
                if (fcc != null) {
                    entriesSorted.add((FishProperties)fp);
                }
            });
            this.entries.forEach(fp -> {
                FishCaughtCounter fcc = null;
                for (FishCaughtCounter fccAll : this.fishCaughtCounterList) {
                    if (!fp.equals(fccAll.fp())) continue;
                    fcc = fccAll;
                    break;
                }
                if (fcc == null) {
                    entriesSorted.add((FishProperties)fp);
                }
            });
            if (!sort.equals((Object)Sort.CAUGHT_UP)) {
                Collections.reverse(entriesSorted);
            }
            this.entries = entriesSorted;
        }
    }

    protected void m_7856_() {
        super.m_7856_();
        this.entries = new ArrayList<FishProperties>(999);
        this.trophiesTps = new ArrayList<TrophyProperties>(999);
        this.secretsTps = new ArrayList<TrophyProperties>(999);
        this.imageWidth = 420;
        this.imageHeight = 260;
        this.uiX = (this.f_96543_ - this.imageWidth) / 2;
        this.uiY = (this.f_96544_ - this.imageHeight) / 2;
        this.level = Minecraft.m_91087_().f_91073_;
        this.player = Minecraft.m_91087_().f_91074_;
        for (FishProperties fp : FishProperties.getFPs((Level)this.level)) {
            if (!fp.hasGuideEntry()) continue;
            this.entries.add(fp);
        }
        this.sortEntries();
        for (TrophyProperties tp : this.level.m_9598_().m_175515_(Starcatcher.TROPHY_REGISTRY)) {
            if (tp.trophyType() != TrophyProperties.TrophyType.TROPHY) continue;
            this.trophiesTps.add(tp);
        }
        for (TrophyProperties tp : this.level.m_9598_().m_175515_(Starcatcher.TROPHY_REGISTRY)) {
            if (tp.trophyType() != TrophyProperties.TrophyType.SECRET || !DataAttachments.get((Player)this.player).trophiesCaught().contains(tp)) continue;
            this.secretsTps.add(tp);
        }
        this.fishInArea = FishProperties.getFpsWithGuideEntryForArea((Entity)this.player);
        this.fishCaughtCounterList = DataAttachments.get((Player)this.player).fishesCaught();
        this.all = new TrophyProperties.RarityProgress(0, DataAttachments.get((Player)this.player).fishesCaught().size() - 1);
        this.common = new TrophyProperties.RarityProgress(0, -1);
        this.uncommon = TrophyProperties.RarityProgress.DEFAULT;
        this.rare = TrophyProperties.RarityProgress.DEFAULT;
        this.epic = TrophyProperties.RarityProgress.DEFAULT;
        this.legendary = TrophyProperties.RarityProgress.DEFAULT;
        for (FishCaughtCounter fcc : DataAttachments.get((Player)this.player).fishesCaught()) {
            this.all = new TrophyProperties.RarityProgress(this.all.total() + fcc.count(), this.all.unique());
            if (fcc.fp().rarity() == FishProperties.Rarity.COMMON) {
                this.common = new TrophyProperties.RarityProgress(this.common.total() + fcc.count(), this.common.unique() + 1);
            }
            if (fcc.fp().rarity() == FishProperties.Rarity.UNCOMMON) {
                this.uncommon = new TrophyProperties.RarityProgress(this.uncommon.total() + fcc.count(), this.uncommon.unique() + 1);
            }
            if (fcc.fp().rarity() == FishProperties.Rarity.RARE) {
                this.rare = new TrophyProperties.RarityProgress(this.rare.total() + fcc.count(), this.rare.unique() + 1);
            }
            if (fcc.fp().rarity() == FishProperties.Rarity.EPIC) {
                this.epic = new TrophyProperties.RarityProgress(this.epic.total() + fcc.count(), this.epic.unique() + 1);
            }
            if (fcc.fp().rarity() != FishProperties.Rarity.LEGENDARY) continue;
            this.legendary = new TrophyProperties.RarityProgress(this.legendary.total() + fcc.count(), this.legendary.unique() + 1);
        }
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        InputConstants.Key key = InputConstants.m_84827_((int)keyCode, (int)scanCode);
        if (this.f_96541_.f_91066_.f_92092_.isActiveAndMatches(key)) {
            this.m_7379_();
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        double x = mouseX - (double)this.uiX;
        double y = mouseY - (double)this.uiY;
        this.arrowIndexPressed = false;
        this.arrowNextPressed = false;
        this.arrowPreviousPressed = false;
        if (x > 49.0 && x < 69.0 && y > 203.0 && y < 217.0) {
            if (this.menu == 0 && this.page != 0) {
                this.f_96541_.f_91074_.m_216990_(SoundEvents.f_11713_);
                --this.page;
                return true;
            }
            if (this.menu == 1 && this.page == 0) {
                this.f_96541_.f_91074_.m_216990_(SoundEvents.f_11713_);
                this.menu = 0;
                this.page = 0;
                return true;
            }
            if (this.menu == 1) {
                this.f_96541_.f_91074_.m_216990_(SoundEvents.f_11713_);
                --this.page;
                return true;
            }
            if (this.menu == 2 && this.page == 0) {
                this.f_96541_.f_91074_.m_216990_(SoundEvents.f_11713_);
                this.menu = 1;
                this.page = 4;
                return true;
            }
            if (this.menu == 2) {
                this.f_96541_.f_91074_.m_216990_(SoundEvents.f_11713_);
                --this.page;
                return true;
            }
        }
        if (x > 336.0 && x < 356.0 && y > 202.0 && y < 216.0) {
            if (this.menu == 0 && this.hasNextEntryPage) {
                this.f_96541_.f_91074_.m_216990_(SoundEvents.f_11713_);
                ++this.page;
                return true;
            }
            if (this.menu == 0) {
                this.f_96541_.f_91074_.m_216990_(SoundEvents.f_11713_);
                this.menu = 1;
                this.page = 0;
                return true;
            }
            if (this.menu == 1 && this.page != 4) {
                this.f_96541_.f_91074_.m_216990_(SoundEvents.f_11713_);
                ++this.page;
                return true;
            }
            if (this.menu == 1) {
                this.f_96541_.f_91074_.m_216990_(SoundEvents.f_11713_);
                this.menu = 2;
                this.page = 0;
                return true;
            }
            if (this.menu == 2 && this.page <= this.entries.size() / 2 - 1) {
                this.f_96541_.f_91074_.m_216990_(SoundEvents.f_11713_);
                ++this.page;
                return true;
            }
            if (this.menu == 2) {
                return true;
            }
        }
        if (x > 174.0 && x < 196.0 && y > 202.0 && y < 216.0) {
            this.f_96541_.f_91074_.m_216990_(SoundEvents.f_11713_);
            this.menu = 0;
            this.page = 0;
            return true;
        }
        if (button == 0) {
            this.clickedX = (int)mouseX;
            this.clickedY = (int)mouseY;
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        double x = mouseX - (double)this.uiX;
        double y = mouseY - (double)this.uiY;
        int numberOfRows = (this.fishInArea.size() - 1) / 7 + 1;
        if (x > 168.0 && x < 191.0 && y > 121.0 && y < 128.0 && numberOfRows == 1 || x > 168.0 && x < 191.0 && y > 141.0 && y < 148.0 && numberOfRows == 2 || x > 168.0 && x < 191.0 && y > 161.0 && y < 168.0 && numberOfRows == 3 || x > 168.0 && x < 191.0 && y > 181.0 && y < 188.0 && numberOfRows == 4) {
            if (button == 0) {
                Config.SORT.set((Object)((Sort)((Object)Config.SORT.get())).next());
            }
            if (button == 1) {
                Config.SORT.set((Object)((Sort)((Object)Config.SORT.get())).previous());
            }
            Config.SORT.save();
            this.sortEntries();
        }
        if (x > 49.0 && x < 69.0 && y > 203.0 && y < 217.0 && (this.menu != 0 || this.page != 0)) {
            this.arrowPreviousPressed = true;
        }
        if (x > 336.0 && x < 356.0 && y > 202.0 && y < 216.0 && this.page <= this.entries.size() / 2 - 1) {
            this.arrowNextPressed = true;
        }
        if (x > 174.0 && x < 196.0 && y > 202.0 && y < 216.0) {
            this.arrowIndexPressed = true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        if (this.menu == -1) {
            Minecraft.m_91087_().m_91152_((Screen)new SettingsScreen(FishProperties.DEFAULT.withFish((Holder<Item>)((Holder)ModItems.AURORA.getHolder().get())), new ItemStack((ItemLike)ModItems.ROD.get())));
            return;
        }
        if (this.menu == 0) {
            if (this.page == 0) {
                this.renderImage(guiGraphics, BACKGROUND_INDEX_FIRST);
            } else {
                this.renderImage(guiGraphics, BACKGROUND_INDEX_SECOND);
            }
            this.renderIndex(guiGraphics, mouseX, mouseY);
        }
        if (this.menu == 1) {
            this.renderImage(guiGraphics, BACKGROUND_BASICS);
            this.renderTheBasics(guiGraphics, mouseX, mouseY);
        }
        if (this.menu == 2) {
            this.renderImage(guiGraphics, BACKGROUND_ENTRY);
            this.renderEntry(guiGraphics, mouseX, mouseY, 52, this.page * 2);
            this.renderEntry(guiGraphics, mouseX, mouseY, 212, this.page * 2 + 1);
        }
        double x = mouseX - this.uiX;
        double y = mouseY - this.uiY;
        if (this.menu != 0 || this.page != 0) {
            if (x > 49.0 && x < 69.0 && y > 203.0 && y < 217.0) {
                this.renderImage(guiGraphics, ARROW_PREVIOUS_HIGHLIGHT);
            }
            this.renderImage(guiGraphics, this.arrowPreviousPressed ? ARROW_PREVIOUS_PRESSED : ARROW_PREVIOUS);
            if (x > 174.0 && x < 196.0 && y > 202.0 && y < 216.0) {
                this.renderImage(guiGraphics, ARROW_INDEX_HIGHLIGHT);
            }
            this.renderImage(guiGraphics, this.arrowIndexPressed ? ARROW_INDEX_PRESSED : ARROW_INDEX);
        }
        if (this.page <= this.entries.size() / 2 - 1) {
            if (x > 336.0 && x < 356.0 && y > 202.0 && y < 216.0) {
                this.renderImage(guiGraphics, ARROW_NEXT_HIGHLIGHT);
            }
            this.renderImage(guiGraphics, this.arrowNextPressed ? ARROW_NEXT_PRESSED : ARROW_NEXT);
        }
        this.clickedX = 0;
        this.clickedY = 0;
    }

    private void renderHelpText(GuiGraphics guiGraphics) {
        MutableComponent comp;
        int i;
        for (i = 0; i < 40 && I18n.m_118936_((String)("gui.guide.page" + this.page + ".left." + i)); ++i) {
            comp = Tooltips.decodeTranslationKey("gui.guide.page" + this.page + ".left." + i).m_6881_().m_130948_(Style.f_131099_.m_178520_(6508608));
            guiGraphics.m_280614_(this.f_96547_, (Component)comp, this.uiX + 52, this.uiY + 10 * i + 13, -16777216, false);
        }
        for (i = 0; i < 40 && I18n.m_118936_((String)("gui.guide.page" + this.page + ".right." + i)); ++i) {
            comp = Tooltips.decodeTranslationKey("gui.guide.page" + this.page + ".right." + i).m_6881_().m_130948_(Style.f_131099_.m_178520_(6508608));
            guiGraphics.m_280614_(this.f_96547_, (Component)comp, this.uiX + 213, this.uiY + 10 * i + 13, -16777216, false);
        }
    }

    private void renderItemWithOutlineAndHover(GuiGraphics guiGraphics, ItemStack is, int x, int y, int mouseX, int mouseY) {
        this.renderItem(is, this.uiX + x, this.uiY + y, 1.0f);
        guiGraphics.m_280509_(this.uiX + x - 2, this.uiY + y - 2, this.uiX + x + 18, this.uiY + y + 18, -4938089);
        if (mouseX > this.uiX + x - 2 && mouseX < this.uiX + x - 2 + 20 && mouseY > this.uiY + y - 2 - 2 && mouseY < this.uiY + y - 2 + 20) {
            guiGraphics.m_280153_(this.f_96547_, is, mouseX, mouseY);
        }
    }

    private void renderSecrets(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        for (int i = 0; i < this.secretsTps.size(); ++i) {
            Item item;
            int rowSize = Math.min(6, this.secretsTps.size() - i / 6 * 6);
            int x = 70 - rowSize * 23 / 2;
            int xrender = x + i % 6 * 23;
            int y = i / 6 * 25;
            xrender += this.uiX + 223;
            y += this.uiY + 110;
            TrophyProperties tp = this.secretsTps.get(i);
            ItemStack is = new ItemStack(tp.fp().fish());
            if (!tp.customName().isEmpty()) {
                is.m_41714_((Component)Component.m_237113_((String)tp.customName()));
            }
            DataComponents.setTrophyProperties(is, tp);
            guiGraphics.m_280637_(xrender - 10, y - 2, 20, 20, -16777216);
            this.renderItem(is, xrender - 8, y, 1.0f);
            if (mouseX > xrender - 10 && mouseX < xrender + 10 && mouseY > y - 2 && mouseY < y + 18) {
                guiGraphics.m_280153_(this.f_96547_, is, mouseX, mouseY);
            }
            if (this.clickedX <= xrender - 10 || this.clickedX >= xrender + 10 || this.clickedY <= y - 2 || this.clickedY >= y + 18 || !((item = is.m_41720_()) instanceof NoteContainer)) continue;
            NoteContainer nc = (NoteContainer)item;
            Minecraft.m_91087_().m_91152_((Screen)new SecretNoteScreen(nc.note));
        }
    }

    private void renderTrophies(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        for (int i = 0; i < this.trophiesTps.size(); ++i) {
            ItemStack is;
            boolean isMouseOnTop;
            int rowSize = Math.min(6, this.trophiesTps.size() - i / 6 * 6);
            int x = 60 - rowSize * 23 / 2;
            int xrender = x + i % 6 * 23;
            int y = i / 6 * 25;
            TrophyProperties tp = this.trophiesTps.get(i);
            boolean bl = isMouseOnTop = mouseX > (xrender += this.uiX + 73) - 10 && mouseX < xrender + 10 && mouseY > (y += this.uiY + 120) - 2 && mouseY < y + 18;
            if (DataAttachments.get((Player)this.player).trophiesCaught().contains(tp)) {
                is = new ItemStack(tp.fp().fish());
                is.m_41714_((Component)Component.m_237113_((String)tp.customName()));
                DataComponents.setTrophyProperties(is, tp);
                if (isMouseOnTop) {
                    guiGraphics.m_280153_(this.f_96547_, is, mouseX, mouseY);
                }
            } else {
                if (isMouseOnTop) {
                    ArrayList<MutableComponent> list = new ArrayList<MutableComponent>(List.of(Component.m_237113_((String)"Requirements:")));
                    if (tp.all().total() != 0) {
                        list.add(Component.m_237119_().m_7220_(Tooltips.decodeTranslationKey("gui.guide.trophy.all.total")).m_130946_("[" + this.all.total() + "/" + tp.all().total() + "]"));
                    }
                    if (tp.all().unique() != 0) {
                        list.add(Component.m_237119_().m_7220_(Tooltips.decodeTranslationKey("gui.guide.trophy.all.unique")).m_130946_("[" + this.all.unique() + "/" + tp.all().unique() + "]"));
                    }
                    if (tp.common().total() != 0) {
                        list.add(Component.m_237119_().m_7220_(Tooltips.decodeTranslationKey("gui.guide.trophy.common.total")).m_130946_("[" + this.common.total() + "/" + tp.common().total() + "]"));
                    }
                    if (tp.common().unique() != 0) {
                        list.add(Component.m_237119_().m_7220_(Tooltips.decodeTranslationKey("gui.guide.trophy.common.unique")).m_130946_("[" + this.common.unique() + "/" + tp.common().unique() + "]"));
                    }
                    if (tp.uncommon().total() != 0) {
                        list.add(Component.m_237119_().m_7220_(Tooltips.decodeTranslationKey("gui.guide.trophy.uncommon.total")).m_130946_("[" + this.uncommon.total() + "/" + tp.uncommon().total() + "]"));
                    }
                    if (tp.uncommon().unique() != 0) {
                        list.add(Component.m_237119_().m_7220_(Tooltips.decodeTranslationKey("gui.guide.trophy.uncommon.unique")).m_130946_("[" + this.uncommon.unique() + "/" + tp.uncommon().unique() + "]"));
                    }
                    if (tp.rare().total() != 0) {
                        list.add(Component.m_237119_().m_7220_(Tooltips.decodeTranslationKey("gui.guide.trophy.rare.total")).m_130946_("[" + this.rare.total() + "/" + tp.rare().total() + "]"));
                    }
                    if (tp.rare().unique() != 0) {
                        list.add(Component.m_237119_().m_7220_(Tooltips.decodeTranslationKey("gui.guide.trophy.rare.unique")).m_130946_("[" + this.rare.unique() + "/" + tp.rare().unique() + "]"));
                    }
                    if (tp.epic().total() != 0) {
                        list.add(Component.m_237119_().m_7220_(Tooltips.decodeTranslationKey("gui.guide.trophy.epic.total")).m_130946_("[" + this.epic.total() + "/" + tp.epic().total() + "]"));
                    }
                    if (tp.epic().unique() != 0) {
                        list.add(Component.m_237119_().m_7220_(Tooltips.decodeTranslationKey("gui.guide.trophy.epic.unique")).m_130946_("[" + this.epic.unique() + "/" + tp.epic().unique() + "]"));
                    }
                    if (tp.legendary().total() != 0) {
                        list.add(Component.m_237119_().m_7220_(Tooltips.decodeTranslationKey("gui.guide.trophy.legendary.total")).m_130946_("[" + this.legendary.total() + "/" + tp.legendary().total() + "]"));
                    }
                    if (tp.legendary().unique() != 0) {
                        list.add(Component.m_237119_().m_7220_(Tooltips.decodeTranslationKey("gui.guide.trophy.legendary.unique")).m_130946_("[" + this.legendary.unique() + "/" + tp.legendary().unique() + "]"));
                    }
                    guiGraphics.m_280677_(this.f_96547_, list, Optional.empty(), mouseX, mouseY);
                }
                is = new ItemStack((ItemLike)ModItems.MISSINGNO.get());
            }
            guiGraphics.m_280637_(xrender - 10, y - 2, 20, 20, -16777216);
            this.renderItem(is, xrender - 8, y, 1.0f);
        }
    }

    private void renderTheBasics(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        this.renderHelpText(guiGraphics);
        if (this.page == 0) {
            this.renderImage(guiGraphics, HELP_PAGE_1);
            this.renderItem(this.basics, this.uiX + 166, this.uiY + 39, 1.0f);
            guiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)"gui.guide.basics"), this.uiX + 80, this.uiY + 45, -16777216, false);
        }
        if (this.page == 1) {
            this.renderImage(guiGraphics, HELP_PAGE_2);
            this.renderItem(this.treasures, this.uiX + 166, this.uiY + 39, 1.0f);
            guiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)"gui.guide.treasures"), this.uiX + 80, this.uiY + 45, -16777216, false);
        }
        if (this.page == 2) {
            this.renderImage(guiGraphics, HELP_PAGE_3);
            this.renderItem(this.ironHook, this.uiX + 166, this.uiY + 39, 1.0f);
            guiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)"gui.guide.hooks"), this.uiX + 80, this.uiY + 45, -16777216, false);
            this.renderItemWithOutlineAndHover(guiGraphics, this.ironHook, 56, 157, mouseX, mouseY);
            this.renderItemWithOutlineAndHover(guiGraphics, this.goldHook, 84, 157, mouseX, mouseY);
            this.renderItemWithOutlineAndHover(guiGraphics, this.shinyHook, 112, 157, mouseX, mouseY);
            this.renderItemWithOutlineAndHover(guiGraphics, this.crystalHook, 140, 157, mouseX, mouseY);
            this.renderItemWithOutlineAndHover(guiGraphics, this.heavyHook, 168, 157, mouseX, mouseY);
            this.renderItemWithOutlineAndHover(guiGraphics, this.mossyHook, 67, 182, mouseX, mouseY);
            this.renderItemWithOutlineAndHover(guiGraphics, this.splitHook, 99, 182, mouseX, mouseY);
            this.renderItemWithOutlineAndHover(guiGraphics, this.stoneHook, 131, 182, mouseX, mouseY);
            this.renderItemWithOutlineAndHover(guiGraphics, this.stabHook, 163, 182, mouseX, mouseY);
            this.renderItem(this.frugalBobber, this.uiX + 321, this.uiY + 39, 1.0f);
            guiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)"gui.guide.bobbers"), this.uiX + 228, this.uiY + 45, -16777216, false);
            this.renderItemWithOutlineAndHover(guiGraphics, this.creeperBobber, 220, 157, mouseX, mouseY);
            this.renderItemWithOutlineAndHover(guiGraphics, this.glitterBobber, 248, 157, mouseX, mouseY);
            this.renderItemWithOutlineAndHover(guiGraphics, this.colorfulBobber, 276, 157, mouseX, mouseY);
            this.renderItemWithOutlineAndHover(guiGraphics, this.frugalBobber, 304, 157, mouseX, mouseY);
            this.renderItemWithOutlineAndHover(guiGraphics, this.clearBobber, 332, 157, mouseX, mouseY);
            this.renderItemWithOutlineAndHover(guiGraphics, this.steadyBobber, 233, 182, mouseX, mouseY);
            this.renderItemWithOutlineAndHover(guiGraphics, this.impatientBobber, 265, 182, mouseX, mouseY);
            this.renderItemWithOutlineAndHover(guiGraphics, this.frogBobber, 297, 182, mouseX, mouseY);
            this.renderItemWithOutlineAndHover(guiGraphics, this.kimbeBobber, 329, 182, mouseX, mouseY);
        }
        if (this.page == 3) {
            this.renderImage(guiGraphics, HELP_PAGE_4);
            this.renderItem(this.cherryBait, this.uiX + 166, this.uiY + 39, 1.0f);
            guiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)"gui.guide.baits"), this.uiX + 80, this.uiY + 45, -16777216, false);
            this.renderItemWithOutlineAndHover(guiGraphics, this.cherryBait, 56, 157, mouseX, mouseY);
            this.renderItemWithOutlineAndHover(guiGraphics, this.lushBait, 94, 157, mouseX, mouseY);
            this.renderItemWithOutlineAndHover(guiGraphics, this.dripstoneBait, 132, 157, mouseX, mouseY);
            this.renderItemWithOutlineAndHover(guiGraphics, this.murkwaterBait, 170, 157, mouseX, mouseY);
            this.renderItemWithOutlineAndHover(guiGraphics, this.sculkBait, 76, 182, mouseX, mouseY);
            this.renderItemWithOutlineAndHover(guiGraphics, this.legendaryBait, 113, 182, mouseX, mouseY);
            this.renderItemWithOutlineAndHover(guiGraphics, this.meteorologicalBait, 150, 182, mouseX, mouseY);
            this.renderItem(this.fishSpotter, this.uiX + 321, this.uiY + 39, 1.0f);
            guiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)"gui.guide.gadgets"), this.uiX + 228, this.uiY + 45, -16777216, false);
            this.renderItemWithOutlineAndHover(guiGraphics, this.fishSpotter, 276, 170, mouseX, mouseY);
        }
        if (this.page == 4) {
            this.renderImage(guiGraphics, HELP_PAGE_5);
            this.renderItem(this.trophies, this.uiX + 166, this.uiY + 39, 1.0f);
            guiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)"gui.guide.trophies"), this.uiX + 80, this.uiY + 45, -16777216, false);
            this.renderTrophies(guiGraphics, mouseX, mouseY);
            this.renderItem(this.secrets, this.uiX + 321, this.uiY + 39, 1.0f);
            guiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)"gui.guide.secrets"), this.uiX + 228, this.uiY + 45, -16777216, false);
            this.renderSecrets(guiGraphics, mouseX, mouseY);
        }
    }

    private void renderTheBasicsIndex(GuiGraphics guiGraphics, ItemStack is, int x, int y, int mouseX, int mouseY, String translationKey, int pageNr) {
        this.renderItem(is, x, y, 1.0f);
        if (mouseX > x - 2 && mouseX < x + 17 && mouseY > y - 2 && mouseY < y + 17) {
            guiGraphics.m_280557_(this.f_96547_, (Component)Component.m_237115_((String)translationKey), mouseX, mouseY);
        }
        if (this.clickedX > x - 2 && this.clickedX < x + 17 && this.clickedY > y - 2 && this.clickedY < y + 17) {
            this.f_96541_.f_91074_.m_216990_(SoundEvents.f_11713_);
            this.menu = 1;
            this.page = pageNr;
            if (pageNr == 5) {
                this.menu = -1;
            }
        }
    }

    private void renderIndex(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        int topLeftCorner = this.uiX + 53;
        int y = this.uiY + 47;
        int columnNumber = -1;
        int rowNumber = -1;
        int semiPageNumber = -this.page * 2;
        this.hasNextEntryPage = false;
        if (this.page == 0) {
            int auxX = topLeftCorner + 2;
            this.renderTheBasicsIndex(guiGraphics, this.basics, auxX, y, mouseX, mouseY, "gui.guide.index.basics", 0);
            this.renderTheBasicsIndex(guiGraphics, this.ironHook, auxX += 20, y, mouseX, mouseY, "gui.guide.index.hooks", 2);
            this.renderTheBasicsIndex(guiGraphics, this.frugalBobber, auxX += 20, y, mouseX, mouseY, "gui.guide.index.bobbers", 2);
            this.renderTheBasicsIndex(guiGraphics, this.cherryBait, auxX += 20, y, mouseX, mouseY, "gui.guide.index.baits", 3);
            this.renderTheBasicsIndex(guiGraphics, this.fishSpotter, auxX += 20, y, mouseX, mouseY, "gui.guide.index.gadgets", 3);
            this.renderTheBasicsIndex(guiGraphics, this.trophies, auxX += 20, y, mouseX, mouseY, "gui.guide.index.trophies", 4);
            this.renderTheBasicsIndex(guiGraphics, this.settings, auxX += 20, y, mouseX, mouseY, "gui.guide.index.settings", 5);
        }
        rowNumber = 2;
        for (FishProperties fp : this.fishInArea) {
            if (++columnNumber > 6) {
                ++rowNumber;
                columnNumber = 0;
            }
            if (rowNumber > 7) {
                ++semiPageNumber;
                rowNumber = 0;
            }
            if (semiPageNumber > 1) break;
            if (semiPageNumber < 0) continue;
            this.renderFishIndex(guiGraphics, topLeftCorner + columnNumber * 20 + semiPageNumber * 205, y - 2 + rowNumber * 20, mouseX, mouseY, fp, -3752529);
        }
        if (this.page == 0) {
            if (this.fishInArea.size() > 6) {
                this.renderImage(guiGraphics, FISHES_IN_AREA_TOP_RIGHT_DECORATION);
            }
            int numberOfRows = (this.fishInArea.size() - 1) / 7 + 1;
            int x = mouseX - this.uiX;
            int y2 = mouseY - this.uiY;
            if (x > 168 && x < 191 && y2 > 121 && y2 < 128 && numberOfRows == 1 || x > 168 && x < 191 && y2 > 141 && y2 < 148 && numberOfRows == 2 || x > 168 && x < 191 && y2 > 161 && y2 < 168 && numberOfRows == 3 || x > 168 && x < 191 && y2 > 181 && y2 < 188 && numberOfRows == 4) {
                guiGraphics.m_280557_(this.f_96547_, (Component)Component.m_237115_((String)((Sort)((Object)Config.SORT.get())).getTranslationKey()), mouseX, mouseY);
            }
            if (!this.fishInArea.isEmpty()) {
                this.renderImage(guiGraphics, FISHES_IN_AREA_BOTTOM_LEFT_DECORATION, 0, (numberOfRows - 1) * 20);
            }
            if (columnNumber < 4) {
                this.renderImage(guiGraphics, FISHES_IN_AREA_FISH_DECORATION, 0, (numberOfRows - 1) * 20);
            }
            if (numberOfRows <= 1) {
                this.renderImage(guiGraphics, ALL_FISHES_4_ROW, 0, 0);
            }
            if (numberOfRows == 2) {
                this.renderImage(guiGraphics, ALL_FISHES_3_ROW, 0, 0);
            }
            if (numberOfRows == 3) {
                this.renderImage(guiGraphics, ALL_FISHES_2_ROW, 0, 0);
            }
            if (numberOfRows == 4) {
                this.renderImage(guiGraphics, ALL_FISHES_1_ROW, 0, 0);
            }
        }
        columnNumber = -1;
        if (++rowNumber > 6) {
            rowNumber = 0;
            ++semiPageNumber;
        }
        ++rowNumber;
        for (FishProperties fp : this.entries) {
            if (++columnNumber > 6) {
                ++rowNumber;
                columnNumber = 0;
            }
            if (rowNumber > 7) {
                ++semiPageNumber;
                rowNumber = 0;
            }
            if (semiPageNumber > 1) break;
            if (semiPageNumber < 0) continue;
            this.renderFishIndex(guiGraphics, topLeftCorner + columnNumber * 20 + semiPageNumber * 159, y + 4 + rowNumber * 20, mouseX, mouseY, fp, this.page == 0 && semiPageNumber == 0 ? -1777448 : -3752529);
        }
        if (semiPageNumber > 1) {
            this.hasNextEntryPage = true;
        }
    }

    private void renderFishIndex(GuiGraphics guiGraphics, int xOffset, int yOffset, int mouseX, int mouseY, FishProperties fp, int backgroundFillColor) {
        List<FishCaughtCounter> fishCounterList = DataAttachments.get((Player)this.player).fishesCaught();
        ItemStack is = new ItemStack(fp.fish());
        int caught = 0;
        for (FishCaughtCounter f : fishCounterList) {
            if (!fp.equals(f.fp())) continue;
            caught = f.count();
            break;
        }
        if (this.clickedX > xOffset - 3 && this.clickedX < xOffset + 21 - 3 && this.clickedY > yOffset - 3 && this.clickedY < yOffset + 21 - 3) {
            this.f_96541_.f_91074_.m_216990_(SoundEvents.f_11713_);
            this.menu = 2;
            this.page = this.entries.indexOf(fp) / 2;
        }
        guiGraphics.m_280509_(xOffset - 1, yOffset - 1, xOffset + 17, yOffset + 17, backgroundFillColor);
        switch (fp.rarity()) {
            case COMMON: {
                guiGraphics.m_280246_(1.0f, 1.0f, 1.0f, 0.0f);
                break;
            }
            case UNCOMMON: {
                guiGraphics.m_280246_(0.7f, 1.0f, 0.7f, 1.0f);
                break;
            }
            case RARE: {
                guiGraphics.m_280246_(0.2f, 0.4f, 0.7f, 0.7f);
                break;
            }
            case EPIC: {
                guiGraphics.m_280246_(1.0f, 0.0f, 1.0f, 0.5f);
                break;
            }
            case LEGENDARY: {
                Color color = Color.getHSBColor(Tooltips.hue * 2.0f, 1.0f, 1.0f);
                float r = (float)color.getRed() / 255.0f;
                float g = (float)color.getGreen() / 255.0f;
                float b = (float)color.getBlue() / 255.0f;
                guiGraphics.m_280246_(r, g, b, 0.7f);
            }
        }
        RenderSystem.enableBlend();
        guiGraphics.m_280163_(GLOW, xOffset - 1, yOffset - 1, 0.0f, 0.0f, 18, 18, 18, 18);
        RenderSystem.disableBlend();
        guiGraphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        if (caught != 0) {
            this.renderItem(is, xOffset, yOffset, 1.0f);
        } else {
            this.renderItem(new ItemStack((ItemLike)ModItems.MISSINGNO.get()), xOffset, yOffset, 1.0f);
        }
        for (FishProperties fpNotif : DataAttachments.get((Player)this.player).fishNotifications()) {
            if (!fp.equals(fpNotif)) continue;
            guiGraphics.m_280163_(STAR, xOffset + 10, yOffset + 7, 0.0f, 0.0f, 10, 10, 10, 10);
        }
        if (mouseX > xOffset - 3 && mouseX < xOffset + 21 - 3 && mouseY > yOffset - 3 && mouseY < yOffset + 21 - 3) {
            ArrayList<Object> components = new ArrayList<Object>();
            if (caught == 0) {
                components.add(Component.m_237115_((String)"gui.guide.not_caught_fish_name"));
                components.add(Component.m_237115_((String)"gui.guide.not_caught_yet").m_130948_(Style.f_131099_.m_178520_(10700086)));
                components.add(Tooltips.decodeTranslationKey("gui.guide.rarity." + fp.rarity().m_7912_()));
            } else {
                if (fp.customName().isEmpty()) {
                    components.add(Component.m_237115_((String)((Item)fp.fish().m_203334_()).m_5524_()));
                } else {
                    components.add(Component.m_237115_((String)("item.starcatcher." + fp.customName())));
                }
                components.add(Component.m_237115_((String)"gui.guide.caught").m_7220_((Component)Component.m_237113_((String)("[" + caught + "]"))).m_130948_(Style.f_131099_.m_178520_(4224300)));
            }
            guiGraphics.m_280677_(this.f_96547_, components, Optional.empty(), mouseX, mouseY);
        }
    }

    private void renderEntry(GuiGraphics guiGraphics, int mouseX, int mouseY, int xOffset, int entry) {
        MutableComponent comp;
        MutableComponent hardCodedTranslations;
        String aboveBelow;
        MutableComponent comp2;
        MutableComponent comp3;
        if (this.level == null) {
            this.level = this.getMinecraft().f_91073_;
        }
        double x = mouseX - this.uiX;
        double y = mouseY - this.uiY;
        if (this.entries.size() <= entry) {
            return;
        }
        ItemStack is = new ItemStack(this.entries.get(entry).fish());
        FishProperties fp = this.entries.get(entry);
        if (!this.fpsSeen.contains(fp)) {
            this.fpsSeen.add(fp);
        }
        FishCaughtCounter fcc = null;
        for (FishCaughtCounter fccAll : this.fishCaughtCounterList) {
            if (!fp.equals(fccAll.fp())) continue;
            fcc = fccAll;
            break;
        }
        guiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)"gui.guide.caught"), this.uiX + xOffset + 73, this.uiY + 68, 10258812, false);
        if (fcc == null) {
            guiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)"gui.guide.not_caught"), this.uiX + xOffset + 73, this.uiY + 78, 10258812, false);
        } else {
            MutableComponent c = Component.m_237113_((String)("[" + fcc.count() + "]")).m_130948_(Style.f_131099_.m_178520_(6508608));
            guiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237119_().m_7220_((Component)c), this.uiX + xOffset + 73, this.uiY + 78, 0, false);
        }
        guiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)"gui.guide.rarity"), this.uiX + xOffset + 73, this.uiY + 90, 10258812, false);
        guiGraphics.m_280614_(this.f_96547_, Tooltips.decodeTranslationKey("gui.guide.rarity." + fp.rarity().m_7912_()), this.uiX + xOffset + 73, this.uiY + 100, 0, false);
        if (fcc == null) {
            guiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)"gui.guide.not_caught_fish_name"), this.uiX + xOffset + 30, this.uiY + 36, 6508608, false);
        } else {
            MutableComponent compName = fp.customName().isEmpty() ? Component.m_237115_((String)((Item)fp.fish().m_203334_()).m_5524_()) : Component.m_237115_((String)("item.starcatcher." + fp.customName()));
            if (xOffset > 200) {
                guiGraphics.m_280614_(this.f_96547_, (Component)compName, this.uiX + xOffset + 15, this.uiY + 36, 6508608, false);
            } else {
                guiGraphics.m_280614_(this.f_96547_, (Component)compName, this.uiX + xOffset + 30, this.uiY + 36, 6508608, false);
            }
        }
        if (fcc != null) {
            this.renderItem(is, this.uiX + xOffset + 26, this.uiY + 70);
        }
        switch (fp.rarity()) {
            case COMMON: {
                guiGraphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
                break;
            }
            case UNCOMMON: {
                guiGraphics.m_280246_(0.7f, 1.0f, 0.7f, 1.0f);
                break;
            }
            case RARE: {
                guiGraphics.m_280246_(0.2f, 0.4f, 0.7f, 0.7f);
                break;
            }
            case EPIC: {
                guiGraphics.m_280246_(1.0f, 0.0f, 1.0f, 0.5f);
                break;
            }
            case LEGENDARY: {
                Color color = Color.getHSBColor(Tooltips.hue, 1.0f, 1.0f);
                float r = (float)color.getRed() / 255.0f;
                float g = (float)color.getGreen() / 255.0f;
                float b = (float)color.getBlue() / 255.0f;
                guiGraphics.m_280246_(r, g, b, 0.7f);
            }
        }
        RenderSystem.enableBlend();
        if (fcc != null) {
            guiGraphics.m_280163_(GLOW, this.uiX + xOffset + 10, this.uiY + 55, 0.0f, 0.0f, 48, 48, 48, 48);
        }
        RenderSystem.disableBlend();
        guiGraphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        if (DataAttachments.get((Player)this.player).fishNotifications().contains(fp)) {
            this.renderImage(guiGraphics, NEW_FISH, xOffset - 52, 0);
        }
        if (mouseX > this.uiX + xOffset + 0 && mouseX < this.uiX + xOffset + 65 && mouseY > this.uiY + 45 && mouseY < this.uiY + 110 && fcc != null) {
            guiGraphics.m_280153_(this.f_96547_, is, mouseX, mouseY);
        }
        if (mouseX > this.uiX + xOffset + 66 && mouseX < this.uiX + xOffset + 140 && mouseY > this.uiY + 57 && mouseY < this.uiY + 110 && fcc != null) {
            ArrayList<MutableComponent> components = new ArrayList<MutableComponent>();
            float averageTicks = (float)((int)(fcc.averageTicks() / 20.0f * 100.0f)) / 100.0f;
            SettingsScreen.Units unit = (SettingsScreen.Units)((Object)Config.UNIT.get());
            String size = unit.getSizeAsString(fcc.size());
            String weight = unit.getWeightAsString(fcc.weight());
            components.add(Component.m_237113_((String)"Fastest Catch: ").m_7220_((Component)Component.m_237113_((String)((float)fcc.fastestTicks() / 20.0f + "s")).m_130940_(ChatFormatting.BOLD)));
            components.add(Component.m_237113_((String)"Average Catch: ").m_7220_((Component)Component.m_237113_((String)(averageTicks + "s")).m_130940_(ChatFormatting.BOLD)));
            components.add(Component.m_237113_((String)""));
            components.add(Component.m_237113_((String)"Biggest Catch: ").m_7220_((Component)Component.m_237113_((String)size).m_130940_(ChatFormatting.BOLD)));
            components.add(Component.m_237113_((String)"Heaviest Catch: ").m_7220_((Component)Component.m_237113_((String)weight).m_130940_(ChatFormatting.BOLD)));
            guiGraphics.m_280677_(this.f_96547_, components, Optional.empty(), mouseX, mouseY);
        }
        int yOffset = 121;
        if (fp.wr().dims().isEmpty()) {
            comp3 = Component.m_237115_((String)"gui.guide.no_restriction");
        } else if (fp.wr().dims().size() == 1) {
            comp3 = Component.m_237115_((String)("dimension." + fp.wr().dims().get(0).m_214298_()));
        } else {
            comp3 = Component.m_237115_((String)"gui.guide.hover");
            if (x > (double)xOffset && x < (double)(xOffset + 100) && y > (double)(yOffset - 2) && y < (double)(yOffset + 10)) {
                ArrayList<MutableComponent> c = new ArrayList<MutableComponent>();
                c.add(Component.m_237115_((String)"gui.guide.dimensions"));
                for (int i = 0; i < fp.wr().dims().size(); ++i) {
                    c.add(Component.m_237115_((String)("dimension." + fp.wr().dims().get(i).m_214298_())));
                }
                guiGraphics.m_280677_(this.f_96547_, c, Optional.empty(), mouseX, mouseY);
            }
        }
        comp3 = fp.wr().dims().isEmpty() ? comp3.m_6881_().m_130948_(Style.f_131099_.m_178520_(4224300)) : (fp.wr().dims().contains(this.level.m_46472_().m_135782_()) ? comp3.m_6881_().m_130948_(Style.f_131099_.m_178520_(4224300)) : comp3.m_6881_().m_130948_(Style.f_131099_.m_178520_(10700086)));
        MutableComponent start = Component.m_237115_((String)"gui.guide.dimension");
        guiGraphics.m_280614_(this.f_96547_, (Component)start.m_6881_().m_7220_((Component)comp3), this.uiX + xOffset, this.uiY + yOffset, 6508608, false);
        if (!fp.wr().dimsBlacklist().isEmpty()) {
            guiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237113_((String)"[!]").m_130948_(Style.f_131099_.m_178520_(10700086)), this.uiX + xOffset + 160, this.uiY + yOffset, 0, false);
            if (x > (double)(xOffset + 155) && x < (double)(xOffset + 175) && y > (double)(yOffset - 4) && y < (double)(yOffset + 12)) {
                ArrayList<MutableComponent> c = new ArrayList<MutableComponent>();
                c.add(Component.m_237115_((String)"gui.guide.blacklisted_dimensions"));
                for (int i = 0; i < fp.wr().dimsBlacklist().size(); ++i) {
                    c.add(Component.m_237113_((String)fp.wr().dimsBlacklist().get(i).toString()));
                }
                guiGraphics.m_280677_(this.f_96547_, c, Optional.empty(), mouseX, mouseY);
            }
        }
        yOffset += 12;
        List<ResourceLocation> biomesBL = FishProperties.getBiomesBlacklistAsList(fp, (Level)this.level);
        List<ResourceLocation> biomes = FishProperties.getBiomesAsList(fp, (Level)this.level);
        if (biomes.isEmpty()) {
            comp2 = Component.m_237115_((String)"gui.guide.no_restriction");
        } else if (biomes.size() == 1) {
            comp2 = Component.m_237115_((String)("biome." + biomes.get(0).m_214298_()));
        } else if (fp.wr().biomesTags().size() == 1) {
            comp2 = Component.m_237115_((String)("tag." + fp.wr().biomesTags().get(0).m_214298_()));
            if (x > (double)xOffset && x < (double)(xOffset + 100) && y > (double)(yOffset - 2) && y < (double)(yOffset + 10)) {
                c = new ArrayList();
                if (!fp.wr().biomesTags().isEmpty()) {
                    c.add(Component.m_237115_((String)"gui.guide.biome_tags").m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(true))));
                    for (ResourceLocation rl : fp.wr().biomesTags()) {
                        c.add(Component.m_237115_((String)("tag." + rl.m_214298_())));
                    }
                    c.add(Component.m_237119_());
                }
                c.add(Component.m_237115_((String)"gui.guide.biomes").m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(true))));
                for (ResourceLocation rl : biomes) {
                    c.add(Component.m_237115_((String)("biome." + rl.m_214298_())));
                }
                guiGraphics.m_280677_(this.f_96547_, c, Optional.empty(), mouseX, mouseY);
            }
        } else {
            comp2 = Component.m_237115_((String)"gui.guide.hover");
            if (x > (double)xOffset && x < (double)(xOffset + 100) && y > (double)(yOffset - 2) && y < (double)(yOffset + 10)) {
                c = new ArrayList<MutableComponent>();
                c.add(Component.m_237115_((String)"gui.guide.biome"));
                for (ResourceLocation rl : biomes) {
                    c.add(Component.m_237115_((String)("biome." + rl.m_214298_())));
                }
                guiGraphics.m_280677_(this.f_96547_, c, Optional.empty(), mouseX, mouseY);
            }
        }
        ResourceLocation rl = ResourceLocation.parse((String)((ResourceKey)this.level.m_204166_(Minecraft.m_91087_().f_91074_.m_20183_()).m_203543_().get()).m_135782_().toString());
        comp2 = comp2.m_6881_().m_130948_(Style.f_131099_.m_178520_(4224300));
        if (!biomes.contains(rl) && !biomes.isEmpty()) {
            comp2 = comp2.m_6881_().m_130948_(Style.f_131099_.m_178520_(10700086));
        }
        if (biomesBL.contains(rl)) {
            comp2 = comp2.m_6881_().m_130948_(Style.f_131099_.m_178520_(10700086));
        }
        MutableComponent start2 = Component.m_237115_((String)"gui.guide.biome");
        guiGraphics.m_280614_(this.f_96547_, (Component)start2.m_6881_().m_7220_((Component)comp2), this.uiX + xOffset, this.uiY + yOffset, 6508608, false);
        if (!biomesBL.isEmpty()) {
            guiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237113_((String)"[!]").m_130948_(Style.f_131099_.m_178520_(10700086)), this.uiX + xOffset + 130, this.uiY + yOffset - 1, 0, false);
            if (x > (double)(xOffset + 129) && x < (double)(xOffset + 140) && y > (double)(yOffset - 3) && y < (double)(yOffset + 8)) {
                ArrayList<MutableComponent> c = new ArrayList<MutableComponent>();
                if (!fp.wr().biomesBlacklistTags().isEmpty()) {
                    c.add(Component.m_237115_((String)"gui.guide.blacklisted_biome_tags").m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(true))));
                    for (ResourceLocation rl2 : fp.wr().biomesBlacklistTags()) {
                        c.add(Component.m_237115_((String)("tag." + rl2.m_214298_())));
                    }
                    c.add(Component.m_237119_());
                }
                c.add(Component.m_237115_((String)"gui.guide.blacklisted_biomes").m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(true))));
                for (ResourceLocation rl2 : biomesBL) {
                    c.add(Component.m_237115_((String)("biome." + rl2.m_214298_())));
                }
                guiGraphics.m_280677_(this.f_96547_, c, Optional.empty(), mouseX, mouseY);
            }
        }
        yOffset += 12;
        if (fp.br().correctBait().isEmpty()) {
            guiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)"gui.guide.bait").m_7220_((Component)Component.m_237115_((String)"gui.guide.no_restriction")), this.uiX + xOffset, this.uiY + yOffset, 6508608, false);
        } else {
            ItemStack bait = new ItemStack((ItemLike)BuiltInRegistries.f_257033_.m_7745_(fp.br().correctBait().get(0)));
            int bonus = fp.br().correctBaitChanceAdded() / fp.baseChance() * 100;
            MutableComponent extra = Component.m_237113_((String)(" (+" + bonus + "%)"));
            if (bait.m_150930_((Item)ModItems.LEGENDARY_BAIT.get())) {
                guiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)"gui.guide.bait").m_7220_(Tooltips.RGBEachLetter(I18n.m_118938_((String)bait.m_41778_(), (Object[])new Object[0]))).m_7220_((Component)extra), this.uiX + xOffset, this.uiY + yOffset, 6508608, false);
            } else {
                guiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)"gui.guide.bait").m_7220_((Component)Component.m_237115_((String)bait.m_41778_())).m_7220_((Component)extra), this.uiX + xOffset, this.uiY + yOffset, 6508608, false);
            }
            if (x > (double)xOffset && x < (double)(xOffset + 100) && y > (double)(yOffset - 2) && y < (double)(yOffset + 10)) {
                guiGraphics.m_280153_(this.f_96547_, bait, mouseX, mouseY);
            }
        }
        yOffset += 12;
        if (fp.weather() == FishProperties.Weather.ALL) {
            comp2 = Component.m_237115_((String)"gui.guide.no_restriction").m_130948_(Style.f_131099_.m_178520_(6508608));
        } else {
            comp2 = Component.m_237115_((String)"gui.guide.no_restriction");
            if (fp.weather() == FishProperties.Weather.RAIN) {
                comp2 = (double)this.level.m_46722_(0.0f) > 0.5 ? Component.m_237115_((String)"gui.guide.raining").m_130948_(Style.f_131099_.m_178520_(4224300)) : Component.m_237115_((String)"gui.guide.raining").m_130948_(Style.f_131099_.m_178520_(10700086));
            }
            if (fp.weather() == FishProperties.Weather.THUNDER) {
                comp2 = (double)this.level.m_46661_(0.0f) > 0.5 ? Component.m_237115_((String)"gui.guide.thundering").m_130948_(Style.f_131099_.m_178520_(4224300)) : Component.m_237115_((String)"gui.guide.thundering").m_130948_(Style.f_131099_.m_178520_(10700086));
            }
            if (fp.weather() == FishProperties.Weather.CLEAR) {
                comp2 = (double)this.level.m_46722_(0.0f) > 0.5 || (double)this.level.m_46661_(0.0f) > 0.5 ? Component.m_237115_((String)"gui.guide.clear").m_130948_(Style.f_131099_.m_178520_(10700086)) : Component.m_237115_((String)"gui.guide.clear").m_130948_(Style.f_131099_.m_178520_(4224300));
            }
        }
        MutableComponent start3 = Component.m_237115_((String)"gui.guide.weather");
        guiGraphics.m_280614_(this.f_96547_, (Component)start3.m_6881_().m_7220_((Component)comp2), this.uiX + xOffset, this.uiY + yOffset, 6508608, false);
        yOffset += 12;
        if (fp.daytime() == FishProperties.Daytime.ALL) {
            comp2 = Component.m_237115_((String)"gui.guide.no_restriction").m_130948_(Style.f_131099_.m_178520_(6508608));
        } else {
            long time = this.level.m_46468_() % 24000L;
            comp2 = switch (fp.daytime()) {
                case FishProperties.Daytime.DAY -> {
                    if (time <= 23000L && time >= 12700L) {
                        yield Component.m_237115_((String)"gui.guide.day").m_130948_(Style.f_131099_.m_178520_(10700086));
                    }
                    yield Component.m_237115_((String)"gui.guide.day").m_130948_(Style.f_131099_.m_178520_(4224300));
                }
                case FishProperties.Daytime.NOON -> {
                    if (time <= 3500L || time >= 8500L) {
                        yield Component.m_237115_((String)"gui.guide.noon").m_130948_(Style.f_131099_.m_178520_(10700086));
                    }
                    yield Component.m_237115_((String)"gui.guide.noon").m_130948_(Style.f_131099_.m_178520_(4224300));
                }
                case FishProperties.Daytime.NIGHT -> {
                    if (time >= 23000L || time <= 12700L) {
                        yield Component.m_237115_((String)"gui.guide.night").m_130948_(Style.f_131099_.m_178520_(10700086));
                    }
                    yield Component.m_237115_((String)"gui.guide.night").m_130948_(Style.f_131099_.m_178520_(4224300));
                }
                case FishProperties.Daytime.MIDNIGHT -> {
                    if (time <= 16500L || time >= 19500L) {
                        yield Component.m_237115_((String)"gui.guide.midnight").m_130948_(Style.f_131099_.m_178520_(10700086));
                    }
                    yield Component.m_237115_((String)"gui.guide.midnight").m_130948_(Style.f_131099_.m_178520_(4224300));
                }
                default -> Component.m_237119_();
            };
        }
        start = Component.m_237115_((String)"gui.guide.daytime");
        guiGraphics.m_280614_(this.f_96547_, (Component)start.m_6881_().m_7220_((Component)comp2), this.uiX + xOffset, this.uiY + yOffset, 6508608, false);
        yOffset += 12;
        int above = fp.wr().mustBeCaughtAboveY();
        int below = fp.wr().mustBeCaughtBelowY();
        switch (aboveBelow = above + ", " + below) {
            case "100, 2147483647": {
                MutableComponent mutableComponent = Component.m_237115_((String)"gui.guide.mountain");
                break;
            }
            case "50, 100": 
            case "50, 2147483647": {
                MutableComponent mutableComponent = Component.m_237115_((String)"gui.guide.surface");
                break;
            }
            case "-2147483648, 50": {
                MutableComponent mutableComponent = Component.m_237115_((String)"gui.guide.underground");
                break;
            }
            case "0, 50": {
                MutableComponent mutableComponent = Component.m_237115_((String)"gui.guide.caves");
                break;
            }
            case "-2147483648, 0": {
                MutableComponent mutableComponent = Component.m_237115_((String)"gui.guide.deepslate");
                break;
            }
            case "-2147483648, 2147483647": {
                MutableComponent mutableComponent = Component.m_237115_((String)"gui.guide.no_restriction");
                break;
            }
            default: {
                MutableComponent mutableComponent = hardCodedTranslations = Component.m_237113_((String)("> " + above + ", < " + below));
            }
        }
        if (this.player.m_20186_() > (double)above && this.player.m_20186_() < (double)below) {
            hardCodedTranslations.m_130948_(Style.f_131099_.m_178520_(4224300));
        } else {
            hardCodedTranslations.m_130948_(Style.f_131099_.m_178520_(10700086));
        }
        ArrayList<MutableComponent> hoverTooltip = new ArrayList<MutableComponent>(List.of());
        if (above > Integer.MIN_VALUE) {
            hoverTooltip.add(Component.m_237115_((String)"gui.guide.above").m_130946_("" + above));
        }
        if (below < Integer.MAX_VALUE) {
            hoverTooltip.add(Component.m_237115_((String)"gui.guide.below").m_130946_("" + below));
        }
        if (x > (double)xOffset && x < (double)(xOffset + 140) && y > (double)(yOffset - 2) && y < (double)(yOffset + 10)) {
            guiGraphics.m_280677_(this.f_96547_, hoverTooltip, Optional.empty(), mouseX, mouseY);
        }
        guiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)"gui.guide.elevation").m_7220_((Component)hardCodedTranslations), this.uiX + xOffset, this.uiY + yOffset, 6508608, false);
        yOffset += 12;
        List<ResourceLocation> fluids = fp.wr().fluids();
        if (fluids.size() == 1) {
            comp = Component.m_237115_((String)("block." + fluids.get(0).m_214298_()));
        } else {
            comp = Component.m_237115_((String)"gui.guide.hover");
            if (x > (double)xOffset && x < (double)(xOffset + 100) && y > (double)(yOffset - 2) && y < (double)(yOffset + 10)) {
                ArrayList<MutableComponent> c = new ArrayList<MutableComponent>();
                c.add(Component.m_237115_((String)"gui.guide.fluid"));
                for (ResourceLocation rl3 : fluids) {
                    c.add(Component.m_237115_((String)("block." + rl3.m_214298_())));
                }
                guiGraphics.m_280677_(this.f_96547_, c, Optional.empty(), mouseX, mouseY);
            }
        }
        guiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)"gui.guide.fluid").m_7220_((Component)comp), this.uiX + xOffset, this.uiY + yOffset, 6508608, false);
    }

    private void renderImage(GuiGraphics guiGraphics, ResourceLocation rl) {
        guiGraphics.m_280163_(rl, this.uiX, this.uiY, 0.0f, 0.0f, 420, 260, 420, 260);
    }

    private void renderImage(GuiGraphics guiGraphics, ResourceLocation rl, int xOffset, int yOffset) {
        guiGraphics.m_280163_(rl, this.uiX + xOffset, this.uiY + yOffset, 0.0f, 0.0f, 420, 260, 420, 260);
    }

    private void renderItem(ItemStack stack, int x, int y) {
        this.renderItem(stack, x, y, 3.0f);
    }

    private void renderItem(ItemStack stack, int x, int y, float scale) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        LocalPlayer entity = Minecraft.m_91087_().f_91074_;
        if (!stack.m_41619_()) {
            boolean usesBlockLight;
            BakedModel bakedmodel = this.f_96541_.m_91291_().m_174264_(stack, (Level)level, (LivingEntity)entity, 234234);
            PoseStack pose = new PoseStack();
            pose.m_85836_();
            pose.m_252880_((float)(x + 8), (float)(y + 8), 150.0f);
            pose.m_85841_(16.0f * scale, -16.0f * scale, 16.0f * scale);
            boolean bl = usesBlockLight = !bakedmodel.m_7547_();
            if (usesBlockLight) {
                Lighting.m_84930_();
            }
            this.f_96541_.m_91291_().m_115143_(stack, ItemDisplayContext.GUI, false, pose, (MultiBufferSource)Minecraft.m_91087_().m_91269_().m_110104_(), 0xF000F0, OverlayTexture.f_118083_, bakedmodel);
            RenderSystem.disableDepthTest();
            Minecraft.m_91087_().m_91269_().m_110104_().m_109911_();
            RenderSystem.enableDepthTest();
            if (usesBlockLight) {
                Lighting.m_84931_();
            }
            pose.m_85849_();
        }
    }

    public void m_7379_() {
        Minecraft.m_91087_().f_91066_.f_92125_ = this.advancedTooltips;
        ArrayList<ResourceLocation> notifRLs = new ArrayList<ResourceLocation>();
        Registry fishProperties = this.player.m_9236_().m_9598_().m_175515_(Starcatcher.FISH_REGISTRY);
        for (FishProperties fp : this.fpsSeen) {
            ResourceLocation rl = fishProperties.m_7981_((Object)fp);
            if (rl == null) {
                rl = Starcatcher.rl("missingno");
            }
            notifRLs.add(rl);
        }
        Payloads.CHANNEL.send(PacketDistributor.SERVER.with(null), (Object)new Payloads.FishesSeenPayload(notifRLs));
        super.m_7379_();
    }

    public boolean m_7043_() {
        return false;
    }

    protected boolean m_264396_() {
        return false;
    }

    public FishingGuideScreen() {
        super((Component)Component.m_237119_());
        this.all = new TrophyProperties.RarityProgress(0, DataAttachments.get((Player)Minecraft.m_91087_().f_91074_).fishesCaught().size() - 1);
        this.common = new TrophyProperties.RarityProgress(0, -1);
        this.uncommon = TrophyProperties.RarityProgress.DEFAULT;
        this.rare = TrophyProperties.RarityProgress.DEFAULT;
        this.epic = TrophyProperties.RarityProgress.DEFAULT;
        this.legendary = TrophyProperties.RarityProgress.DEFAULT;
        this.basics = new ItemStack((ItemLike)ModItems.ROD.get());
        this.treasures = new ItemStack((ItemLike)ModItems.WATERLOGGED_SATCHEL.get());
        this.ironHook = new ItemStack((ItemLike)ModItems.HOOK.get());
        this.shinyHook = new ItemStack((ItemLike)ModItems.SHINY_HOOK.get());
        this.goldHook = new ItemStack((ItemLike)ModItems.GOLD_HOOK.get());
        this.mossyHook = new ItemStack((ItemLike)ModItems.MOSSY_HOOK.get());
        this.crystalHook = new ItemStack((ItemLike)ModItems.CRYSTAL_HOOK.get());
        this.heavyHook = new ItemStack((ItemLike)ModItems.HEAVY_HOOK.get());
        this.stoneHook = new ItemStack((ItemLike)ModItems.STONE_HOOK.get());
        this.splitHook = new ItemStack((ItemLike)ModItems.SPLIT_HOOK.get());
        this.stabHook = new ItemStack((ItemLike)ModItems.STABILIZING_HOOK.get());
        this.frugalBobber = new ItemStack((ItemLike)ModItems.FRUGAL_BOBBER.get());
        this.creeperBobber = new ItemStack((ItemLike)ModItems.CREEPER_BOBBER.get());
        this.glitterBobber = new ItemStack((ItemLike)ModItems.GLITTER_BOBBER.get());
        this.colorfulBobber = new ItemStack((ItemLike)ModItems.COLORFUL_BOBBER.get());
        this.steadyBobber = new ItemStack((ItemLike)ModItems.STEADY_BOBBER.get());
        this.impatientBobber = new ItemStack((ItemLike)ModItems.IMPATIENT_BOBBER.get());
        this.frogBobber = new ItemStack((ItemLike)ModItems.FROG_BOBBER.get());
        this.kimbeBobber = new ItemStack((ItemLike)ModItems.KIMBE_BOBBER.get());
        this.clearBobber = new ItemStack((ItemLike)ModItems.CLEAR_BOBBER.get());
        this.cherryBait = new ItemStack((ItemLike)ModItems.CHERRY_BAIT.get());
        this.lushBait = new ItemStack((ItemLike)ModItems.LUSH_BAIT.get());
        this.sculkBait = new ItemStack((ItemLike)ModItems.SCULK_BAIT.get());
        this.dripstoneBait = new ItemStack((ItemLike)ModItems.DRIPSTONE_BAIT.get());
        this.murkwaterBait = new ItemStack((ItemLike)ModItems.MURKWATER_BAIT.get());
        this.legendaryBait = new ItemStack((ItemLike)ModItems.LEGENDARY_BAIT.get());
        this.meteorologicalBait = new ItemStack((ItemLike)ModItems.METEOROLOGICAL_BAIT.get());
        this.fishSpotter = new ItemStack((ItemLike)ModItems.FISH_SPOTTER.get());
        this.trophies = new ItemStack((ItemLike)ModBlocks.TROPHY_GOLD.get());
        this.secrets = new ItemStack((ItemLike)ModItems.WATERLOGGED_BOTTLE.get());
        this.settings = new ItemStack((ItemLike)ModItems.SETTINGS.get());
        this.advancedTooltips = Minecraft.m_91087_().f_91066_.f_92125_;
        Minecraft.m_91087_().f_91066_.f_92125_ = Minecraft.m_91087_().f_91074_.m_7500_() && this.advancedTooltips;
    }

    public static enum Sort {
        ALPHABETICAL_UP("gui.guide.sort.alphabetical_up"),
        ALPHABETICAL_DOWN("gui.guide.sort.alphabetical_down"),
        MOD_UP("gui.guide.sort.mod_up"),
        MOD_DOWN("gui.guide.sort.mod_down"),
        RARITY_UP("gui.guide.sort.rarity_up"),
        RARITY_DOWN("gui.guide.sort.rarity_down"),
        CAUGHT_UP("gui.guide.sort.caught_up"),
        CAUGHT_DOWN("gui.guide.sort.caught_down"),
        FLUID_UP("gui.guide.sort.fluid_up"),
        FLUID_DOWN("gui.guide.sort.fluid_down");

        private static final Sort[] vals;
        private final String translationKey;

        String getTranslationKey() {
            return this.translationKey;
        }

        private Sort(String translationKey) {
            this.translationKey = translationKey;
        }

        public Sort previous() {
            if (this.ordinal() == 0) {
                return vals[vals.length - 1];
            }
            return vals[(this.ordinal() - 1) % vals.length];
        }

        public Sort next() {
            return vals[(this.ordinal() + 1) % vals.length];
        }

        static {
            vals = Sort.values();
        }
    }
}

