/*
 * Decompiled with CFR 0.152.
 */
package com.wdiscute.starcatcher.guide;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.wdiscute.starcatcher.Config;
import com.wdiscute.starcatcher.ModItems;
import com.wdiscute.starcatcher.Starcatcher;
import com.wdiscute.starcatcher.minigame.HitFakeParticle;
import com.wdiscute.starcatcher.networkandcodecs.DataComponents;
import com.wdiscute.starcatcher.networkandcodecs.FishProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;
import org.joml.Random;
import org.joml.Vector2d;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SettingsScreen
extends Screen {
    private static final Random r = new Random();
    private static final ResourceLocation TEXTURE = Starcatcher.rl("textures/gui/minigame/minigame.png");
    private static final ResourceLocation TANK = Starcatcher.rl("textures/gui/minigame/surface.png");
    private static final ResourceLocation SETTINGS = Starcatcher.rl("textures/gui/minigame/settings.png");
    private static final ResourceLocation GUI_SCALE = Starcatcher.rl("textures/gui/minigame/gui_scale.png");
    private static final int SIZE_1 = 5;
    private static final int SIZE_2 = 7;
    private static final int SIZE_3 = 12;
    private static final int SIZE_4 = 17;
    private static final Logger log = LoggerFactory.getLogger(SettingsScreen.class);
    final FishProperties fp;
    final ItemStack itemBeingFished;
    final ItemStack bobber;
    final ItemStack bait;
    final ItemStack hook;
    float hitDelay;
    float speed;
    int reward;
    int rewardThin;
    int treasureReward;
    int penalty;
    int decay;
    boolean hasTreasure;
    boolean changeRotation;
    boolean moveMarkers = false;
    int gracePeriod = 80;
    final InteractionHand hand;
    int pointerPos = 0;
    float lastHitMarkerPos = 0.0f;
    float lastLastHitMarkerPos = 0.0f;
    float lastLastLastHitMarkerPos = 0.0f;
    int pos1;
    int pos2;
    int posThin1;
    int posThin2;
    int posTreasure;
    int currentRotation = 1;
    float partialTick;
    int lastTick;
    long milisLastTick;
    int completion = 20;
    int completionSmooth = 20;
    boolean perfectCatch = true;
    int consecutiveHits = 0;
    boolean treasureActive;
    int treasureProgress = Integer.MIN_VALUE;
    int treasureProgressSmooth = Integer.MIN_VALUE;
    int difficultyBobberOffset = 0;
    int bigForgiving = 12;
    int thinForgiving = 5;
    int treasureForgiving = 7;
    int previousGuiScale;
    Units unitSelected;
    int tickCount = 0;
    List<HitFakeParticle> hitParticles = new ArrayList<HitFakeParticle>();

    public SettingsScreen(FishProperties fp, ItemStack rod) {
        super((Component)Component.m_237119_());
        this.previousGuiScale = (Integer)Minecraft.m_91087_().f_91066_.m_231928_().m_231551_();
        Minecraft.m_91087_().f_91066_.m_231928_().m_231514_((Object)((Integer)Config.MINIGAME_GUI_SCALE.get()));
        Minecraft.m_91087_().m_5741_();
        this.hitDelay = ((Double)Config.HIT_DELAY.get()).floatValue();
        this.fp = fp;
        this.itemBeingFished = new ItemStack(fp.fish());
        this.bobber = DataComponents.getItemInSlot(rod, DataComponents.Slots.BOBBER);
        this.bait = DataComponents.getItemInSlot(rod, DataComponents.Slots.BAIT);
        this.hook = DataComponents.getItemInSlot(rod, DataComponents.Slots.HOOK);
        this.posTreasure = Integer.MIN_VALUE;
        this.unitSelected = (Units)((Object)Config.UNIT.get());
        FishProperties.Difficulty difficulty = this.hook.m_150930_((Item)ModItems.MOSSY_HOOK.get()) && (fp.rarity() == FishProperties.Rarity.COMMON || fp.rarity() == FishProperties.Rarity.UNCOMMON || fp.rarity() == FishProperties.Rarity.RARE) ? FishProperties.Difficulty.HARD : fp.dif();
        this.speed = difficulty.speed();
        this.reward = difficulty.reward();
        this.rewardThin = difficulty.rewardThin();
        this.treasureReward = difficulty.treasure().hitReward();
        this.penalty = difficulty.penalty();
        this.decay = difficulty.decay();
        this.hasTreasure = difficulty.treasure().hasTreasure();
        this.changeRotation = difficulty.extras().isFlip();
        this.pos1 = difficulty.markers().first() ? this.getRandomFreePosition() : Integer.MIN_VALUE;
        this.pos2 = difficulty.markers().second() ? this.getRandomFreePosition() : Integer.MIN_VALUE;
        this.posThin1 = difficulty.markers().firstThin() ? this.getRandomFreePosition() : Integer.MIN_VALUE;
        int n = this.posThin2 = difficulty.markers().secondThin() ? this.getRandomFreePosition() : Integer.MIN_VALUE;
        if (this.bobber.m_150930_((Item)ModItems.STEADY_BOBBER.get())) {
            this.bigForgiving = 17;
            this.thinForgiving = 7;
            this.treasureForgiving = 7;
            this.difficultyBobberOffset = 16;
        }
        this.hand = Minecraft.m_91087_().f_91074_.m_21205_().m_150930_((Item)ModItems.ROD.get()) ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
    }

    private int getRandomFreePosition() {
        for (int i = 0; i < 100; ++i) {
            int posBeingChecked = r.nextInt(360);
            if ((Math.abs(this.pos1 - posBeingChecked) < 50 || Math.abs(this.pos1 - posBeingChecked) > 310) && this.pos1 != Integer.MIN_VALUE || (Math.abs(this.pos2 - posBeingChecked) < 50 || Math.abs(this.pos2 - posBeingChecked) > 310) && this.pos2 != Integer.MIN_VALUE || (Math.abs(this.posThin1 - posBeingChecked) < 50 || Math.abs(this.posThin1 - posBeingChecked) > 310) && this.posThin1 != Integer.MIN_VALUE || (Math.abs(this.posThin2 - posBeingChecked) < 50 || Math.abs(this.posThin2 - posBeingChecked) > 310) && this.posThin2 != Integer.MIN_VALUE || (Math.abs(this.posTreasure - posBeingChecked) < 50 || Math.abs(this.posTreasure - posBeingChecked) > 310) && this.posTreasure != Integer.MIN_VALUE) continue;
            return posBeingChecked;
        }
        return 0;
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float FRACTION_OF_A_TICK_THAT_HAPPENED_SINCE_THE_LAST_FRAME_NOT_TO_BE_CONFUSED_TO_WHAT_A_PARTIAL_TICK_IS_IN_ONE_DOT_TWENTY_ONE_WHERE_A_PARTIAL_TICK_IS_THE_FRACTION_OF_A_TICK_SINCE_THE_LAST_TICK_NOT_THE_LAST_FRAME_WOW_THATS_SO_COOL_IM_SO_HAPPY_THIS_WAS_CHANGED_AND_THEY_KEPT_THE_SAME_NAME_SO_IT_TOOK_AGES_TO_DEBUG_AND_FIND_OUT_WHAT_WAS_CAUSING_IT) {
        float centerY;
        float centerX;
        PoseStack poseStack;
        super.m_280273_(guiGraphics);
        if (this.tickCount != this.lastTick) {
            this.lastTick = this.tickCount;
            this.milisLastTick = Util.m_137550_();
        }
        this.partialTick = (float)((double)(Util.m_137550_() - this.milisLastTick) / 50.0);
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        int imageWidth = 512;
        int imageHeight = 256;
        int uiX = (this.f_96543_ - imageWidth) / 2;
        int uiY = (this.f_96544_ - imageHeight) / 2;
        double x = mouseX - uiX;
        double y = mouseY - uiY;
        guiGraphics.m_280411_(SETTINGS, this.f_96543_ / 2 - 100, this.f_96544_ / 2 - 128, 256, 256, 0.0f, 0.0f, 256, 256, 256, 256);
        guiGraphics.m_280411_(GUI_SCALE, this.f_96543_ / 2 - 50, 0, 100, 50, 0.0f, 0.0f, 100, 50, 100, 50);
        guiGraphics.m_280056_(this.f_96547_, "Move Markers", this.f_96543_ / 2 + 72, this.f_96544_ / 2 - 24, 0, false);
        if (this.moveMarkers) {
            guiGraphics.m_280509_(this.f_96543_ / 2 + 62, this.f_96544_ / 2 - 22, this.f_96543_ / 2 + 67, this.f_96544_ / 2 - 17, -65281);
        }
        guiGraphics.m_280056_(this.f_96547_, "Flip Rotation", this.f_96543_ / 2 + 72, this.f_96544_ / 2 - 3, 0, false);
        if (this.changeRotation) {
            guiGraphics.m_280509_(this.f_96543_ / 2 + 62, this.f_96544_ / 2 - 2, this.f_96543_ / 2 + 67, this.f_96544_ / 2 + 3, -65281);
        }
        if (x > 350.0 && x < 373.0 && y > 39.0 && y < 66.0) {
            ArrayList<MutableComponent> comp = new ArrayList<MutableComponent>();
            comp.add(Component.m_237113_((String)"This screen serves to help those"));
            comp.add(Component.m_237113_((String)"who might be playing on high input setups"));
            comp.add(Component.m_237113_((String)""));
            comp.add(Component.m_237113_((String)"Use the Hit Delay to adjust the number of ticks"));
            comp.add(Component.m_237113_((String)"the minigame will calculate back in time for your input"));
            comp.add(Component.m_237113_((String)""));
            comp.add(Component.m_237113_((String)"For most people, a delay of 0 works fine."));
            comp.add(Component.m_237113_((String)"Play around and see what feels natural to you"));
            guiGraphics.m_280677_(this.f_96547_, comp, Optional.empty(), mouseX, mouseY);
        }
        guiGraphics.m_280056_(this.f_96547_, "Speed: " + this.speed, this.f_96543_ / 2 + 78, this.f_96544_ / 2 + 63, 0, false);
        guiGraphics.m_280056_(this.f_96547_, "Hit Delay: " + this.hitDelay, this.f_96543_ / 2 + 73, this.f_96544_ / 2 - 53, 0, false);
        guiGraphics.m_280056_(this.f_96547_, "Markers:", this.f_96543_ / 2 + 63, this.f_96544_ / 2 + 13, 0, false);
        if (this.pos1 != Integer.MIN_VALUE) {
            guiGraphics.m_280509_(this.f_96543_ / 2 + 64, this.f_96544_ / 2 + 27, this.f_96543_ / 2 + 69, this.f_96544_ / 2 + 32, -65281);
        }
        if (this.pos2 != Integer.MIN_VALUE) {
            guiGraphics.m_280509_(this.f_96543_ / 2 + 83, this.f_96544_ / 2 + 27, this.f_96543_ / 2 + 88, this.f_96544_ / 2 + 32, -65281);
        }
        if (this.posThin1 != Integer.MIN_VALUE) {
            guiGraphics.m_280509_(this.f_96543_ / 2 + 102, this.f_96544_ / 2 + 27, this.f_96543_ / 2 + 107, this.f_96544_ / 2 + 32, -65281);
        }
        if (this.posThin2 != Integer.MIN_VALUE) {
            guiGraphics.m_280509_(this.f_96543_ / 2 + 121, this.f_96544_ / 2 + 27, this.f_96543_ / 2 + 126, this.f_96544_ / 2 + 32, -65281);
        }
        if (this.posTreasure != Integer.MIN_VALUE) {
            guiGraphics.m_280509_(this.f_96543_ / 2 + 140, this.f_96544_ / 2 + 27, this.f_96543_ / 2 + 145, this.f_96544_ / 2 + 32, -65281);
        }
        guiGraphics.m_280056_(this.f_96547_, "Steady Bobber", this.f_96543_ / 2 + 72, this.f_96544_ / 2 + 43, 0, false);
        if (this.thinForgiving != 5) {
            guiGraphics.m_280509_(this.f_96543_ / 2 + 62, this.f_96544_ / 2 + 44, this.f_96543_ / 2 + 67, this.f_96544_ / 2 + 49, -65281);
        }
        guiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)this.unitSelected.translationKey), this.f_96543_ / 2 - 50, this.f_96544_ / 2 + 102, 0, false);
        if (this.treasureActive) {
            guiGraphics.m_280411_(TEXTURE, this.f_96543_ / 2 - 158, this.f_96544_ / 2 - 42 + (int)(64.0f - 64.0f * (float)this.treasureProgressSmooth / 100.0f), 5, 64 * this.treasureProgressSmooth / 100, 141.0f, 70.0f - (float)(64 * this.treasureProgressSmooth) / 100.0f, 5, 64 * this.treasureProgressSmooth / 100, 256, 256);
            guiGraphics.m_280411_(TEXTURE, this.f_96543_ / 2 - 16 - 155, this.f_96544_ / 2 - 48, 32, 96, 96.0f, 0.0f, 32, 96, 256, 256);
        }
        guiGraphics.m_280411_(TANK, this.f_96543_ / 2 - 42 - 100, this.f_96544_ / 2 - 48, 85, 97, 0.0f, 0.0f, 85, 97, 85, 97);
        guiGraphics.m_280411_(TEXTURE, this.f_96543_ / 2 - 32, this.f_96544_ / 2 - 32, 64, 64, 0.0f, 192.0f, 64, 64, 256, 256);
        guiGraphics.m_280411_(TEXTURE, this.f_96543_ / 2 - 16, this.f_96544_ / 2 + 40, 32, 16, 0.0f, 112.0f, 32, 16, 256, 256);
        if (this.pos1 != Integer.MIN_VALUE) {
            poseStack = guiGraphics.m_280168_();
            poseStack.m_85836_();
            centerX = (float)this.f_96543_ / 2.0f;
            centerY = (float)this.f_96544_ / 2.0f;
            poseStack.m_252880_(centerX, centerY, 0.0f);
            poseStack.m_252781_(new Quaternionf().rotateZ((float)Math.toRadians(this.pos1)));
            poseStack.m_252880_(-centerX, -centerY, 0.0f);
            guiGraphics.m_280411_(TEXTURE, this.f_96543_ / 2 - 8, this.f_96544_ / 2 - 8 - 25, 16, 16, (float)(16 - this.difficultyBobberOffset), 160.0f, 16, 16, 256, 256);
            poseStack.m_85849_();
        }
        if (this.pos2 != Integer.MIN_VALUE) {
            poseStack = guiGraphics.m_280168_();
            poseStack.m_85836_();
            centerX = (float)this.f_96543_ / 2.0f;
            centerY = (float)this.f_96544_ / 2.0f;
            poseStack.m_252880_(centerX, centerY, 0.0f);
            poseStack.m_252781_(new Quaternionf().rotateZ((float)Math.toRadians(this.pos2)));
            poseStack.m_252880_(-centerX, -centerY, 0.0f);
            guiGraphics.m_280411_(TEXTURE, this.f_96543_ / 2 - 8, this.f_96544_ / 2 - 8 - 25, 16, 16, (float)(16 - this.difficultyBobberOffset), 160.0f, 16, 16, 256, 256);
            poseStack.m_85849_();
        }
        if (this.posThin1 != Integer.MIN_VALUE) {
            poseStack = guiGraphics.m_280168_();
            poseStack.m_85836_();
            centerX = (float)this.f_96543_ / 2.0f;
            centerY = (float)this.f_96544_ / 2.0f;
            poseStack.m_252880_(centerX, centerY, 0.0f);
            poseStack.m_252781_(new Quaternionf().rotateZ((float)Math.toRadians(this.posThin1)));
            poseStack.m_252880_(-centerX, -centerY, 0.0f);
            guiGraphics.m_280411_(TEXTURE, this.f_96543_ / 2 - 8, this.f_96544_ / 2 - 8 - 25, 16, 16, (float)(48 - this.difficultyBobberOffset), 160.0f, 16, 16, 256, 256);
            poseStack.m_85849_();
        }
        if (this.posThin2 != Integer.MIN_VALUE) {
            poseStack = guiGraphics.m_280168_();
            poseStack.m_85836_();
            centerX = (float)this.f_96543_ / 2.0f;
            centerY = (float)this.f_96544_ / 2.0f;
            poseStack.m_252880_(centerX, centerY, 0.0f);
            poseStack.m_252781_(new Quaternionf().rotateZ((float)Math.toRadians(this.posThin2)));
            poseStack.m_252880_(-centerX, -centerY, 0.0f);
            guiGraphics.m_280411_(TEXTURE, this.f_96543_ / 2 - 8, this.f_96544_ / 2 - 8 - 25, 16, 16, (float)(48 - this.difficultyBobberOffset), 160.0f, 16, 16, 256, 256);
            poseStack.m_85849_();
        }
        if (this.posTreasure != Integer.MIN_VALUE) {
            poseStack = guiGraphics.m_280168_();
            poseStack.m_85836_();
            centerX = (float)this.f_96543_ / 2.0f;
            centerY = (float)this.f_96544_ / 2.0f;
            poseStack.m_252880_(centerX, centerY, 0.0f);
            poseStack.m_252781_(new Quaternionf().rotateZ((float)Math.toRadians(this.posTreasure)));
            poseStack.m_252880_(-centerX, -centerY, 0.0f);
            guiGraphics.m_280411_(TEXTURE, this.f_96543_ / 2 - 8, this.f_96544_ / 2 - 8 - 25, 16, 16, 64.0f, 160.0f, 16, 16, 256, 256);
            poseStack.m_85849_();
        }
        guiGraphics.m_280411_(TEXTURE, this.f_96543_ / 2 - 32, this.f_96544_ / 2 - 32, 64, 64, 64.0f, 192.0f, 64, 64, 256, 256);
        poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        centerX = (float)this.f_96543_ / 2.0f;
        centerY = (float)this.f_96544_ / 2.0f;
        poseStack.m_252880_(centerX, centerY, 0.0f);
        poseStack.m_252781_(new Quaternionf().rotateZ((float)Math.toRadians((float)this.pointerPos + this.speed * this.partialTick * (float)this.currentRotation)));
        poseStack.m_252880_(-centerX, -centerY, 0.0f);
        guiGraphics.m_280411_(TEXTURE, this.f_96543_ / 2 - 32, this.f_96544_ / 2 - 32 - 16, 64, 64, 128.0f, 192.0f, 64, 64, 256, 256);
        poseStack.m_85849_();
        poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        centerX = (float)this.f_96543_ / 2.0f;
        centerY = (float)this.f_96544_ / 2.0f;
        poseStack.m_252880_(centerX, centerY, 0.0f);
        poseStack.m_252781_(new Quaternionf().rotateZ((float)Math.toRadians(this.lastHitMarkerPos)));
        poseStack.m_252880_(-centerX, -centerY, 0.0f);
        guiGraphics.m_280411_(TEXTURE, this.f_96543_ / 2 - 32, this.f_96544_ / 2 - 32 - 16, 64, 64, 128.0f, 128.0f, 64, 64, 256, 256);
        poseStack.m_85849_();
        poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        RenderSystem.enableBlend();
        centerX = (float)this.f_96543_ / 2.0f;
        centerY = (float)this.f_96544_ / 2.0f;
        poseStack.m_252880_(centerX, centerY, 0.0f);
        poseStack.m_252781_(new Quaternionf().rotateZ((float)Math.toRadians(this.lastLastHitMarkerPos)));
        poseStack.m_252880_(-centerX, -centerY, 0.0f);
        guiGraphics.m_280411_(TEXTURE, this.f_96543_ / 2 - 32, this.f_96544_ / 2 - 32 - 16, 64, 64, 192.0f, 128.0f, 64, 64, 256, 256);
        RenderSystem.disableBlend();
        poseStack.m_85849_();
        poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        RenderSystem.enableBlend();
        centerX = (float)this.f_96543_ / 2.0f;
        centerY = (float)this.f_96544_ / 2.0f;
        poseStack.m_252880_(centerX, centerY, 0.0f);
        poseStack.m_252781_(new Quaternionf().rotateZ((float)Math.toRadians(this.lastLastLastHitMarkerPos)));
        poseStack.m_252880_(-centerX, -centerY, 0.0f);
        guiGraphics.m_280411_(TEXTURE, this.f_96543_ / 2 - 32, this.f_96544_ / 2 - 32 - 16, 64, 64, 192.0f, 64.0f, 64, 64, 256, 256);
        RenderSystem.disableBlend();
        poseStack.m_85849_();
        guiGraphics.m_280411_(TEXTURE, this.f_96543_ / 2 - 16, this.f_96544_ / 2 - 16, 32, 32, 208.0f, 208.0f, 32, 32, 256, 256);
        guiGraphics.m_280411_(TEXTURE, this.f_96543_ / 2 - 32 - 70, this.f_96544_ / 2 - 24 - 57, 64, 48, 192.0f, 0.0f, 64, 48, 256, 256);
        guiGraphics.m_280411_(TEXTURE, this.f_96543_ / 2 - 6 - 102, this.f_96544_ / 2 - 56 - 18, 16, 112 - this.completionSmooth, 176.0f, (float)(0 + this.completionSmooth), 16, 112 - this.completionSmooth, 256, 256);
        guiGraphics.m_280480_(this.itemBeingFished, this.f_96543_ / 2 - 8 - 100, this.f_96544_ / 2 - 8 + 35 - this.completionSmooth);
        for (HitFakeParticle instance : this.hitParticles) {
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280168_().m_85837_(instance.pos.x, instance.pos.y, 0.0);
            RenderSystem.setShaderColor((float)instance.r, (float)instance.g, (float)instance.b, (float)instance.a);
            guiGraphics.m_280411_(TEXTURE, this.f_96543_ / 2 - 8, this.f_96544_ / 2 - 8, 16, 16, 80.0f, 160.0f, 16, 16, 256, 256);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            guiGraphics.m_280168_().m_85849_();
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        int current;
        super.m_6375_(mouseX, mouseY, button);
        int imageWidth = 512;
        int imageHeight = 256;
        int uiX = (this.f_96543_ - imageWidth) / 2;
        int uiY = (this.f_96544_ - imageHeight) / 2;
        double x = mouseX - (double)uiX;
        double y = mouseY - (double)uiY;
        if (x > 226.0 && x < 240.0 && mouseY > 20.0 && mouseY < 50.0) {
            current = (Integer)Minecraft.m_91087_().f_91066_.m_231928_().m_231551_();
            if (current > 1) {
                Minecraft.m_91087_().f_91066_.m_231928_().m_231514_((Object)(current - 1));
            }
            Minecraft.m_91087_().m_5741_();
        }
        if (x > 267.0 && x < 280.0 && mouseY > 20.0 && mouseY < 50.0) {
            current = (Integer)Minecraft.m_91087_().f_91066_.m_231928_().m_231551_();
            Minecraft.m_91087_().f_91066_.m_231928_().m_231514_((Object)(current + 1));
            Minecraft.m_91087_().m_5741_();
        }
        if (x > 316.0 && x < 328.0 && y > 105.0 && y < 112.0) {
            boolean bl = this.moveMarkers = !this.moveMarkers;
        }
        if (x > 316.0 && x < 328.0 && y > 172.0 && y < 180.0) {
            if (this.thinForgiving == 5) {
                this.thinForgiving = 7;
                this.bigForgiving = 17;
                this.difficultyBobberOffset = 16;
            } else {
                this.thinForgiving = 5;
                this.bigForgiving = 12;
                this.difficultyBobberOffset = 0;
            }
        }
        if (x > 316.0 && x < 328.0 && y > 125.0 && y < 145.0) {
            boolean bl = this.changeRotation = !this.changeRotation;
        }
        if (x > 316.0 && x < 330.0 && y > 185.0 && y < 225.0) {
            this.speed -= 1.0f;
            if (this.speed < 0.0f) {
                this.speed = 0.0f;
            }
        }
        if (x > 395.0 && x < 410.0 && y > 185.0 && y < 225.0) {
            this.speed += 1.0f;
        }
        if (x > 316.0 && x < 325.0 && y > 70.0 && y < 100.0) {
            this.hitDelay = (float)((int)(this.hitDelay * 10.0f)) / 10.0f;
            this.hitDelay -= 0.2f;
            this.hitDelay = (float)((int)(this.hitDelay * 10.0f)) / 10.0f;
        }
        if (x > 396.0 && x < 410.0 && y > 70.0 && y < 100.0) {
            this.hitDelay = (float)((int)(this.hitDelay * 10.0f)) / 10.0f;
            this.hitDelay += 0.2f;
            this.hitDelay = (float)((int)(this.hitDelay * 10.0f)) / 10.0f;
        }
        if (x > 312.0 && x < 330.0 && y > 226.0 && y < 240.0) {
            this.unitSelected = this.unitSelected.next();
            Config.UNIT.set((Object)this.unitSelected);
            Config.UNIT.save();
        }
        if (x > 193.0 && x < 205.0 && y > 226.0 && y < 240.0) {
            this.unitSelected = this.unitSelected.previous();
            Config.UNIT.set((Object)this.unitSelected);
            Config.UNIT.save();
        }
        if (x > 319.0 && x < 330.0 && y > 153.0 && y < 166.0) {
            this.pos1 = this.pos1 == Integer.MIN_VALUE ? this.getRandomFreePosition() : Integer.MIN_VALUE;
        }
        if (x > 338.0 && x < 349.0 && y > 153.0 && y < 166.0) {
            this.pos2 = this.pos2 == Integer.MIN_VALUE ? this.getRandomFreePosition() : Integer.MIN_VALUE;
        }
        if (x > 357.0 && x < 368.0 && y > 153.0 && y < 166.0) {
            this.posThin1 = this.posThin1 == Integer.MIN_VALUE ? this.getRandomFreePosition() : Integer.MIN_VALUE;
        }
        if (x > 376.0 && x < 387.0 && y > 153.0 && y < 166.0) {
            this.posThin2 = this.posThin2 == Integer.MIN_VALUE ? this.getRandomFreePosition() : Integer.MIN_VALUE;
        }
        if (x > 395.0 && x < 406.0 && y > 153.0 && y < 166.0) {
            this.posTreasure = this.posTreasure == Integer.MIN_VALUE ? this.getRandomFreePosition() : Integer.MIN_VALUE;
        }
        return false;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        InputConstants.Key mouseKey = InputConstants.m_84827_((int)keyCode, (int)scanCode);
        if (this.f_96541_.f_91066_.f_92092_.isActiveAndMatches(mouseKey)) {
            this.m_7379_();
            return true;
        }
        if (keyCode == Minecraft.m_91087_().f_91066_.f_92089_.getKey().m_84873_()) {
            if (this.gracePeriod > 0) {
                this.gracePeriod = 0;
            }
            Minecraft.m_91087_().f_91074_.m_21011_(this.hand, true);
            boolean hitSomething = false;
            Vec3 pos = Minecraft.m_91087_().f_91074_.m_20182_();
            ClientLevel level = Minecraft.m_91087_().f_91073_;
            float pointerPosPrecise = (float)this.pointerPos + this.speed * this.partialTick * (float)this.currentRotation;
            this.lastLastLastHitMarkerPos = this.lastLastHitMarkerPos;
            this.lastLastHitMarkerPos = this.lastHitMarkerPos;
            this.lastHitMarkerPos = pointerPosPrecise += this.hitDelay * this.speed * (float)this.currentRotation;
            if ((Math.abs((float)this.pos1 - pointerPosPrecise) < (float)this.bigForgiving || Math.abs((float)this.pos1 - pointerPosPrecise) > (float)(360 - this.bigForgiving)) && this.pos1 != Integer.MIN_VALUE) {
                this.addParticles(this.pos1, 15);
                if (this.moveMarkers) {
                    this.pos1 = this.getRandomFreePosition();
                }
                this.completion += this.reward;
                hitSomething = true;
            }
            if ((Math.abs((float)this.pos2 - pointerPosPrecise) < (float)this.bigForgiving || Math.abs((float)this.pos2 - pointerPosPrecise) > (float)(360 - this.bigForgiving)) && this.pos2 != Integer.MIN_VALUE) {
                this.addParticles(this.pos2, 15);
                if (this.moveMarkers) {
                    this.pos2 = this.getRandomFreePosition();
                }
                this.completion += this.reward;
                hitSomething = true;
            }
            if ((Math.abs((float)this.posThin1 - pointerPosPrecise) < (float)this.thinForgiving || Math.abs((float)this.posThin1 - pointerPosPrecise) > (float)(360 - this.thinForgiving)) && this.posThin1 != Integer.MIN_VALUE) {
                this.addParticles(this.posThin1, 30);
                if (this.moveMarkers) {
                    this.posThin1 = this.getRandomFreePosition();
                }
                this.completion += this.rewardThin;
                hitSomething = true;
            }
            if ((Math.abs((float)this.posThin2 - pointerPosPrecise) < (float)this.thinForgiving || Math.abs((float)this.posThin2 - pointerPosPrecise) > (float)(360 - this.thinForgiving)) && this.posThin2 != Integer.MIN_VALUE) {
                this.addParticles(this.posThin2, 30);
                if (this.moveMarkers) {
                    this.posThin2 = this.getRandomFreePosition();
                }
                this.completion += this.rewardThin;
                hitSomething = true;
            }
            if ((Math.abs((float)this.posTreasure - pointerPosPrecise) < (float)this.treasureForgiving || Math.abs((float)this.posTreasure - pointerPosPrecise) > (float)(360 - this.treasureForgiving)) && this.posTreasure != Integer.MIN_VALUE) {
                this.addParticles(this.posTreasure, 30, true);
                if (this.moveMarkers) {
                    this.posTreasure = this.getRandomFreePosition();
                }
                this.treasureProgress += this.treasureReward;
                hitSomething = true;
            }
            if (hitSomething) {
                ++this.consecutiveHits;
                if (this.hook.m_150930_((Item)ModItems.STONE_HOOK.get())) {
                    if (this.fp.rarity() == FishProperties.Rarity.COMMON) {
                        this.gracePeriod = 40;
                    }
                    if (this.fp.rarity() == FishProperties.Rarity.UNCOMMON) {
                        this.gracePeriod = 20;
                    }
                    if (this.fp.rarity() == FishProperties.Rarity.RARE) {
                        this.gracePeriod = 15;
                    }
                    if (this.fp.rarity() == FishProperties.Rarity.EPIC) {
                        this.gracePeriod = 10;
                    }
                    if (this.fp.rarity() == FishProperties.Rarity.LEGENDARY) {
                        this.gracePeriod = 5;
                    }
                }
                level.m_7785_(pos.f_82479_, pos.f_82480_, pos.f_82481_, SoundEvents.f_11871_, SoundSource.BLOCKS, 1.0f, 1.0f, false);
                if (this.changeRotation) {
                    this.currentRotation *= -1;
                }
            } else {
                this.consecutiveHits = 0;
                level.m_7785_(pos.f_82479_, pos.f_82480_, pos.f_82481_, SoundEvents.f_11762_, SoundSource.BLOCKS, 1.0f, 1.0f, false);
                this.completion -= this.penalty;
                this.perfectCatch = false;
            }
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public void m_86600_() {
        this.pointerPos += (int)(this.speed * (float)this.currentRotation);
        if (this.pointerPos > 360) {
            this.pointerPos -= 360;
        }
        if (this.pointerPos < 0) {
            this.pointerPos += 360;
        }
        --this.gracePeriod;
        ++this.tickCount;
        this.completionSmooth += (int)Math.signum(this.completion - this.completionSmooth);
        this.completionSmooth += (int)Math.signum(this.completion - this.completionSmooth);
        this.treasureProgressSmooth += (int)Math.signum(this.treasureProgress - this.treasureProgressSmooth);
        if (this.tickCount % 5 == 0 && this.gracePeriod < 0) {
            this.completion -= this.decay;
        }
        if (this.completionSmooth < 0) {
            this.completion = 0;
            this.completionSmooth = 0;
        }
        if (this.treasureProgressSmooth > 100) {
            this.posTreasure = Integer.MIN_VALUE;
        }
        if (this.completionSmooth > 75) {
            this.completion = 75;
            this.completionSmooth = 75;
        }
        this.hitParticles.removeIf(HitFakeParticle::tick);
    }

    public void m_7379_() {
        Config.HIT_DELAY.set((Object)this.hitDelay);
        Config.HIT_DELAY.save();
        Config.MINIGAME_GUI_SCALE.set((Object)((Integer)Minecraft.m_91087_().f_91066_.m_231928_().m_231551_()));
        Config.MINIGAME_GUI_SCALE.save();
        Minecraft.m_91087_().f_91066_.m_231928_().m_231514_((Object)this.previousGuiScale);
        Minecraft.m_91087_().m_5741_();
        this.f_96541_.popGuiLayer();
    }

    private void addParticles(int posInDegrees, int count) {
        this.addParticles(posInDegrees, count, false);
    }

    private void addParticles(int posInDegrees, int count, boolean treasure) {
        int xPos = (int)(30.0 * Math.cos(Math.toRadians(posInDegrees - 90)));
        int yPos = (int)(30.0 * Math.sin(Math.toRadians(posInDegrees - 90)));
        for (int i = 0; i < count; ++i) {
            if (this.bobber.m_150930_((Item)ModItems.GLITTER_BOBBER.get())) {
                this.hitParticles.add(new HitFakeParticle(xPos, yPos, new Vector2d((double)(r.nextFloat() * 2.0f - 1.0f), (double)(r.nextFloat() * 2.0f - 1.0f)), r.nextFloat(), r.nextFloat(), r.nextFloat(), 1.0f));
                continue;
            }
            if (this.bobber.m_150930_((Item)ModItems.COLORFUL_BOBBER.get())) {
                this.hitParticles.add(new HitFakeParticle(xPos, yPos, new Vector2d((double)(r.nextFloat() * 2.0f - 1.0f), (double)(r.nextFloat() * 2.0f - 1.0f)), DataComponents.getBobberColor(this.bobber).r(), DataComponents.getBobberColor(this.bobber).g(), DataComponents.getBobberColor(this.bobber).b(), 1.0f));
                continue;
            }
            if (treasure) {
                this.hitParticles.add(new HitFakeParticle(xPos, yPos, new Vector2d((double)(r.nextFloat() * 2.0f - 1.0f), (double)(r.nextFloat() * 2.0f - 1.0f)), 0.7f + r.nextFloat() / 3.0f, 0.5f, 0.5f, 1.0f));
                continue;
            }
            this.hitParticles.add(new HitFakeParticle(xPos, yPos, new Vector2d((double)(r.nextFloat() * 2.0f - 1.0f), (double)(r.nextFloat() * 2.0f - 1.0f))));
        }
    }

    public boolean m_7043_() {
        return false;
    }

    public static enum Units {
        METRIC("gui.guide.units.metric", 1.0f, 1.0f),
        IMPERIAL("gui.guide.units.imperial", 0.3937f, 0.03527396f),
        CHEESEBURGER("gui.guide.units.cheeseburger", 0.09f, 0.0087f),
        FOOTBALL("gui.guide.units.football", 0.04545f, 0.00233f),
        DEVELOPER_HEIGHT("gui.guide.units.developer", 0.00592f, 1.40845E-5f),
        BANANA("gui.guide.units.banana", 0.05f, 0.00833f),
        DUCK("gui.guide.units.duck", 0.02f, 6.667E-4f),
        SPACE_WHALE("gui.guide.units.space_whale", 1.0f, 1.0f),
        SCIENTIFIC("gui.guide.units.scientific", 1.0f, 1.0f);

        private static final Units[] vals;
        private final String translationKey;
        private final float multiplierSize;
        private final float multiplierWeight;

        private Units(String translationKey, float multiplierSize, float multiplierWeight) {
            this.translationKey = translationKey;
            this.multiplierSize = multiplierSize;
            this.multiplierWeight = multiplierWeight;
        }

        public String getTranslationKey() {
            return this.translationKey;
        }

        public float getMultiplierSize() {
            return this.multiplierSize;
        }

        public float getMultiplierWeight() {
            return this.multiplierWeight;
        }

        public Units next() {
            return vals[(this.ordinal() + 1) % vals.length];
        }

        public Units previous() {
            if (this.ordinal() == 0) {
                return vals[vals.length - 1];
            }
            return vals[(this.ordinal() - 1) % vals.length];
        }

        public String getSizeAsString(int sizeInCm) {
            if (this.equals((Object)SPACE_WHALE)) {
                return "\u221e space whales";
            }
            if (this.equals((Object)SCIENTIFIC)) {
                return "0 AU";
            }
            float size = (float)sizeInCm * this.getMultiplierSize();
            String sizeString = (float)((int)(size * 100.0f)) / 100.0f + " " + I18n.m_118938_((String)(this.getTranslationKey() + ".size"), (Object[])new Object[0]);
            if (this.equals((Object)METRIC)) {
                sizeString = (int)size + "cm";
                if (size > 100.0f) {
                    sizeString = (float)((int)(size / 100.0f * 100.0f)) / 100.0f + "m";
                }
            }
            if (this.equals((Object)IMPERIAL)) {
                sizeString = (int)size + "''";
                if (size > 12.0f) {
                    sizeString = (int)(size / 12.0f) + "'" + (int)(size % 12.0f) + "''";
                }
            }
            return sizeString;
        }

        public String getWeightAsString(int weightInGrams) {
            if (this.equals((Object)SPACE_WHALE)) {
                return "\u221e space whales";
            }
            if (this.equals((Object)SCIENTIFIC)) {
                return "0 R136a1's";
            }
            float weight = (float)weightInGrams * this.getMultiplierWeight();
            String weightString = (float)((int)(weight * 100.0f)) / 100.0f + " " + I18n.m_118938_((String)(this.getTranslationKey() + ".weight"), (Object[])new Object[0]);
            if (this.equals((Object)METRIC)) {
                if (weight < 1000.0f) {
                    weightString = (int)weight + "g";
                }
                if (weight > 1000.0f) {
                    weightString = (float)((int)(weight / 1000.0f * 100.0f)) / 100.0f + "kg";
                }
            }
            if (this.equals((Object)IMPERIAL)) {
                weightString = (int)weight + "oz";
                if (weight > 12.0f) {
                    weightString = (int)(weight / 16.0f) + " lb " + (int)(weight % 16.0f) + " oz";
                }
            }
            return weightString;
        }

        static {
            vals = Units.values();
        }
    }
}

