/*
 * Decompiled with CFR 0.152.
 */
package com.wdiscute.starcatcher.minigame;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.wdiscute.starcatcher.Config;
import com.wdiscute.starcatcher.ModItems;
import com.wdiscute.starcatcher.Starcatcher;
import com.wdiscute.starcatcher.Tooltips;
import com.wdiscute.starcatcher.minigame.HitFakeParticle;
import com.wdiscute.starcatcher.networkandcodecs.DataComponents;
import com.wdiscute.starcatcher.networkandcodecs.FishProperties;
import com.wdiscute.starcatcher.networkandcodecs.Payloads;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.FastColor;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PacketDistributor;
import org.joml.Quaternionf;
import org.joml.Random;
import org.joml.Vector2d;

public class FishingMinigameScreen
extends Screen
implements GuiEventListener {
    private static final Random r = new Random();
    private static final ResourceLocation TEXTURE = Starcatcher.rl("textures/gui/minigame/minigame.png");
    private static final ResourceLocation NETHER = Starcatcher.rl("textures/gui/minigame/nether.png");
    private static final ResourceLocation CAVE = Starcatcher.rl("textures/gui/minigame/cave.png");
    private static final ResourceLocation SURFACE = Starcatcher.rl("textures/gui/minigame/surface.png");
    private static final int SIZE_1 = 5;
    private static final int SIZE_2 = 7;
    private static final int SIZE_3 = 12;
    private static final int SIZE_4 = 17;
    final FishProperties fp;
    final ItemStack itemBeingFished;
    final ItemStack bobber;
    final ItemStack bait;
    final ItemStack hook;
    final ItemStack treasureIS;
    final float speed;
    final int reward;
    final int rewardThin;
    final int treasureReward;
    final int penalty;
    final int decay;
    final boolean hasTreasure;
    final boolean changeRotation;
    final boolean isFlip;
    final boolean isVanishing;
    final boolean isMoving;
    float lastHitMarkerPos = 0.0f;
    float kimbeColor = 0.0f;
    int gracePeriod = 80;
    final InteractionHand hand;
    int pointerPos = 0;
    int pos1;
    int pos2;
    int posThin1;
    int posThin2;
    int posTreasure;
    float pos1Vanishing = 1.0f;
    float pos2Vanishing = 1.0f;
    float posThin1Vanishing = 1.0f;
    float posThin2Vanishing = 1.0f;
    float vanishingRate = 0.0f;
    int moveRate = 0;
    int currentRotation = 1;
    int lastTick;
    float partialTick;
    float hitDelay;
    int completion = 20;
    int completionSmooth = 20;
    boolean perfectCatch = true;
    int consecutiveHits = 0;
    boolean treasureActive;
    int treasureProgress = Integer.MIN_VALUE;
    int treasureProgressSmooth = Integer.MIN_VALUE;
    int difficultyBobberOffset = 0;
    int bigForgiving = 12;
    int thinForgiving = 5;
    int treasureForgiving = 7;
    int tickCount = 0;
    List<HitFakeParticle> hitParticles = new ArrayList<HitFakeParticle>();
    int previousGuiScale;
    ResourceLocation tankTexture = SURFACE;

    public FishingMinigameScreen(FishProperties fp, ItemStack rod) {
        super((Component)Component.m_237119_());
        this.previousGuiScale = (Integer)Minecraft.m_91087_().f_91066_.m_231928_().m_231551_();
        Minecraft.m_91087_().f_91066_.m_231928_().m_231514_((Object)((Integer)Config.MINIGAME_GUI_SCALE.get()));
        Minecraft.m_91087_().m_5741_();
        this.hitDelay = ((Double)Config.HIT_DELAY.get()).floatValue();
        this.fp = fp;
        this.itemBeingFished = new ItemStack(fp.fish());
        this.bobber = DataComponents.getItemInSlot(rod, DataComponents.Slots.BOBBER);
        this.bait = DataComponents.getItemInSlot(rod, DataComponents.Slots.BAIT);
        this.hook = DataComponents.getItemInSlot(rod, DataComponents.Slots.HOOK);
        this.posTreasure = Integer.MIN_VALUE;
        this.treasureIS = new ItemStack((ItemLike)BuiltInRegistries.f_257033_.m_7745_(fp.dif().treasure().loot()));
        ResourceKey dim = Minecraft.m_91087_().f_91073_.m_46472_();
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player.m_20186_() < 50.0 && dim.equals((Object)Level.f_46428_)) {
            this.tankTexture = CAVE;
        }
        if (dim.equals((Object)Level.f_46429_)) {
            this.tankTexture = NETHER;
        }
        boolean commonUncommonRareFish = fp.rarity() == FishProperties.Rarity.COMMON || fp.rarity() == FishProperties.Rarity.UNCOMMON || fp.rarity() == FishProperties.Rarity.RARE;
        FishProperties.Difficulty difficulty = this.hook.m_150930_((Item)ModItems.MOSSY_HOOK.get()) && commonUncommonRareFish ? FishProperties.Difficulty.MEDIUM_VANISHING_MOVING : fp.dif();
        this.speed = difficulty.speed();
        this.reward = difficulty.reward();
        this.rewardThin = difficulty.rewardThin();
        this.treasureReward = difficulty.treasure().hitReward();
        this.penalty = difficulty.penalty();
        this.decay = difficulty.decay();
        this.hasTreasure = difficulty.treasure().hasTreasure();
        this.changeRotation = difficulty.extras().isFlip() && !this.hook.m_150930_((Item)ModItems.STABILIZING_HOOK.get());
        this.isFlip = difficulty.extras().isFlip();
        this.isVanishing = difficulty.extras().isVanishing();
        this.isMoving = difficulty.extras().isMoving();
        this.pos1 = difficulty.markers().first() ? this.getRandomFreePosition() : Integer.MIN_VALUE;
        this.pos2 = difficulty.markers().second() ? this.getRandomFreePosition() : Integer.MIN_VALUE;
        this.posThin1 = difficulty.markers().firstThin() ? this.getRandomFreePosition() : Integer.MIN_VALUE;
        int n = this.posThin2 = difficulty.markers().secondThin() ? this.getRandomFreePosition() : Integer.MIN_VALUE;
        if (this.isMoving) {
            if (commonUncommonRareFish) {
                this.moveRate = 1;
                if (this.hook.m_150930_((Item)ModItems.MOSSY_HOOK.get())) {
                    this.moveRate = 3;
                }
            } else {
                if (fp.rarity().equals((Object)FishProperties.Rarity.EPIC)) {
                    this.moveRate = 6;
                }
                if (fp.rarity().equals((Object)FishProperties.Rarity.LEGENDARY)) {
                    this.moveRate = 8;
                }
                if (this.hook.m_150930_((Item)ModItems.HEAVY_HOOK.get())) {
                    this.moveRate = 3;
                }
            }
        }
        if (this.isVanishing) {
            if (commonUncommonRareFish) {
                this.vanishingRate = 0.03f;
            }
            if (fp.rarity().equals((Object)FishProperties.Rarity.EPIC)) {
                this.vanishingRate = 0.1f;
            }
            if (fp.rarity().equals((Object)FishProperties.Rarity.LEGENDARY)) {
                this.vanishingRate = 0.2f;
            }
            if (this.bobber.m_150930_((Item)ModItems.CLEAR_BOBBER.get())) {
                this.vanishingRate /= 2.0f;
            }
        }
        if (this.bobber.m_150930_((Item)ModItems.STEADY_BOBBER.get())) {
            this.bigForgiving = 17;
            this.thinForgiving = 7;
            this.treasureForgiving = 7;
            this.difficultyBobberOffset = 16;
        }
        this.hand = Minecraft.m_91087_().f_91074_.m_21205_().m_150930_((Item)ModItems.ROD.get()) ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
    }

    private int getRandomFreePosition() {
        for (int i = 0; i < 100; ++i) {
            int posBeingChecked = r.nextInt(360);
            if ((Math.abs(this.pos1 - posBeingChecked) < 50 || Math.abs(this.pos1 - posBeingChecked) > 310) && this.pos1 != Integer.MIN_VALUE || (Math.abs(this.pos2 - posBeingChecked) < 50 || Math.abs(this.pos2 - posBeingChecked) > 310) && this.pos2 != Integer.MIN_VALUE || (Math.abs(this.posThin1 - posBeingChecked) < 50 || Math.abs(this.posThin1 - posBeingChecked) > 310) && this.posThin1 != Integer.MIN_VALUE || (Math.abs(this.posThin2 - posBeingChecked) < 50 || Math.abs(this.posThin2 - posBeingChecked) > 310) && this.posThin2 != Integer.MIN_VALUE || (Math.abs(this.posTreasure - posBeingChecked) < 50 || Math.abs(this.posTreasure - posBeingChecked) > 310) && this.posTreasure != Integer.MIN_VALUE) continue;
            return posBeingChecked;
        }
        return 0;
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float FRACTION_OF_A_TICK_THAT_HAPPENED_SINCE_THE_LAST_FRAME_NOT_TO_BE_CONFUSED_TO_WHAT_A_PARTIAL_TICK_IS_IN_ONE_DOT_TWENTY_ONE_WHERE_A_PARTIAL_TICK_IS_THE_FRACTION_OF_A_TICK_SINCE_THE_LAST_TICK_NOT_THE_LAST_FRAME_WOW_THATS_SO_COOL_IM_SO_HAPPY_THIS_WAS_CHANGED_AND_THEY_KEPT_THE_SAME_NAME_SO_IT_TOOK_AGES_TO_DEBUG_AND_FIND_OUT_WHAT_WAS_CAUSING_IT) {
        float centerY;
        float centerX;
        super.m_280273_(guiGraphics);
        this.partialTick += FRACTION_OF_A_TICK_THAT_HAPPENED_SINCE_THE_LAST_FRAME_NOT_TO_BE_CONFUSED_TO_WHAT_A_PARTIAL_TICK_IS_IN_ONE_DOT_TWENTY_ONE_WHERE_A_PARTIAL_TICK_IS_THE_FRACTION_OF_A_TICK_SINCE_THE_LAST_TICK_NOT_THE_LAST_FRAME_WOW_THATS_SO_COOL_IM_SO_HAPPY_THIS_WAS_CHANGED_AND_THEY_KEPT_THE_SAME_NAME_SO_IT_TOOK_AGES_TO_DEBUG_AND_FIND_OUT_WHAT_WAS_CAUSING_IT;
        if (this.tickCount != this.lastTick) {
            this.partialTick = FRACTION_OF_A_TICK_THAT_HAPPENED_SINCE_THE_LAST_FRAME_NOT_TO_BE_CONFUSED_TO_WHAT_A_PARTIAL_TICK_IS_IN_ONE_DOT_TWENTY_ONE_WHERE_A_PARTIAL_TICK_IS_THE_FRACTION_OF_A_TICK_SINCE_THE_LAST_TICK_NOT_THE_LAST_FRAME_WOW_THATS_SO_COOL_IM_SO_HAPPY_THIS_WAS_CHANGED_AND_THEY_KEPT_THE_SAME_NAME_SO_IT_TOOK_AGES_TO_DEBUG_AND_FIND_OUT_WHAT_WAS_CAUSING_IT;
            this.lastTick = this.tickCount;
        }
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        if (this.treasureActive) {
            guiGraphics.m_280411_(TEXTURE, this.f_96543_ / 2 - 158, this.f_96544_ / 2 - 42 + (int)(64.0f - 64.0f * (float)this.treasureProgressSmooth / 100.0f), 5, 64 * this.treasureProgressSmooth / 100, 141.0f, 70.0f - (float)(64 * this.treasureProgressSmooth) / 100.0f, 5, 64 * this.treasureProgressSmooth / 100, 256, 256);
            guiGraphics.m_280411_(TEXTURE, this.f_96543_ / 2 - 16 - 155, this.f_96544_ / 2 - 48, 32, 96, 96.0f, 0.0f, 32, 96, 256, 256);
            guiGraphics.m_280480_(this.treasureIS, this.f_96543_ / 2 - 163, (int)((float)this.f_96544_ / 2.0f - 64.0f * (float)this.treasureProgressSmooth / 100.0f) + 15);
            int color = Tooltips.hueToRGBInt(Tooltips.hue);
            if (this.bobber.m_150930_((Item)ModItems.GLITTER_BOBBER.get())) {
                RenderSystem.setShaderColor((float)((float)FastColor.ARGB32.m_13665_((int)color) / 255.0f), (float)((float)FastColor.ARGB32.m_13667_((int)color) / 255.0f), (float)((float)FastColor.ARGB32.m_13669_((int)color) / 255.0f), (float)1.0f);
            }
            if (this.bobber.m_150930_((Item)ModItems.COLORFUL_BOBBER.get())) {
                color = DataComponents.getBobberColor(this.bobber).getColorAsInt();
            }
            if (this.bobber.m_150930_((Item)ModItems.COLORFUL_BOBBER.get())) {
                RenderSystem.setShaderColor((float)((float)FastColor.ARGB32.m_13665_((int)color) / 255.0f), (float)((float)FastColor.ARGB32.m_13667_((int)color) / 255.0f), (float)((float)FastColor.ARGB32.m_13669_((int)color) / 255.0f), (float)1.0f);
            }
            if (this.treasureProgress > 99) {
                guiGraphics.m_280411_(TEXTURE, this.f_96543_ / 2 - 16 - 155, this.f_96544_ / 2 - 48, 32, 96, 64.0f, 0.0f, 32, 96, 256, 256);
            }
            if (this.bobber.m_150930_((Item)ModItems.COLORFUL_BOBBER.get()) || this.bobber.m_150930_((Item)ModItems.GLITTER_BOBBER.get())) {
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
        }
        guiGraphics.m_280411_(this.tankTexture, this.f_96543_ / 2 - 42 - 100, this.f_96544_ / 2 - 48, 85, 97, 0.0f, 0.0f, 85, 97, 85, 97);
        guiGraphics.m_280411_(TEXTURE, this.f_96543_ / 2 - 32, this.f_96544_ / 2 - 32, 64, 64, 0.0f, 192.0f, 64, 64, 256, 256);
        guiGraphics.m_280411_(TEXTURE, this.f_96543_ / 2 - 16, this.f_96544_ / 2 + 40, 32, 16, 0.0f, 112.0f, 32, 16, 256, 256);
        if (this.pos1 != Integer.MIN_VALUE) {
            PoseStack poseStack = guiGraphics.m_280168_();
            poseStack.m_85836_();
            centerX = (float)this.f_96543_ / 2.0f;
            centerY = (float)this.f_96544_ / 2.0f;
            poseStack.m_252880_(centerX, centerY, 0.0f);
            poseStack.m_252781_(new Quaternionf().rotateZ((float)Math.toRadians((float)this.pos1 - this.partialTick * (float)this.currentRotation * (float)this.moveRate)));
            poseStack.m_252880_(-centerX, -centerY, 0.0f);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.pos1Vanishing);
            RenderSystem.enableBlend();
            guiGraphics.m_280411_(TEXTURE, this.f_96543_ / 2 - 8, this.f_96544_ / 2 - 8 - 25, 16, 16, (float)(16 - this.difficultyBobberOffset), 160.0f, 16, 16, 256, 256);
            RenderSystem.disableBlend();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            poseStack.m_85849_();
        }
        if (this.pos2 != Integer.MIN_VALUE) {
            PoseStack poseStack = guiGraphics.m_280168_();
            poseStack.m_85836_();
            centerX = (float)this.f_96543_ / 2.0f;
            centerY = (float)this.f_96544_ / 2.0f;
            poseStack.m_252880_(centerX, centerY, 0.0f);
            poseStack.m_252781_(new Quaternionf().rotateZ((float)Math.toRadians((float)this.pos2 - this.partialTick * (float)this.currentRotation * (float)this.moveRate)));
            poseStack.m_252880_(-centerX, -centerY, 0.0f);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.pos2Vanishing);
            RenderSystem.enableBlend();
            guiGraphics.m_280411_(TEXTURE, this.f_96543_ / 2 - 8, this.f_96544_ / 2 - 8 - 25, 16, 16, (float)(16 - this.difficultyBobberOffset), 160.0f, 16, 16, 256, 256);
            RenderSystem.disableBlend();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            poseStack.m_85849_();
        }
        if (this.posThin1 != Integer.MIN_VALUE) {
            PoseStack poseStack = guiGraphics.m_280168_();
            poseStack.m_85836_();
            centerX = (float)this.f_96543_ / 2.0f;
            centerY = (float)this.f_96544_ / 2.0f;
            poseStack.m_252880_(centerX, centerY, 0.0f);
            poseStack.m_252781_(new Quaternionf().rotateZ((float)Math.toRadians((float)this.posThin1 - this.partialTick * (float)this.currentRotation * (float)this.moveRate)));
            poseStack.m_252880_(-centerX, -centerY, 0.0f);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.posThin1Vanishing);
            RenderSystem.enableBlend();
            guiGraphics.m_280411_(TEXTURE, this.f_96543_ / 2 - 8, this.f_96544_ / 2 - 8 - 25, 16, 16, (float)(48 - this.difficultyBobberOffset), 160.0f, 16, 16, 256, 256);
            RenderSystem.disableBlend();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            poseStack.m_85849_();
        }
        if (this.posThin2 != Integer.MIN_VALUE) {
            PoseStack poseStack = guiGraphics.m_280168_();
            poseStack.m_85836_();
            centerX = (float)this.f_96543_ / 2.0f;
            centerY = (float)this.f_96544_ / 2.0f;
            poseStack.m_252880_(centerX, centerY, 0.0f);
            poseStack.m_252781_(new Quaternionf().rotateZ((float)Math.toRadians((float)this.posThin2 - this.partialTick * (float)this.currentRotation * (float)this.moveRate)));
            poseStack.m_252880_(-centerX, -centerY, 0.0f);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.posThin2Vanishing);
            RenderSystem.enableBlend();
            guiGraphics.m_280411_(TEXTURE, this.f_96543_ / 2 - 8, this.f_96544_ / 2 - 8 - 25, 16, 16, (float)(48 - this.difficultyBobberOffset), 160.0f, 16, 16, 256, 256);
            RenderSystem.disableBlend();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            poseStack.m_85849_();
        }
        if (this.posTreasure != Integer.MIN_VALUE) {
            PoseStack poseStack = guiGraphics.m_280168_();
            poseStack.m_85836_();
            centerX = (float)this.f_96543_ / 2.0f;
            centerY = (float)this.f_96544_ / 2.0f;
            poseStack.m_252880_(centerX, centerY, 0.0f);
            poseStack.m_252781_(new Quaternionf().rotateZ((float)Math.toRadians(this.posTreasure)));
            poseStack.m_252880_(-centerX, -centerY, 0.0f);
            guiGraphics.m_280411_(TEXTURE, this.f_96543_ / 2 - 8, this.f_96544_ / 2 - 8 - 25, 16, 16, 64.0f, 160.0f, 16, 16, 256, 256);
            poseStack.m_85849_();
        }
        guiGraphics.m_280411_(TEXTURE, this.f_96543_ / 2 - 32, this.f_96544_ / 2 - 32, 64, 64, 64.0f, 192.0f, 64, 64, 256, 256);
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        centerX = (float)this.f_96543_ / 2.0f;
        centerY = (float)this.f_96544_ / 2.0f;
        poseStack.m_252880_(centerX, centerY, 0.0f);
        poseStack.m_252781_(new Quaternionf().rotateZ((float)Math.toRadians((float)this.pointerPos + this.speed * this.partialTick * (float)this.currentRotation)));
        poseStack.m_252880_(-centerX, -centerY, 0.0f);
        guiGraphics.m_280411_(TEXTURE, this.f_96543_ / 2 - 32, this.f_96544_ / 2 - 32 - 16, 64, 64, 128.0f, 192.0f, 64, 64, 256, 256);
        poseStack.m_85849_();
        poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        centerX = (float)this.f_96543_ / 2.0f;
        centerY = (float)this.f_96544_ / 2.0f;
        poseStack.m_252880_(centerX, centerY, 0.0f);
        poseStack.m_252781_(new Quaternionf().rotateZ((float)Math.toRadians(this.lastHitMarkerPos)));
        poseStack.m_252880_(-centerX, -centerY, 0.0f);
        RenderSystem.setShaderColor((float)1.0f, (float)0.0f, (float)0.0f, (float)this.kimbeColor);
        RenderSystem.enableBlend();
        if (!this.bobber.m_150930_((Item)ModItems.KIMBE_BOBBER.get())) {
            guiGraphics.m_280411_(TEXTURE, this.f_96543_ / 2 - 32, this.f_96544_ / 2 - 32 - 16, 64, 64, 128.0f, 128.0f, 64, 64, 256, 256);
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
        poseStack.m_85849_();
        guiGraphics.m_280411_(TEXTURE, this.f_96543_ / 2 - 16, this.f_96544_ / 2 - 16, 32, 32, 208.0f, 208.0f, 32, 32, 256, 256);
        guiGraphics.m_280411_(TEXTURE, this.f_96543_ / 2 - 32 - 70, this.f_96544_ / 2 - 24 - 57, 64, 48, 192.0f, 0.0f, 64, 48, 256, 256);
        guiGraphics.m_280411_(TEXTURE, this.f_96543_ / 2 - 6 - 102, this.f_96544_ / 2 - 56 - 18, 16, 112 - this.completionSmooth, 176.0f, (float)(0 + this.completionSmooth), 16, 112 - this.completionSmooth, 256, 256);
        guiGraphics.m_280480_(this.itemBeingFished, this.f_96543_ / 2 - 8 - 100, this.f_96544_ / 2 - 8 + 35 - this.completionSmooth);
        for (HitFakeParticle instance : this.hitParticles) {
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280168_().m_85837_(instance.pos.x, instance.pos.y, 0.0);
            RenderSystem.setShaderColor((float)instance.r, (float)instance.g, (float)instance.b, (float)instance.a);
            guiGraphics.m_280411_(TEXTURE, this.f_96543_ / 2 - 8, this.f_96544_ / 2 - 8, 16, 16, 80.0f, 160.0f, 16, 16, 256, 256);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            guiGraphics.m_280168_().m_85849_();
        }
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        InputConstants.Key mouseKey = InputConstants.m_84827_((int)keyCode, (int)scanCode);
        if (this.f_96541_.f_91066_.f_92092_.isActiveAndMatches(mouseKey)) {
            this.m_7379_();
            return true;
        }
        if (keyCode == Minecraft.m_91087_().f_91066_.f_92089_.getKey().m_84873_()) {
            if (this.gracePeriod > 0) {
                this.gracePeriod = 0;
            }
            Minecraft.m_91087_().f_91074_.m_21011_(this.hand, true);
            boolean hitSomething = false;
            Vec3 pos = Minecraft.m_91087_().f_91074_.m_20182_();
            ClientLevel level = Minecraft.m_91087_().f_91073_;
            float pointerPosPrecise = (float)this.pointerPos + this.speed * this.partialTick * (float)this.currentRotation;
            this.lastHitMarkerPos = pointerPosPrecise += this.hitDelay * this.speed * (float)this.currentRotation;
            if ((Math.abs((float)this.pos1 - pointerPosPrecise) < (float)this.bigForgiving || Math.abs((float)this.pos1 - pointerPosPrecise) > (float)(360 - this.bigForgiving)) && this.pos1 != Integer.MIN_VALUE) {
                this.addParticles(this.pos1, 15);
                this.pos1 = this.getRandomFreePosition();
                this.completion += this.reward;
                hitSomething = true;
                this.pos1Vanishing = 1.0f;
            }
            if ((Math.abs((float)this.pos2 - pointerPosPrecise) < (float)this.bigForgiving || Math.abs((float)this.pos2 - pointerPosPrecise) > (float)(360 - this.bigForgiving)) && this.pos2 != Integer.MIN_VALUE) {
                this.addParticles(this.pos2, 15);
                this.pos2 = this.getRandomFreePosition();
                this.completion += this.reward;
                hitSomething = true;
                this.pos2Vanishing = 1.0f;
            }
            if ((Math.abs((float)this.posThin1 - pointerPosPrecise) < (float)this.thinForgiving || Math.abs((float)this.posThin1 - pointerPosPrecise) > (float)(360 - this.thinForgiving)) && this.posThin1 != Integer.MIN_VALUE) {
                this.addParticles(this.posThin1, 30);
                this.posThin1 = this.getRandomFreePosition();
                this.completion += this.rewardThin;
                hitSomething = true;
                this.posThin1Vanishing = 1.0f;
            }
            if ((Math.abs((float)this.posThin2 - pointerPosPrecise) < (float)this.thinForgiving || Math.abs((float)this.posThin2 - pointerPosPrecise) > (float)(360 - this.thinForgiving)) && this.posThin2 != Integer.MIN_VALUE) {
                this.addParticles(this.posThin2, 30);
                this.posThin2 = this.getRandomFreePosition();
                this.completion += this.rewardThin;
                hitSomething = true;
                this.posThin2Vanishing = 1.0f;
            }
            if ((Math.abs((float)this.posTreasure - pointerPosPrecise) < (float)this.treasureForgiving || Math.abs((float)this.posTreasure - pointerPosPrecise) > (float)(360 - this.treasureForgiving)) && this.posTreasure != Integer.MIN_VALUE) {
                this.addParticles(this.posTreasure, 30, true);
                this.posTreasure = this.getRandomFreePosition();
                this.treasureProgress += this.treasureReward;
                hitSomething = true;
                if (this.treasureProgress > 100) {
                    this.posTreasure = Integer.MIN_VALUE;
                }
            }
            if (hitSomething) {
                ++this.consecutiveHits;
                if (this.hasTreasure && (double)r.nextFloat() > 0.9 && this.completion < 60 && !this.treasureActive && this.treasureProgress == Integer.MIN_VALUE || this.consecutiveHits == 3 && this.treasureProgress == Integer.MIN_VALUE && this.hook.m_150930_((Item)ModItems.SHINY_HOOK.get())) {
                    this.treasureActive = true;
                    this.posTreasure = this.getRandomFreePosition();
                    this.treasureProgress = 0;
                    this.treasureProgressSmooth = 0;
                }
                if (this.hook.m_150930_((Item)ModItems.STONE_HOOK.get())) {
                    if (this.fp.rarity() == FishProperties.Rarity.COMMON) {
                        this.gracePeriod = 40;
                    }
                    if (this.fp.rarity() == FishProperties.Rarity.UNCOMMON) {
                        this.gracePeriod = 20;
                    }
                    if (this.fp.rarity() == FishProperties.Rarity.RARE) {
                        this.gracePeriod = 15;
                    }
                    if (this.fp.rarity() == FishProperties.Rarity.EPIC) {
                        this.gracePeriod = 10;
                    }
                    if (this.fp.rarity() == FishProperties.Rarity.LEGENDARY) {
                        this.gracePeriod = 5;
                    }
                }
                level.m_7785_(pos.f_82479_, pos.f_82480_, pos.f_82481_, SoundEvents.f_11871_, SoundSource.BLOCKS, 1.0f, 1.0f, false);
                if (this.changeRotation) {
                    this.currentRotation *= -1;
                }
            } else {
                this.pos1Vanishing = 1.0f;
                this.pos2Vanishing = 1.0f;
                this.posThin1Vanishing = 1.0f;
                this.posThin2Vanishing = 1.0f;
                if (this.bobber.m_150930_((Item)ModItems.KIMBE_BOBBER.get())) {
                    Minecraft.m_91087_().f_91074_.m_5496_(SoundEvents.f_12507_, 1.0f, 1.0f);
                }
                this.kimbeColor = 1.0f;
                this.consecutiveHits = 0;
                level.m_7785_(pos.f_82479_, pos.f_82480_, pos.f_82481_, SoundEvents.f_11762_, SoundSource.BLOCKS, 1.0f, 1.0f, false);
                this.completion -= this.penalty;
                this.perfectCatch = false;
            }
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public void m_86600_() {
        this.pointerPos += (int)(this.speed * (float)this.currentRotation);
        this.kimbeColor -= 0.1f;
        if (this.isVanishing) {
            this.pos1Vanishing -= this.vanishingRate;
            this.pos2Vanishing -= this.vanishingRate;
            this.posThin1Vanishing -= this.vanishingRate;
            this.posThin2Vanishing -= this.vanishingRate;
        }
        if (this.isMoving) {
            if (this.pos1 != Integer.MIN_VALUE) {
                this.pos1 -= this.moveRate * this.currentRotation;
            }
            if (this.pos2 != Integer.MIN_VALUE) {
                this.pos2 -= this.moveRate * this.currentRotation;
            }
            if (this.posThin1 != Integer.MIN_VALUE) {
                this.posThin1 -= this.moveRate * this.currentRotation;
            }
            if (this.posThin2 != Integer.MIN_VALUE) {
                this.posThin2 -= this.moveRate * this.currentRotation;
            }
        }
        if (this.pos1 < 0 && this.pos1 != Integer.MIN_VALUE) {
            this.pos1 += 360;
        }
        if (this.pos2 < 0 && this.pos2 != Integer.MIN_VALUE) {
            this.pos2 += 360;
        }
        if (this.posThin1 < 0 && this.posThin1 != Integer.MIN_VALUE) {
            this.posThin1 += 360;
        }
        if (this.posThin2 < 0 && this.posThin2 != Integer.MIN_VALUE) {
            this.posThin2 += 360;
        }
        if (this.pointerPos > 360) {
            this.pointerPos -= 360;
        }
        if (this.pointerPos < 0) {
            this.pointerPos += 360;
        }
        --this.gracePeriod;
        ++this.tickCount;
        this.completionSmooth += (int)Math.signum(this.completion - this.completionSmooth);
        this.completionSmooth += (int)Math.signum(this.completion - this.completionSmooth);
        this.treasureProgressSmooth += (int)Math.signum(this.treasureProgress - this.treasureProgressSmooth);
        if (this.tickCount % 5 == 0 && this.gracePeriod < 0) {
            this.completion -= this.decay;
        }
        if (this.completionSmooth < 0) {
            this.m_7379_();
        }
        if (this.completionSmooth > 75) {
            boolean awardTreasure = this.treasureProgressSmooth > 100 || this.perfectCatch && this.hook.m_150930_((Item)ModItems.MOSSY_HOOK.get());
            Payloads.CHANNEL.send(PacketDistributor.SERVER.with(null), (Object)new Payloads.FishingCompletedPayload(this.tickCount, awardTreasure, this.perfectCatch, this.consecutiveHits));
            this.m_7379_();
        }
        this.hitParticles.removeIf(HitFakeParticle::tick);
    }

    public void m_7379_() {
        Minecraft.m_91087_().f_91066_.m_231928_().m_231514_((Object)this.previousGuiScale);
        Minecraft.m_91087_().m_5741_();
        Payloads.CHANNEL.send(PacketDistributor.SERVER.with(null), (Object)new Payloads.FishingCompletedPayload(-1, false, false, this.consecutiveHits));
        this.f_96541_.popGuiLayer();
    }

    private void addParticles(int posInDegrees, int count) {
        this.addParticles(posInDegrees, count, false);
    }

    private void addParticles(int posInDegrees, int count, boolean treasure) {
        int xPos = (int)(30.0 * Math.cos(Math.toRadians(posInDegrees - 90)));
        int yPos = (int)(30.0 * Math.sin(Math.toRadians(posInDegrees - 90)));
        for (int i = 0; i < count; ++i) {
            if (this.bobber.m_150930_((Item)ModItems.GLITTER_BOBBER.get())) {
                this.hitParticles.add(new HitFakeParticle(xPos, yPos, new Vector2d((double)(r.nextFloat() * 2.0f - 1.0f), (double)(r.nextFloat() * 2.0f - 1.0f)), r.nextFloat(), r.nextFloat(), r.nextFloat(), 1.0f));
                continue;
            }
            if (this.bobber.m_150930_((Item)ModItems.COLORFUL_BOBBER.get())) {
                this.hitParticles.add(new HitFakeParticle(xPos, yPos, new Vector2d((double)(r.nextFloat() * 2.0f - 1.0f), (double)(r.nextFloat() * 2.0f - 1.0f)), DataComponents.getBobberColor(this.bobber).r(), DataComponents.getBobberColor(this.bobber).g(), DataComponents.getBobberColor(this.bobber).b(), 1.0f));
                continue;
            }
            if (treasure) {
                this.hitParticles.add(new HitFakeParticle(xPos, yPos, new Vector2d((double)(r.nextFloat() * 2.0f - 1.0f), (double)(r.nextFloat() * 2.0f - 1.0f)), 0.7f + r.nextFloat() / 3.0f, 0.5f, 0.5f, 1.0f));
                continue;
            }
            this.hitParticles.add(new HitFakeParticle(xPos, yPos, new Vector2d((double)(r.nextFloat() * 2.0f - 1.0f), (double)(r.nextFloat() * 2.0f - 1.0f))));
        }
    }

    public boolean m_7043_() {
        return false;
    }
}

