/*
 * Decompiled with CFR 0.152.
 */
package com.wdiscute.starcatcher.networkandcodecs;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.wdiscute.starcatcher.networkandcodecs.DataAttachments;
import com.wdiscute.starcatcher.networkandcodecs.FishProperties;
import com.wdiscute.starcatcher.networkandcodecs.Payloads;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.PacketDistributor;

public record FishCaughtCounter(FishProperties fp, int count, int fastestTicks, float averageTicks, int size, int weight, boolean caughtGolden) {
    public static final Codec<FishCaughtCounter> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)FishProperties.CODEC.fieldOf("fps").forGetter(FishCaughtCounter::fp), (App)Codec.INT.optionalFieldOf("count", (Object)0).forGetter(FishCaughtCounter::count), (App)Codec.INT.optionalFieldOf("fastest_ticks", (Object)0).forGetter(FishCaughtCounter::fastestTicks), (App)Codec.FLOAT.optionalFieldOf("average_ticks", (Object)Float.valueOf(0.0f)).forGetter(FishCaughtCounter::averageTicks), (App)Codec.INT.optionalFieldOf("best_size", (Object)0).forGetter(FishCaughtCounter::size), (App)Codec.INT.optionalFieldOf("best_weight", (Object)0).forGetter(FishCaughtCounter::weight), (App)Codec.BOOL.optionalFieldOf("caught_golden", (Object)false).forGetter(FishCaughtCounter::caughtGolden)).apply((Applicative)instance, FishCaughtCounter::new));
    public static final Codec<List<FishCaughtCounter>> LIST_CODEC = CODEC.listOf();

    public static boolean AwardFishCaughtCounter(FishProperties fpCaught, Player player, int ticks, int size, int weight) {
        List<FishCaughtCounter> listFishCaughtCounter = DataAttachments.get(player).fishesCaught();
        ArrayList<FishCaughtCounter> newlist = new ArrayList<FishCaughtCounter>();
        boolean newFish = true;
        for (FishCaughtCounter fcc : listFishCaughtCounter) {
            if (fpCaught.equals(fcc.fp)) {
                int fastestToSave = Math.min(fcc.fastestTicks, ticks);
                float averageToSave = (fcc.averageTicks * (float)fcc.count + (float)ticks) / (float)(fcc.count + 1);
                int countToSave = fcc.count;
                if (fcc.fastestTicks == 0) {
                    fastestToSave = ticks;
                }
                if (fcc.averageTicks == 0.0f) {
                    averageToSave = ticks;
                }
                if (fcc.count == 999999) {
                    countToSave = 0;
                }
                int sizeToSave = Math.max(size, fcc.size);
                int weightToSave = Math.max(weight, fcc.weight);
                newlist.add(new FishCaughtCounter(fpCaught, countToSave + 1, fastestToSave, averageToSave, sizeToSave, weightToSave, false));
                newFish = false;
                continue;
            }
            newlist.add(fcc);
        }
        if (newFish) {
            newlist.add(new FishCaughtCounter(fpCaught, 1, ticks, ticks, size, weight, false));
        }
        Payloads.CHANNEL.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new Payloads.FishCaughtPayload(fpCaught, newFish, size, weight));
        DataAttachments.get(player).setFishesCaught(newlist);
        return newFish;
    }
}

