/*
 * Decompiled with CFR 0.152.
 */
package com.wdiscute.starcatcher;

import com.wdiscute.starcatcher.Config;
import com.wdiscute.starcatcher.ModCreativeModeTabs;
import com.wdiscute.starcatcher.ModEntities;
import com.wdiscute.starcatcher.ModItemProperties;
import com.wdiscute.starcatcher.ModItems;
import com.wdiscute.starcatcher.ModMenuTypes;
import com.wdiscute.starcatcher.ModParticles;
import com.wdiscute.starcatcher.ModSounds;
import com.wdiscute.starcatcher.Tooltips;
import com.wdiscute.starcatcher.blocks.ModBlockEntities;
import com.wdiscute.starcatcher.blocks.ModBlocks;
import com.wdiscute.starcatcher.bob.FishingBobModel;
import com.wdiscute.starcatcher.bob.FishingBobRenderer;
import com.wdiscute.starcatcher.fishentity.FishEntity;
import com.wdiscute.starcatcher.fishentity.FishRenderer;
import com.wdiscute.starcatcher.fishspotter.FishTrackerLayer;
import com.wdiscute.starcatcher.guide.FishCaughtToast;
import com.wdiscute.starcatcher.guide.SettingsScreen;
import com.wdiscute.starcatcher.networkandcodecs.DataAttachmentCapability;
import com.wdiscute.starcatcher.networkandcodecs.DataAttachments;
import com.wdiscute.starcatcher.networkandcodecs.DataComponents;
import com.wdiscute.starcatcher.networkandcodecs.FishProperties;
import com.wdiscute.starcatcher.networkandcodecs.Payloads;
import com.wdiscute.starcatcher.networkandcodecs.SizeAndWeight;
import com.wdiscute.starcatcher.networkandcodecs.TrophyProperties;
import com.wdiscute.starcatcher.particles.FishingBitingLavaParticles;
import com.wdiscute.starcatcher.particles.FishingBitingParticles;
import com.wdiscute.starcatcher.particles.FishingNotificationParticles;
import com.wdiscute.starcatcher.rod.FishingRodScreen;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.client.renderer.entity.ThrownItemRenderer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.DataPackRegistryEvent;

@Mod(value="starcatcher")
public class Starcatcher {
    public static final String MOD_ID = "starcatcher";
    public static final ResourceKey<Registry<FishProperties>> FISH_REGISTRY = ResourceKey.m_135788_((ResourceLocation)Starcatcher.rl("fish"));
    public static final ResourceKey<Registry<TrophyProperties>> TROPHY_REGISTRY = ResourceKey.m_135788_((ResourceLocation)Starcatcher.rl("trophy"));
    public static final Random r = new Random();

    public static ResourceLocation rl(String s) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)s);
    }

    public static double truncatedNormal(double mean, double deviation) {
        double value;
        while (!((value = mean + deviation * r.nextGaussian()) >= mean - deviation) || !(value <= mean + deviation)) {
        }
        return value;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void fishCaughtToast(FishProperties fp, boolean newFish, int sizeCM, int weightCM) {
        if (newFish) {
            Minecraft.m_91087_().m_91300_().m_94922_((Toast)new FishCaughtToast(fp));
        }
        SettingsScreen.Units units = (SettingsScreen.Units)((Object)Config.UNIT.get());
        String size = units.getSizeAsString(sizeCM);
        String weight = units.getWeightAsString(weightCM);
        Minecraft.m_91087_().f_91074_.m_5661_((Component)Component.m_237113_((String)"").m_7220_((Component)Component.m_237115_((String)((Item)fp.fish().m_203334_()).m_5524_())).m_7220_((Component)Component.m_237113_((String)(" - " + size + " - " + weight))), true);
        Minecraft.m_91087_().f_91065_.f_92991_ = 180;
    }

    public Starcatcher(FMLJavaModLoadingContext context) {
        IEventBus eventBus = context.getModEventBus();
        ModCreativeModeTabs.register(eventBus);
        ModItems.register(eventBus);
        ModBlocks.register(eventBus);
        ModBlockEntities.register(eventBus);
        ModSounds.register(eventBus);
        ModEntities.register(eventBus);
        ModParticles.register(eventBus);
        ModMenuTypes.register(eventBus);
        Payloads.register();
        context.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)Config.SPEC);
        context.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)Config.SPEC_SERVER);
    }

    @OnlyIn(value=Dist.CLIENT)
    @Mod.EventBusSubscriber(modid="starcatcher", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ModClientEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            EntityRenderers.m_174036_(ModEntities.FISHING_BOB.get(), FishingBobRenderer::new);
            EntityRenderers.m_174036_(ModEntities.BOTTLE.get(), ThrownItemRenderer::new);
            EntityRenderers.m_174036_(ModEntities.FISH.get(), FishRenderer::new);
            ModItemProperties.addCustomItemProperties();
            MenuScreens.m_96206_((MenuType)((MenuType)ModMenuTypes.FISHING_ROD_MENU.get()), FishingRodScreen::new);
        }

        @SubscribeEvent
        public static void FishSpotterLayer(RegisterGuiOverlaysEvent event) {
            event.registerAboveAll("fish_tracker", (IGuiOverlay)new FishTrackerLayer());
        }

        @SubscribeEvent
        public static void registerParticleFactories(RegisterParticleProvidersEvent event) {
            event.registerSpriteSet((ParticleType)ModParticles.FISHING_NOTIFICATION.get(), FishingNotificationParticles.Provider::new);
            event.registerSpriteSet((ParticleType)ModParticles.FISHING_BITING.get(), FishingBitingParticles.Provider::new);
            event.registerSpriteSet((ParticleType)ModParticles.FISHING_BITING_LAVA.get(), FishingBitingLavaParticles.Provider::new);
        }

        @SubscribeEvent
        public static void registerLayers(EntityRenderersEvent.RegisterLayerDefinitions event) {
            event.registerLayerDefinition(FishingBobModel.LAYER_LOCATION, FishingBobModel::createBodyLayer);
        }
    }

    @Mod.EventBusSubscriber(modid="starcatcher", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class ModEvents {
        @SubscribeEvent
        public static void addRegistry(DataPackRegistryEvent.NewRegistry event) {
            event.dataPackRegistry(FISH_REGISTRY, FishProperties.CODEC, FishProperties.CODEC);
            event.dataPackRegistry(TROPHY_REGISTRY, TrophyProperties.CODEC, TrophyProperties.CODEC);
        }

        @SubscribeEvent
        public static void registerAttributed(EntityAttributeCreationEvent event) {
            event.put(ModEntities.FISH.get(), FishEntity.m_27495_().m_22265_());
        }
    }

    @Mod.EventBusSubscriber(modid="starcatcher", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class IHateForge {
        @SubscribeEvent
        public static void attachEvent(AttachCapabilitiesEvent<Entity> event) {
            Object object = event.getObject();
            if (!(object instanceof Player)) {
                return;
            }
            Player player = (Player)object;
            final DataAttachments modCapabilities = new DataAttachments(player);
            final LazyOptional optionalStorage = LazyOptional.of(() -> modCapabilities);
            ICapabilitySerializable<CompoundTag> provider = new ICapabilitySerializable<CompoundTag>(){

                public CompoundTag serializeNBT() {
                    return modCapabilities.serializeNBT();
                }

                public void deserializeNBT(CompoundTag tag) {
                    modCapabilities.deserializeNBT(tag);
                }

                public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction direction) {
                    if (cap == DataAttachmentCapability.PLAYER_DATA) {
                        return optionalStorage.cast();
                    }
                    return LazyOptional.empty();
                }
            };
            event.addCapability(Starcatcher.rl("fish"), (ICapabilityProvider)provider);
        }

        @SubscribeEvent
        public static void playerLogInEvent(PlayerEvent.PlayerLoggedInEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)player;
                DataAttachmentCapability playerCap = DataAttachments.get(player);
                Payloads.CHANNEL.send(PacketDistributor.PLAYER.with(() -> sp), (Object)new Payloads.FishesCaughtPayload(playerCap.fishesCaught(), (Player)sp));
                Payloads.CHANNEL.send(PacketDistributor.PLAYER.with(() -> sp), (Object)new Payloads.TrophiesCaughtPayload(playerCap.trophiesCaught()));
                Payloads.CHANNEL.send(PacketDistributor.PLAYER.with(() -> sp), (Object)new Payloads.FishesNotificationPayload(playerCap.fishNotifications(), (Player)sp));
            }
        }

        @SubscribeEvent
        public static void trophyTooltip(ItemTooltipEvent event) {
            List comp = event.getToolTip();
            ItemStack stack = event.getItemStack();
            SizeAndWeight wdad = DataComponents.getSizeAndWeight(stack);
            if (!DataComponents.getSizeAndWeight(stack).equals(SizeAndWeight.DEFAULT)) {
                SizeAndWeight sw = DataComponents.getSizeAndWeight(stack);
                SettingsScreen.Units units = (SettingsScreen.Units)((Object)Config.UNIT.get());
                String size = units.getSizeAsString(sw.sizeInCentimeters());
                String weight = units.getWeightAsString(sw.weightInGrams());
                comp.add(1, Component.m_237113_((String)(size + " - " + weight)).m_130948_(Style.f_131099_.m_178520_(0x888888)));
            }
            if (!DataComponents.getTrophyProperties(stack).equals(TrophyProperties.DEFAULT)) {
                TrophyProperties tp = DataComponents.getTrophyProperties(stack);
                comp.set(0, ((Component)comp.get(0)).m_6881_().m_130948_(Style.f_131099_.m_131155_(Boolean.valueOf(false))));
                if (tp.trophyType() == TrophyProperties.TrophyType.TROPHY) {
                    if (Screen.m_96638_()) {
                        comp.add(Component.m_237115_((String)"tooltip.libtooltips.generic.shift_down"));
                        comp.add(Component.m_237115_((String)"tooltip.libtooltips.generic.empty"));
                        comp.add(Component.m_237115_((String)"tooltip.starcatcher.trophy.0"));
                        comp.add(Component.m_237115_((String)"tooltip.starcatcher.trophy.1"));
                        ArrayList<Component> list = new ArrayList<Component>();
                        if (tp.all().total() != 0) {
                            list.add(Tooltips.decodeString(I18n.m_118938_((String)"tooltip.starcatcher.trophy.total", (Object[])new Object[0]).replace("&", "" + tp.all().total()).replace("$", I18n.m_118938_((String)"tooltip.starcatcher.trophy.all", (Object[])new Object[0]))));
                        }
                        if (tp.all().unique() != 0) {
                            list.add(Tooltips.decodeString(I18n.m_118938_((String)"tooltip.starcatcher.trophy.unique", (Object[])new Object[0]).replace("&", "" + tp.all().unique()).replace("$", I18n.m_118938_((String)"tooltip.starcatcher.trophy.all", (Object[])new Object[0]))));
                        }
                        if (tp.common().total() != 0) {
                            list.add(Tooltips.decodeString(I18n.m_118938_((String)"tooltip.starcatcher.trophy.total", (Object[])new Object[0]).replace("&", "" + tp.common().total()).replace("$", I18n.m_118938_((String)"tooltip.starcatcher.trophy.common", (Object[])new Object[0]))));
                        }
                        if (tp.common().unique() != 0) {
                            list.add(Tooltips.decodeString(I18n.m_118938_((String)"tooltip.starcatcher.trophy.unique", (Object[])new Object[0]).replace("&", "" + tp.common().unique()).replace("$", I18n.m_118938_((String)"tooltip.starcatcher.trophy.common", (Object[])new Object[0]))));
                        }
                        if (tp.uncommon().total() != 0) {
                            list.add(Tooltips.decodeString(I18n.m_118938_((String)"tooltip.starcatcher.trophy.total", (Object[])new Object[0]).replace("&", "" + tp.uncommon().total()).replace("$", I18n.m_118938_((String)"tooltip.starcatcher.trophy.uncommon", (Object[])new Object[0]))));
                        }
                        if (tp.uncommon().unique() != 0) {
                            list.add(Tooltips.decodeString(I18n.m_118938_((String)"tooltip.starcatcher.trophy.unique", (Object[])new Object[0]).replace("&", "" + tp.uncommon().unique()).replace("$", I18n.m_118938_((String)"tooltip.starcatcher.trophy.uncommon", (Object[])new Object[0]))));
                        }
                        if (tp.rare().total() != 0) {
                            list.add(Tooltips.decodeString(I18n.m_118938_((String)"tooltip.starcatcher.trophy.total", (Object[])new Object[0]).replace("&", "" + tp.rare().total()).replace("$", I18n.m_118938_((String)"tooltip.starcatcher.trophy.rare", (Object[])new Object[0]))));
                        }
                        if (tp.rare().unique() != 0) {
                            list.add(Tooltips.decodeString(I18n.m_118938_((String)"tooltip.starcatcher.trophy.unique", (Object[])new Object[0]).replace("&", "" + tp.rare().unique()).replace("$", I18n.m_118938_((String)"tooltip.starcatcher.trophy.rare", (Object[])new Object[0]))));
                        }
                        if (tp.epic().total() != 0) {
                            list.add(Tooltips.decodeString(I18n.m_118938_((String)"tooltip.starcatcher.trophy.total", (Object[])new Object[0]).replace("&", "" + tp.epic().total()).replace("$", I18n.m_118938_((String)"tooltip.starcatcher.trophy.epic", (Object[])new Object[0]))));
                        }
                        if (tp.epic().unique() != 0) {
                            list.add(Tooltips.decodeString(I18n.m_118938_((String)"tooltip.starcatcher.trophy.unique", (Object[])new Object[0]).replace("&", "" + tp.epic().unique()).replace("$", I18n.m_118938_((String)"tooltip.starcatcher.trophy.epic", (Object[])new Object[0]))));
                        }
                        if (tp.legendary().total() != 0) {
                            list.add(Tooltips.decodeString(I18n.m_118938_((String)"tooltip.starcatcher.trophy.total", (Object[])new Object[0]).replace("&", "" + tp.legendary().total()).replace("$", I18n.m_118938_((String)"tooltip.starcatcher.trophy.legendary", (Object[])new Object[0]))));
                        }
                        if (tp.legendary().unique() != 0) {
                            list.add(Tooltips.decodeString(I18n.m_118938_((String)"tooltip.starcatcher.trophy.unique", (Object[])new Object[0]).replace("&", "" + tp.legendary().unique()).replace("$", I18n.m_118938_((String)"tooltip.starcatcher.trophy.legendary", (Object[])new Object[0]))));
                        }
                        if (list.size() == 1) {
                            comp.add(Component.m_237115_((String)"tooltip.starcatcher.trophy.once").m_7220_((Component)list.get(0)).m_7220_((Component)Component.m_237115_((String)"tooltip.starcatcher.trophy.have_been_caught")));
                        } else {
                            comp.add(Component.m_237115_((String)"tooltip.starcatcher.trophy.2"));
                            comp.addAll(list);
                        }
                    } else {
                        comp.add(Component.m_237115_((String)"tooltip.libtooltips.generic.shift_up"));
                    }
                }
            }
        }
    }
}

