/*
 * Decompiled with CFR 0.152.
 */
package com.wdiscute.starcatcher.bob;

import com.wdiscute.starcatcher.ModEntities;
import com.wdiscute.starcatcher.ModItems;
import com.wdiscute.starcatcher.ModParticles;
import com.wdiscute.starcatcher.Starcatcher;
import com.wdiscute.starcatcher.StarcatcherTags;
import com.wdiscute.starcatcher.networkandcodecs.DataAttachments;
import com.wdiscute.starcatcher.networkandcodecs.DataComponents;
import com.wdiscute.starcatcher.networkandcodecs.FishCaughtCounter;
import com.wdiscute.starcatcher.networkandcodecs.FishProperties;
import com.wdiscute.starcatcher.networkandcodecs.Payloads;
import com.wdiscute.starcatcher.networkandcodecs.TrophyProperties;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PacketDistributor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FishingBobEntity
extends Projectile {
    private static final Logger log = LoggerFactory.getLogger(FishingBobEntity.class);
    public static final EntityDataAccessor<Integer> STATE = SynchedEntityData.m_135353_(FishingBobEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<ItemStack> BOBBER = SynchedEntityData.m_135353_(FishingBobEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    public final Player player;
    private FishHookState currentState;
    public FishProperties fpToFish;
    public ItemStack rod = ItemStack.f_41583_;
    public ItemStack bobber = ItemStack.f_41583_;
    public ItemStack hook = ItemStack.f_41583_;
    public ItemStack bait = ItemStack.f_41583_;
    int minTicksToFish;
    int maxTicksToFish;
    int chanceToFishEachTick;
    int timeBiting;
    int ticksInFluid;

    public FishingBobEntity(EntityType<? extends FishingBobEntity> entityType, Level level) {
        super(entityType, level);
        this.player = null;
    }

    public FishingBobEntity(Level level, Player player, ItemStack rod) {
        super(ModEntities.FISHING_BOB.get(), level);
        this.player = player;
        this.rod = rod;
        this.bobber = DataComponents.getItemInSlot(rod, DataComponents.Slots.BOBBER);
        this.bait = DataComponents.getItemInSlot(rod, DataComponents.Slots.BAIT);
        this.hook = DataComponents.getItemInSlot(rod, DataComponents.Slots.HOOK);
        this.m_5602_((Entity)player);
        this.minTicksToFish = 100;
        this.maxTicksToFish = 300;
        this.chanceToFishEachTick = 100;
        if (this.bobber.m_150930_((Item)ModItems.IMPATIENT_BOBBER.get())) {
            this.chanceToFishEachTick = 200;
        }
        float f = player.m_146909_();
        float f1 = player.m_146908_();
        float f2 = Mth.m_14089_((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = Mth.m_14031_((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = -Mth.m_14089_((float)(-f * ((float)Math.PI / 180)));
        float f5 = Mth.m_14031_((float)(-f * ((float)Math.PI / 180)));
        double d0 = player.m_20185_() - (double)f3 * 0.3;
        double d1 = player.m_20188_();
        double d2 = player.m_20189_() - (double)f2 * 0.3;
        this.m_7678_(d0, d1, d2, f1, f);
        Vec3 vec3 = new Vec3((double)(-f3), (double)Mth.m_14036_((float)(-(f5 / f4)), (float)-5.0f, (float)5.0f), (double)(-f2));
        double d3 = vec3.m_82553_();
        vec3 = vec3.m_82542_(0.6 / d3 + this.f_19796_.m_216328_(0.5, 0.0103365), 0.6 / d3 + this.f_19796_.m_216328_(0.5, 0.0103365), 0.6 / d3 + this.f_19796_.m_216328_(0.5, 0.0103365));
        this.m_20256_(vec3);
        this.m_146922_((float)(Mth.m_14136_((double)vec3.f_82479_, (double)vec3.f_82481_) * 180.0 / 3.1415927410125732));
        this.m_146926_((float)(Mth.m_14136_((double)vec3.f_82480_, (double)vec3.m_165924_()) * 180.0 / 3.1415927410125732));
        this.f_19859_ = this.m_146908_();
        this.f_19860_ = this.m_146909_();
        if (!level.f_46443_) {
            DataAttachments.get(player).setFishing(this.f_19820_.toString());
        }
        this.currentState = FishHookState.FLYING;
    }

    public void reel() {
        ArrayList<FishProperties> available = new ArrayList<FishProperties>(List.of());
        ArrayList<TrophyProperties> trophiesCaught = new ArrayList<TrophyProperties>(DataAttachments.get(this.player).trophiesCaught());
        TrophyProperties.RarityProgress all = new TrophyProperties.RarityProgress(0, DataAttachments.get(this.player).fishesCaught().size() - 1);
        TrophyProperties.RarityProgress common = new TrophyProperties.RarityProgress(0, -1);
        TrophyProperties.RarityProgress uncommon = TrophyProperties.RarityProgress.DEFAULT;
        TrophyProperties.RarityProgress rare = TrophyProperties.RarityProgress.DEFAULT;
        TrophyProperties.RarityProgress epic = TrophyProperties.RarityProgress.DEFAULT;
        TrophyProperties.RarityProgress legendary = TrophyProperties.RarityProgress.DEFAULT;
        for (FishCaughtCounter fcc : DataAttachments.get(this.player).fishesCaught()) {
            all = new TrophyProperties.RarityProgress(all.total() + fcc.count(), all.unique());
            if (fcc.fp().rarity() == FishProperties.Rarity.COMMON) {
                common = new TrophyProperties.RarityProgress(common.total() + fcc.count(), common.unique() + 1);
            }
            if (fcc.fp().rarity() == FishProperties.Rarity.UNCOMMON) {
                uncommon = new TrophyProperties.RarityProgress(uncommon.total() + fcc.count(), uncommon.unique() + 1);
            }
            if (fcc.fp().rarity() == FishProperties.Rarity.RARE) {
                rare = new TrophyProperties.RarityProgress(rare.total() + fcc.count(), rare.unique() + 1);
            }
            if (fcc.fp().rarity() == FishProperties.Rarity.EPIC) {
                epic = new TrophyProperties.RarityProgress(epic.total() + fcc.count(), epic.unique() + 1);
            }
            if (fcc.fp().rarity() != FishProperties.Rarity.LEGENDARY) continue;
            legendary = new TrophyProperties.RarityProgress(legendary.total() + fcc.count(), legendary.unique() + 1);
        }
        for (TrophyProperties tp : this.m_9236_().m_9598_().m_175515_(Starcatcher.TROPHY_REGISTRY)) {
            if (!FishingBobEntity.check(all, tp.all()) || !FishingBobEntity.check(common, tp.common()) || !FishingBobEntity.check(uncommon, tp.uncommon()) || !FishingBobEntity.check(rare, tp.rare()) || !FishingBobEntity.check(epic, tp.epic()) || !FishingBobEntity.check(legendary, tp.legendary()) || trophiesCaught.contains(tp) || FishProperties.getChance(tp.fp(), (Entity)this, new ItemStack((ItemLike)ModItems.ROD.get())) <= 0 || this.f_19796_.m_216332_(0, 99) >= tp.chanceToCatch()) continue;
            ItemStack is = new ItemStack(tp.fp().fish());
            DataComponents.setTrophyProperties(is, tp);
            if (!tp.customName().isEmpty()) {
                is.m_41714_((Component)Component.m_237113_((String)tp.customName()));
            }
            ItemEntity itemFished = new ItemEntity(this.m_9236_(), this.m_20182_().f_82479_, this.m_20182_().f_82480_ + (double)1.2f, this.m_20182_().f_82481_, is);
            Vec3 vec3 = new Vec3(Mth.m_14008_((double)((this.player.m_20182_().f_82479_ - this.m_20182_().f_82479_) / 25.0), (double)-1.0, (double)1.0), 0.7 + Mth.m_14008_((double)((this.player.m_20182_().f_82480_ - this.m_20182_().f_82480_) / 20.0), (double)-1.0, (double)1.0), Mth.m_14008_((double)((this.player.m_20182_().f_82481_ - this.m_20182_().f_82481_) / 25.0), (double)-1.0, (double)1.0));
            itemFished.m_20256_(vec3);
            this.m_9236_().m_7967_((Entity)itemFished);
            trophiesCaught.add(tp);
            DataAttachments.get(this.player).setTrophiesCaught(trophiesCaught);
            DataAttachments.get(this.player).setFishing("");
            this.m_6074_();
            return;
        }
        for (FishProperties fp : this.m_9236_().m_9598_().m_175515_(Starcatcher.FISH_REGISTRY)) {
            int chance = FishProperties.getChance(fp, (Entity)this, this.rod);
            for (int i = 0; i < chance; ++i) {
                available.add(fp);
            }
        }
        if (available.isEmpty()) {
            DataAttachments.get(this.player).setFishing("");
            this.m_146870_();
        }
        this.fpToFish = (FishProperties)available.get(this.f_19796_.m_188503_(available.size()));
        if (this.fpToFish.skipMinigame() || this.bobber.m_150930_((Item)ModItems.CREEPER_BOBBER.get())) {
            ItemEntity itemFished = new ItemEntity(this.m_9236_(), this.m_20182_().f_82479_, this.m_20182_().f_82480_ + (double)1.2f, this.m_20182_().f_82481_, new ItemStack(this.fpToFish.fish()));
            double x = (this.player.m_20182_().f_82479_ - this.m_20182_().f_82479_) / 25.0;
            double y = (this.player.m_20182_().f_82480_ - this.m_20182_().f_82480_) / 20.0;
            double z = (this.player.m_20182_().f_82481_ - this.m_20182_().f_82481_) / 25.0;
            x = org.joml.Math.clamp((double)x, (double)-1.0, (double)1.0);
            y = org.joml.Math.clamp((double)y, (double)-1.0, (double)1.0);
            z = org.joml.Math.clamp((double)z, (double)-1.0, (double)1.0);
            if (this.bobber.m_150930_((Item)ModItems.CREEPER_BOBBER.get()) && (double)this.f_19796_.m_188501_() > 0.8) {
                itemFished = new Creeper(EntityType.f_20558_, this.m_9236_());
                itemFished.m_146884_(this.m_20182_().m_82520_(0.0, (double)1.2f, 0.0));
                x *= 2.5;
                y *= 2.0;
                z *= 2.5;
            }
            Vec3 vec3 = new Vec3(x, 0.7 + y, z);
            itemFished.m_20256_(vec3);
            this.m_9236_().m_7967_((Entity)itemFished);
            DataAttachments.get(this.player).setFishing("");
            this.m_6074_();
        } else {
            Player player = this.player;
            if (player instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)player;
                Payloads.CHANNEL.send(PacketDistributor.PLAYER.with(() -> sp), (Object)new Payloads.FishingPayload(this.fpToFish, this.rod));
            }
        }
        if (this.fpToFish.br().consumesBait()) {
            if (this.bobber.m_150930_((Item)ModItems.FRUGAL_BOBBER.get())) {
                if (this.f_19796_.m_188501_() > 0.8f) {
                    this.bait.m_41764_(this.bait.m_41613_() - 1);
                }
            } else {
                this.bait.m_41764_(this.bait.m_41613_() - 1);
            }
            DataComponents.setItemInSlot(this.rod, DataComponents.Slots.BAIT, this.bait);
        }
    }

    private boolean shouldStopFishing(Player player) {
        boolean holdingRod;
        if (this.m_9236_().f_46443_) {
            return false;
        }
        boolean bl = holdingRod = player.m_21205_().m_150930_((Item)ModItems.ROD.get()) || player.m_21206_().m_150930_((Item)ModItems.ROD.get());
        if (!player.m_213877_() && player.m_6084_() && holdingRod && !(this.m_20280_((Entity)player) > 1024.0)) {
            return false;
        }
        DataAttachments.get(player).setFishing("");
        this.m_146870_();
        return true;
    }

    public boolean m_5825_() {
        return this.hook.m_204117_(StarcatcherTags.HOOKS_SURVIVE_FIRE);
    }

    public void m_20093_() {
        super.m_20093_();
        if (!this.hook.m_204117_(StarcatcherTags.HOOKS_SURVIVE_FIRE) && !this.m_9236_().f_46443_) {
            DataAttachments.get(this.player).setFishing("");
            this.m_6074_();
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            if (this.currentState == FishHookState.FLYING) {
                this.f_19804_.m_135381_(STATE, (Object)1);
            }
            if (this.currentState == FishHookState.BOBBING) {
                this.f_19804_.m_135381_(STATE, (Object)2);
            }
            if (this.currentState == FishHookState.BITING) {
                this.f_19804_.m_135381_(STATE, (Object)3);
            }
            if (this.currentState == FishHookState.FISHING) {
                this.f_19804_.m_135381_(STATE, (Object)4);
            }
            this.f_19804_.m_135381_(BOBBER, (Object)this.bobber);
        } else {
            if ((Integer)this.f_19804_.m_135370_(STATE) == 1) {
                this.currentState = FishHookState.FLYING;
            }
            if ((Integer)this.f_19804_.m_135370_(STATE) == 2) {
                this.currentState = FishHookState.BOBBING;
            }
            if ((Integer)this.f_19804_.m_135370_(STATE) == 3) {
                this.currentState = FishHookState.BITING;
            }
            if ((Integer)this.f_19804_.m_135370_(STATE) == 4) {
                this.currentState = FishHookState.FISHING;
            }
            this.bobber = (ItemStack)this.f_19804_.m_135370_(BOBBER);
        }
        Player player = (Player)this.m_19749_();
        if (player == null || this.shouldStopFishing(player)) {
            this.m_146870_();
        }
        BlockPos blockpos = this.m_20183_();
        FluidState fluid = this.m_9236_().m_6425_(blockpos);
        FluidState fluidBellow = this.m_9236_().m_6425_(blockpos.m_7495_());
        if (this.currentState == FishHookState.FLYING) {
            if (this.m_20184_().f_82480_ < (double)1.2f) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, -0.02, 0.0));
            }
            if (!fluid.m_76178_()) {
                this.m_20256_(this.m_20184_().m_82542_(0.3, 0.3, 0.3));
                if (!this.m_9236_().f_46443_) {
                    this.currentState = FishHookState.BOBBING;
                }
                return;
            }
        }
        if (this.currentState == FishHookState.BITING) {
            ++this.timeBiting;
            for (int i = 0; i < 5; ++i) {
                this.m_9236_().m_7106_((ParticleOptions)ModParticles.FISHING_BITING.get(), this.m_20182_().f_82479_ + (double)this.f_19796_.m_188501_() - 0.5, this.m_20182_().f_82480_ + (double)this.f_19796_.m_188501_() * 0.5 - 0.25, this.m_20182_().f_82481_ + (double)this.f_19796_.m_188501_() - 0.5, 0.0, 0.0, 0.0);
            }
            if (this.timeBiting > 80) {
                DataAttachments.get(player).setFishing("");
                this.m_6074_();
            }
        } else {
            this.timeBiting = 0;
        }
        if (fluid.m_76178_() && fluidBellow.m_76178_() && !this.m_9236_().f_46443_) {
            this.currentState = FishHookState.FLYING;
        }
        if (this.currentState == FishHookState.BOBBING || this.currentState == FishHookState.FISHING) {
            this.checkForFish();
            if (!fluid.m_76178_()) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, 0.01, 0.0));
            } else if ((double)this.f_19796_.m_188501_() > 0.02) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, -0.03, 0.0));
            } else {
                this.m_20256_(this.m_20184_().m_82520_(0.0, -0.01, 0.0));
            }
        }
        this.m_6478_(MoverType.SELF, this.m_20184_());
        if (this.m_20096_() || this.f_19862_) {
            this.m_20256_(Vec3.f_82478_);
        }
        this.m_20256_(this.m_20184_().m_82490_(0.92));
        this.m_20090_();
    }

    public boolean checkBiting() {
        if (this.currentState == FishHookState.BITING) {
            this.currentState = FishHookState.FISHING;
            this.reel();
            return true;
        }
        return false;
    }

    private void checkForFish() {
        if (!this.m_9236_().f_46443_ && this.currentState == FishHookState.BOBBING) {
            ++this.ticksInFluid;
            int i = this.f_19796_.m_188503_(this.chanceToFishEachTick);
            if ((i == 1 || this.ticksInFluid > this.maxTicksToFish) && this.ticksInFluid > this.minTicksToFish) {
                ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ModParticles.FISHING_NOTIFICATION.get(), this.m_20182_().f_82479_, this.m_20182_().f_82480_ + 1.0, this.m_20182_().f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
                this.m_6034_(this.m_20182_().f_82479_, this.m_20182_().f_82480_ - 0.5, this.m_20182_().f_82481_);
                if (!this.m_9236_().f_46443_) {
                    this.currentState = FishHookState.BITING;
                }
                this.m_5496_(SoundEvents.f_11940_, 0.25f, 1.0f + (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.4f);
            }
        }
    }

    public AABB m_6921_() {
        AABB box = new AABB(-10.0, -10.0, -10.0, 10.0, 10.0, 10.0);
        return box.m_82383_(this.m_20182_());
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(STATE, (Object)0);
        this.f_19804_.m_135372_(BOBBER, (Object)ItemStack.f_41583_);
    }

    public static boolean check(TrophyProperties.RarityProgress current, TrophyProperties.RarityProgress restriction) {
        return current.total() >= restriction.total() && current.unique() >= restriction.unique();
    }

    static enum FishHookState {
        FLYING,
        BOBBING,
        BITING,
        FISHING;

    }
}

