/*
 * Decompiled with CFR 0.152.
 */
package com.wdiscute.starcatcher.guide;

import com.wdiscute.starcatcher.Starcatcher;
import com.wdiscute.starcatcher.networkandcodecs.FishProperties;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.components.toasts.ToastComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.ItemStack;
import org.joml.Math;

public class FishCaughtToast
implements Toast {
    private static final ResourceLocation BACKGROUND_SPRITE = Starcatcher.rl("textures/gui/toast/fish_caught.png");
    private final Component title;
    private final String description;
    private static final String gibberish = "\u00a7kaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa";
    private int old;
    private static final Random r = new Random();
    private final ItemStack is;

    public FishCaughtToast(FishProperties fp) {
        this.is = new ItemStack(fp.fish());
        this.title = Component.m_237115_((String)"gui.starcatcher.toast.fish_caught");
        this.description = this.is.m_41786_().getString();
    }

    public Toast.Visibility m_7172_(GuiGraphics guiGraphics, ToastComponent toastComponent, long timeSinceLastVisible) {
        guiGraphics.m_280163_(BACKGROUND_SPRITE, 0, 0, 0.0f, 0.0f, 160, 30, 160, 30);
        guiGraphics.m_280480_(this.is, 8, 8);
        guiGraphics.m_280614_(toastComponent.m_94929_().f_91062_, this.title, 30, 7, 0, false);
        int lettersRevealed = Math.clamp((int)0, (int)this.description.length(), (int)((int)((timeSinceLastVisible - 500L) / 150L)));
        if (this.old != lettersRevealed) {
            Minecraft.m_91087_().f_91074_.m_5496_(SoundEvents.f_244067_, 0.4f, r.nextFloat(0.2f) + 1.3f);
            this.old = lettersRevealed;
        }
        MutableComponent comp = Component.m_237113_((String)this.description.substring(0, lettersRevealed)).m_7220_((Component)Component.m_237113_((String)gibberish.substring(0, this.description.length() - lettersRevealed + 2)));
        guiGraphics.m_280614_(toastComponent.m_94929_().f_91062_, (Component)comp, 30, 18, 0, false);
        if (timeSinceLastVisible < 10000L) {
            return Toast.Visibility.SHOW;
        }
        return Toast.Visibility.HIDE;
    }
}

