/*
 * Decompiled with CFR 0.152.
 */
package com.wdiscute.starcatcher.datagen;

import com.wdiscute.starcatcher.ModItems;
import com.wdiscute.starcatcher.Starcatcher;
import com.wdiscute.starcatcher.networkandstuff.FishProperties;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.neoforged.neoforge.common.data.DatapackBuiltinEntriesProvider;

public class FishPropertiesProvider
extends DatapackBuiltinEntriesProvider {
    public static List<FishProperties> FISHES;
    public static final RegistrySetBuilder REGISTRY;

    public FishPropertiesProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, registries, REGISTRY, Set.of("starcatcher"));
    }

    public static FishProperties endFish(Item fish) {
        return FishProperties.DEFAULT.withFish(FishPropertiesProvider.getKey(fish)).withWorldRestrictions(FishProperties.WorldRestrictions.END);
    }

    public static FishProperties netherFish(Item fish) {
        return FishProperties.DEFAULT.withFish(FishPropertiesProvider.getKey(fish)).withWorldRestrictions(FishProperties.WorldRestrictions.NETHER);
    }

    public static FishProperties overworldLushCavesFish(Item fish) {
        return FishProperties.DEFAULT.withFish(FishPropertiesProvider.getKey(fish)).withWorldRestrictions(FishProperties.WorldRestrictions.OVERWORLD_LUSH_CAVES).withMustBeCaughtBelowY(50);
    }

    public static FishProperties overworldDeepDarkFish(Item fish) {
        return FishProperties.DEFAULT.withFish(FishPropertiesProvider.getKey(fish)).withWorldRestrictions(FishProperties.WorldRestrictions.OVERWORLD_DEEP_DARK).withMustBeCaughtBelowY(50);
    }

    public static FishProperties overworldCavesFish(Item fish) {
        return FishProperties.DEFAULT.withFish(FishPropertiesProvider.getKey(fish)).withWorldRestrictions(FishProperties.WorldRestrictions.OVERWORLD).withMustBeCaughtBelowY(50).withMustBeCaughtAboveY(0);
    }

    public static FishProperties overworldUndergroundFish(Item fish) {
        return FishProperties.DEFAULT.withFish(FishPropertiesProvider.getKey(fish)).withWorldRestrictions(FishProperties.WorldRestrictions.OVERWORLD).withMustBeCaughtBelowY(50);
    }

    public static FishProperties overworldMountainFish(Item fish) {
        return FishProperties.DEFAULT.withFish(FishPropertiesProvider.getKey(fish)).withWorldRestrictions(FishProperties.WorldRestrictions.OVERWORLD_LAKE).withMustBeCaughtAboveY(100);
    }

    public static FishProperties overworldDeepslateFish(Item fish) {
        return FishProperties.DEFAULT.withFish(FishPropertiesProvider.getKey(fish)).withWorldRestrictions(FishProperties.WorldRestrictions.OVERWORLD).withMustBeCaughtBelowY(0);
    }

    public static FishProperties overworldIcyLakeFish(Item fish) {
        return FishProperties.DEFAULT.withFish(FishPropertiesProvider.getKey(fish)).withWorldRestrictions(FishProperties.WorldRestrictions.OVERWORLD_ICY_LAKE).withMustBeCaughtAboveY(50).withMustBeCaughtBelowY(100);
    }

    public static FishProperties overworldWarmLakeFish(Item fish) {
        return FishProperties.DEFAULT.withFish(FishPropertiesProvider.getKey(fish)).withWorldRestrictions(FishProperties.WorldRestrictions.OVERWORLD_WARM_LAKE).withMustBeCaughtAboveY(50).withMustBeCaughtBelowY(100);
    }

    public static FishProperties overworldWarmMountainFish(Item fish) {
        return FishProperties.DEFAULT.withFish(FishPropertiesProvider.getKey(fish)).withWorldRestrictions(FishProperties.WorldRestrictions.OVERWORLD_WARM_LAKE).withMustBeCaughtAboveY(100);
    }

    public static FishProperties overworldIcyMountainFish(Item fish) {
        return FishProperties.DEFAULT.withFish(FishPropertiesProvider.getKey(fish)).withWorldRestrictions(FishProperties.WorldRestrictions.OVERWORLD_ICY_LAKE).withMustBeCaughtAboveY(100);
    }

    public static FishProperties overworldIcyOceanFish(Item fish) {
        return FishProperties.DEFAULT.withFish(FishPropertiesProvider.getKey(fish)).withWorldRestrictions(FishProperties.WorldRestrictions.OVERWORLD_ICY_OCEAN).withMustBeCaughtAboveY(50).withMustBeCaughtBelowY(100);
    }

    public static FishProperties overworldIcyRiverFish(Item fish) {
        return FishProperties.DEFAULT.withFish(FishPropertiesProvider.getKey(fish)).withWorldRestrictions(FishProperties.WorldRestrictions.OVERWORLD_ICY_RIVER).withMustBeCaughtAboveY(50).withMustBeCaughtBelowY(100);
    }

    public static FishProperties overworldLakeFish(Item fish) {
        return FishProperties.DEFAULT.withFish(FishPropertiesProvider.getKey(fish)).withWorldRestrictions(FishProperties.WorldRestrictions.OVERWORLD_LAKE).withMustBeCaughtAboveY(50).withMustBeCaughtBelowY(100);
    }

    public static FishProperties overworldOceanFish(Item fish) {
        return FishProperties.DEFAULT.withFish(FishPropertiesProvider.getKey(fish)).withWorldRestrictions(FishProperties.WorldRestrictions.OVERWORLD_OCEAN).withMustBeCaughtAboveY(50).withMustBeCaughtBelowY(100);
    }

    public static FishProperties overworldDeepOceanFish(Item fish) {
        return FishProperties.DEFAULT.withFish(FishPropertiesProvider.getKey(fish)).withWorldRestrictions(FishProperties.WorldRestrictions.OVERWORLD_DEEP_OCEAN).withMustBeCaughtAboveY(50).withMustBeCaughtBelowY(100);
    }

    public static FishProperties overworldRiverFish(Item fish) {
        return FishProperties.DEFAULT.withFish(FishPropertiesProvider.getKey(fish)).withWorldRestrictions(FishProperties.WorldRestrictions.OVERWORLD_RIVER).withMustBeCaughtAboveY(50).withMustBeCaughtBelowY(100);
    }

    public static FishProperties overworldBeachFish(Item fish) {
        return FishProperties.DEFAULT.withFish(FishPropertiesProvider.getKey(fish)).withWorldRestrictions(FishProperties.WorldRestrictions.OVERWORLD_BEACH).withMustBeCaughtAboveY(0);
    }

    public static FishProperties overworldMushroomFieldsFish(Item fish) {
        return FishProperties.DEFAULT.withFish(FishPropertiesProvider.getKey(fish)).withWorldRestrictions(FishProperties.WorldRestrictions.OVERWORLD_MUSHROOM_FIELDS).withMustBeCaughtAboveY(0);
    }

    public static FishProperties overworldCherryGroveFish(Item fish) {
        return FishProperties.DEFAULT.withFish(FishPropertiesProvider.getKey(fish)).withWorldRestrictions(FishProperties.WorldRestrictions.OVERWORLD_CHERRY_GROVE).withMustBeCaughtAboveY(0);
    }

    public static FishProperties overworldSwampFish(Item fish) {
        return FishProperties.DEFAULT.withFish(FishPropertiesProvider.getKey(fish)).withWorldRestrictions(FishProperties.WorldRestrictions.OVERWORLD_SWAMP).withMustBeCaughtAboveY(0);
    }

    public static FishProperties overworldDarkForestFish(Item fish) {
        return FishProperties.DEFAULT.withFish(FishPropertiesProvider.getKey(fish)).withWorldRestrictions(FishProperties.WorldRestrictions.OVERWORLD_DARK_FOREST).withMustBeCaughtAboveY(0);
    }

    public static Holder.Reference<FishProperties> register(BootstrapContext<FishProperties> bootstrap, FishProperties fp) {
        if (fp.customName().isEmpty()) {
            return bootstrap.register(FishPropertiesProvider.key(fp.fish().getNamespace(), fp.fish().getPath()), (Object)fp);
        }
        return bootstrap.register(FishPropertiesProvider.key("starcatcher", fp.customName()), (Object)fp);
    }

    public static ResourceLocation getKey(Item item) {
        return BuiltInRegistries.ITEM.getKey((Object)item);
    }

    public static ResourceKey<FishProperties> key(String namespace, String path) {
        return ResourceKey.create(Starcatcher.FISH_REGISTRY, (ResourceLocation)Starcatcher.rl(namespace + "_" + path));
    }

    static {
        REGISTRY = new RegistrySetBuilder().add(Starcatcher.FISH_REGISTRY, bootstrap -> {
            FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldLakeFish((Item)ModItems.OBIDONTIEE.get()));
            FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldLakeFish((Item)ModItems.SILVERVEIL_PERCH.get()).withWeather(FishProperties.Weather.RAIN).withRarity(FishProperties.Rarity.UNCOMMON).withDifficulty(FishProperties.Difficulty.HARD));
            FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldLakeFish((Item)ModItems.ELDERSCALE.get()).withDifficulty(FishProperties.Difficulty.MEDIUM).withRarity(FishProperties.Rarity.UNCOMMON).withBaseChance(3));
            FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldLakeFish((Item)ModItems.DRIFTFIN.get()).withWeather(FishProperties.Weather.CLEAR));
            FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldLakeFish((Item)ModItems.TWILIGHT_KOI.get()).withDaytime(FishProperties.Daytime.MIDNIGHT).withRarity(FishProperties.Rarity.EPIC).withWeather(FishProperties.Weather.RAIN).withDifficulty(FishProperties.Difficulty.MEDIUM));
            FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldLakeFish((Item)ModItems.THUNDER_BASS.get()).withRarity(FishProperties.Rarity.RARE).withWeather(FishProperties.Weather.THUNDER).withDifficulty(FishProperties.Difficulty.HARD));
            FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldLakeFish((Item)ModItems.LIGHTNING_BASS.get()).withRarity(FishProperties.Rarity.RARE).withWeather(FishProperties.Weather.THUNDER).withDifficulty(FishProperties.Difficulty.HARD));
            FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldLakeFish((Item)ModItems.BOOT.get()).withBaseChance(1).withSkipMinigame(true).withHasGuideEntry(false));
            FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldIcyLakeFish((Item)ModItems.FROSTJAW_TROUT.get()).withDifficulty(FishProperties.Difficulty.HARD));
            FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldIcyLakeFish((Item)ModItems.CRYSTALBACK_TROUT.get()).withDifficulty(FishProperties.Difficulty.MEDIUM));
            FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldIcyLakeFish((Item)ModItems.AURORA.get()).withRarity(FishProperties.Rarity.LEGENDARY).withBaseChance(2).withDifficulty(FishProperties.Difficulty.NON_STOP_ACTION));
            FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldIcyLakeFish((Item)ModItems.WINTERY_PIKE.get()));
            FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldWarmLakeFish((Item)ModItems.SANDTAIL.get()).withDaytime(FishProperties.Daytime.NIGHT));
            FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldWarmLakeFish((Item)ModItems.MIRAGE_CARP.get()).withDifficulty(FishProperties.Difficulty.MEDIUM).withDaytime(FishProperties.Daytime.DAY).withWeather(FishProperties.Weather.CLEAR).withRarity(FishProperties.Rarity.UNCOMMON));
            FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldWarmLakeFish((Item)ModItems.SCORCHFISH.get()).withWeather(FishProperties.Weather.CLEAR));
            FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldWarmLakeFish((Item)ModItems.CACTIFISH.get()).withDaytime(FishProperties.Daytime.DAY));
            FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldWarmLakeFish((Item)ModItems.AGAVE_BREAM.get()).withRarity(FishProperties.Rarity.RARE).withDaytime(FishProperties.Daytime.NIGHT).withWeather(FishProperties.Weather.CLEAR).withDifficulty(FishProperties.Difficulty.HARD));
            FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldMountainFish((Item)ModItems.SUNNY_STURGEON.get()).withDifficulty(FishProperties.Difficulty.HARD_ONLY_THIN).withRarity(FishProperties.Rarity.RARE).withDaytime(FishProperties.Daytime.DAY).withBaseChance(2));
            FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldMountainFish((Item)ModItems.PEAKDWELLER.get()).withDifficulty(FishProperties.Difficulty.HARD));
            FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldMountainFish((Item)ModItems.ROCKGILL.get()).withDifficulty(FishProperties.Difficulty.MEDIUM));
            FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldMountainFish((Item)ModItems.SUN_SEEKING_CARP.get()).withRarity(FishProperties.Rarity.RARE).withBaseChance(2).withDaytime(FishProperties.Daytime.NOON));
            FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldSwampFish((Item)ModItems.SLUDGE_CATFISH.get()).withRarity(FishProperties.Rarity.UNCOMMON));
            FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldSwampFish((Item)ModItems.LILY_SNAPPER.get()).withRarity(FishProperties.Rarity.RARE).withDifficulty(FishProperties.Difficulty.MEDIUM));
            FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldSwampFish((Item)ModItems.SAGE_CATFISH.get()).withRarity(FishProperties.Rarity.EPIC).withDifficulty(FishProperties.Difficulty.SINGLE_BIG_FAST_NO_DECAY).withDaytime(FishProperties.Daytime.NIGHT).withWeather(FishProperties.Weather.CLEAR));
            FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldSwampFish((Item)ModItems.MOSSY_BOOT.get()).withBaseChance(1).withSkipMinigame(true).withHasGuideEntry(false));
            FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldDarkForestFish((Item)ModItems.PALE_PINFISH.get()).withDaytime(FishProperties.Daytime.MIDNIGHT).withRarity(FishProperties.Rarity.RARE).withDifficulty(FishProperties.Difficulty.HARD));
            FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldDarkForestFish((Item)ModItems.PINFISH.get()).withDaytime(FishProperties.Daytime.NIGHT).withRarity(FishProperties.Rarity.UNCOMMON).withDifficulty(FishProperties.Difficulty.MEDIUM));
            FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldDarkForestFish((Item)ModItems.PALE_CARP.get()).withDaytime(FishProperties.Daytime.DAY));
            FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldCherryGroveFish((Item)ModItems.BLOSSOMFISH.get()).withWeather(FishProperties.Weather.CLEAR));
            FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldCherryGroveFish((Item)ModItems.PETALDRIFT_CARP.get()).withDifficulty(FishProperties.Difficulty.MEDIUM).withWeather(FishProperties.Weather.RAIN).withRarity(FishProperties.Rarity.UNCOMMON));
            FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldCherryGroveFish((Item)ModItems.PINK_KOI.get()).withWeather(FishProperties.Weather.RAIN));
            FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldCherryGroveFish((Item)ModItems.MORGANITE.get()).withRarity(FishProperties.Rarity.UNCOMMON).withDifficulty(FishProperties.Difficulty.MEDIUM));
            FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldCherryGroveFish((Item)ModItems.ROSE_SIAMESE_FISH.get()).withDifficulty(FishProperties.Difficulty.HARD).withDaytime(FishProperties.Daytime.DAY).withWeather(FishProperties.Weather.RAIN).withRarity(FishProperties.Rarity.EPIC));
            FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldIcyMountainFish((Item)ModItems.CRYSTALBACK_STURGEON.get()));
            FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldIcyMountainFish((Item)ModItems.ICETOOTH_STURGEON.get()).withDifficulty(FishProperties.Difficulty.MEDIUM));
            FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldIcyMountainFish((Item)ModItems.BOREAL.get()).withDifficulty(FishProperties.Difficulty.THIN_NO_DECAY_NOT_FORGIVING).withRarity(FishProperties.Rarity.LEGENDARY).withBaseChance(3));
            FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldIcyMountainFish((Item)ModItems.CRYSTALBACK_BOREAL.get()).withDifficulty(FishProperties.Difficulty.MEDIUM));
            FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldRiverFish((Item)ModItems.DOWNFALL_BREAM.get()).withDaytime(FishProperties.Daytime.NIGHT).withWeather(FishProperties.Weather.RAIN).withDifficulty(FishProperties.Difficulty.HARD));
            FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldRiverFish((Item)ModItems.DRIFTING_BREAM.get()).withDaytime(FishProperties.Daytime.NIGHT));
            FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldRiverFish((Item)ModItems.WILLOW_BREAM.get()).withDaytime(FishProperties.Daytime.NIGHT).withDifficulty(FishProperties.Difficulty.HARD).withRarity(FishProperties.Rarity.UNCOMMON).withBaseChance(2));
            FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldRiverFish((Item)ModItems.HOLLOWBELLY_DARTER.get()));
            FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldRiverFish((Item)ModItems.MISTBACK_CHUB.get()));
            FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldRiverFish((Item)ModItems.SILVERFIN_PIKE.get()).withDifficulty(FishProperties.Difficulty.MEDIUM).withRarity(FishProperties.Rarity.UNCOMMON));
            FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldRiverFish(Items.SALMON));
            FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldRiverFish((Item)ModItems.DRIED_SEAWEED.get()).withBaseChance(1).withSkipMinigame(true).withHasGuideEntry(false));
            FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldIcyRiverFish((Item)ModItems.FROSTGILL_CHUB.get()));
            FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldIcyRiverFish((Item)ModItems.CRYSTALBACK_MINNOW.get()).withDaytime(FishProperties.Daytime.NIGHT));
            FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldIcyRiverFish((Item)ModItems.AZURE_CRYSTALBACK_MINNOW.get()).withDaytime(FishProperties.Daytime.MIDNIGHT).withRarity(FishProperties.Rarity.LEGENDARY).withBaseChance(1).withDifficulty(FishProperties.Difficulty.NON_STOP_ACTION));
            FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldIcyRiverFish((Item)ModItems.BLUE_CRYSTAL_FIN.get()).withDaytime(FishProperties.Daytime.DAY).withRarity(FishProperties.Rarity.UNCOMMON));
            FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldOceanFish(Items.COD));
            FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldOceanFish((Item)ModItems.SEA_BASS.get()).withBaseChance(15).withDaytime(FishProperties.Daytime.DAY));
            FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldOceanFish((Item)ModItems.IRONJAW_HERRING.get()).withDifficulty(FishProperties.Difficulty.HARD).withBaseChance(2).withRarity(FishProperties.Rarity.UNCOMMON));
            FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldOceanFish((Item)ModItems.DEEPJAW_HERRING.get()).withDifficulty(FishProperties.Difficulty.MEDIUM));
            FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldOceanFish((Item)ModItems.DUSKTAIL_SNAPPER.get()));
            FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldOceanFish((Item)ModItems.JOEL.get()).withDifficulty(FishProperties.Difficulty.EVERYTHING).withBaseChance(1).withRarity(FishProperties.Rarity.LEGENDARY));
            FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldOceanFish((Item)ModItems.REDSCALED_TUNA.get()).withDaytime(FishProperties.Daytime.NIGHT).withRarity(FishProperties.Rarity.UNCOMMON).withDifficulty(FishProperties.Difficulty.HARD));
            FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldOceanFish((Item)ModItems.WATERLOGGED_BOTTLE.get()).withBaseChance(1).withHasGuideEntry(false).withSkipMinigame(true));
            FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldDeepOceanFish((Item)ModItems.BIGEYE_TUNA.get()).withDaytime(FishProperties.Daytime.NIGHT).withRarity(FishProperties.Rarity.UNCOMMON).withDifficulty(FishProperties.Difficulty.HARD));
            FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldBeachFish((Item)ModItems.CONCH.get()).withBaseChance(15).withHasGuideEntry(false).withSkipMinigame(true));
            FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldBeachFish((Item)ModItems.CLAM.get()).withBaseChance(15).withHasGuideEntry(false).withSkipMinigame(true));
            FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldMushroomFieldsFish((Item)ModItems.SHROOMFISH.get()).withRarity(FishProperties.Rarity.LEGENDARY).withDifficulty(FishProperties.Difficulty.THIN_NO_DECAY_NOT_FORGIVING));
            FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldMushroomFieldsFish((Item)ModItems.SPOREFISH.get()).withRarity(FishProperties.Rarity.RARE).withDifficulty(FishProperties.Difficulty.HARD));
            FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldUndergroundFish((Item)ModItems.GOLD_FAN.get()));
            FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldUndergroundFish((Item)ModItems.GEODE_EEL.get()).withRarity(FishProperties.Rarity.EPIC).withBaseChance(1).withDifficulty(FishProperties.Difficulty.HARD));
            FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldCavesFish((Item)ModItems.WHITEVEIL.get()));
            FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldCavesFish((Item)ModItems.BLACK_EEL.get()).withDifficulty(FishProperties.Difficulty.MEDIUM).withRarity(FishProperties.Rarity.UNCOMMON));
            FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldCavesFish((Item)ModItems.STONEFISH.get()).withDifficulty(FishProperties.Difficulty.MEDIUM));
            FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldCavesFish((Item)ModItems.AMETHYSTBACK.get()).withDifficulty(FishProperties.Difficulty.SINGLE_BIG_FAST).withRarity(FishProperties.Rarity.EPIC).withMustBeCaughtBelowY(-20).withMustBeCaughtAboveY(-40));
            FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldCavesFish((Item)ModItems.FOSSILIZED_ANGELFISH.get()).withRarity(FishProperties.Rarity.RARE).withDifficulty(FishProperties.Difficulty.HARD));
            FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldCavesFish((Item)ModItems.DRIPFIN.get()).withDifficulty(FishProperties.Difficulty.MEDIUM));
            FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldCavesFish((Item)ModItems.YELLOWSTONE_FISH.get()).withDifficulty(FishProperties.Difficulty.MEDIUM).withRarity(FishProperties.Rarity.UNCOMMON));
            FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldLushCavesFish((Item)ModItems.LUSH_PIKE.get()).withDifficulty(FishProperties.Difficulty.THIN_NO_DECAY).withRarity(FishProperties.Rarity.LEGENDARY).withBaseChance(2));
            FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldLushCavesFish((Item)ModItems.VIVID_MOSS.get()).withDifficulty(FishProperties.Difficulty.HARD).withRarity(FishProperties.Rarity.UNCOMMON).withBaseChance(4));
            FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldDeepslateFish((Item)ModItems.GHOSTLY_PIKE.get()).withRarity(FishProperties.Rarity.UNCOMMON).withBaseChance(2));
            FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldDeepslateFish((Item)ModItems.DEEPSLATEFISH.get()).withDifficulty(FishProperties.Difficulty.HARD));
            FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldDeepslateFish((Item)ModItems.AQUAMARINE_PIKE.get()).withDifficulty(FishProperties.Difficulty.MEDIUM));
            FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldDeepslateFish((Item)ModItems.GARNET_MACKEREL.get()).withDifficulty(FishProperties.Difficulty.HARD).withRarity(FishProperties.Rarity.UNCOMMON));
            FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldDeepslateFish((Item)ModItems.BRIGHT_AMETHYST_SNAPPER.get()).withDifficulty(FishProperties.Difficulty.HARD_ONLY_THIN).withRarity(FishProperties.Rarity.EPIC).withBaseChance(2));
            FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldDeepslateFish((Item)ModItems.DARK_AMETHYST_SNAPPER.get()).withDifficulty(FishProperties.Difficulty.SINGLE_BIG_FAST_NO_DECAY).withRarity(FishProperties.Rarity.EPIC).withBaseChance(2));
            FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldDeepDarkFish((Item)ModItems.SKULKFISH.get()).withDifficulty(FishProperties.Difficulty.HARD).withRarity(FishProperties.Rarity.UNCOMMON));
            FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldDeepDarkFish((Item)ModItems.WARD.get()).withDifficulty(FishProperties.Difficulty.NON_STOP_ACTION).withRarity(FishProperties.Rarity.LEGENDARY).withBaseChance(2));
            FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldDeepDarkFish((Item)ModItems.GLOWING_DARK.get()).withRarity(FishProperties.Rarity.UNCOMMON).withDifficulty(FishProperties.Difficulty.HARD));
            FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.netherFish((Item)ModItems.EMBERGILL.get()).withDifficulty(FishProperties.Difficulty.HARD_ONLY_THIN.withTreasure(FishProperties.Treasure.NETHER)));
            FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.netherFish((Item)ModItems.LAVA_CRAB.get()).withRarity(FishProperties.Rarity.EPIC).withDifficulty(FishProperties.Difficulty.EVERYTHING_FLIP.withTreasure(FishProperties.Treasure.NETHER)));
            FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.netherFish((Item)ModItems.MAGMA_FISH.get()).withRarity(FishProperties.Rarity.UNCOMMON).withDifficulty(FishProperties.Difficulty.HARD.withTreasure(FishProperties.Treasure.NETHER)));
            FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.netherFish((Item)ModItems.GLOWSTONE_SEEKER.get()).withDifficulty(FishProperties.Difficulty.MEDIUM.withTreasure(FishProperties.Treasure.NETHER)));
            FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.netherFish((Item)ModItems.CINDER_SQUID.get()).withDifficulty(FishProperties.Difficulty.SINGLE_BIG_FAST_NO_DECAY.withTreasure(FishProperties.Treasure.NETHER)).withRarity(FishProperties.Rarity.RARE).withBaseChance(2));
            FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.netherFish((Item)ModItems.SCALDING_PIKE.get()).withDifficulty(FishProperties.Difficulty.MEDIUM.withTreasure(FishProperties.Treasure.NETHER)));
            FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.netherFish((Item)ModItems.LAVA_CRAB_CLAW.get()).withBaseChance(1).withSkipMinigame(true).withHasGuideEntry(false));
            FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.endFish((Item)ModItems.CHARFISH.get()).withRarity(FishProperties.Rarity.RARE).withDifficulty(FishProperties.Difficulty.EVERYTHING_FLIP));
        });
    }
}

