/*
 * Decompiled with CFR 0.152.
 */
package com.wdiscute.starcatcher.rod;

import com.wdiscute.starcatcher.ModItems;
import com.wdiscute.starcatcher.fishingbob.FishingBobEntity;
import com.wdiscute.starcatcher.networkandstuff.ModDataAttachments;
import com.wdiscute.starcatcher.rod.FishingRodMenu;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public class StarcatcherFishingRod
extends Item
implements MenuProvider {
    public StarcatcherFishingRod(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        if (!player.getItemInHand(hand).is(ModItems.ROD)) {
            return InteractionResultHolder.pass((Object)player.getItemInHand(hand));
        }
        if (player.isCrouching()) {
            player.openMenu((MenuProvider)this);
            return InteractionResultHolder.success((Object)player.getItemInHand(hand));
        }
        if (level.isClientSide) {
            return InteractionResultHolder.success((Object)player.getItemInHand(hand));
        }
        if (((String)player.getData(ModDataAttachments.FISHING.get())).isEmpty()) {
            level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.FISHING_BOBBER_THROW, SoundSource.NEUTRAL, 0.5f, 0.4f / (level.getRandom().nextFloat() * 0.4f + 0.8f));
            if (level instanceof ServerLevel) {
                FishingBobEntity entity = new FishingBobEntity(level, player, player.getItemInHand(hand));
                level.addFreshEntity((Entity)entity);
                player.setData(ModDataAttachments.FISHING.get(), (Object)entity.getStringUUID());
            }
        } else {
            List entities = level.getEntities(null, new AABB(-25.0, -65.0, -25.0, 25.0, 65.0, 25.0).move(player.position()));
            for (Entity entity : entities) {
                FishingBobEntity fbe;
                if (!entity.getUUID().toString().equals(player.getData(ModDataAttachments.FISHING.get())) || !(entity instanceof FishingBobEntity) || (fbe = (FishingBobEntity)entity).checkBiting()) continue;
                fbe.kill();
                player.setData(ModDataAttachments.FISHING.get(), (Object)"");
            }
        }
        return InteractionResultHolder.success((Object)player.getItemInHand(hand));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }

    public Component getDisplayName() {
        return Component.literal((String)"Starcatcher's rod");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int i, Inventory inventory, Player player) {
        return new FishingRodMenu(i, inventory, player.getMainHandItem());
    }
}

