/*
 * Decompiled with CFR 0.152.
 */
package com.wdiscute.starcatcher.datagen;

import com.wdiscute.starcatcher.ModItems;
import com.wdiscute.starcatcher.Starcatcher;
import com.wdiscute.starcatcher.StarcatcherTags;
import com.wdiscute.starcatcher.datagen.FishPropertiesWithModRestriction;
import com.wdiscute.starcatcher.datagen.TrustedHolder;
import com.wdiscute.starcatcher.networkandstuff.FishProperties;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderOwner;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.ModLoadedCondition;
import net.neoforged.neoforge.common.data.DatapackBuiltinEntriesProvider;

public class FishPropertiesProvider
extends DatapackBuiltinEntriesProvider {
    public static final List<FishPropertiesWithModRestriction> RESTRICTED_FPS = List.of(FishPropertiesProvider.overworldColdFreshwaterFish(FishPropertiesProvider.fromRL("tide", "trout")).withDifficulty(FishProperties.Difficulty.MEDIUM).withDaytime(FishProperties.Daytime.DAY).withRarity(FishProperties.Rarity.UNCOMMON).withMod("tide"), FishPropertiesProvider.overworldFreshwaterFish(FishPropertiesProvider.fromRL("tide", "bass")).withWeather(FishProperties.Weather.CLEAR).withMod("tide"), FishPropertiesProvider.overworldFreshwaterFish(FishPropertiesProvider.fromRL("tide", "yellow_perch")).withDifficulty(FishProperties.Difficulty.MEDIUM).withWeather(FishProperties.Weather.RAIN).withMod("tide"), FishPropertiesProvider.overworldFreshwaterFish(FishPropertiesProvider.fromRL("tide", "bluegill")).withMod("tide"), FishPropertiesProvider.overworldWarmFreshwaterFish(FishPropertiesProvider.fromRL("tide", "mint_carp")).withDifficulty(FishProperties.Difficulty.MEDIUM).withWeather(FishProperties.Weather.RAIN).withRarity(FishProperties.Rarity.UNCOMMON).withMod("tide"), FishPropertiesProvider.overworldColdFreshwaterFish(FishPropertiesProvider.fromRL("tide", "pike")).withMod("tide"), FishPropertiesProvider.overworldWarmFreshwaterFish(FishPropertiesProvider.fromRL("tide", "guppy")).withDifficulty(FishProperties.Difficulty.MEDIUM).withDaytime(FishProperties.Daytime.NIGHT).withMod("tide"), FishPropertiesProvider.overworldColdFreshwaterFish(FishPropertiesProvider.fromRL("tide", "catfish")).withDifficulty(FishProperties.Difficulty.MEDIUM).withRarity(FishProperties.Rarity.UNCOMMON).withMod("tide"), FishPropertiesProvider.overworldColdFreshwaterFish(FishPropertiesProvider.fromRL("tide", "clayfish")).withWeather(FishProperties.Weather.RAIN).withMod("tide"), FishPropertiesProvider.overworldOceanFish(FishPropertiesProvider.fromRL("tide", "tuna")).withMod("tide"), FishPropertiesProvider.overworldColdOceanFish(FishPropertiesProvider.fromRL("tide", "ocean_perch")).withDifficulty(FishProperties.Difficulty.MEDIUM).withDaytime(FishProperties.Daytime.NIGHT).withRarity(FishProperties.Rarity.UNCOMMON).withMod("tide"), FishPropertiesProvider.overworldOceanFish(FishPropertiesProvider.fromRL("tide", "mackerel")).withDifficulty(FishProperties.Difficulty.MEDIUM).withMod("tide"), FishPropertiesProvider.overworldWarmOceanFish(FishPropertiesProvider.fromRL("tide", "angelfish")).withWeather(FishProperties.Weather.RAIN).withMod("tide"), FishPropertiesProvider.overworldOceanFish(FishPropertiesProvider.fromRL("tide", "barracuda")).withRarity(FishProperties.Rarity.RARE).withDaytime(FishProperties.Daytime.NIGHT).withWeather(FishProperties.Weather.RAIN).withDifficulty(FishProperties.Difficulty.MEDIUM).withMod("tide"), FishPropertiesProvider.overworldWarmOceanFish(FishPropertiesProvider.fromRL("tide", "sailfish")).withWeather(FishProperties.Weather.RAIN).withMod("tide"), FishPropertiesProvider.overworldCavesFish(FishPropertiesProvider.fromRL("tide", "cave_eel")).withDifficulty(FishProperties.Difficulty.MEDIUM).withMod("tide"), FishPropertiesProvider.overworldCavesFish(FishPropertiesProvider.fromRL("tide", "crystal_shrimp")).withMod("tide"), FishPropertiesProvider.overworldCavesFish(FishPropertiesProvider.fromRL("tide", "iron_tetra")).withDifficulty(FishProperties.Difficulty.MEDIUM).withMod("tide"), FishPropertiesProvider.overworldCavesFish(FishPropertiesProvider.fromRL("tide", "glowfish")).withRarity(FishProperties.Rarity.UNCOMMON).withDifficulty(FishProperties.Difficulty.MEDIUM).withMod("tide"), FishPropertiesProvider.overworldCavesFish(FishPropertiesProvider.fromRL("tide", "anglerfish")).withMod("tide"), FishPropertiesProvider.overworldCavesFish(FishPropertiesProvider.fromRL("tide", "cave_crawler")).withDifficulty(FishProperties.Difficulty.MEDIUM).withMod("tide"), FishPropertiesProvider.overworldCavesFish(FishPropertiesProvider.fromRL("tide", "gilded_minnow")).withMod("tide"), FishPropertiesProvider.overworldDeepslateFish(FishPropertiesProvider.fromRL("tide", "deep_grouper")).withDifficulty(FishProperties.Difficulty.MEDIUM).withMod("tide"), FishPropertiesProvider.overworldDeepslateFish(FishPropertiesProvider.fromRL("tide", "shadow_snapper")).withDifficulty(FishProperties.Difficulty.MEDIUM).withMod("tide"), FishPropertiesProvider.overworldDeepslateFish(FishPropertiesProvider.fromRL("tide", "abyss_angler")).withRarity(FishProperties.Rarity.EPIC).withDifficulty(FishProperties.Difficulty.HARD).withBaseChance(2).withMod("tide"), FishPropertiesProvider.overworldDeepslateFish(FishPropertiesProvider.fromRL("tide", "lapis_lanternfish")).withDifficulty(FishProperties.Difficulty.MEDIUM).withMod("tide"), FishPropertiesProvider.overworldDeepslateFish(FishPropertiesProvider.fromRL("tide", "luminescent_jellyfish")).withRarity(FishProperties.Rarity.UNCOMMON).withDifficulty(FishProperties.Difficulty.MEDIUM).withMod("tide"), FishPropertiesProvider.overworldDeepslateFish(FishPropertiesProvider.fromRL("tide", "crystalline_carp")).withDifficulty(FishProperties.Difficulty.HARD_ONLY_THIN).withRarity(FishProperties.Rarity.RARE).withMod("tide"), FishPropertiesProvider.overworldDeepslateFish(FishPropertiesProvider.fromRL("tide", "bedrock_tetra")).withRarity(FishProperties.Rarity.EPIC).withDifficulty(FishProperties.Difficulty.HARD_ONLY_THIN).withMod("tide"), FishPropertiesProvider.fish(FishPropertiesProvider.fromRL("tide", "prarie_pike")).withWorldRestrictions(FishProperties.WorldRestrictions.DEFAULT.withBiomes(FishPropertiesProvider.rl("minecraft", "plains"))).withRarity(FishProperties.Rarity.UNCOMMON).withMod("tide"), FishPropertiesProvider.fish(FishPropertiesProvider.fromRL("tide", "sandskipper")).withWorldRestrictions(FishProperties.WorldRestrictions.DEFAULT.withBiomes(FishPropertiesProvider.rl("minecraft", "desert"))).withRarity(FishProperties.Rarity.UNCOMMON).withDifficulty(FishProperties.Difficulty.SINGLE_BIG_FAST).withMod("tide"), FishPropertiesProvider.fish(FishPropertiesProvider.fromRL("tide", "blossom_bass")).withWorldRestrictions(FishProperties.WorldRestrictions.OVERWORLD_CHERRY_GROVE).withDifficulty(FishProperties.Difficulty.MEDIUM).withRarity(FishProperties.Rarity.UNCOMMON).withMod("tide"), FishPropertiesProvider.fish(FishPropertiesProvider.fromRL("tide", "oakfish")).withWorldRestrictions(FishProperties.WorldRestrictions.DEFAULT.withBiomes(FishPropertiesProvider.rl("minecraft", "forest"))).withDifficulty(FishProperties.Difficulty.MEDIUM).withMod("tide"), FishPropertiesProvider.overworldColdFreshwaterFish(FishPropertiesProvider.fromRL("tide", "frostbite_flounder")).withDifficulty(FishProperties.Difficulty.MEDIUM).withMod("tide"), FishPropertiesProvider.fish(FishPropertiesProvider.fromRL("tide", "mirage_catfish")).withRarity(FishProperties.Rarity.EPIC).withDifficulty(FishProperties.Difficulty.EVERYTHING_FLIP).withWorldRestrictions(FishProperties.WorldRestrictions.DEFAULT.withBiomesTags(FishPropertiesProvider.rl("minecraft", "is_badlands"))).withMod("tide"), FishPropertiesProvider.overworldDeepDarkFish(FishPropertiesProvider.fromRL("tide", "echofin_snapper")).withRarity(FishProperties.Rarity.RARE).withDifficulty(FishProperties.Difficulty.HARD).withMod("tide"), FishPropertiesProvider.fish(FishPropertiesProvider.fromRL("tide", "sunspike_goby")).withWorldRestrictions(FishProperties.WorldRestrictions.DEFAULT.withBiomesTags(FishPropertiesProvider.rl("minecraft", "is_savanna"))).withRarity(FishProperties.Rarity.EPIC).withDifficulty(FishProperties.Difficulty.HARD).withMod("tide"), FishPropertiesProvider.fish(FishPropertiesProvider.fromRL("tide", "birch_trout")).withWorldRestrictions(FishProperties.WorldRestrictions.DEFAULT.withBiomesTags(StarcatcherTags.IS_BIRCH_FOREST)).withDifficulty(FishProperties.Difficulty.MEDIUM).withMod("tide"), FishPropertiesProvider.overworldMountainFish(FishPropertiesProvider.fromRL("tide", "stonefish")).withDifficulty(FishProperties.Difficulty.MEDIUM).withMod("tide"), FishPropertiesProvider.overworldDripstoneCavesFish(FishPropertiesProvider.fromRL("tide", "dripstone_darter")).withRarity(FishProperties.Rarity.UNCOMMON).withDifficulty(FishProperties.Difficulty.HARD).withMod("tide"), FishPropertiesProvider.overworldSwampFish(FishPropertiesProvider.fromRL("tide", "slimefin_snapper")).withRarity(FishProperties.Rarity.RARE).withDifficulty(FishProperties.Difficulty.SINGLE_BIG_FAST).withMod("tide"), FishPropertiesProvider.overworldMushroomFieldsFish(FishPropertiesProvider.fromRL("tide", "sporestalker")).withRarity(FishProperties.Rarity.UNCOMMON).withDifficulty(FishProperties.Difficulty.THIN_NO_DECAY).withMod("tide"), FishPropertiesProvider.overworldJungleFish(FishPropertiesProvider.fromRL("tide", "leafback")).withRarity(FishProperties.Rarity.EPIC).withDifficulty(FishProperties.Difficulty.EVERYTHING).withMod("tide"), FishPropertiesProvider.overworldLushCavesFish(FishPropertiesProvider.fromRL("tide", "fluttergill")).withRarity(FishProperties.Rarity.UNCOMMON).withDifficulty(FishProperties.Difficulty.MEDIUM).withMod("tide"), FishPropertiesProvider.overworldTaigaFish(FishPropertiesProvider.fromRL("tide", "pine_perch")).withDifficulty(FishProperties.Difficulty.MEDIUM).withMod("tide"), FishPropertiesProvider.fish(FishPropertiesProvider.fromRL("tide", "ember_koi")).withDifficulty(FishProperties.Difficulty.EVERYTHING).withRarity(FishProperties.Rarity.EPIC).withWorldRestrictions(FishProperties.WorldRestrictions.OVERWORLD.withFluids(FishPropertiesProvider.rl("minecraft", "lava"))).withMustBeCaughtAboveY(50).withMod("tide"), FishPropertiesProvider.fish(FishPropertiesProvider.fromRL("tide", "inferno_guppy")).withDifficulty(FishProperties.Difficulty.HARD).withRarity(FishProperties.Rarity.RARE).withWorldRestrictions(FishProperties.WorldRestrictions.OVERWORLD.withFluids(FishPropertiesProvider.rl("minecraft", "lava"))).withMustBeCaughtAboveY(50).withMod("tide"), FishPropertiesProvider.fish(FishPropertiesProvider.fromRL("tide", "obsidian_pike")).withRarity(FishProperties.Rarity.UNCOMMON).withDifficulty(FishProperties.Difficulty.HARD).withWorldRestrictions(FishProperties.WorldRestrictions.OVERWORLD.withFluids(FishPropertiesProvider.rl("minecraft", "lava"))).withMustBeCaughtAboveY(50).withMod("tide"), FishPropertiesProvider.fish(FishPropertiesProvider.fromRL("tide", "volcano_tuna")).withRarity(FishProperties.Rarity.RARE).withDifficulty(FishProperties.Difficulty.HARD).withWorldRestrictions(FishProperties.WorldRestrictions.OVERWORLD.withFluids(FishPropertiesProvider.rl("minecraft", "lava"))).withMustBeCaughtAboveY(50).withMod("tide"), FishPropertiesProvider.netherLavaFish(FishPropertiesProvider.fromRL("tide", "magma_mackerel")).withDifficulty(FishProperties.Difficulty.HARD).withMod("tide"), FishPropertiesProvider.netherLavaFish(FishPropertiesProvider.fromRL("tide", "ashen_perch")).withDifficulty(FishProperties.Difficulty.MEDIUM).withMod("tide"), FishPropertiesProvider.netherLavaFish(FishPropertiesProvider.fromRL("tide", "soulscaler")).withRarity(FishProperties.Rarity.RARE).withBaseChance(3).withMod("tide"), FishPropertiesProvider.netherLavaFish(FishPropertiesProvider.fromRL("tide", "warped_guppy")).withMod("tide"), FishPropertiesProvider.netherLavaFish(FishPropertiesProvider.fromRL("tide", "crimson_fangjaw")).withDifficulty(FishProperties.Difficulty.MEDIUM).withRarity(FishProperties.Rarity.UNCOMMON).withMod("tide"), FishPropertiesProvider.netherLavaFish(FishPropertiesProvider.fromRL("tide", "witherfin")).withRarity(FishProperties.Rarity.EPIC).withDifficulty(FishProperties.Difficulty.HARD_ONLY_THIN).withMod("tide"), FishPropertiesProvider.netherLavaFish(FishPropertiesProvider.fromRL("tide", "blazing_swordfish")).withBaseChance(2).withRarity(FishProperties.Rarity.EPIC).withDifficulty(FishProperties.Difficulty.EVERYTHING).withMod("tide"), FishPropertiesProvider.endFish(FishPropertiesProvider.fromRL("tide", "endstone_perch")).withDifficulty(FishProperties.Difficulty.MEDIUM).withMod("tide"), FishPropertiesProvider.endFish(FishPropertiesProvider.fromRL("tide", "enderfin")).withBaseChance(2).withRarity(FishProperties.Rarity.UNCOMMON).withDifficulty(FishProperties.Difficulty.MEDIUM).withMod("tide"), FishPropertiesProvider.endFish(FishPropertiesProvider.fromRL("tide", "endergazer")).withBaseChance(2).withDifficulty(FishProperties.Difficulty.HARD).withRarity(FishProperties.Rarity.EPIC).withMod("tide"), FishPropertiesProvider.endFish(FishPropertiesProvider.fromRL("tide", "purpur_pike")).withRarity(FishProperties.Rarity.UNCOMMON).withDifficulty(FishProperties.Difficulty.MEDIUM).withMod("tide"), FishPropertiesProvider.endFish(FishPropertiesProvider.fromRL("tide", "chorus_cod")).withDifficulty(FishProperties.Difficulty.MEDIUM).withMod("tide"), FishPropertiesProvider.endFish(FishPropertiesProvider.fromRL("tide", "elytrout")).withBaseChance(2).withRarity(FishProperties.Rarity.RARE).withDifficulty(FishProperties.Difficulty.HARD).withMod("tide"), FishPropertiesProvider.overworldFreshwaterFish(FishPropertiesProvider.fromRL("tide", "midas_fish")).withBaseChance(1).withRarity(FishProperties.Rarity.LEGENDARY).withDifficulty(FishProperties.Difficulty.EVERYTHING_FLIP).withMod("tide"), FishPropertiesProvider.endFish(FishPropertiesProvider.fromRL("tide", "voidseeker")).withBaseChance(1).withRarity(FishProperties.Rarity.LEGENDARY).withDifficulty(FishProperties.Difficulty.THIN_NO_DECAY_NOT_FORGIVING).withMod("tide"), FishPropertiesProvider.overworldOceanFish(FishPropertiesProvider.fromRL("tide", "shooting_starfish")).withBaseChance(1).withRarity(FishProperties.Rarity.LEGENDARY).withDaytime(FishProperties.Daytime.MIDNIGHT).withDifficulty(FishProperties.Difficulty.HARD_ONLY_THIN).withMod("tide"));
    public static final RegistrySetBuilder REGISTRY = new RegistrySetBuilder().add(Starcatcher.FISH_REGISTRY, bootstrap -> {
        for (FishPropertiesWithModRestriction restriction : RESTRICTED_FPS) {
            FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, restriction.fp());
        }
        FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldLakeFish(ModItems.OBIDONTIEE));
        FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldLakeFish(ModItems.SILVERVEIL_PERCH).withWeather(FishProperties.Weather.RAIN).withRarity(FishProperties.Rarity.UNCOMMON).withDifficulty(FishProperties.Difficulty.HARD));
        FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldLakeFish(ModItems.ELDERSCALE).withDifficulty(FishProperties.Difficulty.MEDIUM).withRarity(FishProperties.Rarity.UNCOMMON).withBaseChance(3));
        FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldLakeFish(ModItems.DRIFTFIN).withWeather(FishProperties.Weather.CLEAR));
        FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldLakeFish(ModItems.TWILIGHT_KOI).withDaytime(FishProperties.Daytime.MIDNIGHT).withRarity(FishProperties.Rarity.EPIC).withWeather(FishProperties.Weather.RAIN).withDifficulty(FishProperties.Difficulty.MEDIUM));
        FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldLakeFish(ModItems.THUNDER_BASS).withRarity(FishProperties.Rarity.RARE).withWeather(FishProperties.Weather.THUNDER).withDifficulty(FishProperties.Difficulty.HARD));
        FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldLakeFish(ModItems.LIGHTNING_BASS).withRarity(FishProperties.Rarity.RARE).withWeather(FishProperties.Weather.THUNDER).withDifficulty(FishProperties.Difficulty.HARD));
        FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldLakeFish(ModItems.BOOT).withBaseChance(1).withSkipMinigame(true).withHasGuideEntry(false));
        FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldColdLakeFish(ModItems.FROSTJAW_TROUT).withDifficulty(FishProperties.Difficulty.HARD));
        FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldColdLakeFish(ModItems.CRYSTALBACK_TROUT).withDifficulty(FishProperties.Difficulty.MEDIUM));
        FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldColdLakeFish(ModItems.AURORA).withRarity(FishProperties.Rarity.LEGENDARY).withBaseChance(2).withDifficulty(FishProperties.Difficulty.NON_STOP_ACTION));
        FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldColdLakeFish(ModItems.WINTERY_PIKE));
        FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldWarmLakeFish(ModItems.SANDTAIL).withDaytime(FishProperties.Daytime.NIGHT));
        FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldWarmLakeFish(ModItems.MIRAGE_CARP).withDifficulty(FishProperties.Difficulty.MEDIUM).withDaytime(FishProperties.Daytime.DAY).withWeather(FishProperties.Weather.CLEAR).withRarity(FishProperties.Rarity.UNCOMMON));
        FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldWarmLakeFish(ModItems.SCORCHFISH).withWeather(FishProperties.Weather.CLEAR));
        FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldWarmLakeFish(ModItems.CACTIFISH).withDaytime(FishProperties.Daytime.DAY));
        FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldWarmLakeFish(ModItems.AGAVE_BREAM).withRarity(FishProperties.Rarity.RARE).withDaytime(FishProperties.Daytime.NIGHT).withWeather(FishProperties.Weather.CLEAR).withDifficulty(FishProperties.Difficulty.HARD));
        FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldMountainFish(ModItems.SUNNY_STURGEON).withDifficulty(FishProperties.Difficulty.HARD_ONLY_THIN).withRarity(FishProperties.Rarity.RARE).withDaytime(FishProperties.Daytime.DAY).withBaseChance(2));
        FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldMountainFish(ModItems.PEAKDWELLER).withDifficulty(FishProperties.Difficulty.HARD));
        FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldMountainFish(ModItems.ROCKGILL).withDifficulty(FishProperties.Difficulty.MEDIUM));
        FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldMountainFish(ModItems.SUN_SEEKING_CARP).withRarity(FishProperties.Rarity.RARE).withBaseChance(2).withDaytime(FishProperties.Daytime.NOON));
        FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldSwampFish(ModItems.SLUDGE_CATFISH).withRarity(FishProperties.Rarity.UNCOMMON));
        FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldSwampFish(ModItems.LILY_SNAPPER).withRarity(FishProperties.Rarity.RARE).withDifficulty(FishProperties.Difficulty.MEDIUM));
        FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldSwampFish(ModItems.SAGE_CATFISH).withRarity(FishProperties.Rarity.EPIC).withDifficulty(FishProperties.Difficulty.SINGLE_BIG_FAST_NO_DECAY).withDaytime(FishProperties.Daytime.NIGHT).withWeather(FishProperties.Weather.CLEAR));
        FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldSwampFish(ModItems.MOSSY_BOOT).withBaseChance(1).withSkipMinigame(true).withHasGuideEntry(false));
        FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldDarkForestFish(ModItems.PALE_PINFISH).withDaytime(FishProperties.Daytime.MIDNIGHT).withRarity(FishProperties.Rarity.RARE).withDifficulty(FishProperties.Difficulty.HARD));
        FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldDarkForestFish(ModItems.PINFISH).withDaytime(FishProperties.Daytime.NIGHT).withRarity(FishProperties.Rarity.UNCOMMON).withDifficulty(FishProperties.Difficulty.MEDIUM));
        FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldDarkForestFish(ModItems.PALE_CARP).withDaytime(FishProperties.Daytime.DAY));
        FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldCherryGroveFish(ModItems.BLOSSOMFISH).withWeather(FishProperties.Weather.CLEAR));
        FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldCherryGroveFish(ModItems.PETALDRIFT_CARP).withDifficulty(FishProperties.Difficulty.MEDIUM).withWeather(FishProperties.Weather.RAIN).withRarity(FishProperties.Rarity.UNCOMMON));
        FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldCherryGroveFish(ModItems.PINK_KOI).withWeather(FishProperties.Weather.RAIN));
        FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldCherryGroveFish(ModItems.MORGANITE).withRarity(FishProperties.Rarity.UNCOMMON).withDifficulty(FishProperties.Difficulty.MEDIUM));
        FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldCherryGroveFish(ModItems.ROSE_SIAMESE_FISH).withDifficulty(FishProperties.Difficulty.HARD).withDaytime(FishProperties.Daytime.DAY).withWeather(FishProperties.Weather.RAIN).withRarity(FishProperties.Rarity.EPIC));
        FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldColdMountainFish(ModItems.CRYSTALBACK_STURGEON));
        FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldColdMountainFish(ModItems.ICETOOTH_STURGEON).withDifficulty(FishProperties.Difficulty.MEDIUM));
        FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldColdMountainFish(ModItems.BOREAL).withDifficulty(FishProperties.Difficulty.THIN_NO_DECAY_NOT_FORGIVING).withRarity(FishProperties.Rarity.LEGENDARY).withBaseChance(3));
        FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldColdMountainFish(ModItems.CRYSTALBACK_BOREAL).withDifficulty(FishProperties.Difficulty.MEDIUM));
        FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldRiverFish(ModItems.DOWNFALL_BREAM).withDaytime(FishProperties.Daytime.NIGHT).withWeather(FishProperties.Weather.RAIN).withDifficulty(FishProperties.Difficulty.HARD));
        FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldRiverFish(ModItems.DRIFTING_BREAM).withDaytime(FishProperties.Daytime.NIGHT));
        FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldRiverFish(ModItems.WILLOW_BREAM).withDaytime(FishProperties.Daytime.NIGHT).withDifficulty(FishProperties.Difficulty.HARD).withRarity(FishProperties.Rarity.UNCOMMON).withBaseChance(2));
        FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldRiverFish(ModItems.HOLLOWBELLY_DARTER));
        FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldRiverFish(ModItems.MISTBACK_CHUB));
        FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldRiverFish(ModItems.SILVERFIN_PIKE).withDifficulty(FishProperties.Difficulty.MEDIUM).withRarity(FishProperties.Rarity.UNCOMMON));
        FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldRiverFish(ModItems.DRIED_SEAWEED).withBaseChance(1).withSkipMinigame(true).withHasGuideEntry(false));
        FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldColdRiverFish(ModItems.FROSTGILL_CHUB));
        FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldColdRiverFish(ModItems.CRYSTALBACK_MINNOW).withDaytime(FishProperties.Daytime.NIGHT));
        FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldColdRiverFish(ModItems.AZURE_CRYSTALBACK_MINNOW).withDaytime(FishProperties.Daytime.MIDNIGHT).withRarity(FishProperties.Rarity.LEGENDARY).withBaseChance(1).withDifficulty(FishProperties.Difficulty.NON_STOP_ACTION));
        FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldColdRiverFish(ModItems.BLUE_CRYSTAL_FIN).withDaytime(FishProperties.Daytime.DAY).withRarity(FishProperties.Rarity.UNCOMMON));
        FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldOceanFish(ModItems.SEA_BASS).withBaseChance(15).withDaytime(FishProperties.Daytime.DAY));
        FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldOceanFish(ModItems.IRONJAW_HERRING).withDifficulty(FishProperties.Difficulty.HARD).withBaseChance(2).withRarity(FishProperties.Rarity.UNCOMMON));
        FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldOceanFish(ModItems.DEEPJAW_HERRING).withDifficulty(FishProperties.Difficulty.MEDIUM));
        FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldOceanFish(ModItems.DUSKTAIL_SNAPPER));
        FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldOceanFish(ModItems.JOEL).withDifficulty(FishProperties.Difficulty.EVERYTHING).withBaseChance(1).withRarity(FishProperties.Rarity.LEGENDARY));
        FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldOceanFish(ModItems.REDSCALED_TUNA).withDaytime(FishProperties.Daytime.NIGHT).withRarity(FishProperties.Rarity.UNCOMMON).withDifficulty(FishProperties.Difficulty.HARD));
        FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldOceanFish(ModItems.WATERLOGGED_BOTTLE).withBaseChance(1).withHasGuideEntry(false).withSkipMinigame(true));
        FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldDeepOceanFish(ModItems.BIGEYE_TUNA).withDaytime(FishProperties.Daytime.NIGHT).withRarity(FishProperties.Rarity.UNCOMMON).withDifficulty(FishProperties.Difficulty.HARD));
        FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldBeachFish(ModItems.CONCH).withBaseChance(15).withHasGuideEntry(false).withSkipMinigame(true));
        FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldBeachFish(ModItems.CLAM).withBaseChance(15).withHasGuideEntry(false).withSkipMinigame(true));
        FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldMushroomFieldsFish(ModItems.SHROOMFISH).withRarity(FishProperties.Rarity.LEGENDARY).withDifficulty(FishProperties.Difficulty.THIN_NO_DECAY_NOT_FORGIVING));
        FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldMushroomFieldsFish(ModItems.SPOREFISH).withRarity(FishProperties.Rarity.RARE).withDifficulty(FishProperties.Difficulty.HARD));
        FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldUndergroundFish(ModItems.GOLD_FAN));
        FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldUndergroundFish(ModItems.GEODE_EEL).withRarity(FishProperties.Rarity.EPIC).withBaseChance(1).withDifficulty(FishProperties.Difficulty.HARD));
        FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldCavesFish(ModItems.WHITEVEIL));
        FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldCavesFish(ModItems.BLACK_EEL).withDifficulty(FishProperties.Difficulty.MEDIUM).withRarity(FishProperties.Rarity.UNCOMMON));
        FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldCavesFish(ModItems.STONEFISH).withDifficulty(FishProperties.Difficulty.MEDIUM));
        FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldCavesFish(ModItems.AMETHYSTBACK).withDifficulty(FishProperties.Difficulty.SINGLE_BIG_FAST).withRarity(FishProperties.Rarity.EPIC).withMustBeCaughtBelowY(-20).withMustBeCaughtAboveY(-40));
        FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldDripstoneCavesFish(ModItems.FOSSILIZED_ANGELFISH).withRarity(FishProperties.Rarity.RARE).withDifficulty(FishProperties.Difficulty.HARD));
        FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldDripstoneCavesFish(ModItems.DRIPFIN).withDifficulty(FishProperties.Difficulty.MEDIUM));
        FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldDripstoneCavesFish(ModItems.YELLOWSTONE_FISH).withDifficulty(FishProperties.Difficulty.MEDIUM).withRarity(FishProperties.Rarity.UNCOMMON));
        FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldLushCavesFish(ModItems.LUSH_PIKE).withDifficulty(FishProperties.Difficulty.THIN_NO_DECAY).withRarity(FishProperties.Rarity.LEGENDARY).withBaseChance(2));
        FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldLushCavesFish(ModItems.VIVID_MOSS).withDifficulty(FishProperties.Difficulty.HARD).withRarity(FishProperties.Rarity.UNCOMMON).withBaseChance(4));
        FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldDeepslateFish(ModItems.GHOSTLY_PIKE).withRarity(FishProperties.Rarity.UNCOMMON).withBaseChance(2));
        FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldDeepslateFish(ModItems.DEEPSLATEFISH).withDifficulty(FishProperties.Difficulty.HARD));
        FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldDeepslateFish(ModItems.AQUAMARINE_PIKE).withDifficulty(FishProperties.Difficulty.MEDIUM));
        FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldDeepslateFish(ModItems.GARNET_MACKEREL).withDifficulty(FishProperties.Difficulty.HARD).withRarity(FishProperties.Rarity.UNCOMMON));
        FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldDeepslateFish(ModItems.BRIGHT_AMETHYST_SNAPPER).withDifficulty(FishProperties.Difficulty.HARD_ONLY_THIN).withRarity(FishProperties.Rarity.EPIC).withBaseChance(2));
        FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldDeepslateFish(ModItems.DARK_AMETHYST_SNAPPER).withDifficulty(FishProperties.Difficulty.SINGLE_BIG_FAST_NO_DECAY).withRarity(FishProperties.Rarity.EPIC).withBaseChance(2));
        FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldDeepDarkFish(ModItems.SKULKFISH).withDifficulty(FishProperties.Difficulty.HARD).withRarity(FishProperties.Rarity.UNCOMMON));
        FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldDeepDarkFish(ModItems.WARD).withDifficulty(FishProperties.Difficulty.NON_STOP_ACTION).withRarity(FishProperties.Rarity.LEGENDARY).withBaseChance(2));
        FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldDeepDarkFish(ModItems.GLOWING_DARK).withRarity(FishProperties.Rarity.UNCOMMON).withDifficulty(FishProperties.Difficulty.HARD));
        FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.netherLavaFish(ModItems.EMBERGILL).withDifficulty(FishProperties.Difficulty.HARD_ONLY_THIN.withTreasure(FishProperties.Treasure.NETHER)));
        FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.netherLavaFish(ModItems.LAVA_CRAB).withRarity(FishProperties.Rarity.EPIC).withDifficulty(FishProperties.Difficulty.EVERYTHING_FLIP.withTreasure(FishProperties.Treasure.NETHER)));
        FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.netherLavaFish(ModItems.MAGMA_FISH).withRarity(FishProperties.Rarity.UNCOMMON).withDifficulty(FishProperties.Difficulty.HARD.withTreasure(FishProperties.Treasure.NETHER)));
        FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.netherLavaFish(ModItems.GLOWSTONE_SEEKER).withDifficulty(FishProperties.Difficulty.MEDIUM.withTreasure(FishProperties.Treasure.NETHER)));
        FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.netherLavaFish(ModItems.CINDER_SQUID).withDifficulty(FishProperties.Difficulty.SINGLE_BIG_FAST_NO_DECAY.withTreasure(FishProperties.Treasure.NETHER)).withRarity(FishProperties.Rarity.RARE).withBaseChance(2));
        FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.netherLavaFish(ModItems.SCALDING_PIKE).withDifficulty(FishProperties.Difficulty.MEDIUM.withTreasure(FishProperties.Treasure.NETHER)));
        FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.netherLavaFish(ModItems.LAVA_CRAB_CLAW).withBaseChance(1).withSkipMinigame(true).withHasGuideEntry(false));
        FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.endFish(ModItems.CHARFISH).withRarity(FishProperties.Rarity.RARE).withDifficulty(FishProperties.Difficulty.HARD));
    });

    public FishPropertiesProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, registries, REGISTRY, FishPropertiesProvider::addConditions, Set.of("starcatcher"));
    }

    private static void addConditions(BiConsumer<ResourceKey<?>, ICondition> consumer) {
        for (FishPropertiesWithModRestriction restricted : RESTRICTED_FPS) {
            consumer.accept(FishPropertiesProvider.createKey(restricted.fp()), (ICondition)new ModLoadedCondition(restricted.modid()));
        }
    }

    public static FishProperties fish(Holder<Item> fish) {
        return FishProperties.DEFAULT.withFish(fish);
    }

    public static FishProperties overworldFish(Holder<Item> fish) {
        return FishProperties.DEFAULT.withFish(fish).withWorldRestrictions(FishProperties.WorldRestrictions.OVERWORLD);
    }

    public static FishProperties endFish(Holder<Item> fish) {
        return FishProperties.DEFAULT.withFish(fish).withWorldRestrictions(FishProperties.WorldRestrictions.END);
    }

    public static FishProperties netherLavaFish(Holder<Item> fish) {
        return FishProperties.DEFAULT.withFish(fish).withWorldRestrictions(FishProperties.WorldRestrictions.NETHER_LAVA);
    }

    public static FishProperties overworldLushCavesFish(Holder<Item> fish) {
        return FishProperties.DEFAULT.withFish(fish).withWorldRestrictions(FishProperties.WorldRestrictions.OVERWORLD_LUSH_CAVES).withMustBeCaughtBelowY(50);
    }

    public static FishProperties overworldDeepDarkFish(Holder<Item> fish) {
        return FishProperties.DEFAULT.withFish(fish).withWorldRestrictions(FishProperties.WorldRestrictions.OVERWORLD_DEEP_DARK).withMustBeCaughtBelowY(50);
    }

    public static FishProperties overworldCavesFish(Holder<Item> fish) {
        return FishProperties.DEFAULT.withFish(fish).withWorldRestrictions(FishProperties.WorldRestrictions.OVERWORLD).withMustBeCaughtBelowY(50).withMustBeCaughtAboveY(0);
    }

    public static FishProperties overworldDripstoneCavesFish(Holder<Item> fish) {
        return FishProperties.DEFAULT.withFish(fish).withWorldRestrictions(FishProperties.WorldRestrictions.OVERWORLD_DRIPSTONE_CAVES).withMustBeCaughtBelowY(50).withMustBeCaughtAboveY(0);
    }

    public static FishProperties overworldUndergroundFish(Holder<Item> fish) {
        return FishProperties.DEFAULT.withFish(fish).withWorldRestrictions(FishProperties.WorldRestrictions.OVERWORLD).withMustBeCaughtBelowY(50);
    }

    public static FishProperties overworldMountainFish(Holder<Item> fish) {
        return FishProperties.DEFAULT.withFish(fish).withWorldRestrictions(FishProperties.WorldRestrictions.OVERWORLD_LAKE).withMustBeCaughtAboveY(100);
    }

    public static FishProperties overworldDeepslateFish(Holder<Item> fish) {
        return FishProperties.DEFAULT.withFish(fish).withWorldRestrictions(FishProperties.WorldRestrictions.OVERWORLD).withMustBeCaughtBelowY(0);
    }

    public static FishProperties overworldColdLakeFish(Holder<Item> fish) {
        return FishProperties.DEFAULT.withFish(fish).withWorldRestrictions(FishProperties.WorldRestrictions.OVERWORLD_COLD_LAKE).withMustBeCaughtAboveY(50).withMustBeCaughtBelowY(100);
    }

    public static FishProperties overworldWarmLakeFish(Holder<Item> fish) {
        return FishProperties.DEFAULT.withFish(fish).withWorldRestrictions(FishProperties.WorldRestrictions.OVERWORLD_WARM_LAKE).withMustBeCaughtAboveY(50).withMustBeCaughtBelowY(100);
    }

    public static FishProperties overworldWarmMountainFish(Holder<Item> fish) {
        return FishProperties.DEFAULT.withFish(fish).withWorldRestrictions(FishProperties.WorldRestrictions.OVERWORLD_WARM_LAKE).withMustBeCaughtAboveY(100);
    }

    public static FishProperties overworldColdMountainFish(Holder<Item> fish) {
        return FishProperties.DEFAULT.withFish(fish).withWorldRestrictions(FishProperties.WorldRestrictions.OVERWORLD_COLD_LAKE).withMustBeCaughtAboveY(100);
    }

    public static FishProperties overworldColdOceanFish(Holder<Item> fish) {
        return FishProperties.DEFAULT.withFish(fish).withWorldRestrictions(FishProperties.WorldRestrictions.OVERWORLD_COLD_OCEAN).withMustBeCaughtAboveY(50).withMustBeCaughtBelowY(100);
    }

    public static FishProperties overworldColdRiverFish(Holder<Item> fish) {
        return FishProperties.DEFAULT.withFish(fish).withWorldRestrictions(FishProperties.WorldRestrictions.OVERWORLD_COLD_RIVER).withMustBeCaughtAboveY(50).withMustBeCaughtBelowY(100);
    }

    public static FishProperties overworldLakeFish(Holder<Item> fish) {
        return FishProperties.DEFAULT.withFish(fish).withWorldRestrictions(FishProperties.WorldRestrictions.OVERWORLD_LAKE).withMustBeCaughtAboveY(50).withMustBeCaughtBelowY(100);
    }

    public static FishProperties overworldFreshwaterFish(Holder<Item> fish) {
        return FishProperties.DEFAULT.withFish(fish).withWorldRestrictions(FishProperties.WorldRestrictions.OVERWORLD_FRESHWATER).withMustBeCaughtAboveY(50).withMustBeCaughtBelowY(100);
    }

    public static FishProperties overworldWarmFreshwaterFish(Holder<Item> fish) {
        return FishProperties.DEFAULT.withFish(fish).withWorldRestrictions(FishProperties.WorldRestrictions.OVERWORLD_WARM_FRESHWATER).withMustBeCaughtAboveY(50).withMustBeCaughtBelowY(100);
    }

    public static FishProperties overworldColdFreshwaterFish(Holder<Item> fish) {
        return FishProperties.DEFAULT.withFish(fish).withWorldRestrictions(FishProperties.WorldRestrictions.OVERWORLD_COLD_FRESHWATER).withMustBeCaughtAboveY(50).withMustBeCaughtBelowY(100);
    }

    public static FishProperties overworldOceanFish(Holder<Item> fish) {
        return FishProperties.DEFAULT.withFish(fish).withWorldRestrictions(FishProperties.WorldRestrictions.OVERWORLD_OCEAN).withMustBeCaughtAboveY(50).withMustBeCaughtBelowY(100);
    }

    public static FishProperties overworldWarmOceanFish(Holder<Item> fish) {
        return FishProperties.DEFAULT.withFish(fish).withWorldRestrictions(FishProperties.WorldRestrictions.OVERWORLD_WARM_OCEAN).withMustBeCaughtAboveY(50).withMustBeCaughtBelowY(100);
    }

    public static FishProperties overworldDeepOceanFish(Holder<Item> fish) {
        return FishProperties.DEFAULT.withFish(fish).withWorldRestrictions(FishProperties.WorldRestrictions.OVERWORLD_DEEP_OCEAN).withMustBeCaughtAboveY(50).withMustBeCaughtBelowY(100);
    }

    public static FishProperties overworldRiverFish(Holder<Item> fish) {
        return FishProperties.DEFAULT.withFish(fish).withWorldRestrictions(FishProperties.WorldRestrictions.OVERWORLD_RIVER).withMustBeCaughtAboveY(50).withMustBeCaughtBelowY(100);
    }

    public static FishProperties overworldBeachFish(Holder<Item> fish) {
        return FishProperties.DEFAULT.withFish(fish).withWorldRestrictions(FishProperties.WorldRestrictions.OVERWORLD_BEACH).withMustBeCaughtAboveY(0);
    }

    public static FishProperties overworldMushroomFieldsFish(Holder<Item> fish) {
        return FishProperties.DEFAULT.withFish(fish).withWorldRestrictions(FishProperties.WorldRestrictions.OVERWORLD_MUSHROOM_FIELDS).withMustBeCaughtAboveY(0);
    }

    public static FishProperties overworldJungleFish(Holder<Item> fish) {
        return FishProperties.DEFAULT.withFish(fish).withWorldRestrictions(FishProperties.WorldRestrictions.OVERWORLD_JUNGLE).withMustBeCaughtAboveY(0);
    }

    public static FishProperties overworldTaigaFish(Holder<Item> fish) {
        return FishProperties.DEFAULT.withFish(fish).withWorldRestrictions(FishProperties.WorldRestrictions.OVERWORLD_TAIGA).withMustBeCaughtAboveY(0);
    }

    public static FishProperties overworldCherryGroveFish(Holder<Item> fish) {
        return FishProperties.DEFAULT.withFish(fish).withWorldRestrictions(FishProperties.WorldRestrictions.OVERWORLD_CHERRY_GROVE).withMustBeCaughtAboveY(0);
    }

    public static FishProperties overworldSwampFish(Holder<Item> fish) {
        return FishProperties.DEFAULT.withFish(fish).withWorldRestrictions(FishProperties.WorldRestrictions.OVERWORLD_SWAMP).withMustBeCaughtAboveY(0);
    }

    public static FishProperties overworldDarkForestFish(Holder<Item> fish) {
        return FishProperties.DEFAULT.withFish(fish).withWorldRestrictions(FishProperties.WorldRestrictions.OVERWORLD_DARK_FOREST).withMustBeCaughtAboveY(0);
    }

    public static ResourceLocation rl(String namespace, String path) {
        return ResourceLocation.fromNamespaceAndPath((String)namespace, (String)path);
    }

    public static Holder.Reference<FishProperties> register(BootstrapContext<FishProperties> bootstrap, FishProperties fp) {
        return bootstrap.register(FishPropertiesProvider.createKey(fp), (Object)fp);
    }

    public static Holder<Item> fromRL(String ns, String path) {
        return TrustedHolder.createStandAlone((HolderOwner)BuiltInRegistries.ITEM.holderOwner(), (ResourceKey)ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)FishPropertiesProvider.rl(ns, path)));
    }

    public static ResourceKey<FishProperties> createKey(FishProperties fp) {
        if (fp.customName().isEmpty()) {
            return ResourceKey.create(Starcatcher.FISH_REGISTRY, (ResourceLocation)Starcatcher.rl(fp.fish().getRegisteredName().replace(":", "_")));
        }
        return ResourceKey.create(Starcatcher.FISH_REGISTRY, (ResourceLocation)Starcatcher.rl("starcatcher_" + fp.customName()));
    }
}

