/*
 * Decompiled with CFR 0.152.
 */
package com.wdiscute.starcatcher.fishentity;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Leashable;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class FishEntity
extends AbstractFish {
    public ItemStack is;
    public static final EntityDataAccessor<ItemStack> ITEMSTACK = SynchedEntityData.defineId(FishEntity.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK);

    public FishEntity(EntityType<? extends FishEntity> entityType, Level level) {
        super(entityType, level);
    }

    protected SoundEvent getAmbientSound() {
        return SoundEvents.TROPICAL_FISH_AMBIENT;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.TROPICAL_FISH_DEATH;
    }

    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return SoundEvents.TROPICAL_FISH_HURT;
    }

    protected SoundEvent getFlopSound() {
        return SoundEvents.TROPICAL_FISH_FLOP;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 3.0);
    }

    public void setFish(ItemStack is) {
        this.is = is;
        this.entityData.set(ITEMSTACK, (Object)is);
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide) {
            this.is = (ItemStack)this.entityData.get(ITEMSTACK);
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(ITEMSTACK, (Object)ItemStack.EMPTY);
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
    }

    public void writeLeashData(CompoundTag tag, @Nullable Leashable.LeashData leashData) {
        super.writeLeashData(tag, leashData);
    }

    public ItemStack getBucketItemStack() {
        return this.is;
    }
}

