/*
 * Decompiled with CFR 0.152.
 */
package com.wdiscute.starcatcher.items;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.wdiscute.starcatcher.ModDataComponents;
import java.util.List;
import java.util.Random;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.FastColor;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class ColorfulBobber
extends Item {
    public ColorfulBobber() {
        super(new Item.Properties().component(ModDataComponents.BOBBER_COLOR, (Object)BobberColor.DEFAULT));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.translatable((String)"tooltip.starcatcher.colorful_bobber.999").withColor(((BobberColor)stack.get(ModDataComponents.BOBBER_COLOR)).getColorAsInt()));
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            BobberColor bobberColor = BobberColor.random();
            player.getItemInHand(usedHand).set(ModDataComponents.BOBBER_COLOR, (Object)bobberColor);
            sp.displayClientMessage((Component)Component.literal((String)"Your bobber shines differently...").withColor(bobberColor.getColorAsInt()), true);
        }
        return InteractionResultHolder.success((Object)player.getItemInHand(usedHand));
    }

    public record BobberColor(float r, float g, float b) {
        public static final Codec<BobberColor> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("r").forGetter(BobberColor::r), (App)Codec.FLOAT.fieldOf("g").forGetter(BobberColor::g), (App)Codec.FLOAT.fieldOf("b").forGetter(BobberColor::b)).apply((Applicative)instance, BobberColor::new));
        public static final BobberColor DEFAULT = new BobberColor(0.5f, 0.8f, 0.5f);

        public static BobberColor random() {
            Random r = new Random();
            return new BobberColor(r.nextFloat(), r.nextFloat(), r.nextFloat());
        }

        public int getColorAsInt() {
            return FastColor.ARGB32.color((int)255, (int)((int)(this.r * 255.0f)), (int)((int)(this.g * 255.0f)), (int)((int)(this.b * 255.0f)));
        }
    }
}

