/*
 * Decompiled with CFR 0.152.
 */
package com.wdiscute.starcatcher.items;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;

public class FishingTreasure
extends Item {
    private final ResourceLocation lootTable;

    public FishingTreasure(ResourceLocation rl) {
        super(new Item.Properties().stacksTo(1));
        this.lootTable = rl;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        if (level.isClientSide) {
            return InteractionResultHolder.success((Object)player.getItemInHand(usedHand));
        }
        ResourceKey lootTable = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)this.lootTable);
        LootParams.Builder builder = new LootParams.Builder((ServerLevel)level);
        LootParams params = builder.create(LootContextParamSets.EMPTY);
        ObjectArrayList arrayOfItemStacks = level.getServer().reloadableRegistries().getLootTable(lootTable).getRandomItems(params);
        if (!arrayOfItemStacks.isEmpty()) {
            ItemStack is = (ItemStack)arrayOfItemStacks.get(0);
            player.setItemInHand(usedHand, is);
        }
        return InteractionResultHolder.success((Object)player.getItemInHand(usedHand));
    }
}

