/*
 * Decompiled with CFR 0.152.
 */
package com.wdiscute.starcatcher.networkandstuff;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Function11;
import com.mojang.datafixers.util.Function12;
import com.mojang.datafixers.util.Function13;
import com.mojang.datafixers.util.Function7;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.wdiscute.starcatcher.ModDataComponents;
import com.wdiscute.starcatcher.ModItems;
import com.wdiscute.starcatcher.Starcatcher;
import com.wdiscute.starcatcher.StarcatcherTags;
import com.wdiscute.starcatcher.datagen.FishPropertiesWithModRestriction;
import com.wdiscute.starcatcher.fishingbob.FishingBobEntity;
import com.wdiscute.starcatcher.networkandstuff.SingleStackContainer;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.network.codec.NeoForgeStreamCodecs;

public record FishProperties(Holder<Item> fish, int baseChance, String customName, Rarity rarity, WorldRestrictions wr, BaitRestrictions br, Difficulty dif, Daytime daytime, Weather weather, int mustBeCaughtBelowY, int mustBeCaughtAboveY, boolean skipMinigame, boolean hasGuideEntry) {
    public static final Codec<FishProperties> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BuiltInRegistries.ITEM.holderByNameCodec().fieldOf("fish").forGetter(FishProperties::fish), (App)Codec.INT.optionalFieldOf("base_chance", (Object)5).forGetter(FishProperties::baseChance), (App)Codec.STRING.optionalFieldOf("customName", (Object)"").forGetter(FishProperties::customName), (App)Rarity.CODEC.optionalFieldOf("rarity", (Object)Rarity.COMMON).forGetter(FishProperties::rarity), (App)WorldRestrictions.CODEC.optionalFieldOf("world_restrictions", (Object)WorldRestrictions.DEFAULT).forGetter(FishProperties::wr), (App)BaitRestrictions.CODEC.optionalFieldOf("bait_restrictions", (Object)BaitRestrictions.DEFAULT).forGetter(FishProperties::br), (App)Difficulty.CODEC.optionalFieldOf("difficulty", (Object)Difficulty.DEFAULT).forGetter(FishProperties::dif), (App)Daytime.CODEC.optionalFieldOf("daytime", (Object)Daytime.ALL).forGetter(FishProperties::daytime), (App)Weather.CODEC.optionalFieldOf("weather", (Object)Weather.ALL).forGetter(FishProperties::weather), (App)Codec.INT.optionalFieldOf("below_y", (Object)Integer.MAX_VALUE).forGetter(FishProperties::mustBeCaughtBelowY), (App)Codec.INT.optionalFieldOf("above_y", (Object)Integer.MIN_VALUE).forGetter(FishProperties::mustBeCaughtAboveY), (App)Codec.BOOL.optionalFieldOf("skips_minigame", (Object)false).forGetter(FishProperties::skipMinigame), (App)Codec.BOOL.optionalFieldOf("has_guide_entry", (Object)true).forGetter(FishProperties::hasGuideEntry)).apply((Applicative)instance, FishProperties::new));
    public static final Codec<List<FishProperties>> LIST_CODEC = CODEC.listOf();
    public static final StreamCodec<RegistryFriendlyByteBuf, FishProperties> STREAM_CODEC = FishProperties.composite(ByteBufCodecs.holderRegistry((ResourceKey)Registries.ITEM), FishProperties::fish, ByteBufCodecs.VAR_INT, FishProperties::baseChance, ByteBufCodecs.STRING_UTF8, FishProperties::customName, Rarity.STREAM_CODEC, FishProperties::rarity, WorldRestrictions.STREAM_CODEC, FishProperties::wr, BaitRestrictions.STREAM_CODEC, FishProperties::br, Difficulty.STREAM_CODEC, FishProperties::dif, Daytime.STREAM_CODEC, FishProperties::daytime, Weather.STREAM_CODEC, FishProperties::weather, ByteBufCodecs.VAR_INT, FishProperties::mustBeCaughtBelowY, ByteBufCodecs.VAR_INT, FishProperties::mustBeCaughtAboveY, ByteBufCodecs.BOOL, FishProperties::skipMinigame, ByteBufCodecs.BOOL, FishProperties::hasGuideEntry, FishProperties::new);
    public static final StreamCodec<RegistryFriendlyByteBuf, List<FishProperties>> STREAM_CODEC_LIST = STREAM_CODEC.apply(ByteBufCodecs.list());
    public static final FishProperties DEFAULT = new FishProperties((Holder<Item>)ModItems.MISSINGNO, 5, "", Rarity.COMMON, WorldRestrictions.DEFAULT, BaitRestrictions.DEFAULT, Difficulty.DEFAULT, Daytime.ALL, Weather.ALL, Integer.MAX_VALUE, Integer.MIN_VALUE, false, true);

    public FishPropertiesWithModRestriction withMod(String modid) {
        return new FishPropertiesWithModRestriction(this, modid);
    }

    public FishProperties withFish(Holder<Item> fish) {
        return new FishProperties(fish, this.baseChance, this.customName, this.rarity, this.wr, this.br, this.dif, this.daytime, this.weather, this.mustBeCaughtBelowY, this.mustBeCaughtAboveY, this.skipMinigame, this.hasGuideEntry);
    }

    public FishProperties withBaseChance(int baseChance) {
        return new FishProperties(this.fish, baseChance, this.customName, this.rarity, this.wr, this.br, this.dif, this.daytime, this.weather, this.mustBeCaughtBelowY, this.mustBeCaughtAboveY, this.skipMinigame, this.hasGuideEntry);
    }

    public FishProperties withCustomName(String customName) {
        return new FishProperties(this.fish, this.baseChance, customName, this.rarity, this.wr, this.br, this.dif, this.daytime, this.weather, this.mustBeCaughtBelowY, this.mustBeCaughtAboveY, this.skipMinigame, this.hasGuideEntry);
    }

    public FishProperties withRarity(Rarity rarity) {
        return new FishProperties(this.fish, this.baseChance, this.customName, rarity, this.wr, this.br, this.dif, this.daytime, this.weather, this.mustBeCaughtBelowY, this.mustBeCaughtAboveY, this.skipMinigame, this.hasGuideEntry);
    }

    public FishProperties withWorldRestrictions(WorldRestrictions wr) {
        return new FishProperties(this.fish, this.baseChance, this.customName, this.rarity, wr, this.br, this.dif, this.daytime, this.weather, this.mustBeCaughtBelowY, this.mustBeCaughtAboveY, this.skipMinigame, this.hasGuideEntry);
    }

    public FishProperties withBaitRestrictions(BaitRestrictions br) {
        return new FishProperties(this.fish, this.baseChance, this.customName, this.rarity, this.wr, br, this.dif, this.daytime, this.weather, this.mustBeCaughtBelowY, this.mustBeCaughtAboveY, this.skipMinigame, this.hasGuideEntry);
    }

    public FishProperties withDifficulty(Difficulty dif) {
        return new FishProperties(this.fish, this.baseChance, this.customName, this.rarity, this.wr, this.br, dif, this.daytime, this.weather, this.mustBeCaughtBelowY, this.mustBeCaughtAboveY, this.skipMinigame, this.hasGuideEntry);
    }

    public FishProperties withDaytime(Daytime daytime) {
        return new FishProperties(this.fish, this.baseChance, this.customName, this.rarity, this.wr, this.br, this.dif, daytime, this.weather, this.mustBeCaughtBelowY, this.mustBeCaughtAboveY, this.skipMinigame, this.hasGuideEntry);
    }

    public FishProperties withWeather(Weather weather) {
        return new FishProperties(this.fish, this.baseChance, this.customName, this.rarity, this.wr, this.br, this.dif, this.daytime, weather, this.mustBeCaughtBelowY, this.mustBeCaughtAboveY, this.skipMinigame, this.hasGuideEntry);
    }

    public FishProperties withMustBeCaughtBelowY(int mustBeCaughtBelowY) {
        return new FishProperties(this.fish, this.baseChance, this.customName, this.rarity, this.wr, this.br, this.dif, this.daytime, this.weather, mustBeCaughtBelowY, this.mustBeCaughtAboveY, this.skipMinigame, this.hasGuideEntry);
    }

    public FishProperties withMustBeCaughtAboveY(int mustBeCaughtAboveY) {
        return new FishProperties(this.fish, this.baseChance, this.customName, this.rarity, this.wr, this.br, this.dif, this.daytime, this.weather, this.mustBeCaughtBelowY, mustBeCaughtAboveY, this.skipMinigame, this.hasGuideEntry);
    }

    public FishProperties withSkipMinigame(boolean skipMinigame) {
        return new FishProperties(this.fish, this.baseChance, this.customName, this.rarity, this.wr, this.br, this.dif, this.daytime, this.weather, this.mustBeCaughtBelowY, this.mustBeCaughtAboveY, skipMinigame, this.hasGuideEntry);
    }

    public FishProperties withHasGuideEntry(boolean hasGuideEntry) {
        return new FishProperties(this.fish, this.baseChance, this.customName, this.rarity, this.wr, this.br, this.dif, this.daytime, this.weather, this.mustBeCaughtBelowY, this.mustBeCaughtAboveY, this.skipMinigame, hasGuideEntry);
    }

    public static List<ResourceLocation> getBiomesAsList(FishProperties fp, Level level) {
        level.registryAccess().registry(Registries.BIOME);
        ArrayList<ResourceLocation> rls = new ArrayList<ResourceLocation>();
        for (ResourceLocation rl : fp.wr.biomesTags) {
            TagKey biomeBeingChecked = TagKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)rl);
            Optional optional = level.registryAccess().lookupOrThrow(Registries.BIOME).get(biomeBeingChecked);
            if (!optional.isPresent()) continue;
            for (Holder biomeHolder : (HolderSet.Named)optional.get()) {
                String biomeString = biomeHolder.getRegisteredName();
                rls.add(ResourceLocation.parse((String)biomeString));
            }
        }
        for (ResourceLocation rl : fp.wr.biomes) {
            Optional optional = level.registryAccess().lookupOrThrow(Registries.BIOME).get(ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)rl));
            if (!optional.isPresent() || rls.contains(rl)) continue;
            rls.add(rl);
        }
        return rls;
    }

    public static List<ResourceLocation> getBiomesBlacklistAsList(FishProperties fp, Level level) {
        level.registryAccess().registry(Registries.BIOME);
        ArrayList<ResourceLocation> rls = new ArrayList<ResourceLocation>();
        for (ResourceLocation rl : fp.wr.biomesBlacklistTags) {
            TagKey biomeBeingChecked = TagKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)rl);
            Optional optional = level.registryAccess().lookupOrThrow(Registries.BIOME).get(biomeBeingChecked);
            if (!optional.isPresent()) continue;
            for (Holder biomeHolder : (HolderSet.Named)optional.get()) {
                String biomeString = biomeHolder.getRegisteredName();
                rls.add(ResourceLocation.parse((String)biomeString));
            }
        }
        for (ResourceLocation rl : fp.wr.biomesBlacklist) {
            Optional optional = level.registryAccess().lookupOrThrow(Registries.BIOME).get(ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)rl));
            if (!optional.isPresent() || rls.contains(rl)) continue;
            rls.add(rl);
        }
        return rls;
    }

    public static List<FishProperties> getFPs(Level level) {
        return FishProperties.getFPs(level.registryAccess());
    }

    public static List<FishProperties> getFPs(RegistryAccess registryAccess) {
        return registryAccess.registryOrThrow(Starcatcher.FISH_REGISTRY).stream().toList();
    }

    public static int getChance(FishProperties fp, Entity entity, ItemStack rod) {
        Level level = entity.level();
        int chance = fp.baseChance();
        ItemStack bobber = ((SingleStackContainer)rod.get(ModDataComponents.BOBBER)).stack().copy();
        ItemStack bait = ((SingleStackContainer)rod.get(ModDataComponents.BAIT)).stack().copy();
        if (!fp.wr.dims.isEmpty() && !fp.wr().dims().contains(level.dimension().location())) {
            return 0;
        }
        if (fp.wr.dimsBlacklist.contains(level.dimension().location())) {
            return 0;
        }
        List<ResourceLocation> biomes = FishProperties.getBiomesAsList(fp, level);
        List<ResourceLocation> blacklist = FishProperties.getBiomesBlacklistAsList(fp, level);
        ResourceLocation currentBiome = level.getBiome(entity.blockPosition()).getKey().location();
        if (!biomes.isEmpty() && !biomes.contains(currentBiome)) {
            return 0;
        }
        if (!blacklist.isEmpty() && blacklist.contains(currentBiome)) {
            return 0;
        }
        boolean fluid = fp.wr.fluids.contains(BuiltInRegistries.FLUID.getKey((Object)FishProperties.getSource(level.getFluidState(entity.blockPosition()).getType())));
        boolean fluidAbove = fp.wr.fluids.contains(BuiltInRegistries.FLUID.getKey((Object)FishProperties.getSource(level.getFluidState(entity.blockPosition().above()).getType())));
        boolean fluidBelow = fp.wr.fluids.contains(BuiltInRegistries.FLUID.getKey((Object)FishProperties.getSource(level.getFluidState(entity.blockPosition().below()).getType())));
        if (!fluid && !fluidAbove && !fluidBelow && entity instanceof FishingBobEntity) {
            return 0;
        }
        if (fp.br().incorrectBaits().contains(BuiltInRegistries.ITEM.getKey((Object)bait.getItem()))) {
            return 0;
        }
        if (entity.position().y > (double)fp.mustBeCaughtBelowY()) {
            return 0;
        }
        if (entity.position().y < (double)fp.mustBeCaughtAboveY()) {
            return 0;
        }
        if (fp.daytime() != Daytime.ALL) {
            long time = level.getDayTime() % 24000L;
            switch (fp.daytime().ordinal()) {
                case 1: {
                    if (time > 23000L || time < 12700L) break;
                    return 0;
                }
                case 2: {
                    if (time > 3500L && time < 8500L) break;
                    return 0;
                }
                case 3: {
                    if (time < 23000L && time > 12700L) break;
                    return 0;
                }
                case 4: {
                    if (time > 16500L && time < 19500L) break;
                    return 0;
                }
            }
        }
        if (fp.weather() == Weather.CLEAR && ((double)level.getRainLevel(0.0f) > 0.5 || (double)level.getThunderLevel(0.0f) > 0.5)) {
            return 0;
        }
        if (fp.weather() == Weather.RAIN && (double)level.getRainLevel(0.0f) < 0.5) {
            return 0;
        }
        if (fp.weather() == Weather.THUNDER && (double)level.getThunderLevel(0.0f) < 0.5) {
            return 0;
        }
        if (fp.br().mustHaveCorrectBait() && !fp.br().correctBait().contains(BuiltInRegistries.ITEM.getKey((Object)bait.getItem()))) {
            return 0;
        }
        if (fp.br().correctBait().contains(BuiltInRegistries.ITEM.getKey((Object)bait.getItem()))) {
            chance += fp.br().correctBaitChanceAdded();
        }
        if (!fp.br().correctBobber().isEmpty() && !fp.br().correctBobber().contains(BuiltInRegistries.ITEM.getKey((Object)bobber.getItem()))) {
            return 0;
        }
        return chance;
    }

    public static List<FishProperties> getFpsWithGuideEntryForArea(Entity entity) {
        ArrayList<FishProperties> list = new ArrayList<FishProperties>();
        for (FishProperties fp : entity.level().registryAccess().registryOrThrow(Starcatcher.FISH_REGISTRY)) {
            if (FishProperties.getChance(fp, entity, new ItemStack((ItemLike)ModItems.ROD.get())) <= 0 || !fp.hasGuideEntry) continue;
            list.add(fp);
        }
        return list;
    }

    public static Fluid getSource(Fluid fluid1) {
        if (fluid1 instanceof FlowingFluid) {
            FlowingFluid fluid = (FlowingFluid)fluid1;
            return fluid.getSource();
        }
        return fluid1;
    }

    static <B, C, T1, T2, T3, T4, T5, T6, T7> StreamCodec<B, C> composite(final StreamCodec<? super B, T1> codec1, final Function<C, T1> getter1, final StreamCodec<? super B, T2> codec2, final Function<C, T2> getter2, final StreamCodec<? super B, T3> codec3, final Function<C, T3> getter3, final StreamCodec<? super B, T4> codec4, final Function<C, T4> getter4, final StreamCodec<? super B, T5> codec5, final Function<C, T5> getter5, final StreamCodec<? super B, T6> codec6, final Function<C, T6> getter6, final StreamCodec<? super B, T7> codec7, final Function<C, T7> getter7, final Function7<T1, T2, T3, T4, T5, T6, T7, C> factory) {
        return new StreamCodec<B, C>(){

            public C decode(B p_330310_) {
                Object t1 = codec1.decode(p_330310_);
                Object t2 = codec2.decode(p_330310_);
                Object t3 = codec3.decode(p_330310_);
                Object t4 = codec4.decode(p_330310_);
                Object t5 = codec5.decode(p_330310_);
                Object t6 = codec6.decode(p_330310_);
                Object t7 = codec7.decode(p_330310_);
                return factory.apply(t1, t2, t3, t4, t5, t6, t7);
            }

            public void encode(B p_332052_, C p_331912_) {
                codec1.encode(p_332052_, getter1.apply(p_331912_));
                codec2.encode(p_332052_, getter2.apply(p_331912_));
                codec3.encode(p_332052_, getter3.apply(p_331912_));
                codec4.encode(p_332052_, getter4.apply(p_331912_));
                codec5.encode(p_332052_, getter5.apply(p_331912_));
                codec6.encode(p_332052_, getter6.apply(p_331912_));
                codec7.encode(p_332052_, getter7.apply(p_331912_));
            }
        };
    }

    static <B, C, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11> StreamCodec<B, C> composite(final StreamCodec<? super B, T1> codec1, final Function<C, T1> getter1, final StreamCodec<? super B, T2> codec2, final Function<C, T2> getter2, final StreamCodec<? super B, T3> codec3, final Function<C, T3> getter3, final StreamCodec<? super B, T4> codec4, final Function<C, T4> getter4, final StreamCodec<? super B, T5> codec5, final Function<C, T5> getter5, final StreamCodec<? super B, T6> codec6, final Function<C, T6> getter6, final StreamCodec<? super B, T7> codec7, final Function<C, T7> getter7, final StreamCodec<? super B, T8> codec8, final Function<C, T8> getter8, final StreamCodec<? super B, T9> codec9, final Function<C, T9> getter9, final StreamCodec<? super B, T10> codec10, final Function<C, T10> getter10, final StreamCodec<? super B, T11> codec11, final Function<C, T11> getter11, final Function11<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, C> factory) {
        return new StreamCodec<B, C>(){

            public C decode(B p_330310_) {
                Object t1 = codec1.decode(p_330310_);
                Object t2 = codec2.decode(p_330310_);
                Object t3 = codec3.decode(p_330310_);
                Object t4 = codec4.decode(p_330310_);
                Object t5 = codec5.decode(p_330310_);
                Object t6 = codec6.decode(p_330310_);
                Object t7 = codec7.decode(p_330310_);
                Object t8 = codec8.decode(p_330310_);
                Object t9 = codec9.decode(p_330310_);
                Object t10 = codec10.decode(p_330310_);
                Object t11 = codec11.decode(p_330310_);
                return factory.apply(t1, t2, t3, t4, t5, t6, t7, t8, t9, t10, t11);
            }

            public void encode(B p_332052_, C p_331912_) {
                codec1.encode(p_332052_, getter1.apply(p_331912_));
                codec2.encode(p_332052_, getter2.apply(p_331912_));
                codec3.encode(p_332052_, getter3.apply(p_331912_));
                codec4.encode(p_332052_, getter4.apply(p_331912_));
                codec5.encode(p_332052_, getter5.apply(p_331912_));
                codec6.encode(p_332052_, getter6.apply(p_331912_));
                codec7.encode(p_332052_, getter7.apply(p_331912_));
                codec8.encode(p_332052_, getter8.apply(p_331912_));
                codec9.encode(p_332052_, getter9.apply(p_331912_));
                codec10.encode(p_332052_, getter10.apply(p_331912_));
                codec11.encode(p_332052_, getter11.apply(p_331912_));
            }
        };
    }

    static <B, C, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12> StreamCodec<B, C> composite(final StreamCodec<? super B, T1> codec1, final Function<C, T1> getter1, final StreamCodec<? super B, T2> codec2, final Function<C, T2> getter2, final StreamCodec<? super B, T3> codec3, final Function<C, T3> getter3, final StreamCodec<? super B, T4> codec4, final Function<C, T4> getter4, final StreamCodec<? super B, T5> codec5, final Function<C, T5> getter5, final StreamCodec<? super B, T6> codec6, final Function<C, T6> getter6, final StreamCodec<? super B, T7> codec7, final Function<C, T7> getter7, final StreamCodec<? super B, T8> codec8, final Function<C, T8> getter8, final StreamCodec<? super B, T9> codec9, final Function<C, T9> getter9, final StreamCodec<? super B, T10> codec10, final Function<C, T10> getter10, final StreamCodec<? super B, T11> codec11, final Function<C, T11> getter11, final StreamCodec<? super B, T12> codec12, final Function<C, T12> getter12, final Function12<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, C> factory) {
        return new StreamCodec<B, C>(){

            public C decode(B p_330310_) {
                Object t1 = codec1.decode(p_330310_);
                Object t2 = codec2.decode(p_330310_);
                Object t3 = codec3.decode(p_330310_);
                Object t4 = codec4.decode(p_330310_);
                Object t5 = codec5.decode(p_330310_);
                Object t6 = codec6.decode(p_330310_);
                Object t7 = codec7.decode(p_330310_);
                Object t8 = codec8.decode(p_330310_);
                Object t9 = codec9.decode(p_330310_);
                Object t10 = codec10.decode(p_330310_);
                Object t11 = codec11.decode(p_330310_);
                Object t12 = codec12.decode(p_330310_);
                return factory.apply(t1, t2, t3, t4, t5, t6, t7, t8, t9, t10, t11, t12);
            }

            public void encode(B p_332052_, C p_331912_) {
                codec1.encode(p_332052_, getter1.apply(p_331912_));
                codec2.encode(p_332052_, getter2.apply(p_331912_));
                codec3.encode(p_332052_, getter3.apply(p_331912_));
                codec4.encode(p_332052_, getter4.apply(p_331912_));
                codec5.encode(p_332052_, getter5.apply(p_331912_));
                codec6.encode(p_332052_, getter6.apply(p_331912_));
                codec7.encode(p_332052_, getter7.apply(p_331912_));
                codec8.encode(p_332052_, getter8.apply(p_331912_));
                codec9.encode(p_332052_, getter9.apply(p_331912_));
                codec10.encode(p_332052_, getter10.apply(p_331912_));
                codec11.encode(p_332052_, getter11.apply(p_331912_));
                codec12.encode(p_332052_, getter12.apply(p_331912_));
            }
        };
    }

    static <B, C, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13> StreamCodec<B, C> composite(final StreamCodec<? super B, T1> codec1, final Function<C, T1> getter1, final StreamCodec<? super B, T2> codec2, final Function<C, T2> getter2, final StreamCodec<? super B, T3> codec3, final Function<C, T3> getter3, final StreamCodec<? super B, T4> codec4, final Function<C, T4> getter4, final StreamCodec<? super B, T5> codec5, final Function<C, T5> getter5, final StreamCodec<? super B, T6> codec6, final Function<C, T6> getter6, final StreamCodec<? super B, T7> codec7, final Function<C, T7> getter7, final StreamCodec<? super B, T8> codec8, final Function<C, T8> getter8, final StreamCodec<? super B, T9> codec9, final Function<C, T9> getter9, final StreamCodec<? super B, T10> codec10, final Function<C, T10> getter10, final StreamCodec<? super B, T11> codec11, final Function<C, T11> getter11, final StreamCodec<? super B, T12> codec12, final Function<C, T12> getter12, final StreamCodec<? super B, T13> codec13, final Function<C, T13> getter13, final Function13<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, C> factory) {
        return new StreamCodec<B, C>(){

            public C decode(B p_330310_) {
                Object t1 = codec1.decode(p_330310_);
                Object t2 = codec2.decode(p_330310_);
                Object t3 = codec3.decode(p_330310_);
                Object t4 = codec4.decode(p_330310_);
                Object t5 = codec5.decode(p_330310_);
                Object t6 = codec6.decode(p_330310_);
                Object t7 = codec7.decode(p_330310_);
                Object t8 = codec8.decode(p_330310_);
                Object t9 = codec9.decode(p_330310_);
                Object t10 = codec10.decode(p_330310_);
                Object t11 = codec11.decode(p_330310_);
                Object t12 = codec12.decode(p_330310_);
                Object t13 = codec13.decode(p_330310_);
                return factory.apply(t1, t2, t3, t4, t5, t6, t7, t8, t9, t10, t11, t12, t13);
            }

            public void encode(B p_332052_, C p_331912_) {
                codec1.encode(p_332052_, getter1.apply(p_331912_));
                codec2.encode(p_332052_, getter2.apply(p_331912_));
                codec3.encode(p_332052_, getter3.apply(p_331912_));
                codec4.encode(p_332052_, getter4.apply(p_331912_));
                codec5.encode(p_332052_, getter5.apply(p_331912_));
                codec6.encode(p_332052_, getter6.apply(p_331912_));
                codec7.encode(p_332052_, getter7.apply(p_331912_));
                codec8.encode(p_332052_, getter8.apply(p_331912_));
                codec9.encode(p_332052_, getter9.apply(p_331912_));
                codec10.encode(p_332052_, getter10.apply(p_331912_));
                codec11.encode(p_332052_, getter11.apply(p_331912_));
                codec12.encode(p_332052_, getter12.apply(p_331912_));
                codec13.encode(p_332052_, getter13.apply(p_331912_));
            }
        };
    }

    public static enum Rarity implements StringRepresentable
    {
        COMMON("common"),
        UNCOMMON("uncommon"),
        RARE("rare"),
        EPIC("epic"),
        LEGENDARY("legendary");

        public static final Codec<Rarity> CODEC;
        public static final StreamCodec<FriendlyByteBuf, Rarity> STREAM_CODEC;
        private final String key;

        private Rarity(String key) {
            this.key = key;
        }

        public String getSerializedName() {
            return this.key;
        }

        static {
            CODEC = StringRepresentable.fromEnum(Rarity::values);
            STREAM_CODEC = NeoForgeStreamCodecs.enumCodec(Rarity.class);
        }
    }

    public record WorldRestrictions(List<ResourceLocation> dims, List<ResourceLocation> dimsBlacklist, List<ResourceLocation> biomes, List<ResourceLocation> biomesTags, List<ResourceLocation> biomesBlacklist, List<ResourceLocation> biomesBlacklistTags, List<ResourceLocation> fluids) {
        public static final Codec<WorldRestrictions> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.list((Codec)ResourceLocation.CODEC).optionalFieldOf("dimensions", List.of()).forGetter(WorldRestrictions::dims), (App)Codec.list((Codec)ResourceLocation.CODEC).optionalFieldOf("dimensions_blacklist", List.of()).forGetter(WorldRestrictions::dimsBlacklist), (App)Codec.list((Codec)ResourceLocation.CODEC).optionalFieldOf("biomes", List.of()).forGetter(WorldRestrictions::biomes), (App)Codec.list((Codec)ResourceLocation.CODEC).optionalFieldOf("biomes_tags", List.of()).forGetter(WorldRestrictions::biomesTags), (App)Codec.list((Codec)ResourceLocation.CODEC).optionalFieldOf("biomes_blacklist", List.of()).forGetter(WorldRestrictions::biomesBlacklist), (App)Codec.list((Codec)ResourceLocation.CODEC).optionalFieldOf("biomes_blacklist_tags", List.of()).forGetter(WorldRestrictions::biomesBlacklistTags), (App)Codec.list((Codec)ResourceLocation.CODEC).optionalFieldOf("fluids", List.of(ResourceLocation.withDefaultNamespace((String)"water"))).forGetter(WorldRestrictions::fluids)).apply((Applicative)instance, WorldRestrictions::new));
        public static final StreamCodec<ByteBuf, WorldRestrictions> STREAM_CODEC = FishProperties.composite(ByteBufCodecs.fromCodec((Codec)Codec.list((Codec)ResourceLocation.CODEC)), WorldRestrictions::dims, ByteBufCodecs.fromCodec((Codec)Codec.list((Codec)ResourceLocation.CODEC)), WorldRestrictions::dimsBlacklist, ByteBufCodecs.fromCodec((Codec)Codec.list((Codec)ResourceLocation.CODEC)), WorldRestrictions::biomes, ByteBufCodecs.fromCodec((Codec)Codec.list((Codec)ResourceLocation.CODEC)), WorldRestrictions::biomesTags, ByteBufCodecs.fromCodec((Codec)Codec.list((Codec)ResourceLocation.CODEC)), WorldRestrictions::biomesBlacklist, ByteBufCodecs.fromCodec((Codec)Codec.list((Codec)ResourceLocation.CODEC)), WorldRestrictions::biomesBlacklistTags, ByteBufCodecs.fromCodec((Codec)Codec.list((Codec)ResourceLocation.CODEC)), WorldRestrictions::fluids, WorldRestrictions::new);
        public static final WorldRestrictions DEFAULT = new WorldRestrictions(List.of(), List.of(), List.of(), List.of(), List.of(), List.of(), List.of(ResourceLocation.withDefaultNamespace((String)"water")));
        public static final WorldRestrictions OVERWORLD = DEFAULT.withDims(Level.OVERWORLD.location());
        public static final WorldRestrictions OVERWORLD_LUSH_CAVES = DEFAULT.withDims(Level.OVERWORLD.location()).withBiomes(Biomes.LUSH_CAVES.location());
        public static final WorldRestrictions OVERWORLD_DRIPSTONE_CAVES = DEFAULT.withDims(Level.OVERWORLD.location()).withBiomes(Biomes.DRIPSTONE_CAVES.location());
        public static final WorldRestrictions OVERWORLD_DEEP_DARK = DEFAULT.withDims(Level.OVERWORLD.location()).withBiomes(Biomes.DEEP_DARK.location());
        public static final WorldRestrictions OVERWORLD_RIVER = DEFAULT.withDims(Level.OVERWORLD.location()).withBiomesTags(StarcatcherTags.IS_RIVER);
        public static final WorldRestrictions OVERWORLD_OCEAN = DEFAULT.withDims(Level.OVERWORLD.location()).withBiomesTags(StarcatcherTags.IS_OCEAN);
        public static final WorldRestrictions OVERWORLD_WARM_OCEAN = DEFAULT.withDims(Level.OVERWORLD.location()).withBiomesTags(StarcatcherTags.IS_WARM_OCEAN);
        public static final WorldRestrictions OVERWORLD_DEEP_OCEAN = DEFAULT.withDims(Level.OVERWORLD.location()).withBiomesTags(StarcatcherTags.IS_DEEP_OCEAN);
        public static final WorldRestrictions OVERWORLD_LAKE = DEFAULT.withDims(Level.OVERWORLD.location()).withBiomesBlacklistTags(List.of(StarcatcherTags.IS_OCEAN, StarcatcherTags.IS_RIVER));
        public static final WorldRestrictions OVERWORLD_FRESHWATER = DEFAULT.withDims(Level.OVERWORLD.location()).withBiomesBlacklistTags(StarcatcherTags.IS_OCEAN);
        public static final WorldRestrictions OVERWORLD_COLD_FRESHWATER = DEFAULT.withDims(Level.OVERWORLD.location()).withBiomesTags(List.of(StarcatcherTags.IS_COLD_LAKE, StarcatcherTags.IS_COLD_RIVER));
        public static final WorldRestrictions OVERWORLD_WARM_FRESHWATER = DEFAULT.withDims(Level.OVERWORLD.location()).withBiomesTags(List.of(StarcatcherTags.IS_WARM_LAKE, StarcatcherTags.IS_WARM_RIVER));
        public static final WorldRestrictions OVERWORLD_WARM_LAKE = DEFAULT.withDims(Level.OVERWORLD.location()).withBiomesTags(StarcatcherTags.IS_WARM_LAKE);
        public static final WorldRestrictions OVERWORLD_COLD_RIVER = DEFAULT.withDims(Level.OVERWORLD.location()).withBiomesTags(StarcatcherTags.IS_COLD_RIVER);
        public static final WorldRestrictions OVERWORLD_COLD_OCEAN = DEFAULT.withDims(Level.OVERWORLD.location()).withBiomesTags(StarcatcherTags.IS_COLD_OCEAN);
        public static final WorldRestrictions OVERWORLD_COLD_LAKE = DEFAULT.withDims(Level.OVERWORLD.location()).withBiomesTags(StarcatcherTags.IS_COLD_LAKE);
        public static final WorldRestrictions OVERWORLD_BEACH = DEFAULT.withDims(Level.OVERWORLD.location()).withBiomesTags(StarcatcherTags.IS_BEACH);
        public static final WorldRestrictions OVERWORLD_MUSHROOM_FIELDS = DEFAULT.withDims(Level.OVERWORLD.location()).withBiomesTags(StarcatcherTags.IS_MUSHROOM_FIELDS);
        public static final WorldRestrictions OVERWORLD_JUNGLE = DEFAULT.withDims(Level.OVERWORLD.location()).withBiomesTags(BiomeTags.IS_JUNGLE.location());
        public static final WorldRestrictions OVERWORLD_TAIGA = DEFAULT.withDims(Level.OVERWORLD.location()).withBiomesTags(BiomeTags.IS_TAIGA.location());
        public static final WorldRestrictions OVERWORLD_CHERRY_GROVE = DEFAULT.withDims(Level.OVERWORLD.location()).withBiomesTags(StarcatcherTags.IS_CHERRY_GROVE);
        public static final WorldRestrictions OVERWORLD_SWAMP = DEFAULT.withDims(Level.OVERWORLD.location()).withBiomesTags(StarcatcherTags.IS_SWAMP);
        public static final WorldRestrictions OVERWORLD_DARK_FOREST = DEFAULT.withDims(Level.OVERWORLD.location()).withBiomesTags(StarcatcherTags.IS_DARK_FOREST);
        public static final WorldRestrictions NETHER_LAVA = DEFAULT.withDims(Level.NETHER.location()).withFluids(ResourceLocation.withDefaultNamespace((String)"lava"));
        public static final WorldRestrictions END = DEFAULT.withDims(Level.END.location());

        public WorldRestrictions withDims(ResourceLocation dims) {
            return new WorldRestrictions(List.of(dims), this.dimsBlacklist, this.biomes, this.biomesTags, this.biomesBlacklist, this.biomesBlacklistTags, this.fluids);
        }

        public WorldRestrictions withDims(List<ResourceLocation> dims) {
            return new WorldRestrictions(dims, this.dimsBlacklist, this.biomes, this.biomesTags, this.biomesBlacklist, this.biomesBlacklistTags, this.fluids);
        }

        public WorldRestrictions withDimsBlacklist(ResourceLocation dimsBlacklist) {
            return new WorldRestrictions(this.dims, List.of(dimsBlacklist), this.biomes, this.biomesTags, this.biomesBlacklist, this.biomesBlacklistTags, this.fluids);
        }

        public WorldRestrictions withDimsBlacklist(List<ResourceLocation> dimsBlacklist) {
            return new WorldRestrictions(this.dims, dimsBlacklist, this.biomes, this.biomesTags, this.biomesBlacklist, this.biomesBlacklistTags, this.fluids);
        }

        public WorldRestrictions withBiomes(ResourceLocation biome) {
            return new WorldRestrictions(this.dims, this.dimsBlacklist, List.of(biome), this.biomesTags, this.biomesBlacklist, this.biomesBlacklistTags, this.fluids);
        }

        public WorldRestrictions withBiomes(List<ResourceLocation> biomes) {
            return new WorldRestrictions(this.dims, this.dimsBlacklist, biomes, this.biomesTags, this.biomesBlacklist, this.biomesBlacklistTags, this.fluids);
        }

        public WorldRestrictions withBiomesTags(ResourceLocation biomesTag) {
            return new WorldRestrictions(this.dims, this.dimsBlacklist, this.biomes, List.of(biomesTag), this.biomesBlacklist, this.biomesBlacklistTags, this.fluids);
        }

        public WorldRestrictions withBiomesTags(List<ResourceLocation> biomesTags) {
            return new WorldRestrictions(this.dims, this.dimsBlacklist, this.biomes, biomesTags, this.biomesBlacklist, this.biomesBlacklistTags, this.fluids);
        }

        public WorldRestrictions withBiomesBlacklist(List<ResourceLocation> biomesBlacklist) {
            return new WorldRestrictions(this.dims, this.dimsBlacklist, this.biomes, this.biomesTags, biomesBlacklist, this.biomesBlacklistTags, this.fluids);
        }

        public WorldRestrictions withBiomesBlacklist(ResourceLocation biomesBlacklist) {
            return new WorldRestrictions(this.dims, this.dimsBlacklist, this.biomes, this.biomesTags, List.of(biomesBlacklist), this.biomesBlacklistTags, this.fluids);
        }

        public WorldRestrictions withBiomesBlacklistTags(List<ResourceLocation> biomesBlacklistTags) {
            return new WorldRestrictions(this.dims, this.dimsBlacklist, this.biomes, this.biomesTags, this.biomesBlacklist, biomesBlacklistTags, this.fluids);
        }

        public WorldRestrictions withBiomesBlacklistTags(ResourceLocation biomesBlacklistTags) {
            return new WorldRestrictions(this.dims, this.dimsBlacklist, this.biomes, this.biomesTags, this.biomesBlacklist, List.of(biomesBlacklistTags), this.fluids);
        }

        public WorldRestrictions withFluids(List<ResourceLocation> fluids) {
            return new WorldRestrictions(this.dims, this.dimsBlacklist, this.biomes, this.biomesTags, this.biomesBlacklist, this.biomesBlacklistTags, fluids);
        }

        public WorldRestrictions withFluids(ResourceLocation fluids) {
            return new WorldRestrictions(this.dims, this.dimsBlacklist, this.biomes, this.biomesTags, this.biomesBlacklist, this.biomesBlacklistTags, List.of(fluids));
        }
    }

    public record BaitRestrictions(List<ResourceLocation> correctBobber, List<ResourceLocation> correctBait, boolean consumesBait, int correctBaitChanceAdded, List<ResourceLocation> incorrectBaits, boolean mustHaveCorrectBait) {
        public static final Codec<BaitRestrictions> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.list((Codec)ResourceLocation.CODEC).optionalFieldOf("correct_bobbers", List.of()).forGetter(BaitRestrictions::correctBobber), (App)Codec.list((Codec)ResourceLocation.CODEC).optionalFieldOf("correct_baits", List.of()).forGetter(BaitRestrictions::correctBait), (App)Codec.BOOL.optionalFieldOf("consumes_bait", (Object)true).forGetter(BaitRestrictions::consumesBait), (App)Codec.INT.optionalFieldOf("correct_bait_chance_added", (Object)0).forGetter(BaitRestrictions::correctBaitChanceAdded), (App)Codec.list((Codec)ResourceLocation.CODEC).optionalFieldOf("incorrect_baits", List.of()).forGetter(BaitRestrictions::incorrectBaits), (App)Codec.BOOL.optionalFieldOf("must_have_correct_bait", (Object)false).forGetter(BaitRestrictions::mustHaveCorrectBait)).apply((Applicative)instance, BaitRestrictions::new));
        public static final StreamCodec<ByteBuf, BaitRestrictions> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.fromCodec((Codec)Codec.list((Codec)ResourceLocation.CODEC)), BaitRestrictions::correctBobber, (StreamCodec)ByteBufCodecs.fromCodec((Codec)Codec.list((Codec)ResourceLocation.CODEC)), BaitRestrictions::correctBait, (StreamCodec)ByteBufCodecs.BOOL, BaitRestrictions::consumesBait, (StreamCodec)ByteBufCodecs.INT, BaitRestrictions::correctBaitChanceAdded, (StreamCodec)ByteBufCodecs.fromCodec((Codec)Codec.list((Codec)ResourceLocation.CODEC)), BaitRestrictions::incorrectBaits, (StreamCodec)ByteBufCodecs.BOOL, BaitRestrictions::mustHaveCorrectBait, BaitRestrictions::new);
        public static final BaitRestrictions DEFAULT = new BaitRestrictions(List.of(), List.of(), true, 0, List.of(), false);
    }

    public record Difficulty(int speed, int reward, int rewardThin, int penalty, int decay, boolean hasFirstMarker, boolean hasSecondMarker, boolean hasFirstThinMarker, boolean hasSecondThinMarker, Treasure treasure, boolean changeRotationOnEveryHit) {
        public static final Difficulty DEFAULT = new Difficulty(9, 20, 0, 6, 1, true, true, false, false, Treasure.DEFAULT, true);
        public static final Difficulty MEDIUM = new Difficulty(10, 15, 35, 15, 1, true, false, true, false, Treasure.UNCOMMON, true);
        public static final Difficulty HARD = new Difficulty(12, 15, 35, 25, 2, true, false, true, false, Treasure.HARD, true);
        public static final Difficulty HARD_ONLY_THIN = new Difficulty(9, 15, 20, 25, 2, false, false, true, true, Treasure.HARD, true);
        public static final Difficulty THIN_NO_DECAY = new Difficulty(9, 0, 15, 30, 0, false, false, true, true, Treasure.HARD, false);
        public static final Difficulty THIN_NO_DECAY_NOT_FORGIVING = new Difficulty(9, 0, 15, 999, 0, false, false, true, true, Treasure.HARD, false);
        public static final Difficulty SINGLE_BIG_FAST_NO_DECAY = new Difficulty(15, 5, 0, 15, 0, true, false, false, false, Treasure.HARD, false);
        public static final Difficulty SINGLE_BIG_FAST = new Difficulty(15, 5, 0, 15, 2, true, false, false, false, Treasure.HARD, false);
        public static final Difficulty EVERYTHING = new Difficulty(12, 15, 30, 15, 3, true, true, true, true, Treasure.HARD, false);
        public static final Difficulty EVERYTHING_FLIP = new Difficulty(12, 15, 30, 15, 3, true, true, true, true, Treasure.HARD, true);
        public static final Difficulty NON_STOP_ACTION = new Difficulty(15, 18, 30, 0, 10, true, true, false, false, Treasure.HARD, false);
        public static final Codec<Difficulty> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.optionalFieldOf("speed", (Object)Difficulty.DEFAULT.speed).forGetter(Difficulty::speed), (App)Codec.INT.optionalFieldOf("reward", (Object)Difficulty.DEFAULT.reward).forGetter(Difficulty::reward), (App)Codec.INT.optionalFieldOf("reward_thin", (Object)Difficulty.DEFAULT.rewardThin).forGetter(Difficulty::rewardThin), (App)Codec.INT.optionalFieldOf("penalty", (Object)Difficulty.DEFAULT.penalty).forGetter(Difficulty::penalty), (App)Codec.INT.optionalFieldOf("decay", (Object)Difficulty.DEFAULT.decay).forGetter(Difficulty::decay), (App)Codec.BOOL.optionalFieldOf("has_first_marker", (Object)Difficulty.DEFAULT.hasFirstMarker).forGetter(Difficulty::hasFirstMarker), (App)Codec.BOOL.optionalFieldOf("has_second_marker", (Object)Difficulty.DEFAULT.hasSecondMarker).forGetter(Difficulty::hasSecondMarker), (App)Codec.BOOL.optionalFieldOf("has_first_thin_marker", (Object)Difficulty.DEFAULT.hasFirstThinMarker).forGetter(Difficulty::hasFirstThinMarker), (App)Codec.BOOL.optionalFieldOf("has_second_thin_marker", (Object)Difficulty.DEFAULT.hasSecondThinMarker).forGetter(Difficulty::hasSecondThinMarker), (App)Treasure.CODEC.optionalFieldOf("treasure", (Object)Treasure.DEFAULT).forGetter(Difficulty::treasure), (App)Codec.BOOL.optionalFieldOf("change_rotation_every_hit", (Object)Difficulty.DEFAULT.changeRotationOnEveryHit).forGetter(Difficulty::changeRotationOnEveryHit)).apply((Applicative)instance, Difficulty::new));
        public static final StreamCodec<ByteBuf, Difficulty> STREAM_CODEC = FishProperties.composite(ByteBufCodecs.INT, Difficulty::speed, ByteBufCodecs.INT, Difficulty::reward, ByteBufCodecs.INT, Difficulty::rewardThin, ByteBufCodecs.INT, Difficulty::penalty, ByteBufCodecs.INT, Difficulty::decay, ByteBufCodecs.BOOL, Difficulty::hasFirstMarker, ByteBufCodecs.BOOL, Difficulty::hasSecondMarker, ByteBufCodecs.BOOL, Difficulty::hasFirstThinMarker, ByteBufCodecs.BOOL, Difficulty::hasSecondThinMarker, Treasure.STREAM_CODEC, Difficulty::treasure, ByteBufCodecs.BOOL, Difficulty::changeRotationOnEveryHit, Difficulty::new);

        public Difficulty withTreasure(Treasure treasure) {
            return new Difficulty(this.speed, this.reward, this.rewardThin, this.penalty, this.decay, this.hasFirstMarker, this.hasSecondMarker, this.hasFirstThinMarker, this.hasSecondThinMarker, treasure, this.changeRotationOnEveryHit);
        }
    }

    public static enum Daytime implements StringRepresentable
    {
        ALL("all"),
        DAY("day"),
        NOON("noon"),
        NIGHT("night"),
        MIDNIGHT("midnight");

        public static final Codec<Daytime> CODEC;
        public static final StreamCodec<FriendlyByteBuf, Daytime> STREAM_CODEC;
        private final String key;

        private Daytime(String key) {
            this.key = key;
        }

        public String getSerializedName() {
            return this.key;
        }

        static {
            CODEC = StringRepresentable.fromEnum(Daytime::values);
            STREAM_CODEC = NeoForgeStreamCodecs.enumCodec(Daytime.class);
        }
    }

    public static enum Weather implements StringRepresentable
    {
        ALL("all"),
        CLEAR("clear"),
        RAIN("rain"),
        THUNDER("thunder");

        public static final Codec<Weather> CODEC;
        public static final StreamCodec<FriendlyByteBuf, Weather> STREAM_CODEC;
        private final String key;

        private Weather(String key) {
            this.key = key;
        }

        public String getSerializedName() {
            return this.key;
        }

        static {
            CODEC = StringRepresentable.fromEnum(Weather::values);
            STREAM_CODEC = NeoForgeStreamCodecs.enumCodec(Weather.class);
        }
    }

    public record Treasure(boolean hasTreasure, ResourceLocation loot, int hitReward) {
        public static final Codec<Treasure> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.optionalFieldOf("has_treasure", (Object)false).forGetter(Treasure::hasTreasure), (App)ResourceLocation.CODEC.optionalFieldOf("loot", (Object)Starcatcher.rl("none")).forGetter(Treasure::loot), (App)Codec.INT.optionalFieldOf("hit_reward", (Object)0).forGetter(Treasure::hitReward)).apply((Applicative)instance, Treasure::new));
        public static final StreamCodec<ByteBuf, Treasure> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.BOOL, Treasure::hasTreasure, (StreamCodec)ResourceLocation.STREAM_CODEC, Treasure::loot, (StreamCodec)ByteBufCodecs.INT, Treasure::hitReward, Treasure::new);
        public static final Treasure DEFAULT = new Treasure(false, Starcatcher.rl("waterlogged_satchel"), 15);
        public static final Treasure UNCOMMON = new Treasure(true, Starcatcher.rl("waterlogged_satchel"), 15);
        public static final Treasure HARD = new Treasure(true, Starcatcher.rl("treasure"), 15);
        public static final Treasure NETHER = new Treasure(true, Starcatcher.rl("scalding_treasure"), 28);
    }
}

