/*
 * Decompiled with CFR 0.152.
 */
package com.wdiscute.starcatcher.fishspotter;

import com.mojang.blaze3d.systems.RenderSystem;
import com.wdiscute.starcatcher.ModItems;
import com.wdiscute.starcatcher.Starcatcher;
import com.wdiscute.starcatcher.networkandcodecs.FishCaughtCounter;
import com.wdiscute.starcatcher.networkandcodecs.FishProperties;
import com.wdiscute.starcatcher.networkandcodecs.ModDataAttachments;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class FishTrackerLayer
implements LayeredDraw.Layer {
    private static final ResourceLocation BACKGROUND = Starcatcher.rl("textures/gui/fish_tracker.png");
    int uiX;
    int uiY;
    float offScreen = -150.0f;
    Font font;
    int imageWidth = 150;
    int imageHeight = 100;
    float counterSinceLastRefresh = 999.0f;
    Player player;
    ClientLevel level;
    List<FishProperties> fpsInArea = new ArrayList<FishProperties>();
    List<FishProperties> fishesCaught;

    private void recalculate() {
        this.fpsInArea = FishProperties.getFpsWithGuideEntryForArea((Entity)this.player);
        this.fishesCaught = new ArrayList<FishProperties>();
        for (FishCaughtCounter fishes : (List)this.player.getData(ModDataAttachments.FISHES_CAUGHT)) {
            this.fishesCaught.add(fishes.fp());
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void render(GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        boolean shouldShow;
        this.font = Minecraft.getInstance().font;
        this.uiX = Minecraft.getInstance().getWindow().getGuiScaledWidth() - this.imageWidth;
        this.uiY = Minecraft.getInstance().getWindow().getGuiScaledHeight() - this.imageHeight - 80;
        if (Minecraft.getInstance().level == null) {
            return;
        }
        this.level = Minecraft.getInstance().level;
        if (Minecraft.getInstance().player == null) {
            return;
        }
        this.player = Minecraft.getInstance().player;
        boolean bl = shouldShow = this.player.getMainHandItem().is(ModItems.FISH_SPOTTER) || this.player.getOffhandItem().is(ModItems.FISH_SPOTTER);
        if (!shouldShow) {
            if (!(this.offScreen > -150.0f)) {
                this.offScreen = -150.0f;
                return;
            }
            this.offScreen -= 15.0f * deltaTracker.getGameTimeDeltaTicks();
        } else {
            this.offScreen = this.offScreen < 0.0f ? (this.offScreen += 15.0f * deltaTracker.getGameTimeDeltaTicks()) : 0.0f;
        }
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate(-this.offScreen, 0.0f, 0.0f);
        RenderSystem.enableBlend();
        this.renderImage(guiGraphics, BACKGROUND);
        RenderSystem.disableBlend();
        this.counterSinceLastRefresh += 1.0f * deltaTracker.getGameTimeDeltaTicks();
        if (this.counterSinceLastRefresh > 100.0f) {
            this.recalculate();
        }
        for (int i = 0; i < this.fpsInArea.size(); ++i) {
            ItemStack is = new ItemStack((ItemLike)ModItems.MISSINGNO.get());
            if (this.fishesCaught.contains(this.fpsInArea.get(i))) {
                is = new ItemStack(this.fpsInArea.get(i).fish());
            }
            guiGraphics.renderItem(is, this.uiX + 50 + i * 20 % 100, this.uiY + 10 + i / 5 * 20);
            if (i > 8) break;
        }
        guiGraphics.pose().popPose();
    }

    private void renderImage(GuiGraphics guiGraphics, ResourceLocation rl) {
        guiGraphics.blit(rl, this.uiX, this.uiY, 0.0f, 0.0f, this.imageWidth, this.imageHeight, this.imageWidth, this.imageHeight);
    }

    private void drawComp(GuiGraphics guiGraphics, Component comp, int xOffset, int yOffset) {
        guiGraphics.drawString(this.font, comp, this.uiX + xOffset, this.uiY + yOffset, 0, false);
    }
}

