/*
 * Decompiled with CFR 0.152.
 */
package com.wdiscute.starcatcher.items;

import com.wdiscute.starcatcher.networkandcodecs.ModDataComponents;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.FastColor;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class ColorfulBobber
extends Item {
    public ColorfulBobber() {
        super(new Item.Properties().m_41487_(1));
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        super.m_7373_(stack, level, tooltipComponents, isAdvanced);
        BobberColor bobberColor = ModDataComponents.getBobberColor(stack);
        tooltipComponents.add((Component)Component.m_237115_((String)"tooltip.starcatcher.colorful_bobber.999").m_130948_(Style.f_131099_.m_178520_(bobberColor.getColorAsInt())));
        super.m_7373_(stack, level, tooltipComponents, isAdvanced);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand usedHand) {
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            BobberColor bobberColor = BobberColor.random();
            ModDataComponents.setBobberColor(player.m_21120_(usedHand), bobberColor);
            sp.m_5661_((Component)Component.m_237113_((String)"Your bobber shines differently...").m_130948_(Style.f_131099_.m_178520_(bobberColor.getColorAsInt())), true);
        }
        return InteractionResultHolder.m_19090_((Object)player.m_21120_(usedHand));
    }

    public record BobberColor(float r, float g, float b) {
        public static final BobberColor DEFAULT = new BobberColor(0.5f, 0.8f, 0.5f);

        public static BobberColor random() {
            Random r = new Random();
            return new BobberColor(r.nextFloat(), r.nextFloat(), r.nextFloat());
        }

        public int getColorAsInt() {
            return FastColor.ARGB32.m_13660_((int)255, (int)((int)(this.r * 255.0f)), (int)((int)(this.g * 255.0f)), (int)((int)(this.b * 255.0f)));
        }
    }
}

