/*
 * Decompiled with CFR 0.152.
 */
package com.wdiscute.starcatcher.blocks;

import com.wdiscute.starcatcher.blocks.ModBlockEntities;
import com.wdiscute.starcatcher.blocks.ModBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class StandBlock
extends Block
implements EntityBlock {
    public static final EnumProperty<StandPart> PART = EnumProperty.create((String)"stand_part", StandPart.class);
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    private static final VoxelShape BOTTOM_LEFT = Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.box((double)8.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.box((double)8.0, (double)0.0, (double)2.0, (double)16.0, (double)6.0, (double)10.0)});
    private static final VoxelShape BOTTOM_LEFT_EAST = Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0), (VoxelShape[])new VoxelShape[]{Block.box((double)0.0, (double)14.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0), Block.box((double)6.0, (double)0.0, (double)8.0, (double)14.0, (double)6.0, (double)16.0)});
    private static final VoxelShape BOTTOM_LEFT_SOUTH = Shapes.or((VoxelShape)Block.box((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.box((double)0.0, (double)14.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)6.0, (double)8.0, (double)6.0, (double)14.0)});
    private static final VoxelShape BOTTOM_LEFT_WEST = Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.box((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0), Block.box((double)2.0, (double)0.0, (double)0.0, (double)10.0, (double)6.0, (double)8.0)});
    private static final VoxelShape BOTTOM_RIGHT = Shapes.or((VoxelShape)Block.box((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape)Block.box((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0));
    private static final VoxelShape BOTTOM_RIGHT_EAST = Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape)Block.box((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0));
    private static final VoxelShape BOTTOM_RIGHT_SOUTH = Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0), (VoxelShape)Block.box((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0));
    private static final VoxelShape BOTTOM_RIGHT_WEST = Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0), (VoxelShape)Block.box((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0));
    private static final VoxelShape TOP_LEFT = Shapes.or((VoxelShape)Block.box((double)15.0, (double)0.0, (double)7.0, (double)16.0, (double)16.0, (double)8.0), (VoxelShape)Block.box((double)0.0, (double)10.0, (double)7.0, (double)16.0, (double)16.0, (double)8.0));
    private static final VoxelShape TOP_LEFT_EAST = Shapes.or((VoxelShape)Block.box((double)8.0, (double)0.0, (double)15.0, (double)9.0, (double)16.0, (double)16.0), (VoxelShape)Block.box((double)8.0, (double)10.0, (double)0.0, (double)9.0, (double)16.0, (double)16.0));
    private static final VoxelShape TOP_LEFT_SOUTH = Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)8.0, (double)1.0, (double)16.0, (double)9.0), (VoxelShape)Block.box((double)0.0, (double)10.0, (double)8.0, (double)16.0, (double)16.0, (double)9.0));
    private static final VoxelShape TOP_LEFT_WEST = Shapes.or((VoxelShape)Block.box((double)7.0, (double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)1.0), (VoxelShape)Block.box((double)7.0, (double)10.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0));
    private static final VoxelShape TOP_RIGHT = Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)7.0, (double)1.0, (double)16.0, (double)8.0), (VoxelShape)Block.box((double)0.0, (double)10.0, (double)7.0, (double)16.0, (double)16.0, (double)8.0));
    private static final VoxelShape TOP_RIGHT_EAST = Shapes.or((VoxelShape)Block.box((double)8.0, (double)0.0, (double)0.0, (double)9.0, (double)16.0, (double)1.0), (VoxelShape)Block.box((double)8.0, (double)10.0, (double)0.0, (double)9.0, (double)16.0, (double)16.0));
    private static final VoxelShape TOP_RIGHT_SOUTH = Shapes.or((VoxelShape)Block.box((double)15.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0, (double)9.0), (VoxelShape)Block.box((double)0.0, (double)10.0, (double)8.0, (double)16.0, (double)16.0, (double)9.0));
    private static final VoxelShape TOP_RIGHT_WEST = Shapes.or((VoxelShape)Block.box((double)7.0, (double)0.0, (double)15.0, (double)8.0, (double)16.0, (double)16.0), (VoxelShape)Block.box((double)7.0, (double)10.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0));

    public StandBlock() {
        super(BlockBehaviour.Properties.of().noOcclusion());
    }

    protected void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        super.onRemove(state, level, pos, newState, movedByPiston);
        Direction direction = (Direction)state.getValue((Property)FACING);
        if (state.getValue(PART) == StandPart.BOTTOM_LEFT) {
            level.destroyBlock(pos.above(), false);
            level.destroyBlock(pos.relative(direction.getCounterClockWise()), false);
            level.destroyBlock(pos.relative(direction.getCounterClockWise()).above(), false);
        }
        if (state.getValue(PART) == StandPart.BOTTOM_RIGHT) {
            level.destroyBlock(pos.above(), false);
            level.destroyBlock(pos.relative(direction.getClockWise()), false);
            level.destroyBlock(pos.relative(direction.getClockWise()).above(), false);
        }
        if (state.getValue(PART) == StandPart.TOP_LEFT) {
            level.destroyBlock(pos.below(), false);
            level.destroyBlock(pos.relative(direction.getCounterClockWise()), false);
            level.destroyBlock(pos.relative(direction.getCounterClockWise()).below(), false);
        }
        if (state.getValue(PART) == StandPart.TOP_RIGHT) {
            level.destroyBlock(pos.above(), false);
            level.destroyBlock(pos.relative(direction.getClockWise()), false);
            level.destroyBlock(pos.relative(direction.getClockWise()).above(), false);
        }
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos blockpos = context.getClickedPos();
        Level level = context.getLevel();
        Direction direction = context.getHorizontalDirection().getOpposite();
        if (blockpos.getY() < level.getMaxBuildHeight() - 1 && level.getBlockState(blockpos.above()).canBeReplaced(context) && blockpos.getY() < level.getMaxBuildHeight() - 1 && level.getBlockState(blockpos.relative(direction.getCounterClockWise())).canBeReplaced(context) && blockpos.getY() < level.getMaxBuildHeight() - 1 && level.getBlockState(blockpos.above().relative(direction.getCounterClockWise())).canBeReplaced(context)) {
            return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)direction)).setValue(PART, (Comparable)((Object)StandPart.BOTTOM_LEFT));
        }
        return null;
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        if (level.getBlockState(pos).is(ModBlocks.STAND)) {
            Direction direction = (Direction)level.getBlockState(pos).getValue((Property)FACING);
            level.setBlock(pos.above(), (BlockState)((BlockState)state.setValue(PART, (Comparable)((Object)StandPart.TOP_LEFT))).setValue((Property)FACING, (Comparable)direction), 3);
            level.setBlock(pos.relative(direction.getCounterClockWise()), (BlockState)((BlockState)state.setValue(PART, (Comparable)((Object)StandPart.BOTTOM_RIGHT))).setValue((Property)FACING, (Comparable)direction), 3);
            level.setBlock(pos.above().relative(direction.getCounterClockWise()), (BlockState)((BlockState)state.setValue(PART, (Comparable)((Object)StandPart.TOP_RIGHT))).setValue((Property)FACING, (Comparable)direction), 3);
        }
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        StandPart part = (StandPart)((Object)state.getValue(PART));
        Direction facing = (Direction)state.getValue((Property)FACING);
        if (part == StandPart.BOTTOM_LEFT) {
            if (facing.equals((Object)Direction.NORTH)) {
                return BOTTOM_LEFT;
            }
            if (facing.equals((Object)Direction.EAST)) {
                return BOTTOM_LEFT_EAST;
            }
            if (facing.equals((Object)Direction.SOUTH)) {
                return BOTTOM_LEFT_SOUTH;
            }
            if (facing.equals((Object)Direction.WEST)) {
                return BOTTOM_LEFT_WEST;
            }
        }
        if (part == StandPart.BOTTOM_RIGHT) {
            if (facing.equals((Object)Direction.NORTH)) {
                return BOTTOM_RIGHT;
            }
            if (facing.equals((Object)Direction.EAST)) {
                return BOTTOM_RIGHT_EAST;
            }
            if (facing.equals((Object)Direction.SOUTH)) {
                return BOTTOM_RIGHT_SOUTH;
            }
            if (facing.equals((Object)Direction.WEST)) {
                return BOTTOM_RIGHT_WEST;
            }
        }
        if (part == StandPart.TOP_LEFT) {
            if (facing.equals((Object)Direction.NORTH)) {
                return TOP_LEFT;
            }
            if (facing.equals((Object)Direction.EAST)) {
                return TOP_LEFT_EAST;
            }
            if (facing.equals((Object)Direction.SOUTH)) {
                return TOP_LEFT_SOUTH;
            }
            if (facing.equals((Object)Direction.WEST)) {
                return TOP_LEFT_WEST;
            }
        }
        if (part == StandPart.TOP_RIGHT) {
            if (facing.equals((Object)Direction.NORTH)) {
                return TOP_RIGHT;
            }
            if (facing.equals((Object)Direction.EAST)) {
                return TOP_RIGHT_EAST;
            }
            if (facing.equals((Object)Direction.SOUTH)) {
                return TOP_RIGHT_SOUTH;
            }
            if (facing.equals((Object)Direction.WEST)) {
                return TOP_RIGHT_WEST;
            }
        }
        return super.getShape(state, level, pos, context);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{PART});
        builder.add(new Property[]{FACING});
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return ModBlockEntities.STAND.get().create(blockPos, blockState);
    }

    public static enum StandPart implements StringRepresentable
    {
        BOTTOM_LEFT("bottom_left"),
        BOTTOM_RIGHT("bottom_right"),
        TOP_LEFT("top_left"),
        TOP_RIGHT("top_right");

        private final String name;

        private StandPart(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public String getSerializedName() {
            return this.name;
        }
    }
}

