/*
 * Decompiled with CFR 0.152.
 */
package com.wdiscute.starcatcher.guide;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.wdiscute.libtooltips.Tooltips;
import com.wdiscute.starcatcher.Config;
import com.wdiscute.starcatcher.ModItems;
import com.wdiscute.starcatcher.Starcatcher;
import com.wdiscute.starcatcher.U;
import com.wdiscute.starcatcher.blocks.ModBlocks;
import com.wdiscute.starcatcher.compat.SereneSeasonsCompat;
import com.wdiscute.starcatcher.guide.SettingsScreen;
import com.wdiscute.starcatcher.networkandcodecs.FishCaughtCounter;
import com.wdiscute.starcatcher.networkandcodecs.FishProperties;
import com.wdiscute.starcatcher.networkandcodecs.ModDataAttachments;
import com.wdiscute.starcatcher.networkandcodecs.ModDataComponents;
import com.wdiscute.starcatcher.networkandcodecs.Payloads;
import com.wdiscute.starcatcher.networkandcodecs.TrophyProperties;
import com.wdiscute.starcatcher.secretnotes.NoteContainer;
import com.wdiscute.starcatcher.secretnotes.SecretNoteScreen;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.SequencedCollection;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.network.PacketDistributor;

public class FishingGuideScreen
extends Screen {
    private static final ResourceLocation BACKGROUND_INDEX_FIRST = Starcatcher.rl("textures/gui/guide/background_index_first.png");
    private static final ResourceLocation BACKGROUND_INDEX_SECOND = Starcatcher.rl("textures/gui/guide/background_index_second.png");
    private static final ResourceLocation BACKGROUND_ENTRY = Starcatcher.rl("textures/gui/guide/background_entry.png");
    private static final ResourceLocation BACKGROUND_BASICS = Starcatcher.rl("textures/gui/guide/background_basics.png");
    private static final ResourceLocation FISHES_IN_AREA_TOP_RIGHT_DECORATION = Starcatcher.rl("textures/gui/guide/fishes_in_area_top_right_decoration.png");
    private static final ResourceLocation FISHES_IN_AREA_BOTTOM_LEFT_DECORATION = Starcatcher.rl("textures/gui/guide/fishes_in_area_bottom_left_decoration.png");
    private static final ResourceLocation FISHES_IN_AREA_FISH_DECORATION = Starcatcher.rl("textures/gui/guide/fishes_in_area_fish_decoration.png");
    private static final ResourceLocation ALL_FISHES_1_ROW = Starcatcher.rl("textures/gui/guide/all_fishes_1_rows.png");
    private static final ResourceLocation ALL_FISHES_2_ROW = Starcatcher.rl("textures/gui/guide/all_fishes_2_rows.png");
    private static final ResourceLocation ALL_FISHES_3_ROW = Starcatcher.rl("textures/gui/guide/all_fishes_3_rows.png");
    private static final ResourceLocation ALL_FISHES_4_ROW = Starcatcher.rl("textures/gui/guide/all_fishes_4_rows.png");
    private static final ResourceLocation HELP_PAGE_1 = Starcatcher.rl("textures/gui/guide/help_1.png");
    private static final ResourceLocation HELP_PAGE_2 = Starcatcher.rl("textures/gui/guide/help_2.png");
    private static final ResourceLocation HELP_PAGE_3 = Starcatcher.rl("textures/gui/guide/help_3.png");
    private static final ResourceLocation HELP_PAGE_4 = Starcatcher.rl("textures/gui/guide/help_4.png");
    private static final ResourceLocation HELP_PAGE_5 = Starcatcher.rl("textures/gui/guide/help_5.png");
    private static final ResourceLocation ARROW_PREVIOUS = Starcatcher.rl("textures/gui/guide/arrow_previous.png");
    private static final ResourceLocation ARROW_PREVIOUS_PRESSED = Starcatcher.rl("textures/gui/guide/arrow_previous_pressed.png");
    private static final ResourceLocation ARROW_PREVIOUS_HIGHLIGHT = Starcatcher.rl("textures/gui/guide/arrow_previous_highlight.png");
    private static final ResourceLocation ARROW_NEXT = Starcatcher.rl("textures/gui/guide/arrow_next.png");
    private static final ResourceLocation ARROW_NEXT_PRESSED = Starcatcher.rl("textures/gui/guide/arrow_next_pressed.png");
    private static final ResourceLocation ARROW_NEXT_HIGHLIGHT = Starcatcher.rl("textures/gui/guide/arrow_next_highlight.png");
    private static final ResourceLocation ARROW_INDEX = Starcatcher.rl("textures/gui/guide/arrow_index.png");
    private static final ResourceLocation ARROW_INDEX_PRESSED = Starcatcher.rl("textures/gui/guide/arrow_index_pressed.png");
    private static final ResourceLocation ARROW_INDEX_HIGHLIGHT = Starcatcher.rl("textures/gui/guide/arrow_index_highlight.png");
    private static final ResourceLocation NEW_FISH = Starcatcher.rl("textures/gui/guide/new_fish.png");
    private static final ResourceLocation STAR = Starcatcher.rl("textures/gui/guide/star.png");
    private static final ResourceLocation GLOW = Starcatcher.rl("textures/gui/guide/glow.png");
    private static final ResourceLocation SEASONS = Starcatcher.rl("textures/gui/guide/seasons.png");
    private static final int MAX_HELP_PAGES = 4;
    final boolean advancedTooltips;
    private final ItemStack basics;
    private final ItemStack treasures;
    private final ItemStack ironHook;
    private final ItemStack shinyHook;
    private final ItemStack goldHook;
    private final ItemStack mossyHook;
    private final ItemStack crystalHook;
    private final ItemStack heavyHook;
    private final ItemStack stoneHook;
    private final ItemStack splitHook;
    private final ItemStack stabHook;
    private final ItemStack frugalBobber;
    private final ItemStack creeperBobber;
    private final ItemStack glitterBobber;
    private final ItemStack colorfulBobber;
    private final ItemStack steadyBobber;
    private final ItemStack impatientBobber;
    private final ItemStack frogBobber;
    private final ItemStack kimbeBobber;
    private final ItemStack clearBobber;
    private final ItemStack cherryBait;
    private final ItemStack lushBait;
    private final ItemStack sculkBait;
    private final ItemStack dripstoneBait;
    private final ItemStack murkwaterBait;
    private final ItemStack legendaryBait;
    private final ItemStack meteorologicalBait;
    private final ItemStack fishSpotter;
    private final ItemStack trophies;
    private final ItemStack secrets;
    private final ItemStack settings;
    int uiX;
    int uiY;
    int imageWidth;
    int imageHeight;
    int clickedX;
    int clickedY;
    boolean arrowPreviousPressed;
    boolean arrowNextPressed;
    boolean arrowIndexPressed;
    int menu = 0;
    int page = 0;
    boolean hasNextEntryPage;
    ClientLevel level;
    LocalPlayer player;
    List<FishProperties> fpsSeen = new ArrayList<FishProperties>();
    List<FishProperties> entries = new ArrayList<FishProperties>(999);
    List<TrophyProperties> trophiesTps = new ArrayList<TrophyProperties>();
    List<TrophyProperties> secretsTps = new ArrayList<TrophyProperties>();
    List<FishProperties> fishInArea = new ArrayList<FishProperties>();
    List<FishCaughtCounter> fishCaughtCounterList = new ArrayList<FishCaughtCounter>();
    TrophyProperties.RarityProgress all;
    TrophyProperties.RarityProgress common;
    TrophyProperties.RarityProgress uncommon;
    TrophyProperties.RarityProgress rare;
    TrophyProperties.RarityProgress epic;
    TrophyProperties.RarityProgress legendary;

    private void sortEntries() {
        ArrayList<FishProperties> entriesSorted;
        Sort sort = (Sort)((Object)Config.SORT.get());
        if (sort.equals((Object)Sort.RARITY_DOWN) || sort.equals((Object)Sort.RARITY_UP)) {
            entriesSorted = new ArrayList<FishProperties>();
            this.entries.forEach(e -> {
                if (e.rarity().equals((Object)FishProperties.Rarity.COMMON)) {
                    entriesSorted.add((FishProperties)e);
                }
            });
            this.entries.forEach(e -> {
                if (e.rarity().equals((Object)FishProperties.Rarity.UNCOMMON)) {
                    entriesSorted.add((FishProperties)e);
                }
            });
            this.entries.forEach(e -> {
                if (e.rarity().equals((Object)FishProperties.Rarity.RARE)) {
                    entriesSorted.add((FishProperties)e);
                }
            });
            this.entries.forEach(e -> {
                if (e.rarity().equals((Object)FishProperties.Rarity.EPIC)) {
                    entriesSorted.add((FishProperties)e);
                }
            });
            this.entries.forEach(e -> {
                if (e.rarity().equals((Object)FishProperties.Rarity.LEGENDARY)) {
                    entriesSorted.add((FishProperties)e);
                }
            });
            SequencedCollection<FishProperties> sequencedCollection = this.entries = sort.equals((Object)Sort.RARITY_UP) ? entriesSorted : entriesSorted.reversed();
        }
        if (sort.equals((Object)Sort.ALPHABETICAL_DOWN) || sort.equals((Object)Sort.ALPHABETICAL_UP)) {
            entriesSorted = new ArrayList();
            HashMap<String, FishProperties> map = new HashMap<String, FishProperties>();
            Iterator<String> entriesString = new ArrayList();
            for (FishProperties fp2 : this.entries) {
                String path = ((ResourceKey)fp2.fish().unwrapKey().get()).location().getPath();
                map.put(path, fp2);
                entriesString.add(path);
            }
            entriesString = entriesString.stream().sorted().toList();
            Iterator<FishProperties> iterator = entriesString.iterator();
            while (iterator.hasNext()) {
                String s = (String)((Object)iterator.next());
                entriesSorted.add((FishProperties)map.get(s));
            }
            SequencedCollection<FishProperties> sequencedCollection = this.entries = sort.equals((Object)Sort.ALPHABETICAL_UP) ? entriesSorted : entriesSorted.reversed();
        }
        if (sort.equals((Object)Sort.MOD_DOWN) || sort.equals((Object)Sort.MOD_UP)) {
            Config.SORT.set((Object)Sort.ALPHABETICAL_UP);
            Config.SORT.save();
            this.sortEntries();
            Config.SORT.set((Object)sort);
            Config.SORT.save();
            entriesSorted = new ArrayList();
            ArrayList<String> allNamespaces = new ArrayList<String>();
            for (FishProperties fp3 : this.entries) {
                String namespace = ((ResourceKey)fp3.fish().unwrapKey().get()).location().getNamespace();
                if (allNamespaces.contains(namespace)) continue;
                allNamespaces.add(namespace);
            }
            for (String s : allNamespaces) {
                for (FishProperties fp4 : this.entries) {
                    String namespace = ((ResourceKey)fp4.fish().unwrapKey().get()).location().getNamespace();
                    if (!namespace.equals(s)) continue;
                    entriesSorted.add(fp4);
                }
            }
            SequencedCollection<FishProperties> sequencedCollection = this.entries = sort.equals((Object)Sort.MOD_UP) ? entriesSorted : entriesSorted.reversed();
        }
        if (sort.equals((Object)Sort.FLUID_DOWN) || sort.equals((Object)Sort.FLUID_UP)) {
            Config.SORT.set((Object)Sort.ALPHABETICAL_UP);
            Config.SORT.save();
            this.sortEntries();
            Config.SORT.set((Object)sort);
            Config.SORT.save();
            entriesSorted = new ArrayList();
            ArrayList<FishProperties> entriesRemaining = new ArrayList<FishProperties>(this.entries);
            while (!entriesRemaining.isEmpty()) {
                ResourceLocation rlBeingSorted = ((FishProperties)entriesRemaining.getFirst()).wr().fluids().getFirst();
                ArrayList<FishProperties> temp = new ArrayList<FishProperties>(entriesRemaining);
                temp.forEach(e -> {
                    if (e.wr().fluids().getFirst().equals((Object)rlBeingSorted)) {
                        entriesSorted.add((FishProperties)e);
                        entriesRemaining.remove(e);
                    }
                });
            }
            SequencedCollection<FishProperties> sequencedCollection = this.entries = sort.equals((Object)Sort.FLUID_UP) ? entriesSorted : entriesSorted.reversed();
        }
        if (sort.equals((Object)Sort.CAUGHT_UP) || sort.equals((Object)Sort.CAUGHT_DOWN)) {
            Config.SORT.set((Object)Sort.ALPHABETICAL_UP);
            Config.SORT.save();
            this.sortEntries();
            Config.SORT.set((Object)sort);
            Config.SORT.save();
            entriesSorted = new ArrayList();
            this.entries.forEach(fp -> {
                FishCaughtCounter fcc = null;
                for (FishCaughtCounter fccAll : this.fishCaughtCounterList) {
                    if (!fp.equals(fccAll.fp())) continue;
                    fcc = fccAll;
                    break;
                }
                if (fcc != null) {
                    entriesSorted.add((FishProperties)fp);
                }
            });
            this.entries.forEach(fp -> {
                FishCaughtCounter fcc = null;
                for (FishCaughtCounter fccAll : this.fishCaughtCounterList) {
                    if (!fp.equals(fccAll.fp())) continue;
                    fcc = fccAll;
                    break;
                }
                if (fcc == null) {
                    entriesSorted.add((FishProperties)fp);
                }
            });
            SequencedCollection<FishProperties> sequencedCollection = this.entries = sort.equals((Object)Sort.CAUGHT_UP) ? entriesSorted : entriesSorted.reversed();
        }
        if (sort.equals((Object)Sort.SEASON_DOWN) || sort.equals((Object)Sort.SEASON_UP)) {
            entriesSorted = new ArrayList();
            ArrayList<FishProperties> entriesUnsorted = new ArrayList<FishProperties>(this.entries);
            for (FishProperties fp3 : entriesUnsorted) {
                if (!fp3.wr().seasons().contains((Object)FishProperties.WorldRestrictions.Seasons.ALL)) continue;
                entriesSorted.add(fp3);
            }
            entriesUnsorted.removeAll(entriesSorted);
            for (FishProperties fp3 : entriesUnsorted) {
                if (!fp3.wr().seasons().contains((Object)FishProperties.WorldRestrictions.Seasons.SPRING)) continue;
                entriesSorted.add(fp3);
            }
            entriesUnsorted.removeAll(entriesSorted);
            for (FishProperties fp3 : entriesUnsorted) {
                if (!fp3.wr().seasons().contains((Object)FishProperties.WorldRestrictions.Seasons.EARLY_SPRING)) continue;
                entriesSorted.add(fp3);
            }
            entriesUnsorted.removeAll(entriesSorted);
            for (FishProperties fp3 : entriesUnsorted) {
                if (!fp3.wr().seasons().contains((Object)FishProperties.WorldRestrictions.Seasons.MID_SPRING)) continue;
                entriesSorted.add(fp3);
            }
            entriesUnsorted.removeAll(entriesSorted);
            for (FishProperties fp3 : entriesUnsorted) {
                if (!fp3.wr().seasons().contains((Object)FishProperties.WorldRestrictions.Seasons.LATE_SPRING)) continue;
                entriesSorted.add(fp3);
            }
            entriesUnsorted.removeAll(entriesSorted);
            for (FishProperties fp3 : entriesUnsorted) {
                if (!fp3.wr().seasons().contains((Object)FishProperties.WorldRestrictions.Seasons.SUMMER)) continue;
                entriesSorted.add(fp3);
            }
            entriesUnsorted.removeAll(entriesSorted);
            for (FishProperties fp3 : entriesUnsorted) {
                if (!fp3.wr().seasons().contains((Object)FishProperties.WorldRestrictions.Seasons.EARLY_SUMMER)) continue;
                entriesSorted.add(fp3);
            }
            entriesUnsorted.removeAll(entriesSorted);
            for (FishProperties fp3 : entriesUnsorted) {
                if (!fp3.wr().seasons().contains((Object)FishProperties.WorldRestrictions.Seasons.MID_SUMMER)) continue;
                entriesSorted.add(fp3);
            }
            entriesUnsorted.removeAll(entriesSorted);
            for (FishProperties fp3 : entriesUnsorted) {
                if (!fp3.wr().seasons().contains((Object)FishProperties.WorldRestrictions.Seasons.LATE_SUMMER)) continue;
                entriesSorted.add(fp3);
            }
            entriesUnsorted.removeAll(entriesSorted);
            for (FishProperties fp3 : entriesUnsorted) {
                if (!fp3.wr().seasons().contains((Object)FishProperties.WorldRestrictions.Seasons.AUTUMN)) continue;
                entriesSorted.add(fp3);
            }
            entriesUnsorted.removeAll(entriesSorted);
            for (FishProperties fp3 : entriesUnsorted) {
                if (!fp3.wr().seasons().contains((Object)FishProperties.WorldRestrictions.Seasons.EARLY_AUTUMN)) continue;
                entriesSorted.add(fp3);
            }
            entriesUnsorted.removeAll(entriesSorted);
            for (FishProperties fp3 : entriesUnsorted) {
                if (!fp3.wr().seasons().contains((Object)FishProperties.WorldRestrictions.Seasons.MID_AUTUMN)) continue;
                entriesSorted.add(fp3);
            }
            entriesUnsorted.removeAll(entriesSorted);
            for (FishProperties fp3 : entriesUnsorted) {
                if (!fp3.wr().seasons().contains((Object)FishProperties.WorldRestrictions.Seasons.LATE_AUTUMN)) continue;
                entriesSorted.add(fp3);
            }
            entriesUnsorted.removeAll(entriesSorted);
            for (FishProperties fp3 : entriesUnsorted) {
                if (!fp3.wr().seasons().contains((Object)FishProperties.WorldRestrictions.Seasons.WINTER)) continue;
                entriesSorted.add(fp3);
            }
            entriesUnsorted.removeAll(entriesSorted);
            for (FishProperties fp3 : entriesUnsorted) {
                if (!fp3.wr().seasons().contains((Object)FishProperties.WorldRestrictions.Seasons.EARLY_WINTER)) continue;
                entriesSorted.add(fp3);
            }
            entriesUnsorted.removeAll(entriesSorted);
            for (FishProperties fp3 : entriesUnsorted) {
                if (!fp3.wr().seasons().contains((Object)FishProperties.WorldRestrictions.Seasons.MID_WINTER)) continue;
                entriesSorted.add(fp3);
            }
            entriesUnsorted.removeAll(entriesSorted);
            for (FishProperties fp3 : entriesUnsorted) {
                if (!fp3.wr().seasons().contains((Object)FishProperties.WorldRestrictions.Seasons.LATE_WINTER)) continue;
                entriesSorted.add(fp3);
            }
            entriesUnsorted.removeAll(entriesSorted);
            this.entries = sort.equals((Object)Sort.SEASON_UP) ? entriesSorted : entriesSorted.reversed();
        }
    }

    protected void init() {
        super.init();
        this.entries = new ArrayList<FishProperties>(999);
        this.trophiesTps = new ArrayList<TrophyProperties>(999);
        this.secretsTps = new ArrayList<TrophyProperties>(999);
        this.imageWidth = 420;
        this.imageHeight = 260;
        this.uiX = (this.width - this.imageWidth) / 2;
        this.uiY = (this.height - this.imageHeight) / 2;
        this.level = Minecraft.getInstance().level;
        this.player = Minecraft.getInstance().player;
        for (FishProperties fp : FishProperties.getFPs((Level)this.level)) {
            if (!fp.hasGuideEntry()) continue;
            this.entries.add(fp);
        }
        this.sortEntries();
        for (TrophyProperties tp : this.level.registryAccess().registryOrThrow(Starcatcher.TROPHY_REGISTRY)) {
            if (tp.trophyType() != TrophyProperties.TrophyType.TROPHY) continue;
            this.trophiesTps.add(tp);
        }
        for (TrophyProperties tp : this.level.registryAccess().registryOrThrow(Starcatcher.TROPHY_REGISTRY)) {
            if (tp.trophyType() != TrophyProperties.TrophyType.SECRET || !((List)this.player.getData(ModDataAttachments.TROPHIES_CAUGHT)).contains(tp)) continue;
            this.secretsTps.add(tp);
        }
        this.fishInArea = FishProperties.getFpsWithGuideEntryForArea((Entity)this.player);
        this.fishCaughtCounterList = (List)this.player.getData(ModDataAttachments.FISHES_CAUGHT);
        this.all = new TrophyProperties.RarityProgress(0, ((List)this.player.getData(ModDataAttachments.FISHES_CAUGHT)).size() - 1);
        this.common = new TrophyProperties.RarityProgress(0, -1);
        this.uncommon = TrophyProperties.RarityProgress.DEFAULT;
        this.rare = TrophyProperties.RarityProgress.DEFAULT;
        this.epic = TrophyProperties.RarityProgress.DEFAULT;
        this.legendary = TrophyProperties.RarityProgress.DEFAULT;
        for (FishCaughtCounter fcc : (List)this.player.getData(ModDataAttachments.FISHES_CAUGHT)) {
            this.all = new TrophyProperties.RarityProgress(this.all.total() + fcc.count(), this.all.unique());
            if (fcc.fp().rarity() == FishProperties.Rarity.COMMON) {
                this.common = new TrophyProperties.RarityProgress(this.common.total() + fcc.count(), this.common.unique() + 1);
            }
            if (fcc.fp().rarity() == FishProperties.Rarity.UNCOMMON) {
                this.uncommon = new TrophyProperties.RarityProgress(this.uncommon.total() + fcc.count(), this.uncommon.unique() + 1);
            }
            if (fcc.fp().rarity() == FishProperties.Rarity.RARE) {
                this.rare = new TrophyProperties.RarityProgress(this.rare.total() + fcc.count(), this.rare.unique() + 1);
            }
            if (fcc.fp().rarity() == FishProperties.Rarity.EPIC) {
                this.epic = new TrophyProperties.RarityProgress(this.epic.total() + fcc.count(), this.epic.unique() + 1);
            }
            if (fcc.fp().rarity() != FishProperties.Rarity.LEGENDARY) continue;
            this.legendary = new TrophyProperties.RarityProgress(this.legendary.total() + fcc.count(), this.legendary.unique() + 1);
        }
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        InputConstants.Key key = InputConstants.getKey((int)keyCode, (int)scanCode);
        if (this.minecraft.options.keyInventory.isActiveAndMatches(key)) {
            this.onClose();
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        double x = mouseX - (double)this.uiX;
        double y = mouseY - (double)this.uiY;
        this.arrowIndexPressed = false;
        this.arrowNextPressed = false;
        this.arrowPreviousPressed = false;
        if (x > 49.0 && x < 69.0 && y > 203.0 && y < 217.0) {
            if (this.menu == 0 && this.page != 0) {
                this.minecraft.player.playSound(SoundEvents.BOOK_PAGE_TURN);
                --this.page;
                return true;
            }
            if (this.menu == 1 && this.page == 0) {
                this.minecraft.player.playSound(SoundEvents.BOOK_PAGE_TURN);
                this.menu = 0;
                this.page = 0;
                return true;
            }
            if (this.menu == 1) {
                this.minecraft.player.playSound(SoundEvents.BOOK_PAGE_TURN);
                --this.page;
                return true;
            }
            if (this.menu == 2 && this.page == 0) {
                this.minecraft.player.playSound(SoundEvents.BOOK_PAGE_TURN);
                this.menu = 1;
                this.page = 4;
                return true;
            }
            if (this.menu == 2) {
                this.minecraft.player.playSound(SoundEvents.BOOK_PAGE_TURN);
                --this.page;
                return true;
            }
        }
        if (x > 336.0 && x < 356.0 && y > 202.0 && y < 216.0) {
            if (this.menu == 0 && this.hasNextEntryPage) {
                this.minecraft.player.playSound(SoundEvents.BOOK_PAGE_TURN);
                ++this.page;
                return true;
            }
            if (this.menu == 0) {
                this.minecraft.player.playSound(SoundEvents.BOOK_PAGE_TURN);
                this.menu = 1;
                this.page = 0;
                return true;
            }
            if (this.menu == 1 && this.page != 4) {
                this.minecraft.player.playSound(SoundEvents.BOOK_PAGE_TURN);
                ++this.page;
                return true;
            }
            if (this.menu == 1) {
                this.minecraft.player.playSound(SoundEvents.BOOK_PAGE_TURN);
                this.menu = 2;
                this.page = 0;
                return true;
            }
            if (this.menu == 2 && this.page <= this.entries.size() / 2 - 1) {
                this.minecraft.player.playSound(SoundEvents.BOOK_PAGE_TURN);
                ++this.page;
                return true;
            }
            if (this.menu == 2) {
                return true;
            }
        }
        if (x > 174.0 && x < 196.0 && y > 202.0 && y < 216.0) {
            this.minecraft.player.playSound(SoundEvents.BOOK_PAGE_TURN);
            this.menu = 0;
            this.page = 0;
            return true;
        }
        if (button == 0) {
            this.clickedX = (int)mouseX;
            this.clickedY = (int)mouseY;
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        double x = mouseX - (double)this.uiX;
        double y = mouseY - (double)this.uiY;
        int numberOfRows = (this.fishInArea.size() - 1) / 7 + 1;
        if (x > 168.0 && x < 191.0 && y > 121.0 && y < 128.0 && numberOfRows == 1 || x > 168.0 && x < 191.0 && y > 141.0 && y < 148.0 && numberOfRows == 2 || x > 168.0 && x < 191.0 && y > 161.0 && y < 168.0 && numberOfRows == 3 || x > 168.0 && x < 191.0 && y > 181.0 && y < 188.0 && numberOfRows == 4) {
            if (button == 0) {
                Config.SORT.set((Object)((Sort)((Object)Config.SORT.get())).next());
            }
            if (button == 1) {
                Config.SORT.set((Object)((Sort)((Object)Config.SORT.get())).previous());
            }
            Config.SORT.save();
            this.sortEntries();
        }
        if (x > 49.0 && x < 69.0 && y > 203.0 && y < 217.0 && (this.menu != 0 || this.page != 0)) {
            this.arrowPreviousPressed = true;
        }
        if (x > 336.0 && x < 356.0 && y > 202.0 && y < 216.0 && this.page <= this.entries.size() / 2 - 1) {
            this.arrowNextPressed = true;
        }
        if (x > 174.0 && x < 196.0 && y > 202.0 && y < 216.0) {
            this.arrowIndexPressed = true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        if (this.menu == -1) {
            Minecraft.getInstance().setScreen((Screen)new SettingsScreen(FishProperties.DEFAULT.withFish((Holder<Item>)ModItems.AURORA), new ItemStack((ItemLike)ModItems.ROD.get())));
            return;
        }
        if (this.menu == 0) {
            if (this.page == 0) {
                this.renderImage(guiGraphics, BACKGROUND_INDEX_FIRST);
            } else {
                this.renderImage(guiGraphics, BACKGROUND_INDEX_SECOND);
            }
            this.renderIndex(guiGraphics, mouseX, mouseY);
        }
        if (this.menu == 1) {
            this.renderImage(guiGraphics, BACKGROUND_BASICS);
            this.renderTheBasics(guiGraphics, mouseX, mouseY);
        }
        if (this.menu == 2) {
            this.renderImage(guiGraphics, BACKGROUND_ENTRY);
            this.renderEntry(guiGraphics, mouseX, mouseY, 52, this.page * 2);
            this.renderEntry(guiGraphics, mouseX, mouseY, 212, this.page * 2 + 1);
        }
        double x = mouseX - this.uiX;
        double y = mouseY - this.uiY;
        if (this.menu != 0 || this.page != 0) {
            if (x > 49.0 && x < 69.0 && y > 203.0 && y < 217.0) {
                this.renderImage(guiGraphics, ARROW_PREVIOUS_HIGHLIGHT);
            }
            this.renderImage(guiGraphics, this.arrowPreviousPressed ? ARROW_PREVIOUS_PRESSED : ARROW_PREVIOUS);
            if (x > 174.0 && x < 196.0 && y > 202.0 && y < 216.0) {
                this.renderImage(guiGraphics, ARROW_INDEX_HIGHLIGHT);
            }
            this.renderImage(guiGraphics, this.arrowIndexPressed ? ARROW_INDEX_PRESSED : ARROW_INDEX);
        }
        if (this.page <= this.entries.size() / 2 - 1) {
            if (x > 336.0 && x < 356.0 && y > 202.0 && y < 216.0) {
                this.renderImage(guiGraphics, ARROW_NEXT_HIGHLIGHT);
            }
            this.renderImage(guiGraphics, this.arrowNextPressed ? ARROW_NEXT_PRESSED : ARROW_NEXT);
        }
        this.clickedX = 0;
        this.clickedY = 0;
    }

    private void renderHelpText(GuiGraphics guiGraphics) {
        MutableComponent comp;
        int i;
        for (i = 0; i < 40 && I18n.exists((String)("gui.guide.page" + this.page + ".left." + i)); ++i) {
            comp = Tooltips.decodeTranslationKey((String)("gui.guide.page" + this.page + ".left." + i)).copy().withColor(6508608);
            guiGraphics.drawString(this.font, (Component)comp, this.uiX + 52, this.uiY + 10 * i + 13, -16777216, false);
        }
        for (i = 0; i < 40 && I18n.exists((String)("gui.guide.page" + this.page + ".right." + i)); ++i) {
            comp = Tooltips.decodeTranslationKey((String)("gui.guide.page" + this.page + ".right." + i)).copy().withColor(6508608);
            guiGraphics.drawString(this.font, (Component)comp, this.uiX + 213, this.uiY + 10 * i + 13, -16777216, false);
        }
    }

    private void renderItemWithOutlineAndHover(GuiGraphics guiGraphics, ItemStack is, int x, int y, int mouseX, int mouseY) {
        this.renderItem(is, this.uiX + x, this.uiY + y, 1.0f);
        guiGraphics.fill(this.uiX + x - 2, this.uiY + y - 2, this.uiX + x + 18, this.uiY + y + 18, -4938089);
        if (mouseX > this.uiX + x - 2 && mouseX < this.uiX + x - 2 + 20 && mouseY > this.uiY + y - 2 - 2 && mouseY < this.uiY + y - 2 + 20) {
            guiGraphics.renderTooltip(this.font, is, mouseX, mouseY);
        }
    }

    private void renderSecrets(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        for (int i = 0; i < this.secretsTps.size(); ++i) {
            Item item;
            int rowSize = Math.min(6, this.secretsTps.size() - i / 6 * 6);
            int x = 70 - rowSize * 23 / 2;
            int xrender = x + i % 6 * 23;
            int y = i / 6 * 25;
            xrender += this.uiX + 223;
            y += this.uiY + 110;
            TrophyProperties tp = this.secretsTps.get(i);
            ItemStack is = new ItemStack(tp.fp().fish());
            if (!tp.customName().isEmpty()) {
                is.set(DataComponents.ITEM_NAME, (Object)Component.translatable((String)tp.customName()));
            }
            is.set(ModDataComponents.TROPHY, (Object)tp);
            guiGraphics.renderOutline(xrender - 10, y - 2, 20, 20, -16777216);
            this.renderItem(is, xrender - 8, y, 1.0f);
            if (mouseX > xrender - 10 && mouseX < xrender + 10 && mouseY > y - 2 && mouseY < y + 18) {
                guiGraphics.renderTooltip(this.font, is, mouseX, mouseY);
            }
            if (this.clickedX <= xrender - 10 || this.clickedX >= xrender + 10 || this.clickedY <= y - 2 || this.clickedY >= y + 18 || !((item = is.getItem()) instanceof NoteContainer)) continue;
            NoteContainer nc = (NoteContainer)item;
            Minecraft.getInstance().setScreen((Screen)new SecretNoteScreen(nc.note));
        }
    }

    private void renderTrophies(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        for (int i = 0; i < this.trophiesTps.size(); ++i) {
            ItemStack is;
            boolean isMouseOnTop;
            int rowSize = Math.min(6, this.trophiesTps.size() - i / 6 * 6);
            int x = 60 - rowSize * 23 / 2;
            int xrender = x + i % 6 * 23;
            int y = i / 6 * 25;
            TrophyProperties tp = this.trophiesTps.get(i);
            boolean bl = isMouseOnTop = mouseX > (xrender += this.uiX + 73) - 10 && mouseX < xrender + 10 && mouseY > (y += this.uiY + 120) - 2 && mouseY < y + 18;
            if (((List)this.player.getData(ModDataAttachments.TROPHIES_CAUGHT)).contains(tp)) {
                is = new ItemStack(tp.fp().fish());
                is.set(DataComponents.ITEM_NAME, (Object)Component.translatable((String)tp.customName()));
                is.set(ModDataComponents.TROPHY, (Object)tp);
                if (isMouseOnTop) {
                    guiGraphics.renderTooltip(this.font, is, mouseX, mouseY);
                }
            } else {
                if (isMouseOnTop) {
                    ArrayList<MutableComponent> list = new ArrayList<MutableComponent>(List.of(Component.literal((String)"Requirements:")));
                    if (tp.all().total() != 0) {
                        list.add(Component.empty().append(Tooltips.decodeTranslationKey((String)"gui.guide.trophy.all.total")).append("[" + this.all.total() + "/" + tp.all().total() + "]"));
                    }
                    if (tp.all().unique() != 0) {
                        list.add(Component.empty().append(Tooltips.decodeTranslationKey((String)"gui.guide.trophy.all.unique")).append("[" + this.all.unique() + "/" + tp.all().unique() + "]"));
                    }
                    if (tp.common().total() != 0) {
                        list.add(Component.empty().append(Tooltips.decodeTranslationKey((String)"gui.guide.trophy.common.total")).append("[" + this.common.total() + "/" + tp.common().total() + "]"));
                    }
                    if (tp.common().unique() != 0) {
                        list.add(Component.empty().append(Tooltips.decodeTranslationKey((String)"gui.guide.trophy.common.unique")).append("[" + this.common.unique() + "/" + tp.common().unique() + "]"));
                    }
                    if (tp.uncommon().total() != 0) {
                        list.add(Component.empty().append(Tooltips.decodeTranslationKey((String)"gui.guide.trophy.uncommon.total")).append("[" + this.uncommon.total() + "/" + tp.uncommon().total() + "]"));
                    }
                    if (tp.uncommon().unique() != 0) {
                        list.add(Component.empty().append(Tooltips.decodeTranslationKey((String)"gui.guide.trophy.uncommon.unique")).append("[" + this.uncommon.unique() + "/" + tp.uncommon().unique() + "]"));
                    }
                    if (tp.rare().total() != 0) {
                        list.add(Component.empty().append(Tooltips.decodeTranslationKey((String)"gui.guide.trophy.rare.total")).append("[" + this.rare.total() + "/" + tp.rare().total() + "]"));
                    }
                    if (tp.rare().unique() != 0) {
                        list.add(Component.empty().append(Tooltips.decodeTranslationKey((String)"gui.guide.trophy.rare.unique")).append("[" + this.rare.unique() + "/" + tp.rare().unique() + "]"));
                    }
                    if (tp.epic().total() != 0) {
                        list.add(Component.empty().append(Tooltips.decodeTranslationKey((String)"gui.guide.trophy.epic.total")).append("[" + this.epic.total() + "/" + tp.epic().total() + "]"));
                    }
                    if (tp.epic().unique() != 0) {
                        list.add(Component.empty().append(Tooltips.decodeTranslationKey((String)"gui.guide.trophy.epic.unique")).append("[" + this.epic.unique() + "/" + tp.epic().unique() + "]"));
                    }
                    if (tp.legendary().total() != 0) {
                        list.add(Component.empty().append(Tooltips.decodeTranslationKey((String)"gui.guide.trophy.legendary.total")).append("[" + this.legendary.total() + "/" + tp.legendary().total() + "]"));
                    }
                    if (tp.legendary().unique() != 0) {
                        list.add(Component.empty().append(Tooltips.decodeTranslationKey((String)"gui.guide.trophy.legendary.unique")).append("[" + this.legendary.unique() + "/" + tp.legendary().unique() + "]"));
                    }
                    guiGraphics.renderTooltip(this.font, list, Optional.empty(), mouseX, mouseY);
                }
                is = new ItemStack((ItemLike)ModItems.MISSINGNO.get());
            }
            guiGraphics.renderOutline(xrender - 10, y - 2, 20, 20, -16777216);
            this.renderItem(is, xrender - 8, y, 1.0f);
        }
    }

    private void renderTheBasics(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        this.renderHelpText(guiGraphics);
        if (this.page == 0) {
            this.renderImage(guiGraphics, HELP_PAGE_1);
            this.renderItem(this.basics, this.uiX + 166, this.uiY + 39, 1.0f);
            guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.guide.basics"), this.uiX + 80, this.uiY + 45, -16777216, false);
        }
        if (this.page == 1) {
            this.renderImage(guiGraphics, HELP_PAGE_2);
            this.renderItem(this.treasures, this.uiX + 166, this.uiY + 39, 1.0f);
            guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.guide.treasures"), this.uiX + 80, this.uiY + 45, -16777216, false);
        }
        if (this.page == 2) {
            this.renderImage(guiGraphics, HELP_PAGE_3);
            this.renderItem(this.ironHook, this.uiX + 166, this.uiY + 39, 1.0f);
            guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.guide.hooks"), this.uiX + 80, this.uiY + 45, -16777216, false);
            this.renderItemWithOutlineAndHover(guiGraphics, this.ironHook, 56, 157, mouseX, mouseY);
            this.renderItemWithOutlineAndHover(guiGraphics, this.goldHook, 84, 157, mouseX, mouseY);
            this.renderItemWithOutlineAndHover(guiGraphics, this.shinyHook, 112, 157, mouseX, mouseY);
            this.renderItemWithOutlineAndHover(guiGraphics, this.crystalHook, 140, 157, mouseX, mouseY);
            this.renderItemWithOutlineAndHover(guiGraphics, this.heavyHook, 168, 157, mouseX, mouseY);
            this.renderItemWithOutlineAndHover(guiGraphics, this.mossyHook, 67, 182, mouseX, mouseY);
            this.renderItemWithOutlineAndHover(guiGraphics, this.splitHook, 99, 182, mouseX, mouseY);
            this.renderItemWithOutlineAndHover(guiGraphics, this.stoneHook, 131, 182, mouseX, mouseY);
            this.renderItemWithOutlineAndHover(guiGraphics, this.stabHook, 163, 182, mouseX, mouseY);
            this.renderItem(this.frugalBobber, this.uiX + 321, this.uiY + 39, 1.0f);
            guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.guide.bobbers"), this.uiX + 228, this.uiY + 45, -16777216, false);
            this.renderItemWithOutlineAndHover(guiGraphics, this.creeperBobber, 220, 157, mouseX, mouseY);
            this.renderItemWithOutlineAndHover(guiGraphics, this.glitterBobber, 248, 157, mouseX, mouseY);
            this.renderItemWithOutlineAndHover(guiGraphics, this.colorfulBobber, 276, 157, mouseX, mouseY);
            this.renderItemWithOutlineAndHover(guiGraphics, this.frugalBobber, 304, 157, mouseX, mouseY);
            this.renderItemWithOutlineAndHover(guiGraphics, this.clearBobber, 332, 157, mouseX, mouseY);
            this.renderItemWithOutlineAndHover(guiGraphics, this.steadyBobber, 233, 182, mouseX, mouseY);
            this.renderItemWithOutlineAndHover(guiGraphics, this.impatientBobber, 265, 182, mouseX, mouseY);
            this.renderItemWithOutlineAndHover(guiGraphics, this.frogBobber, 297, 182, mouseX, mouseY);
            this.renderItemWithOutlineAndHover(guiGraphics, this.kimbeBobber, 329, 182, mouseX, mouseY);
        }
        if (this.page == 3) {
            this.renderImage(guiGraphics, HELP_PAGE_4);
            this.renderItem(this.cherryBait, this.uiX + 166, this.uiY + 39, 1.0f);
            guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.guide.baits"), this.uiX + 80, this.uiY + 45, -16777216, false);
            this.renderItemWithOutlineAndHover(guiGraphics, this.cherryBait, 56, 157, mouseX, mouseY);
            this.renderItemWithOutlineAndHover(guiGraphics, this.lushBait, 94, 157, mouseX, mouseY);
            this.renderItemWithOutlineAndHover(guiGraphics, this.dripstoneBait, 132, 157, mouseX, mouseY);
            this.renderItemWithOutlineAndHover(guiGraphics, this.murkwaterBait, 170, 157, mouseX, mouseY);
            this.renderItemWithOutlineAndHover(guiGraphics, this.sculkBait, 76, 182, mouseX, mouseY);
            this.renderItemWithOutlineAndHover(guiGraphics, this.legendaryBait, 113, 182, mouseX, mouseY);
            this.renderItemWithOutlineAndHover(guiGraphics, this.meteorologicalBait, 150, 182, mouseX, mouseY);
            this.renderItem(this.fishSpotter, this.uiX + 321, this.uiY + 39, 1.0f);
            guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.guide.gadgets"), this.uiX + 228, this.uiY + 45, -16777216, false);
            this.renderItemWithOutlineAndHover(guiGraphics, this.fishSpotter, 276, 170, mouseX, mouseY);
        }
        if (this.page == 4) {
            this.renderImage(guiGraphics, HELP_PAGE_5);
            this.renderItem(this.trophies, this.uiX + 166, this.uiY + 39, 1.0f);
            guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.guide.trophies"), this.uiX + 80, this.uiY + 45, -16777216, false);
            this.renderTrophies(guiGraphics, mouseX, mouseY);
            this.renderItem(this.secrets, this.uiX + 321, this.uiY + 39, 1.0f);
            guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.guide.secrets"), this.uiX + 228, this.uiY + 45, -16777216, false);
            this.renderSecrets(guiGraphics, mouseX, mouseY);
        }
    }

    private void renderTheBasicsIndex(GuiGraphics guiGraphics, ItemStack is, int x, int y, int mouseX, int mouseY, String translationKey, int pageNr) {
        this.renderItem(is, x, y, 1.0f);
        if (mouseX > x - 2 && mouseX < x + 17 && mouseY > y - 2 && mouseY < y + 17) {
            guiGraphics.renderTooltip(this.font, (Component)Component.translatable((String)translationKey), mouseX, mouseY);
        }
        if (this.clickedX > x - 2 && this.clickedX < x + 17 && this.clickedY > y - 2 && this.clickedY < y + 17) {
            this.minecraft.player.playSound(SoundEvents.BOOK_PAGE_TURN);
            this.menu = 1;
            this.page = pageNr;
            if (pageNr == 5) {
                this.menu = -1;
            }
        }
    }

    private void renderIndex(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        int topLeftCorner = this.uiX + 53;
        int y = this.uiY + 47;
        int columnNumber = -1;
        int rowNumber = -1;
        int semiPageNumber = -this.page * 2;
        this.hasNextEntryPage = false;
        if (this.page == 0) {
            int auxX = topLeftCorner + 2;
            this.renderTheBasicsIndex(guiGraphics, this.basics, auxX, y, mouseX, mouseY, "gui.guide.index.basics", 0);
            this.renderTheBasicsIndex(guiGraphics, this.ironHook, auxX += 20, y, mouseX, mouseY, "gui.guide.index.hooks", 2);
            this.renderTheBasicsIndex(guiGraphics, this.frugalBobber, auxX += 20, y, mouseX, mouseY, "gui.guide.index.bobbers", 2);
            this.renderTheBasicsIndex(guiGraphics, this.cherryBait, auxX += 20, y, mouseX, mouseY, "gui.guide.index.baits", 3);
            this.renderTheBasicsIndex(guiGraphics, this.fishSpotter, auxX += 20, y, mouseX, mouseY, "gui.guide.index.gadgets", 3);
            this.renderTheBasicsIndex(guiGraphics, this.trophies, auxX += 20, y, mouseX, mouseY, "gui.guide.index.trophies", 4);
            this.renderTheBasicsIndex(guiGraphics, this.settings, auxX += 20, y, mouseX, mouseY, "gui.guide.index.settings", 5);
        }
        rowNumber = 2;
        for (FishProperties fp : this.fishInArea) {
            if (++columnNumber > 6) {
                ++rowNumber;
                columnNumber = 0;
            }
            if (rowNumber > 7) {
                ++semiPageNumber;
                rowNumber = 0;
            }
            if (semiPageNumber > 1) break;
            if (semiPageNumber < 0) continue;
            this.renderFishIndex(guiGraphics, topLeftCorner + columnNumber * 20 + semiPageNumber * 205, y - 2 + rowNumber * 20, mouseX, mouseY, fp, -3752529);
        }
        if (this.page == 0) {
            if (this.fishInArea.size() > 6) {
                this.renderImage(guiGraphics, FISHES_IN_AREA_TOP_RIGHT_DECORATION);
            }
            int numberOfRows = (this.fishInArea.size() - 1) / 7 + 1;
            int x = mouseX - this.uiX;
            int y2 = mouseY - this.uiY;
            if (x > 168 && x < 191 && y2 > 121 && y2 < 128 && numberOfRows == 1 || x > 168 && x < 191 && y2 > 141 && y2 < 148 && numberOfRows == 2 || x > 168 && x < 191 && y2 > 161 && y2 < 168 && numberOfRows == 3 || x > 168 && x < 191 && y2 > 181 && y2 < 188 && numberOfRows == 4) {
                guiGraphics.renderTooltip(this.font, (Component)Component.translatable((String)((Sort)((Object)Config.SORT.get())).getTranslationKey()), mouseX, mouseY);
            }
            if (!this.fishInArea.isEmpty()) {
                this.renderImage(guiGraphics, FISHES_IN_AREA_BOTTOM_LEFT_DECORATION, 0, (numberOfRows - 1) * 20);
            }
            if (columnNumber < 4) {
                this.renderImage(guiGraphics, FISHES_IN_AREA_FISH_DECORATION, 0, (numberOfRows - 1) * 20);
            }
            if (numberOfRows <= 1) {
                this.renderImage(guiGraphics, ALL_FISHES_4_ROW, 0, 0);
            }
            if (numberOfRows == 2) {
                this.renderImage(guiGraphics, ALL_FISHES_3_ROW, 0, 0);
            }
            if (numberOfRows == 3) {
                this.renderImage(guiGraphics, ALL_FISHES_2_ROW, 0, 0);
            }
            if (numberOfRows == 4) {
                this.renderImage(guiGraphics, ALL_FISHES_1_ROW, 0, 0);
            }
        }
        columnNumber = -1;
        if (++rowNumber > 6) {
            rowNumber = 0;
            ++semiPageNumber;
        }
        ++rowNumber;
        for (FishProperties fp : this.entries) {
            if (++columnNumber > 6) {
                ++rowNumber;
                columnNumber = 0;
            }
            if (rowNumber > 7) {
                ++semiPageNumber;
                rowNumber = 0;
            }
            if (semiPageNumber > 1) break;
            if (semiPageNumber < 0) continue;
            this.renderFishIndex(guiGraphics, topLeftCorner + columnNumber * 20 + semiPageNumber * 159, y + 4 + rowNumber * 20, mouseX, mouseY, fp, this.page == 0 && semiPageNumber == 0 ? -1777448 : -3752529);
        }
        if (semiPageNumber > 1) {
            this.hasNextEntryPage = true;
        }
    }

    private void renderFishIndex(GuiGraphics guiGraphics, int xOffset, int yOffset, int mouseX, int mouseY, FishProperties fp, int backgroundFillColor) {
        List fishCounterList = (List)this.player.getData(ModDataAttachments.FISHES_CAUGHT);
        ItemStack is = new ItemStack(fp.fish());
        int caught = 0;
        for (FishCaughtCounter f : fishCounterList) {
            if (!fp.equals(f.fp())) continue;
            caught = f.count();
            break;
        }
        if (this.clickedX > xOffset - 3 && this.clickedX < xOffset + 21 - 3 && this.clickedY > yOffset - 3 && this.clickedY < yOffset + 21 - 3) {
            this.minecraft.player.playSound(SoundEvents.BOOK_PAGE_TURN);
            this.menu = 2;
            this.page = this.entries.indexOf(fp) / 2;
        }
        guiGraphics.fill(xOffset - 1, yOffset - 1, xOffset + 17, yOffset + 17, backgroundFillColor);
        switch (fp.rarity()) {
            case COMMON: {
                guiGraphics.setColor(1.0f, 1.0f, 1.0f, 0.0f);
                break;
            }
            case UNCOMMON: {
                guiGraphics.setColor(0.7f, 1.0f, 0.7f, 1.0f);
                break;
            }
            case RARE: {
                guiGraphics.setColor(0.2f, 0.4f, 0.7f, 0.7f);
                break;
            }
            case EPIC: {
                guiGraphics.setColor(1.0f, 0.0f, 1.0f, 0.5f);
                break;
            }
            case LEGENDARY: {
                Color color = Color.getHSBColor(Tooltips.hue * 2.0f, 1.0f, 1.0f);
                float r = (float)color.getRed() / 255.0f;
                float g = (float)color.getGreen() / 255.0f;
                float b = (float)color.getBlue() / 255.0f;
                guiGraphics.setColor(r, g, b, 0.7f);
            }
        }
        RenderSystem.enableBlend();
        guiGraphics.blit(GLOW, xOffset - 1, yOffset - 1, 0.0f, 0.0f, 18, 18, 18, 18);
        RenderSystem.disableBlend();
        guiGraphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        if (caught != 0) {
            this.renderItem(is, xOffset, yOffset, 1.0f);
        } else {
            this.renderItem(new ItemStack((ItemLike)ModItems.MISSINGNO.get()), xOffset, yOffset, 1.0f);
        }
        for (FishProperties fpNotif : (List)this.player.getData(ModDataAttachments.FISHES_NOTIFICATION)) {
            if (!fp.equals(fpNotif)) continue;
            guiGraphics.blit(STAR, xOffset + 10, yOffset + 7, 0.0f, 0.0f, 10, 10, 10, 10);
        }
        if (mouseX > xOffset - 3 && mouseX < xOffset + 21 - 3 && mouseY > yOffset - 3 && mouseY < yOffset + 21 - 3) {
            ArrayList<Object> components = new ArrayList<Object>();
            if (caught == 0) {
                components.add(Component.translatable((String)"gui.guide.not_caught_fish_name"));
                components.add(Tooltips.decodeTranslationKey((String)("gui.guide.rarity." + fp.rarity().getSerializedName())));
                components.add(Component.translatable((String)"gui.guide.not_caught_yet").withColor(10700086));
            } else {
                if (fp.customName().isEmpty()) {
                    components.add(Component.translatable((String)("item." + fp.fish().getRegisteredName().replace(":", "."))));
                } else {
                    components.add(Component.translatable((String)("item.starcatcher." + fp.customName())));
                }
                components.add(Tooltips.decodeTranslationKey((String)("gui.guide.rarity." + fp.rarity().getSerializedName())));
                components.add(Component.translatable((String)"gui.guide.caught").append((Component)Component.literal((String)(" [" + caught + "]"))).withColor(4224300));
            }
            if (ModList.get().isLoaded("sereneseasons")) {
                if (SereneSeasonsCompat.canCatch(fp, (Level)this.level)) {
                    components.add(Component.translatable((String)"gui.guide.seasons.in_season").withStyle(Style.EMPTY.withColor(4224300)));
                } else {
                    components.add(Component.translatable((String)"gui.guide.seasons.not_in_season").withStyle(Style.EMPTY.withColor(10700086)));
                }
            }
            guiGraphics.renderTooltip(this.font, components, Optional.empty(), mouseX, mouseY);
        }
    }

    private void renderEntry(GuiGraphics guiGraphics, int mouseX, int mouseY, int xOffset, int entry) {
        MutableComponent comp;
        MutableComponent hardCodedTranslations;
        String aboveBelow;
        MutableComponent comp2;
        MutableComponent comp3;
        if (this.level == null) {
            this.level = this.getMinecraft().level;
        }
        double x = mouseX - this.uiX;
        double y = mouseY - this.uiY;
        if (this.entries.size() <= entry) {
            return;
        }
        ItemStack is = new ItemStack(this.entries.get(entry).fish());
        FishProperties fp = this.entries.get(entry);
        if (!this.fpsSeen.contains(fp)) {
            this.fpsSeen.add(fp);
        }
        FishCaughtCounter fcc = null;
        for (FishCaughtCounter fccAll : this.fishCaughtCounterList) {
            if (!fp.equals(fccAll.fp())) continue;
            fcc = fccAll;
            break;
        }
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.guide.caught"), this.uiX + xOffset + 73, this.uiY + 68, 10258812, false);
        if (fcc == null) {
            guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.guide.not_caught"), this.uiX + xOffset + 73, this.uiY + 78, 10258812, false);
        } else {
            MutableComponent c = Component.literal((String)("[" + fcc.count() + "]")).withColor(6508608);
            guiGraphics.drawString(this.font, (Component)Component.empty().append((Component)c), this.uiX + xOffset + 73, this.uiY + 78, 0, false);
        }
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.guide.rarity"), this.uiX + xOffset + 73, this.uiY + 90, 10258812, false);
        guiGraphics.drawString(this.font, Tooltips.decodeTranslationKey((String)("gui.guide.rarity." + fp.rarity().getSerializedName())), this.uiX + xOffset + 73, this.uiY + 100, 0, false);
        if (ModList.get().isLoaded("sereneseasons")) {
            int seasonX = 79;
            int seasonY = 48;
            int spacing = 15;
            List<FishProperties.WorldRestrictions.Seasons> seasons = fp.wr().seasons();
            if (U.containsAny(seasons, FishProperties.WorldRestrictions.Seasons.ALL, FishProperties.WorldRestrictions.Seasons.SPRING, FishProperties.WorldRestrictions.Seasons.EARLY_SPRING, FishProperties.WorldRestrictions.Seasons.MID_SPRING, FishProperties.WorldRestrictions.Seasons.LATE_SPRING)) {
                guiGraphics.blit(SEASONS, this.uiX + xOffset + seasonX, this.uiY + seasonY, 8, 8, 0.0f, 0.0f, 8, 8, 32, 8);
            }
            if (U.containsAny(seasons, FishProperties.WorldRestrictions.Seasons.ALL, FishProperties.WorldRestrictions.Seasons.SUMMER, FishProperties.WorldRestrictions.Seasons.EARLY_SUMMER, FishProperties.WorldRestrictions.Seasons.MID_SUMMER, FishProperties.WorldRestrictions.Seasons.LATE_SUMMER)) {
                guiGraphics.blit(SEASONS, this.uiX + xOffset + seasonX + spacing * 1, this.uiY + seasonY, 8, 8, 8.0f, 0.0f, 8, 8, 32, 8);
            }
            if (U.containsAny(seasons, FishProperties.WorldRestrictions.Seasons.ALL, FishProperties.WorldRestrictions.Seasons.AUTUMN, FishProperties.WorldRestrictions.Seasons.EARLY_AUTUMN, FishProperties.WorldRestrictions.Seasons.MID_AUTUMN, FishProperties.WorldRestrictions.Seasons.LATE_AUTUMN)) {
                guiGraphics.blit(SEASONS, this.uiX + xOffset + seasonX + spacing * 2, this.uiY + seasonY, 8, 8, 16.0f, 0.0f, 8, 8, 32, 8);
            }
            if (U.containsAny(seasons, FishProperties.WorldRestrictions.Seasons.ALL, FishProperties.WorldRestrictions.Seasons.WINTER, FishProperties.WorldRestrictions.Seasons.EARLY_WINTER, FishProperties.WorldRestrictions.Seasons.MID_WINTER, FishProperties.WorldRestrictions.Seasons.LATE_WINTER)) {
                guiGraphics.blit(SEASONS, this.uiX + xOffset + seasonX + spacing * 3, this.uiY + seasonY, 8, 8, 24.0f, 0.0f, 8, 8, 32, 8);
            }
            if (x > (double)(xOffset + 70) && x < (double)(xOffset + 140) && y > 46.0 && y < 57.0) {
                ArrayList<MutableComponent> seasonsComp = new ArrayList<MutableComponent>();
                seasonsComp.add(Component.translatable((String)"gui.guide.seasons"));
                if (fp.wr().seasons().contains((Object)FishProperties.WorldRestrictions.Seasons.ALL)) {
                    seasonsComp.add(Component.translatable((String)"gui.guide.seasons.all"));
                } else {
                    for (FishProperties.WorldRestrictions.Seasons s : seasons) {
                        seasonsComp.add(Component.translatable((String)("desc.sereneseasons." + s.getSerializedName())));
                    }
                }
                guiGraphics.renderTooltip(this.font, seasonsComp, Optional.empty(), mouseX, mouseY);
            }
        }
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.guide.rarity"), this.uiX + xOffset + 73, this.uiY + 90, 10258812, false);
        if (fcc == null) {
            guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.guide.not_caught_fish_name"), this.uiX + xOffset + 30, this.uiY + 36, 6508608, false);
        } else {
            MutableComponent compName = fp.customName().isEmpty() ? Component.translatable((String)((Item)fp.fish().value()).getDescriptionId()) : Component.translatable((String)("item.starcatcher." + fp.customName()));
            if (xOffset > 200) {
                guiGraphics.drawString(this.font, (Component)compName, this.uiX + xOffset + 15, this.uiY + 36, 6508608, false);
            } else {
                guiGraphics.drawString(this.font, (Component)compName, this.uiX + xOffset + 30, this.uiY + 36, 6508608, false);
            }
        }
        if (fcc != null) {
            this.renderItem(is, this.uiX + xOffset + 26, this.uiY + 70);
        }
        switch (fp.rarity()) {
            case COMMON: {
                guiGraphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
                break;
            }
            case UNCOMMON: {
                guiGraphics.setColor(0.7f, 1.0f, 0.7f, 1.0f);
                break;
            }
            case RARE: {
                guiGraphics.setColor(0.2f, 0.4f, 0.7f, 0.7f);
                break;
            }
            case EPIC: {
                guiGraphics.setColor(1.0f, 0.0f, 1.0f, 0.5f);
                break;
            }
            case LEGENDARY: {
                Color color = Color.getHSBColor(Tooltips.hue, 1.0f, 1.0f);
                float r = (float)color.getRed() / 255.0f;
                float g = (float)color.getGreen() / 255.0f;
                float b = (float)color.getBlue() / 255.0f;
                guiGraphics.setColor(r, g, b, 0.7f);
            }
        }
        RenderSystem.enableBlend();
        if (fcc != null) {
            guiGraphics.blit(GLOW, this.uiX + xOffset + 10, this.uiY + 55, 0.0f, 0.0f, 48, 48, 48, 48);
        }
        RenderSystem.disableBlend();
        guiGraphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        if (((List)this.player.getData(ModDataAttachments.FISHES_NOTIFICATION)).contains(fp)) {
            this.renderImage(guiGraphics, NEW_FISH, xOffset - 52, 0);
        }
        if (mouseX > this.uiX + xOffset + 0 && mouseX < this.uiX + xOffset + 65 && mouseY > this.uiY + 45 && mouseY < this.uiY + 110 && fcc != null) {
            guiGraphics.renderTooltip(this.font, is, mouseX, mouseY);
        }
        if (mouseX > this.uiX + xOffset + 66 && mouseX < this.uiX + xOffset + 140 && mouseY > this.uiY + 57 && mouseY < this.uiY + 110 && fcc != null) {
            ArrayList<MutableComponent> components = new ArrayList<MutableComponent>();
            float averageTicks = (float)((int)(fcc.averageTicks() / 20.0f * 100.0f)) / 100.0f;
            SettingsScreen.Units unit = (SettingsScreen.Units)((Object)Config.UNIT.get());
            String size = unit.getSizeAsString(fcc.size());
            String weight = unit.getWeightAsString(fcc.weight());
            components.add(Component.literal((String)"Fastest Catch: ").append((Component)Component.literal((String)((float)fcc.fastestTicks() / 20.0f + "s")).withStyle(ChatFormatting.BOLD)));
            components.add(Component.literal((String)"Average Catch: ").append((Component)Component.literal((String)(averageTicks + "s")).withStyle(ChatFormatting.BOLD)));
            components.add(Component.literal((String)""));
            components.add(Component.literal((String)"Biggest Catch: ").append((Component)Component.literal((String)size).withStyle(ChatFormatting.BOLD)));
            components.add(Component.literal((String)"Heaviest Catch: ").append((Component)Component.literal((String)weight).withStyle(ChatFormatting.BOLD)));
            guiGraphics.renderTooltip(this.font, components, Optional.empty(), mouseX, mouseY);
        }
        int yOffset = 121;
        if (fp.wr().dims().isEmpty()) {
            comp3 = Component.translatable((String)"gui.guide.no_restriction");
        } else if (fp.wr().dims().size() == 1) {
            comp3 = Component.translatable((String)("dimension." + fp.wr().dims().getFirst().toLanguageKey()));
        } else {
            comp3 = Component.translatable((String)"gui.guide.hover");
            if (x > (double)xOffset && x < (double)(xOffset + 100) && y > (double)(yOffset - 2) && y < (double)(yOffset + 10)) {
                ArrayList<MutableComponent> c = new ArrayList<MutableComponent>();
                c.add(Component.translatable((String)"gui.guide.dimensions"));
                for (int i = 0; i < fp.wr().dims().size(); ++i) {
                    c.add(Component.translatable((String)("dimension." + fp.wr().dims().get(i).toLanguageKey())));
                }
                guiGraphics.renderTooltip(this.font, c, Optional.empty(), mouseX, mouseY);
            }
        }
        comp3 = fp.wr().dims().isEmpty() ? comp3.copy().withColor(4224300) : (fp.wr().dims().contains(this.level.dimension().location()) ? comp3.copy().withColor(4224300) : comp3.copy().withColor(10700086));
        MutableComponent start = Component.translatable((String)"gui.guide.dimension");
        guiGraphics.drawString(this.font, (Component)start.copy().append((Component)comp3), this.uiX + xOffset, this.uiY + yOffset, 6508608, false);
        if (!fp.wr().dimsBlacklist().isEmpty()) {
            guiGraphics.drawString(this.font, (Component)Component.literal((String)"[!]").withColor(10700086), this.uiX + xOffset + 160, this.uiY + yOffset, 0, false);
            if (x > (double)(xOffset + 155) && x < (double)(xOffset + 175) && y > (double)(yOffset - 4) && y < (double)(yOffset + 12)) {
                ArrayList<MutableComponent> c = new ArrayList<MutableComponent>();
                c.add(Component.translatable((String)"gui.guide.blacklisted_dimensions"));
                for (int i = 0; i < fp.wr().dimsBlacklist().size(); ++i) {
                    c.add(Component.literal((String)fp.wr().dimsBlacklist().get(i).toString()));
                }
                guiGraphics.renderTooltip(this.font, c, Optional.empty(), mouseX, mouseY);
            }
        }
        yOffset += 12;
        List<ResourceLocation> biomesBL = FishProperties.getBiomesBlacklistAsList(fp, (Level)this.level);
        List<ResourceLocation> biomes = FishProperties.getBiomesAsList(fp, (Level)this.level);
        if (biomes.isEmpty()) {
            comp2 = Component.translatable((String)"gui.guide.no_restriction");
        } else if (biomes.size() == 1) {
            comp2 = Component.translatable((String)("biome." + biomes.getFirst().toLanguageKey()));
        } else if (fp.wr().biomesTags().size() == 1) {
            comp2 = Component.translatable((String)("tag." + fp.wr().biomesTags().getFirst().toLanguageKey()));
            if (x > (double)xOffset && x < (double)(xOffset + 100) && y > (double)(yOffset - 2) && y < (double)(yOffset + 10)) {
                c = new ArrayList();
                if (!fp.wr().biomesTags().isEmpty()) {
                    c.add(Component.translatable((String)"gui.guide.biome_tags").withStyle(Style.EMPTY.withBold(Boolean.valueOf(true))));
                    for (ResourceLocation rl : fp.wr().biomesTags()) {
                        c.add(Component.translatable((String)("tag." + rl.toLanguageKey())));
                    }
                    c.add(Component.empty());
                }
                c.add(Component.translatable((String)"gui.guide.biomes").withStyle(Style.EMPTY.withBold(Boolean.valueOf(true))));
                for (ResourceLocation rl : biomes) {
                    c.add(Component.translatable((String)("biome." + rl.toLanguageKey())));
                }
                guiGraphics.renderTooltip(this.font, c, Optional.empty(), mouseX, mouseY);
            }
        } else {
            comp2 = Component.translatable((String)"gui.guide.hover");
            if (x > (double)xOffset && x < (double)(xOffset + 100) && y > (double)(yOffset - 2) && y < (double)(yOffset + 10)) {
                c = new ArrayList<MutableComponent>();
                c.add(Component.translatable((String)"gui.guide.biome"));
                for (ResourceLocation rl : biomes) {
                    c.add(Component.translatable((String)("biome." + rl.toLanguageKey())));
                }
                guiGraphics.renderTooltip(this.font, c, Optional.empty(), mouseX, mouseY);
            }
        }
        ResourceLocation rl = ResourceLocation.parse((String)this.level.getBiome(Minecraft.getInstance().player.blockPosition()).getRegisteredName());
        comp2 = comp2.copy().withColor(4224300);
        if (!biomes.contains(rl) && !biomes.isEmpty()) {
            comp2 = comp2.copy().withColor(10700086);
        }
        if (biomesBL.contains(rl)) {
            comp2 = comp2.copy().withColor(10700086);
        }
        MutableComponent start2 = Component.translatable((String)"gui.guide.biome");
        guiGraphics.drawString(this.font, (Component)start2.copy().append((Component)comp2), this.uiX + xOffset, this.uiY + yOffset, 6508608, false);
        if (!biomesBL.isEmpty()) {
            guiGraphics.drawString(this.font, (Component)Component.literal((String)"[!]").withColor(10700086), this.uiX + xOffset + 130, this.uiY + yOffset - 1, 0, false);
            if (x > (double)(xOffset + 129) && x < (double)(xOffset + 140) && y > (double)(yOffset - 3) && y < (double)(yOffset + 8)) {
                ArrayList<MutableComponent> c = new ArrayList<MutableComponent>();
                if (!fp.wr().biomesBlacklistTags().isEmpty()) {
                    c.add(Component.translatable((String)"gui.guide.blacklisted_biome_tags").withStyle(Style.EMPTY.withBold(Boolean.valueOf(true))));
                    for (ResourceLocation rl2 : fp.wr().biomesBlacklistTags()) {
                        c.add(Component.translatable((String)("tag." + rl2.toLanguageKey())));
                    }
                    c.add(Component.empty());
                }
                c.add(Component.translatable((String)"gui.guide.blacklisted_biomes").withStyle(Style.EMPTY.withBold(Boolean.valueOf(true))));
                for (ResourceLocation rl2 : biomesBL) {
                    c.add(Component.translatable((String)("biome." + rl2.toLanguageKey())));
                }
                guiGraphics.renderTooltip(this.font, c, Optional.empty(), mouseX, mouseY);
            }
        }
        yOffset += 12;
        if (fp.br().correctBait().isEmpty()) {
            guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.guide.bait").append((Component)Component.translatable((String)"gui.guide.no_restriction")), this.uiX + xOffset, this.uiY + yOffset, 6508608, false);
        } else {
            ItemStack bait = new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(fp.br().correctBait().getFirst()));
            int bonus = fp.br().correctBaitChanceAdded() / fp.baseChance() * 100;
            MutableComponent extra = Component.literal((String)(" (+" + bonus + "%)"));
            if (bait.is((Item)ModItems.LEGENDARY_BAIT.get())) {
                guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.guide.bait").append(Tooltips.RGBEachLetter((String)I18n.get((String)bait.getDescriptionId(), (Object[])new Object[0]))).append((Component)extra), this.uiX + xOffset, this.uiY + yOffset, 6508608, false);
            } else {
                guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.guide.bait").append((Component)Component.translatable((String)bait.getDescriptionId())).append((Component)extra), this.uiX + xOffset, this.uiY + yOffset, 6508608, false);
            }
            if (x > (double)xOffset && x < (double)(xOffset + 100) && y > (double)(yOffset - 2) && y < (double)(yOffset + 10)) {
                guiGraphics.renderTooltip(this.font, bait, mouseX, mouseY);
            }
        }
        yOffset += 12;
        if (fp.weather() == FishProperties.Weather.ALL) {
            comp2 = Component.translatable((String)"gui.guide.no_restriction").withColor(6508608);
        } else {
            comp2 = Component.translatable((String)"gui.guide.no_restriction");
            if (fp.weather() == FishProperties.Weather.RAIN) {
                comp2 = (double)this.level.getRainLevel(0.0f) > 0.5 ? Component.translatable((String)"gui.guide.raining").withColor(4224300) : Component.translatable((String)"gui.guide.raining").withColor(10700086);
            }
            if (fp.weather() == FishProperties.Weather.THUNDER) {
                comp2 = (double)this.level.getThunderLevel(0.0f) > 0.5 ? Component.translatable((String)"gui.guide.thundering").withColor(4224300) : Component.translatable((String)"gui.guide.thundering").withColor(10700086);
            }
            if (fp.weather() == FishProperties.Weather.CLEAR) {
                comp2 = (double)this.level.getRainLevel(0.0f) > 0.5 || (double)this.level.getThunderLevel(0.0f) > 0.5 ? Component.translatable((String)"gui.guide.clear").withColor(10700086) : Component.translatable((String)"gui.guide.clear").withColor(4224300);
            }
        }
        MutableComponent start3 = Component.translatable((String)"gui.guide.weather");
        guiGraphics.drawString(this.font, (Component)start3.copy().append((Component)comp2), this.uiX + xOffset, this.uiY + yOffset, 6508608, false);
        yOffset += 12;
        if (fp.daytime() == FishProperties.Daytime.ALL) {
            comp2 = Component.translatable((String)"gui.guide.no_restriction").withColor(6508608);
        } else {
            long time = this.level.getDayTime() % 24000L;
            comp2 = switch (fp.daytime()) {
                case FishProperties.Daytime.DAY -> {
                    if (time <= 23000L && time >= 12700L) {
                        yield Component.translatable((String)"gui.guide.day").withColor(10700086);
                    }
                    yield Component.translatable((String)"gui.guide.day").withColor(4224300);
                }
                case FishProperties.Daytime.NOON -> {
                    if (time <= 3500L || time >= 8500L) {
                        yield Component.translatable((String)"gui.guide.noon").withColor(10700086);
                    }
                    yield Component.translatable((String)"gui.guide.noon").withColor(4224300);
                }
                case FishProperties.Daytime.NIGHT -> {
                    if (time >= 23000L || time <= 12700L) {
                        yield Component.translatable((String)"gui.guide.night").withColor(10700086);
                    }
                    yield Component.translatable((String)"gui.guide.night").withColor(4224300);
                }
                case FishProperties.Daytime.MIDNIGHT -> {
                    if (time <= 16500L || time >= 19500L) {
                        yield Component.translatable((String)"gui.guide.midnight").withColor(10700086);
                    }
                    yield Component.translatable((String)"gui.guide.midnight").withColor(4224300);
                }
                default -> Component.empty();
            };
        }
        start = Component.translatable((String)"gui.guide.daytime");
        guiGraphics.drawString(this.font, (Component)start.copy().append((Component)comp2), this.uiX + xOffset, this.uiY + yOffset, 6508608, false);
        yOffset += 12;
        int above = fp.wr().mustBeCaughtAboveY();
        int below = fp.wr().mustBeCaughtBelowY();
        switch (aboveBelow = above + ", " + below) {
            case "100, 2147483647": {
                MutableComponent mutableComponent = Component.translatable((String)"gui.guide.mountain");
                break;
            }
            case "50, 100": 
            case "50, 2147483647": {
                MutableComponent mutableComponent = Component.translatable((String)"gui.guide.surface");
                break;
            }
            case "-2147483648, 50": {
                MutableComponent mutableComponent = Component.translatable((String)"gui.guide.underground");
                break;
            }
            case "0, 50": {
                MutableComponent mutableComponent = Component.translatable((String)"gui.guide.caves");
                break;
            }
            case "-2147483648, 0": {
                MutableComponent mutableComponent = Component.translatable((String)"gui.guide.deepslate");
                break;
            }
            case "-2147483648, 2147483647": {
                MutableComponent mutableComponent = Component.translatable((String)"gui.guide.no_restriction");
                break;
            }
            default: {
                MutableComponent mutableComponent = hardCodedTranslations = Component.literal((String)("> " + above + ", < " + below));
            }
        }
        if (this.player.getY() > (double)above && this.player.getY() < (double)below) {
            hardCodedTranslations.withColor(4224300);
        } else {
            hardCodedTranslations.withColor(10700086);
        }
        ArrayList<MutableComponent> hoverTooltip = new ArrayList<MutableComponent>(List.of());
        if (above > Integer.MIN_VALUE) {
            hoverTooltip.add(Component.translatable((String)"gui.guide.above").append("" + above));
        }
        if (below < Integer.MAX_VALUE) {
            hoverTooltip.add(Component.translatable((String)"gui.guide.below").append("" + below));
        }
        if (x > (double)xOffset && x < (double)(xOffset + 140) && y > (double)(yOffset - 2) && y < (double)(yOffset + 10)) {
            guiGraphics.renderTooltip(this.font, hoverTooltip, Optional.empty(), mouseX, mouseY);
        }
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.guide.elevation").append((Component)hardCodedTranslations), this.uiX + xOffset, this.uiY + yOffset, 6508608, false);
        yOffset += 12;
        List<ResourceLocation> fluids = fp.wr().fluids();
        if (fluids.size() == 1) {
            comp = Component.translatable((String)("block." + fluids.getFirst().toLanguageKey()));
        } else {
            comp = Component.translatable((String)"gui.guide.hover");
            if (x > (double)xOffset && x < (double)(xOffset + 100) && y > (double)(yOffset - 2) && y < (double)(yOffset + 10)) {
                ArrayList<MutableComponent> c = new ArrayList<MutableComponent>();
                c.add(Component.translatable((String)"gui.guide.fluid"));
                for (ResourceLocation rl3 : fluids) {
                    c.add(Component.translatable((String)("block." + rl3.toLanguageKey())));
                }
                guiGraphics.renderTooltip(this.font, c, Optional.empty(), mouseX, mouseY);
            }
        }
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.guide.fluid").append((Component)comp), this.uiX + xOffset, this.uiY + yOffset, 6508608, false);
    }

    private void renderImage(GuiGraphics guiGraphics, ResourceLocation rl) {
        guiGraphics.blit(rl, this.uiX, this.uiY, 0.0f, 0.0f, 420, 260, 420, 260);
    }

    private void renderImage(GuiGraphics guiGraphics, ResourceLocation rl, int xOffset, int yOffset) {
        guiGraphics.blit(rl, this.uiX + xOffset, this.uiY + yOffset, 0.0f, 0.0f, 420, 260, 420, 260);
    }

    private void renderItem(ItemStack stack, int x, int y) {
        this.renderItem(stack, x, y, 3.0f);
    }

    private void renderItem(ItemStack stack, int x, int y, float scale) {
        ClientLevel level = Minecraft.getInstance().level;
        LocalPlayer entity = Minecraft.getInstance().player;
        if (!stack.isEmpty()) {
            boolean usesBlockLight;
            BakedModel bakedmodel = this.minecraft.getItemRenderer().getModel(stack, (Level)level, (LivingEntity)entity, 234234);
            PoseStack pose = new PoseStack();
            pose.pushPose();
            pose.translate((float)(x + 8), (float)(y + 8), 150.0f);
            pose.scale(16.0f * scale, -16.0f * scale, 16.0f * scale);
            boolean bl = usesBlockLight = !bakedmodel.usesBlockLight();
            if (usesBlockLight) {
                Lighting.setupForFlatItems();
            }
            this.minecraft.getItemRenderer().render(stack, ItemDisplayContext.GUI, false, pose, (MultiBufferSource)Minecraft.getInstance().renderBuffers().bufferSource(), 0xF000F0, OverlayTexture.NO_OVERLAY, bakedmodel);
            RenderSystem.disableDepthTest();
            Minecraft.getInstance().renderBuffers().bufferSource().endBatch();
            RenderSystem.enableDepthTest();
            if (usesBlockLight) {
                Lighting.setupFor3DItems();
            }
            pose.popPose();
        }
    }

    public void onClose() {
        Minecraft.getInstance().options.advancedItemTooltips = this.advancedTooltips;
        PacketDistributor.sendToServer((CustomPacketPayload)new Payloads.FPsSeen(this.fpsSeen), (CustomPacketPayload[])new CustomPacketPayload[0]);
        super.onClose();
    }

    public boolean isPauseScreen() {
        return false;
    }

    protected boolean shouldNarrateNavigation() {
        return false;
    }

    public FishingGuideScreen() {
        super((Component)Component.empty());
        this.all = new TrophyProperties.RarityProgress(0, ((List)Minecraft.getInstance().player.getData(ModDataAttachments.FISHES_CAUGHT)).size() - 1);
        this.common = new TrophyProperties.RarityProgress(0, -1);
        this.uncommon = TrophyProperties.RarityProgress.DEFAULT;
        this.rare = TrophyProperties.RarityProgress.DEFAULT;
        this.epic = TrophyProperties.RarityProgress.DEFAULT;
        this.legendary = TrophyProperties.RarityProgress.DEFAULT;
        this.basics = new ItemStack((ItemLike)ModItems.ROD.get());
        this.treasures = new ItemStack((ItemLike)ModItems.WATERLOGGED_SATCHEL.get());
        this.ironHook = new ItemStack((ItemLike)ModItems.HOOK.get());
        this.shinyHook = new ItemStack((ItemLike)ModItems.SHINY_HOOK.get());
        this.goldHook = new ItemStack((ItemLike)ModItems.GOLD_HOOK.get());
        this.mossyHook = new ItemStack((ItemLike)ModItems.MOSSY_HOOK.get());
        this.crystalHook = new ItemStack((ItemLike)ModItems.CRYSTAL_HOOK.get());
        this.heavyHook = new ItemStack((ItemLike)ModItems.HEAVY_HOOK.get());
        this.stoneHook = new ItemStack((ItemLike)ModItems.STONE_HOOK.get());
        this.splitHook = new ItemStack((ItemLike)ModItems.SPLIT_HOOK.get());
        this.stabHook = new ItemStack((ItemLike)ModItems.STABILIZING_HOOK.get());
        this.frugalBobber = new ItemStack((ItemLike)ModItems.FRUGAL_BOBBER.get());
        this.creeperBobber = new ItemStack((ItemLike)ModItems.CREEPER_BOBBER.get());
        this.glitterBobber = new ItemStack((ItemLike)ModItems.GLITTER_BOBBER.get());
        this.colorfulBobber = new ItemStack((ItemLike)ModItems.COLORFUL_BOBBER.get());
        this.steadyBobber = new ItemStack((ItemLike)ModItems.STEADY_BOBBER.get());
        this.impatientBobber = new ItemStack((ItemLike)ModItems.IMPATIENT_BOBBER.get());
        this.frogBobber = new ItemStack((ItemLike)ModItems.FROG_BOBBER.get());
        this.kimbeBobber = new ItemStack((ItemLike)ModItems.KIMBE_BOBBER.get());
        this.clearBobber = new ItemStack((ItemLike)ModItems.CLEAR_BOBBER.get());
        this.cherryBait = new ItemStack((ItemLike)ModItems.CHERRY_BAIT.get());
        this.lushBait = new ItemStack((ItemLike)ModItems.LUSH_BAIT.get());
        this.sculkBait = new ItemStack((ItemLike)ModItems.SCULK_BAIT.get());
        this.dripstoneBait = new ItemStack((ItemLike)ModItems.DRIPSTONE_BAIT.get());
        this.murkwaterBait = new ItemStack((ItemLike)ModItems.MURKWATER_BAIT.get());
        this.legendaryBait = new ItemStack((ItemLike)ModItems.LEGENDARY_BAIT.get());
        this.meteorologicalBait = new ItemStack((ItemLike)ModItems.METEOROLOGICAL_BAIT.get());
        this.fishSpotter = new ItemStack((ItemLike)ModItems.FISH_SPOTTER.get());
        this.trophies = new ItemStack((ItemLike)ModBlocks.TROPHY_GOLD.get());
        this.secrets = new ItemStack((ItemLike)ModItems.WATERLOGGED_BOTTLE.get());
        this.settings = new ItemStack((ItemLike)ModItems.SETTINGS.get());
        this.advancedTooltips = Minecraft.getInstance().options.advancedItemTooltips;
        Minecraft.getInstance().options.advancedItemTooltips = Minecraft.getInstance().player.isCreative() && this.advancedTooltips;
    }

    public static enum Sort {
        ALPHABETICAL_UP("gui.guide.sort.alphabetical_up"),
        ALPHABETICAL_DOWN("gui.guide.sort.alphabetical_down"),
        MOD_UP("gui.guide.sort.mod_up"),
        MOD_DOWN("gui.guide.sort.mod_down"),
        RARITY_UP("gui.guide.sort.rarity_up"),
        RARITY_DOWN("gui.guide.sort.rarity_down"),
        CAUGHT_UP("gui.guide.sort.caught_up"),
        CAUGHT_DOWN("gui.guide.sort.caught_down"),
        FLUID_UP("gui.guide.sort.fluid_up"),
        FLUID_DOWN("gui.guide.sort.fluid_down"),
        SEASON_UP("gui.guide.sort.season_up"),
        SEASON_DOWN("gui.guide.sort.season_down");

        private static final Sort[] vals;
        private final String translationKey;

        String getTranslationKey() {
            return this.translationKey;
        }

        private Sort(String translationKey) {
            this.translationKey = translationKey;
        }

        public Sort previous() {
            int lenght = vals.length - 2;
            if (ModList.get().isLoaded("sereneseasons")) {
                lenght += 2;
            }
            if (this.ordinal() == 0) {
                return vals[lenght - 1];
            }
            return vals[(this.ordinal() - 1) % lenght];
        }

        public Sort next() {
            int lenght = vals.length - 2;
            if (ModList.get().isLoaded("sereneseasons")) {
                lenght += 2;
            }
            return vals[(this.ordinal() + 1) % lenght];
        }

        static {
            vals = Sort.values();
        }
    }
}

