/*
 * Decompiled with CFR 0.152.
 */
package com.wdiscute.starcatcher.networkandcodecs;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.wdiscute.starcatcher.ModItems;
import com.wdiscute.starcatcher.networkandcodecs.ExtraComposites;
import com.wdiscute.starcatcher.networkandcodecs.FishProperties;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.Item;
import net.neoforged.neoforge.network.codec.NeoForgeStreamCodecs;
import org.jetbrains.annotations.NotNull;

public record TrophyProperties(FishProperties fp, TrophyType trophyType, String customName, RarityProgress all, RarityProgress common, RarityProgress uncommon, RarityProgress rare, RarityProgress epic, RarityProgress legendary, int chanceToCatch) {
    public static final TrophyProperties DEFAULT = new TrophyProperties(FishProperties.DEFAULT.withFish((Holder<Item>)ModItems.MISSINGNO), TrophyType.EXTRA, "Missingno Trophy", RarityProgress.DEFAULT, RarityProgress.DEFAULT, RarityProgress.DEFAULT, RarityProgress.DEFAULT, RarityProgress.DEFAULT, RarityProgress.DEFAULT, 100);
    public static final Codec<TrophyProperties> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)FishProperties.CODEC.optionalFieldOf("fish_properties", (Object)TrophyProperties.DEFAULT.fp).forGetter(TrophyProperties::fp), (App)TrophyType.CODEC.optionalFieldOf("trophy_type", (Object)TrophyProperties.DEFAULT.trophyType).forGetter(TrophyProperties::trophyType), (App)Codec.STRING.optionalFieldOf("custom_name", (Object)TrophyProperties.DEFAULT.customName).forGetter(TrophyProperties::customName), (App)RarityProgress.CODEC.optionalFieldOf("all", (Object)TrophyProperties.DEFAULT.common).forGetter(TrophyProperties::all), (App)RarityProgress.CODEC.optionalFieldOf("common", (Object)TrophyProperties.DEFAULT.common).forGetter(TrophyProperties::common), (App)RarityProgress.CODEC.optionalFieldOf("uncommon", (Object)TrophyProperties.DEFAULT.common).forGetter(TrophyProperties::uncommon), (App)RarityProgress.CODEC.optionalFieldOf("rare", (Object)TrophyProperties.DEFAULT.common).forGetter(TrophyProperties::rare), (App)RarityProgress.CODEC.optionalFieldOf("epic", (Object)TrophyProperties.DEFAULT.common).forGetter(TrophyProperties::epic), (App)RarityProgress.CODEC.optionalFieldOf("legendary", (Object)TrophyProperties.DEFAULT.common).forGetter(TrophyProperties::legendary), (App)Codec.INT.optionalFieldOf("chance_to_catch", (Object)TrophyProperties.DEFAULT.chanceToCatch).forGetter(TrophyProperties::chanceToCatch)).apply((Applicative)instance, TrophyProperties::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, TrophyProperties> STREAM_CODEC = ExtraComposites.composite(FishProperties.STREAM_CODEC, TrophyProperties::fp, TrophyType.STREAM_CODEC, TrophyProperties::trophyType, ByteBufCodecs.STRING_UTF8, TrophyProperties::customName, RarityProgress.STREAM_CODEC, TrophyProperties::all, RarityProgress.STREAM_CODEC, TrophyProperties::common, RarityProgress.STREAM_CODEC, TrophyProperties::uncommon, RarityProgress.STREAM_CODEC, TrophyProperties::rare, RarityProgress.STREAM_CODEC, TrophyProperties::epic, RarityProgress.STREAM_CODEC, TrophyProperties::legendary, ByteBufCodecs.VAR_INT, TrophyProperties::chanceToCatch, TrophyProperties::new);
    public static final StreamCodec<RegistryFriendlyByteBuf, List<TrophyProperties>> LIST_STREAM_CODEC = STREAM_CODEC.apply(ByteBufCodecs.list());
    public static final Codec<List<TrophyProperties>> LIST_CODEC = CODEC.listOf();

    public static enum TrophyType implements StringRepresentable
    {
        TROPHY("trophy"),
        SECRET("secret"),
        EXTRA("extra");

        public static final Codec<TrophyType> CODEC;
        public static final StreamCodec<FriendlyByteBuf, TrophyType> STREAM_CODEC;
        private final String key;

        private TrophyType(String key) {
            this.key = key;
        }

        @NotNull
        public String getSerializedName() {
            return this.key;
        }

        static {
            CODEC = StringRepresentable.fromEnum(TrophyType::values);
            STREAM_CODEC = NeoForgeStreamCodecs.enumCodec(TrophyType.class);
        }
    }

    public record RarityProgress(int total, int unique) {
        public static final Codec<RarityProgress> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.optionalFieldOf("total", (Object)0).forGetter(RarityProgress::total), (App)Codec.INT.optionalFieldOf("unique", (Object)0).forGetter(RarityProgress::unique)).apply((Applicative)instance, RarityProgress::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, RarityProgress> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, RarityProgress::total, (StreamCodec)ByteBufCodecs.VAR_INT, RarityProgress::unique, RarityProgress::new);
        public static final RarityProgress DEFAULT = new RarityProgress(0, 0);
    }
}

