/*
 * Decompiled with CFR 0.152.
 */
package com.wdiscute.starcatcher.rod;

import com.wdiscute.starcatcher.ModItems;
import com.wdiscute.starcatcher.ModMenuTypes;
import com.wdiscute.starcatcher.StarcatcherTags;
import com.wdiscute.starcatcher.networkandcodecs.ModDataComponents;
import com.wdiscute.starcatcher.networkandcodecs.SingleStackContainer;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.SlotItemHandler;

public class FishingRodMenu
extends AbstractContainerMenu {
    public final ItemStackHandler inventory = new ItemStackHandler(this, 3){

        protected int getStackLimit(int slot, ItemStack stack) {
            return 64;
        }
    };
    public final ItemStack is;
    private static final int HOTBAR_SLOT_COUNT = 9;
    private static final int PLAYER_INVENTORY_ROW_COUNT = 3;
    private static final int PLAYER_INVENTORY_COLUMN_COUNT = 9;
    private static final int PLAYER_INVENTORY_SLOT_COUNT = 27;
    private static final int VANILLA_SLOT_COUNT = 36;
    private static final int VANILLA_FIRST_SLOT_INDEX = 0;
    private static final int TE_INVENTORY_FIRST_SLOT_INDEX = 36;
    private static final int TE_INVENTORY_SLOT_COUNT = 3;

    public FishingRodMenu(int containerId, Inventory inv, FriendlyByteBuf extraData) {
        this(containerId, inv, inv.player.getMainHandItem());
    }

    public FishingRodMenu(int containerId, Inventory inv, ItemStack itemStack) {
        super(ModMenuTypes.FISHING_ROD_MENU.get(), containerId);
        int i;
        this.is = itemStack;
        for (i = 0; i < 3; ++i) {
            for (int l = 0; l < 9; ++l) {
                this.addSlot(new Slot((Container)inv, l + i * 9 + 9, 8 + l * 18, 84 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)inv, i, 8 + i * 18, 142));
        }
        this.inventory.setStackInSlot(0, ((SingleStackContainer)this.is.get((DataComponentType)ModDataComponents.BOBBER.get())).stack().copy());
        this.inventory.setStackInSlot(1, ((SingleStackContainer)this.is.get((DataComponentType)ModDataComponents.BAIT.get())).stack().copy());
        this.inventory.setStackInSlot(2, ((SingleStackContainer)this.is.get((DataComponentType)ModDataComponents.HOOK.get())).stack().copy());
        this.addSlot((Slot)new SlotItemHandler(this, (IItemHandler)this.inventory, 0, 50, 35){

            public boolean mayPlace(ItemStack stack) {
                return stack.is(StarcatcherTags.BOBBERS);
            }
        });
        this.addSlot((Slot)new SlotItemHandler(this, (IItemHandler)this.inventory, 1, 80, 35){

            public boolean mayPlace(ItemStack stack) {
                return !stack.is(StarcatcherTags.HOOKS) && !stack.is(StarcatcherTags.BOBBERS);
            }
        });
        this.addSlot((Slot)new SlotItemHandler(this, (IItemHandler)this.inventory, 2, 110, 35){

            public boolean mayPlace(ItemStack stack) {
                return stack.is(StarcatcherTags.HOOKS);
            }
        });
    }

    protected boolean moveItemStackTo(ItemStack stack, int startIndex, int endIndex, boolean reverseDirection) {
        return super.moveItemStackTo(stack, startIndex, endIndex, reverseDirection);
    }

    public void clicked(int slotId, int button, ClickType clickType, Player player) {
        int hotbarSlotId;
        if (slotId >= 0 && this.getSlot(slotId).getItem().equals(this.is)) {
            return;
        }
        if (clickType == ClickType.SWAP && slotId == (hotbarSlotId = 29 + button)) {
            return;
        }
        super.clicked(slotId, button, clickType, player);
    }

    public void removed(Player player) {
        super.removed(player);
        if (!player.level().isClientSide) {
            this.is.set((DataComponentType)ModDataComponents.BOBBER.get(), (Object)new SingleStackContainer(this.inventory.getStackInSlot(0)));
            this.is.set((DataComponentType)ModDataComponents.BAIT.get(), (Object)new SingleStackContainer(this.inventory.getStackInSlot(1)));
            this.is.set((DataComponentType)ModDataComponents.HOOK.get(), (Object)new SingleStackContainer(this.inventory.getStackInSlot(2)));
        }
    }

    public ItemStack quickMoveStack(Player playerIn, int pIndex) {
        Slot sourceSlot = (Slot)this.slots.get(pIndex);
        if (!sourceSlot.hasItem()) {
            return ItemStack.EMPTY;
        }
        ItemStack sourceStack = sourceSlot.getItem();
        ItemStack copyOfSourceStack = sourceStack.copy();
        if (pIndex < 36) {
            if (!this.moveItemStackTo(sourceStack, 36, 39, false)) {
                return ItemStack.EMPTY;
            }
        } else if (pIndex < 39) {
            if (!this.moveItemStackTo(sourceStack, 0, 36, false)) {
                return ItemStack.EMPTY;
            }
        } else {
            return ItemStack.EMPTY;
        }
        if (sourceStack.getCount() == 0) {
            sourceSlot.set(ItemStack.EMPTY);
        } else {
            sourceSlot.setChanged();
        }
        sourceSlot.onTake(playerIn, sourceStack);
        return copyOfSourceStack;
    }

    public boolean stillValid(Player player) {
        return player.getMainHandItem().is((Item)ModItems.ROD.get());
    }
}

