/*
 * Decompiled with CFR 0.152.
 */
package com.wdiscute.starcatcher.guide;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.wdiscute.starcatcher.ModItems;
import com.wdiscute.starcatcher.Starcatcher;
import com.wdiscute.starcatcher.Tooltips;
import com.wdiscute.starcatcher.networkandcodecs.DataAttachments;
import com.wdiscute.starcatcher.networkandcodecs.FishCaughtCounter;
import com.wdiscute.starcatcher.networkandcodecs.FishProperties;
import com.wdiscute.starcatcher.networkandcodecs.ModDataComponents;
import com.wdiscute.starcatcher.networkandcodecs.Payloads;
import com.wdiscute.starcatcher.networkandcodecs.TrophyProperties;
import com.wdiscute.starcatcher.secretnotes.NoteContainer;
import com.wdiscute.starcatcher.secretnotes.SecretNoteScreen;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.network.PacketDistributor;

public class FishingGuideScreen
extends Screen {
    private static final ResourceLocation BACKGROUND = Starcatcher.rl("textures/gui/guide/background.png");
    private static final ResourceLocation HELP_PAGE_1 = Starcatcher.rl("textures/gui/guide/help_1.png");
    private static final ResourceLocation HELP_PAGE_2 = Starcatcher.rl("textures/gui/guide/help_2.png");
    private static final ResourceLocation ARROW_PREVIOUS = Starcatcher.rl("textures/gui/guide/arrow_previous.png");
    private static final ResourceLocation ARROW_PREVIOUS_PRESSED = Starcatcher.rl("textures/gui/guide/arrow_previous_pressed.png");
    private static final ResourceLocation ARROW_PREVIOUS_HIGHLIGHT = Starcatcher.rl("textures/gui/guide/arrow_previous_highlight.png");
    private static final ResourceLocation ARROW_NEXT = Starcatcher.rl("textures/gui/guide/arrow_next.png");
    private static final ResourceLocation ARROW_NEXT_PRESSED = Starcatcher.rl("textures/gui/guide/arrow_next_pressed.png");
    private static final ResourceLocation ARROW_NEXT_HIGHLIGHT = Starcatcher.rl("textures/gui/guide/arrow_next_highlight.png");
    private static final ResourceLocation ARROW_INDEX = Starcatcher.rl("textures/gui/guide/arrow_index.png");
    private static final ResourceLocation ARROW_INDEX_PRESSED = Starcatcher.rl("textures/gui/guide/arrow_index_pressed.png");
    private static final ResourceLocation ARROW_INDEX_HIGHLIGHT = Starcatcher.rl("textures/gui/guide/arrow_index_highlight.png");
    private static final ResourceLocation STAR = Starcatcher.rl("textures/gui/guide/star.png");
    private static final ResourceLocation GLOW = Starcatcher.rl("textures/gui/guide/glow.png");
    private static final int MAX_HELP_PAGES = 4;
    final boolean advancedTooltips;
    private final ItemStack basics;
    private final ItemStack treasures;
    private final ItemStack ironHook;
    private final ItemStack shinyHook;
    private final ItemStack goldHook;
    private final ItemStack mossyHook;
    private final ItemStack crystalHook;
    private final ItemStack stoneHook;
    private final ItemStack splitHook;
    private final ItemStack frugalBobber;
    private final ItemStack creeperBobber;
    private final ItemStack glitterBobber;
    private final ItemStack colorfulBobber;
    private final ItemStack steadyBobber;
    private final ItemStack impatientBobber;
    private final ItemStack frogBobber;
    private final ItemStack cherryBait;
    private final ItemStack lushBait;
    private final ItemStack sculkBait;
    private final ItemStack dripstoneBait;
    private final ItemStack murkwaterBait;
    private final ItemStack legendaryBait;
    private final ItemStack meteorologicalBait;
    private final ItemStack fishSpotter;
    private final ItemStack trophies;
    private final ItemStack secrets;
    int uiX;
    int uiY;
    int imageWidth;
    int imageHeight;
    int clickedX;
    int clickedY;
    boolean arrowPreviousPressed;
    boolean arrowNextPressed;
    boolean arrowIndexPressed;
    int menu = 0;
    int page = 0;
    boolean hasNextEntryPage;
    ClientLevel level;
    LocalPlayer player;
    List<FishProperties> fpsSeen = new ArrayList<FishProperties>();
    List<FishProperties> entries = new ArrayList<FishProperties>(999);
    List<TrophyProperties> trophiesTps = new ArrayList<TrophyProperties>();
    List<TrophyProperties> secretsTps = new ArrayList<TrophyProperties>();
    List<FishProperties> fishInArea = new ArrayList<FishProperties>();
    List<FishCaughtCounter> fishCaughtCounterList = new ArrayList<FishCaughtCounter>();
    TrophyProperties.RarityProgress all;
    TrophyProperties.RarityProgress common;
    TrophyProperties.RarityProgress uncommon;
    TrophyProperties.RarityProgress rare;
    TrophyProperties.RarityProgress epic;
    TrophyProperties.RarityProgress legendary;

    protected void m_7856_() {
        super.m_7856_();
        this.entries = new ArrayList<FishProperties>(999);
        this.trophiesTps = new ArrayList<TrophyProperties>(999);
        this.secretsTps = new ArrayList<TrophyProperties>(999);
        this.imageWidth = 512;
        this.imageHeight = 256;
        this.uiX = (this.f_96543_ - this.imageWidth) / 2;
        this.uiY = (this.f_96544_ - this.imageHeight) / 2;
        this.level = Minecraft.m_91087_().f_91073_;
        this.player = Minecraft.m_91087_().f_91074_;
        for (FishProperties fp : FishProperties.getFPs((Level)this.level)) {
            if (!fp.hasGuideEntry()) continue;
            this.entries.add(fp);
        }
        for (TrophyProperties tp : this.level.m_9598_().m_175515_(Starcatcher.TROPHY_REGISTRY)) {
            if (tp.trophyType() != TrophyProperties.TrophyType.TROPHY) continue;
            this.trophiesTps.add(tp);
        }
        for (TrophyProperties tp : this.level.m_9598_().m_175515_(Starcatcher.TROPHY_REGISTRY)) {
            if (tp.trophyType() != TrophyProperties.TrophyType.SECRET || !DataAttachments.get((Player)this.player).trophiesCaught().contains(tp)) continue;
            this.secretsTps.add(tp);
        }
        this.fishInArea = FishProperties.getFpsWithGuideEntryForArea((Entity)this.player);
        this.fishCaughtCounterList = DataAttachments.get((Player)this.player).fishesCaught();
        this.all = new TrophyProperties.RarityProgress(0, DataAttachments.get((Player)this.player).fishesCaught().size() - 1);
        this.common = new TrophyProperties.RarityProgress(0, -1);
        this.uncommon = TrophyProperties.RarityProgress.DEFAULT;
        this.rare = TrophyProperties.RarityProgress.DEFAULT;
        this.epic = TrophyProperties.RarityProgress.DEFAULT;
        this.legendary = TrophyProperties.RarityProgress.DEFAULT;
        for (FishCaughtCounter fcc : DataAttachments.get((Player)this.player).fishesCaught()) {
            this.all = new TrophyProperties.RarityProgress(this.all.total() + fcc.count(), this.all.unique());
            if (fcc.fp().rarity() == FishProperties.Rarity.COMMON) {
                this.common = new TrophyProperties.RarityProgress(this.common.total() + fcc.count(), this.common.unique() + 1);
            }
            if (fcc.fp().rarity() == FishProperties.Rarity.UNCOMMON) {
                this.uncommon = new TrophyProperties.RarityProgress(this.uncommon.total() + fcc.count(), this.uncommon.unique() + 1);
            }
            if (fcc.fp().rarity() == FishProperties.Rarity.RARE) {
                this.rare = new TrophyProperties.RarityProgress(this.rare.total() + fcc.count(), this.rare.unique() + 1);
            }
            if (fcc.fp().rarity() == FishProperties.Rarity.EPIC) {
                this.epic = new TrophyProperties.RarityProgress(this.epic.total() + fcc.count(), this.epic.unique() + 1);
            }
            if (fcc.fp().rarity() != FishProperties.Rarity.LEGENDARY) continue;
            this.legendary = new TrophyProperties.RarityProgress(this.legendary.total() + fcc.count(), this.legendary.unique() + 1);
        }
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        InputConstants.Key key = InputConstants.m_84827_((int)keyCode, (int)scanCode);
        if (this.f_96541_.f_91066_.f_92092_.isActiveAndMatches(key)) {
            this.m_7379_();
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        double x = mouseX - (double)this.uiX;
        double y = mouseY - (double)this.uiY;
        this.arrowIndexPressed = false;
        this.arrowNextPressed = false;
        this.arrowPreviousPressed = false;
        if (x > 65.0 && x < 95.0 && y > 225.0 && y < 240.0) {
            if (this.menu == 0 && this.page != 0) {
                this.f_96541_.f_91074_.m_216990_(SoundEvents.f_11713_);
                --this.page;
                return true;
            }
            if (this.menu == 1 && this.page == 0) {
                this.f_96541_.f_91074_.m_216990_(SoundEvents.f_11713_);
                this.menu = 0;
                this.page = 0;
                return true;
            }
            if (this.menu == 1) {
                this.f_96541_.f_91074_.m_216990_(SoundEvents.f_11713_);
                --this.page;
                return true;
            }
            if (this.menu == 2 && this.page == 0) {
                this.f_96541_.f_91074_.m_216990_(SoundEvents.f_11713_);
                this.menu = 1;
                this.page = 4;
                return true;
            }
            if (this.menu == 2) {
                this.f_96541_.f_91074_.m_216990_(SoundEvents.f_11713_);
                --this.page;
                return true;
            }
        }
        if (x > 420.0 && x < 440.0 && y > 230.0 && y < 240.0) {
            if (this.menu == 0 && this.hasNextEntryPage) {
                this.f_96541_.f_91074_.m_216990_(SoundEvents.f_11713_);
                ++this.page;
                return true;
            }
            if (this.menu == 0) {
                this.f_96541_.f_91074_.m_216990_(SoundEvents.f_11713_);
                this.menu = 1;
                this.page = 0;
                return true;
            }
            if (this.menu == 1 && this.page != 4) {
                this.f_96541_.f_91074_.m_216990_(SoundEvents.f_11713_);
                ++this.page;
                return true;
            }
            if (this.menu == 1) {
                this.f_96541_.f_91074_.m_216990_(SoundEvents.f_11713_);
                this.menu = 2;
                this.page = 0;
                return true;
            }
            if (this.menu == 2 && this.page <= this.entries.size() / 2 - 1) {
                this.f_96541_.f_91074_.m_216990_(SoundEvents.f_11713_);
                ++this.page;
                return true;
            }
            if (this.menu == 2) {
                return true;
            }
        }
        if (x > 225.0 && x < 245.0 && y > 223.0 && y < 243.0) {
            this.f_96541_.f_91074_.m_216990_(SoundEvents.f_11713_);
            this.menu = 0;
            this.page = 0;
            return true;
        }
        if (button == 0) {
            this.clickedX = (int)mouseX;
            this.clickedY = (int)mouseY;
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        double x = mouseX - (double)this.uiX;
        double y = mouseY - (double)this.uiY;
        if (x > 65.0 && x < 95.0 && y > 225.0 && y < 240.0 && (this.menu != 0 || this.page != 0)) {
            this.arrowPreviousPressed = true;
        }
        if (x > 420.0 && x < 440.0 && y > 230.0 && y < 240.0 && this.page <= this.entries.size() / 2 - 1) {
            this.arrowNextPressed = true;
        }
        if (x > 225.0 && x < 245.0 && y > 223.0 && y < 243.0) {
            this.arrowIndexPressed = true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        this.renderImage(guiGraphics, BACKGROUND);
        if (this.menu == 0) {
            this.renderIndex(guiGraphics, mouseX, mouseY);
        }
        if (this.menu == 1) {
            this.renderTheBasics(guiGraphics, mouseX, mouseY);
        }
        if (this.menu == 2) {
            this.renderEntry(guiGraphics, mouseX, mouseY, 70, this.page * 2);
            this.renderEntry(guiGraphics, mouseX, mouseY, 276, this.page * 2 + 1);
        }
        double x = mouseX - this.uiX;
        double y = mouseY - this.uiY;
        if (this.menu != 0 || this.page != 0) {
            if (x > 65.0 && x < 95.0 && y > 225.0 && y < 240.0) {
                guiGraphics.m_280163_(ARROW_PREVIOUS_HIGHLIGHT, this.uiX + 65, this.uiY + 227, 0.0f, 0.0f, 23, 13, 23, 13);
            }
            ResourceLocation previous = this.arrowPreviousPressed ? ARROW_PREVIOUS_PRESSED : ARROW_PREVIOUS;
            guiGraphics.m_280163_(previous, this.uiX + 65, this.uiY + 227, 0.0f, 0.0f, 23, 13, 23, 13);
            if (x > 225.0 && x < 245.0 && y > 223.0 && y < 243.0) {
                guiGraphics.m_280163_(ARROW_INDEX_HIGHLIGHT, this.uiX + 225, this.uiY + 223, 0.0f, 0.0f, 20, 20, 20, 20);
            }
            ResourceLocation index = this.arrowIndexPressed ? ARROW_INDEX_PRESSED : ARROW_INDEX;
            guiGraphics.m_280163_(index, this.uiX + 225, this.uiY + 223, 0.0f, 0.0f, 20, 20, 20, 20);
        }
        if (this.page <= this.entries.size() / 2 - 1) {
            if (x > 420.0 && x < 442.0 && y > 227.0 && y < 242.0) {
                guiGraphics.m_280163_(ARROW_NEXT_HIGHLIGHT, this.uiX + 420, this.uiY + 227, 0.0f, 0.0f, 23, 13, 23, 13);
            }
            ResourceLocation next = this.arrowNextPressed ? ARROW_NEXT_PRESSED : ARROW_NEXT;
            guiGraphics.m_280163_(next, this.uiX + 420, this.uiY + 227, 0.0f, 0.0f, 23, 13, 23, 13);
        }
        this.clickedX = 0;
        this.clickedY = 0;
    }

    private void renderHelpTitle(GuiGraphics guiGraphics, ItemStack is, Component comp, int x, int y) {
        this.renderItem(is, this.uiX + x + 10, this.uiY + y + 10, 2);
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_85841_(2.0f, 2.0f, 2.0f);
        guiGraphics.m_280614_(this.f_96547_, comp, this.uiX / 2 + x / 2 + 23, this.uiY / 2 + y / 2 + 6, -16777216, false);
        guiGraphics.m_280168_().m_85849_();
        guiGraphics.m_280637_(this.uiX + x - 2, this.uiY + y - 2, 40, 40, -16777216);
        guiGraphics.m_280637_(this.uiX + x - 1, this.uiY + y - 1, 38, 38, -16777216);
    }

    private void renderHelpText(GuiGraphics guiGraphics) {
        Component comp;
        int i;
        for (i = 0; i < 40 && I18n.m_118936_((String)("gui.guide.page" + this.page + ".left." + i)); ++i) {
            comp = Tooltips.decodeTranslationKey("gui.guide.page" + this.page + ".left." + i);
            guiGraphics.m_280614_(this.f_96547_, comp, this.uiX + 70, this.uiY + 10 * i + 10, -16777216, false);
        }
        for (i = 0; i < 40 && I18n.m_118936_((String)("gui.guide.page" + this.page + ".right." + i)); ++i) {
            comp = Tooltips.decodeTranslationKey("gui.guide.page" + this.page + ".right." + i);
            guiGraphics.m_280614_(this.f_96547_, comp, this.uiX + 278, this.uiY + 10 * i + 10, -16777216, false);
        }
    }

    private void renderItemWithOutlineAndHover(GuiGraphics guiGraphics, ItemStack is, int x, int y, int mouseX, int mouseY) {
        this.renderItem(is, this.uiX + x, this.uiY + y, 1);
        guiGraphics.m_280637_(this.uiX + x - 2, this.uiY + y - 2, 20, 20, -16777216);
        if (mouseX > this.uiX + x - 2 && mouseX < this.uiX + x - 2 + 20 && mouseY > this.uiY + y - 2 - 2 && mouseY < this.uiY + y - 2 + 20) {
            guiGraphics.m_280153_(this.f_96547_, is, mouseX, mouseY);
        }
    }

    private void renderSecrets(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        for (int i = 0; i < this.secretsTps.size(); ++i) {
            Item item;
            int rowSize = Math.min(7, this.secretsTps.size() - i / 7 * 7);
            int x = 90 - rowSize * 23 / 2;
            int xrender = x + i % 7 * 23;
            int y = i / 7 * 25;
            xrender += this.uiX + 280;
            y += this.uiY + 167;
            TrophyProperties tp = this.secretsTps.get(i);
            ItemStack is = new ItemStack((ItemLike)tp.fp().fish());
            if (!tp.customName().isEmpty()) {
                is.m_41714_((Component)Component.m_237113_((String)tp.customName()));
            }
            ModDataComponents.setTrophyProperties(is, tp);
            guiGraphics.m_280637_(xrender - 10, y - 2, 20, 20, -16777216);
            this.renderItem(is, xrender - 8, y, 1);
            if (mouseX > xrender - 10 && mouseX < xrender + 10 && mouseY > y - 2 && mouseY < y + 18) {
                guiGraphics.m_280153_(this.f_96547_, is, mouseX, mouseY);
            }
            if (this.clickedX <= xrender - 10 || this.clickedX >= xrender + 10 || this.clickedY <= y - 2 || this.clickedY >= y + 18 || !((item = is.m_41720_()) instanceof NoteContainer)) continue;
            NoteContainer nc = (NoteContainer)item;
            Minecraft.m_91087_().m_91152_((Screen)new SecretNoteScreen(nc.note));
        }
    }

    private void renderTrophies(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        for (int i = 0; i < this.trophiesTps.size(); ++i) {
            ItemStack is;
            boolean isMouseOnTop;
            int rowSize = Math.min(7, this.trophiesTps.size() - i / 7 * 7);
            int x = 90 - rowSize * 23 / 2;
            int xrender = x + i % 7 * 23;
            int y = i / 7 * 25;
            TrophyProperties tp = this.trophiesTps.get(i);
            boolean bl = isMouseOnTop = mouseX > (xrender += this.uiX + 75) - 10 && mouseX < xrender + 10 && mouseY > (y += this.uiY + 160) - 2 && mouseY < y + 18;
            if (DataAttachments.get((Player)this.player).trophiesCaught().contains(tp)) {
                is = new ItemStack((ItemLike)tp.fp().fish());
                is.m_41714_((Component)Component.m_237113_((String)tp.customName()));
                ModDataComponents.setTrophyProperties(is, tp);
                if (isMouseOnTop) {
                    guiGraphics.m_280153_(this.f_96547_, is, mouseX, mouseY);
                }
            } else {
                if (isMouseOnTop) {
                    ArrayList<MutableComponent> list = new ArrayList<MutableComponent>(List.of(Component.m_237113_((String)"Requirements:")));
                    if (tp.all().total() != 0) {
                        list.add(Component.m_237119_().m_7220_(Tooltips.decodeTranslationKey("gui.guide.trophy.all.total")).m_130946_("[" + this.all.total() + "/" + tp.all().total() + "]"));
                    }
                    if (tp.all().unique() != 0) {
                        list.add(Component.m_237119_().m_7220_(Tooltips.decodeTranslationKey("gui.guide.trophy.all.unique")).m_130946_("[" + this.all.unique() + "/" + tp.all().unique() + "]"));
                    }
                    if (tp.common().total() != 0) {
                        list.add(Component.m_237119_().m_7220_(Tooltips.decodeTranslationKey("gui.guide.trophy.common.total")).m_130946_("[" + this.common.total() + "/" + tp.common().total() + "]"));
                    }
                    if (tp.common().unique() != 0) {
                        list.add(Component.m_237119_().m_7220_(Tooltips.decodeTranslationKey("gui.guide.trophy.common.unique")).m_130946_("[" + this.common.unique() + "/" + tp.common().unique() + "]"));
                    }
                    if (tp.uncommon().total() != 0) {
                        list.add(Component.m_237119_().m_7220_(Tooltips.decodeTranslationKey("gui.guide.trophy.uncommon.total")).m_130946_("[" + this.uncommon.total() + "/" + tp.uncommon().total() + "]"));
                    }
                    if (tp.uncommon().unique() != 0) {
                        list.add(Component.m_237119_().m_7220_(Tooltips.decodeTranslationKey("gui.guide.trophy.uncommon.unique")).m_130946_("[" + this.uncommon.unique() + "/" + tp.uncommon().unique() + "]"));
                    }
                    if (tp.rare().total() != 0) {
                        list.add(Component.m_237119_().m_7220_(Tooltips.decodeTranslationKey("gui.guide.trophy.rare.total")).m_130946_("[" + this.rare.total() + "/" + tp.rare().total() + "]"));
                    }
                    if (tp.rare().unique() != 0) {
                        list.add(Component.m_237119_().m_7220_(Tooltips.decodeTranslationKey("gui.guide.trophy.rare.unique")).m_130946_("[" + this.rare.unique() + "/" + tp.rare().unique() + "]"));
                    }
                    if (tp.epic().total() != 0) {
                        list.add(Component.m_237119_().m_7220_(Tooltips.decodeTranslationKey("gui.guide.trophy.epic.total")).m_130946_("[" + this.epic.total() + "/" + tp.epic().total() + "]"));
                    }
                    if (tp.epic().unique() != 0) {
                        list.add(Component.m_237119_().m_7220_(Tooltips.decodeTranslationKey("gui.guide.trophy.epic.unique")).m_130946_("[" + this.epic.unique() + "/" + tp.epic().unique() + "]"));
                    }
                    if (tp.legendary().total() != 0) {
                        list.add(Component.m_237119_().m_7220_(Tooltips.decodeTranslationKey("gui.guide.trophy.legendary.total")).m_130946_("[" + this.legendary.total() + "/" + tp.legendary().total() + "]"));
                    }
                    if (tp.legendary().unique() != 0) {
                        list.add(Component.m_237119_().m_7220_(Tooltips.decodeTranslationKey("gui.guide.trophy.legendary.unique")).m_130946_("[" + this.legendary.unique() + "/" + tp.legendary().unique() + "]"));
                    }
                    guiGraphics.m_280677_(this.f_96547_, list, Optional.empty(), mouseX, mouseY);
                }
                is = new ItemStack((ItemLike)ModItems.MISSINGNO.get());
            }
            guiGraphics.m_280637_(xrender - 10, y - 2, 20, 20, -16777216);
            this.renderItem(is, xrender - 8, y, 1);
        }
    }

    private void renderTheBasics(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        this.renderHelpText(guiGraphics);
        if (this.page == 0) {
            this.renderImage(guiGraphics, HELP_PAGE_1);
            this.renderHelpTitle(guiGraphics, this.basics, (Component)Component.m_237115_((String)"gui.guide.basics"), 70, 15);
        }
        if (this.page == 1) {
            this.renderImage(guiGraphics, HELP_PAGE_2);
            this.renderHelpTitle(guiGraphics, this.treasures, (Component)Component.m_237115_((String)"gui.guide.treasures"), 70, 15);
        }
        if (this.page == 2) {
            this.renderHelpTitle(guiGraphics, this.ironHook, (Component)Component.m_237115_((String)"gui.guide.hooks"), 70, 15);
            this.renderItemWithOutlineAndHover(guiGraphics, this.ironHook, 85, 170, mouseX, mouseY);
            this.renderItemWithOutlineAndHover(guiGraphics, this.goldHook, 125, 170, mouseX, mouseY);
            this.renderItemWithOutlineAndHover(guiGraphics, this.shinyHook, 165, 170, mouseX, mouseY);
            this.renderItemWithOutlineAndHover(guiGraphics, this.crystalHook, 205, 170, mouseX, mouseY);
            this.renderItemWithOutlineAndHover(guiGraphics, this.mossyHook, 105, 200, mouseX, mouseY);
            this.renderItemWithOutlineAndHover(guiGraphics, this.splitHook, 145, 200, mouseX, mouseY);
            this.renderItemWithOutlineAndHover(guiGraphics, this.stoneHook, 185, 200, mouseX, mouseY);
            this.renderHelpTitle(guiGraphics, this.frugalBobber, (Component)Component.m_237115_((String)"gui.guide.bobbers"), 280, 15);
            this.renderItemWithOutlineAndHover(guiGraphics, this.creeperBobber, 288, 170, mouseX, mouseY);
            this.renderItemWithOutlineAndHover(guiGraphics, this.glitterBobber, 328, 170, mouseX, mouseY);
            this.renderItemWithOutlineAndHover(guiGraphics, this.colorfulBobber, 368, 170, mouseX, mouseY);
            this.renderItemWithOutlineAndHover(guiGraphics, this.frugalBobber, 408, 170, mouseX, mouseY);
            this.renderItemWithOutlineAndHover(guiGraphics, this.steadyBobber, 308, 200, mouseX, mouseY);
            this.renderItemWithOutlineAndHover(guiGraphics, this.impatientBobber, 348, 200, mouseX, mouseY);
            this.renderItemWithOutlineAndHover(guiGraphics, this.frogBobber, 388, 200, mouseX, mouseY);
        }
        if (this.page == 3) {
            this.renderHelpTitle(guiGraphics, this.cherryBait, (Component)Component.m_237115_((String)"gui.guide.baits"), 70, 15);
            this.renderItemWithOutlineAndHover(guiGraphics, this.cherryBait, 85, 170, mouseX, mouseY);
            this.renderItemWithOutlineAndHover(guiGraphics, this.lushBait, 125, 170, mouseX, mouseY);
            this.renderItemWithOutlineAndHover(guiGraphics, this.dripstoneBait, 165, 170, mouseX, mouseY);
            this.renderItemWithOutlineAndHover(guiGraphics, this.murkwaterBait, 205, 170, mouseX, mouseY);
            this.renderItemWithOutlineAndHover(guiGraphics, this.sculkBait, 105, 200, mouseX, mouseY);
            this.renderItemWithOutlineAndHover(guiGraphics, this.legendaryBait, 145, 200, mouseX, mouseY);
            this.renderItemWithOutlineAndHover(guiGraphics, this.meteorologicalBait, 185, 200, mouseX, mouseY);
            this.renderHelpTitle(guiGraphics, this.fishSpotter, (Component)Component.m_237115_((String)"gui.guide.gadgets"), 280, 15);
            this.renderItemWithOutlineAndHover(guiGraphics, this.fishSpotter, 350, 170, mouseX, mouseY);
        }
        if (this.page == 4) {
            this.renderHelpTitle(guiGraphics, this.trophies, (Component)Component.m_237115_((String)"gui.guide.trophies"), 70, 15);
            this.renderTrophies(guiGraphics, mouseX, mouseY);
            this.renderHelpTitle(guiGraphics, this.secrets, (Component)Component.m_237115_((String)"gui.guide.secrets"), 280, 15);
            this.renderHelpText(guiGraphics);
            this.renderSecrets(guiGraphics, mouseX, mouseY);
        }
    }

    private void renderIndex(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        int x = this.uiX + 70;
        int y = this.uiY + 30;
        int columnNumber = -1;
        int rowNumber = -1;
        int semiPageNumber = -this.page * 2;
        this.hasNextEntryPage = false;
        if (this.page == 0) {
            guiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)"gui.guide.fishing"), x + 25 + columnNumber * 25 + semiPageNumber * 205, y + 10 + rowNumber * 25, 0, false);
            ++rowNumber;
            int auxX = x - 2 + ++columnNumber * 25;
            guiGraphics.m_280637_(auxX, y - 2, 20, 20, -16777216);
            this.renderItem(new ItemStack((ItemLike)ModItems.ROD.get()), x + columnNumber * 25, y, 1);
            if (mouseX > auxX && mouseX < auxX + 20 && mouseY > y - 2 && mouseY < y + 20) {
                guiGraphics.m_280557_(this.f_96547_, (Component)Component.m_237115_((String)"gui.guide.basics"), mouseX, mouseY);
            }
            if (this.clickedX > auxX && this.clickedX < auxX + 20 && this.clickedY > y - 2 && this.clickedY < y + 20) {
                this.f_96541_.f_91074_.m_216990_(SoundEvents.f_11713_);
                this.menu = 1;
                this.page = 0;
            }
            auxX = x - 2 + ++columnNumber * 25;
            guiGraphics.m_280637_(auxX, y - 2, 20, 20, -16777216);
            this.renderItem(this.ironHook, x + columnNumber * 25, y, 1);
            if (mouseX > auxX && mouseX < auxX + 20 && mouseY > y - 2 && mouseY < y + 20) {
                guiGraphics.m_280557_(this.f_96547_, (Component)Component.m_237115_((String)"gui.guide.hooks"), mouseX, mouseY);
            }
            if (this.clickedX > auxX && this.clickedX < auxX + 20 && this.clickedY > y - 2 && this.clickedY < y + 20) {
                this.f_96541_.f_91074_.m_216990_(SoundEvents.f_11713_);
                this.menu = 1;
                this.page = 2;
            }
            auxX = x - 2 + ++columnNumber * 25;
            guiGraphics.m_280637_(auxX, y - 2, 20, 20, -16777216);
            this.renderItem(this.frugalBobber, x + columnNumber * 25, y, 1);
            if (mouseX > auxX && mouseX < auxX + 20 && mouseY > y - 2 && mouseY < y + 20) {
                guiGraphics.m_280557_(this.f_96547_, (Component)Component.m_237115_((String)"gui.guide.bobbers"), mouseX, mouseY);
            }
            if (this.clickedX > auxX && this.clickedX < auxX + 20 && this.clickedY > y - 2 && this.clickedY < y + 20) {
                this.f_96541_.f_91074_.m_216990_(SoundEvents.f_11713_);
                this.menu = 1;
                this.page = 2;
            }
            auxX = x - 2 + ++columnNumber * 25;
            guiGraphics.m_280637_(auxX, y - 2, 20, 20, -16777216);
            this.renderItem(this.cherryBait, x + columnNumber * 25, y, 1);
            if (mouseX > auxX && mouseX < auxX + 20 && mouseY > y - 2 && mouseY < y + 20) {
                guiGraphics.m_280557_(this.f_96547_, (Component)Component.m_237115_((String)"gui.guide.baits"), mouseX, mouseY);
            }
            if (this.clickedX > auxX && this.clickedX < auxX + 20 && this.clickedY > y - 2 && this.clickedY < y + 20) {
                this.f_96541_.f_91074_.m_216990_(SoundEvents.f_11713_);
                this.menu = 1;
                this.page = 3;
            }
            auxX = x - 2 + ++columnNumber * 25;
            guiGraphics.m_280637_(auxX, y - 2, 20, 20, -16777216);
            this.renderItem(this.fishSpotter, x + columnNumber * 25, y, 1);
            if (mouseX > auxX && mouseX < auxX + 20 && mouseY > y - 2 && mouseY < y + 20) {
                guiGraphics.m_280557_(this.f_96547_, (Component)Component.m_237115_((String)"gui.guide.gadgets"), mouseX, mouseY);
            }
            if (this.clickedX > auxX && this.clickedX < auxX + 20 && this.clickedY > y - 2 && this.clickedY < y + 20) {
                this.f_96541_.f_91074_.m_216990_(SoundEvents.f_11713_);
                this.menu = 1;
                this.page = 3;
            }
            auxX = x - 2 + ++columnNumber * 25;
            guiGraphics.m_280637_(auxX, y - 2, 20, 20, -16777216);
            this.renderItem(this.trophies, x + columnNumber * 25, y, 1);
            if (mouseX > auxX && mouseX < auxX + 20 && mouseY > y - 2 && mouseY < y + 20) {
                guiGraphics.m_280557_(this.f_96547_, (Component)Component.m_237115_((String)"gui.guide.trophies"), mouseX, mouseY);
            }
            if (this.clickedX > auxX && this.clickedX < auxX + 20 && this.clickedY > y - 2 && this.clickedY < y + 20) {
                this.f_96541_.f_91074_.m_216990_(SoundEvents.f_11713_);
                this.menu = 1;
                this.page = 4;
            }
            auxX = x - 2 + ++columnNumber * 25;
            guiGraphics.m_280637_(auxX, y - 2, 20, 20, -16777216);
            this.renderItem(this.secrets, x + columnNumber * 25, y, 1);
            if (mouseX > auxX && mouseX < auxX + 20 && mouseY > y - 2 && mouseY < y + 20) {
                guiGraphics.m_280557_(this.f_96547_, (Component)Component.m_237115_((String)"gui.guide.secrets"), mouseX, mouseY);
            }
            if (this.clickedX > auxX && this.clickedX < auxX + 20 && this.clickedY > y - 2 && this.clickedY < y + 20) {
                this.f_96541_.f_91074_.m_216990_(SoundEvents.f_11713_);
                this.menu = 1;
                this.page = 4;
            }
        } else {
            ++rowNumber;
        }
        ++rowNumber;
        columnNumber = -1;
        if (this.page == 0) {
            guiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)"gui.guide.available"), x + 25 + columnNumber * 25 + semiPageNumber * 205, y + 10 + rowNumber * 25, 0, false);
        }
        ++rowNumber;
        for (FishProperties fp : this.fishInArea) {
            if (++columnNumber > 6) {
                ++rowNumber;
                columnNumber = 0;
            }
            if (rowNumber > 7) {
                ++semiPageNumber;
                rowNumber = 0;
            }
            if (semiPageNumber > 1) break;
            if (semiPageNumber < 0) continue;
            this.renderFishIndex(guiGraphics, x + columnNumber * 25 + semiPageNumber * 205, y + rowNumber * 25, mouseX, mouseY, fp);
        }
        columnNumber = -1;
        if (++rowNumber > 6) {
            rowNumber = 0;
            ++semiPageNumber;
        }
        if (this.page == 0) {
            guiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)"gui.guide.all"), x + 25 + columnNumber * 25 + semiPageNumber * 205, y + 10 + rowNumber * 25, 0, false);
        }
        ++rowNumber;
        for (FishProperties fp : this.entries) {
            if (++columnNumber > 6) {
                ++rowNumber;
                columnNumber = 0;
            }
            if (rowNumber > 7) {
                ++semiPageNumber;
                rowNumber = 0;
            }
            if (semiPageNumber > 1) break;
            if (semiPageNumber < 0) continue;
            this.renderFishIndex(guiGraphics, x + columnNumber * 25 + semiPageNumber * 205, y + rowNumber * 25, mouseX, mouseY, fp);
        }
        if (semiPageNumber > 1) {
            this.hasNextEntryPage = true;
        }
    }

    private void renderFishIndex(GuiGraphics guiGraphics, int xOffset, int yOffset, int mouseX, int mouseY, FishProperties fp) {
        List<FishCaughtCounter> fishCounterList = DataAttachments.get((Player)this.player).fishesCaught();
        ItemStack is = new ItemStack((ItemLike)fp.fish());
        int caught = 0;
        for (FishCaughtCounter f : fishCounterList) {
            if (!fp.equals(f.fp())) continue;
            caught = f.count();
            break;
        }
        if (this.clickedX > xOffset - 3 && this.clickedX < xOffset + 21 - 3 && this.clickedY > yOffset - 3 && this.clickedY < yOffset + 21 - 3) {
            this.f_96541_.f_91074_.m_216990_(SoundEvents.f_11713_);
            this.menu = 2;
            this.page = this.entries.indexOf(fp) / 2;
        }
        guiGraphics.m_280637_(xOffset - 2, yOffset - 2, 20, 20, -15654349);
        switch (fp.rarity()) {
            case COMMON: {
                guiGraphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
                break;
            }
            case UNCOMMON: {
                guiGraphics.m_280246_(0.7f, 1.0f, 0.7f, 1.0f);
                break;
            }
            case RARE: {
                guiGraphics.m_280246_(0.2f, 0.4f, 0.7f, 0.7f);
                break;
            }
            case EPIC: {
                guiGraphics.m_280246_(1.0f, 0.0f, 1.0f, 0.5f);
                break;
            }
            case LEGENDARY: {
                Color color = Color.getHSBColor(Tooltips.hue * 2.0f, 1.0f, 1.0f);
                float r = (float)color.getRed() / 255.0f;
                float g = (float)color.getGreen() / 255.0f;
                float b = (float)color.getBlue() / 255.0f;
                guiGraphics.m_280246_(r, g, b, 0.7f);
            }
        }
        RenderSystem.enableBlend();
        guiGraphics.m_280163_(GLOW, xOffset - 1, yOffset - 1, 0.0f, 0.0f, 18, 18, 18, 18);
        RenderSystem.disableBlend();
        guiGraphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        if (caught != 0) {
            this.renderItem(is, xOffset, yOffset, 1);
        } else {
            this.renderItem(new ItemStack((ItemLike)ModItems.MISSINGNO.get()), xOffset, yOffset, 1);
        }
        for (FishProperties fpNotif : DataAttachments.get((Player)this.player).fishNotifications()) {
            if (!fp.equals(fpNotif)) continue;
            guiGraphics.m_280163_(STAR, xOffset + 10, yOffset + 7, 0.0f, 0.0f, 10, 10, 10, 10);
        }
        if (mouseX > xOffset - 3 && mouseX < xOffset + 21 - 3 && mouseY > yOffset - 3 && mouseY < yOffset + 21 - 3) {
            ArrayList<Object> components = new ArrayList<Object>();
            if (caught == 0) {
                components.add(Component.m_237115_((String)"gui.guide.not_caught_fish_name"));
                components.add(Component.m_237115_((String)"gui.guide.not_caught").m_130948_(Style.f_131099_.m_178520_(0xAA0000)));
                components.add(Tooltips.decodeTranslationKey("gui.guide.rarity." + fp.rarity().m_7912_()));
            } else {
                if (fp.customName().isEmpty()) {
                    components.add(Component.m_237115_((String)fp.fish().m_5524_()));
                } else {
                    components.add(Component.m_237115_((String)("item.starcatcher." + fp.customName())));
                }
                components.add(Component.m_237115_((String)"gui.guide.caught").m_7220_((Component)Component.m_237113_((String)("[" + caught + "]"))).m_130948_(Style.f_131099_.m_178520_(43520)));
            }
            guiGraphics.m_280677_(this.f_96547_, components, Optional.empty(), mouseX, mouseY);
        }
    }

    private void renderEntry(GuiGraphics guiGraphics, int mouseX, int mouseY, int xOffset, int entry) {
        List<ResourceLocation> fluids;
        MutableComponent comp;
        MutableComponent comp2;
        Object c;
        if (this.level == null) {
            this.level = this.getMinecraft().f_91073_;
        }
        double x = mouseX - this.uiX;
        double y = mouseY - this.uiY;
        if (this.entries.size() <= entry) {
            return;
        }
        ItemStack is = new ItemStack((ItemLike)this.entries.get(entry).fish());
        FishProperties fp = this.entries.get(entry);
        if (!this.fpsSeen.contains(fp)) {
            this.fpsSeen.add(fp);
        }
        FishCaughtCounter fcc = null;
        for (FishCaughtCounter fccAll : this.fishCaughtCounterList) {
            if (!fp.equals(fccAll.fp())) continue;
            fcc = fccAll;
            break;
        }
        if (fcc == null) {
            guiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)"gui.guide.not_caught_fish_name"), this.uiX + xOffset + 46, this.uiY + 55, 0, false);
            guiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)"gui.guide.not_caught").m_130948_(Style.f_131099_.m_178520_(0xAA0000)), this.uiX + xOffset + 46, this.uiY + 65, 0, false);
            guiGraphics.m_280614_(this.f_96547_, Tooltips.decodeTranslationKey("gui.guide.rarity." + fp.rarity().m_7912_()), this.uiX + xOffset + 46, this.uiY + 75, 0, false);
            this.renderItem(new ItemStack((ItemLike)ModItems.MISSINGNO.get()), this.uiX + xOffset + 10, this.uiY + 60);
        } else {
            MutableComponent compName = fp.customName().isEmpty() ? Component.m_237115_((String)fp.fish().m_5524_()) : Component.m_237115_((String)("item.starcatcher." + fp.customName()));
            guiGraphics.m_280614_(this.f_96547_, (Component)compName, this.uiX + xOffset + 46, this.uiY + 55, 0, false);
            c = Component.m_237113_((String)("[" + fcc.count() + "]")).m_130948_(Style.f_131099_.m_178520_(43520));
            guiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)"gui.guide.caught").m_7220_((Component)c).m_130948_(Style.f_131099_.m_178520_(43520)), this.uiX + xOffset + 46, this.uiY + 65, 0, false);
            Component rarity = Tooltips.decodeTranslationKey("gui.guide.rarity." + fp.rarity().m_7912_());
            guiGraphics.m_280614_(this.f_96547_, rarity, this.uiX + xOffset + 46, this.uiY + 75, 0, false);
            this.renderItem(is, this.uiX + xOffset + 10, this.uiY + 60);
            switch (fp.rarity()) {
                case COMMON: {
                    guiGraphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
                    break;
                }
                case UNCOMMON: {
                    guiGraphics.m_280246_(0.7f, 1.0f, 0.7f, 1.0f);
                    break;
                }
                case RARE: {
                    guiGraphics.m_280246_(0.2f, 0.4f, 0.7f, 0.7f);
                    break;
                }
                case EPIC: {
                    guiGraphics.m_280246_(1.0f, 0.0f, 1.0f, 0.5f);
                    break;
                }
                case LEGENDARY: {
                    Color color = Color.getHSBColor(Tooltips.hue, 1.0f, 1.0f);
                    float r = (float)color.getRed() / 255.0f;
                    float g = (float)color.getGreen() / 255.0f;
                    float b = (float)color.getBlue() / 255.0f;
                    guiGraphics.m_280246_(r, g, b, 0.7f);
                }
            }
            RenderSystem.enableBlend();
            guiGraphics.m_280163_(GLOW, this.uiX + xOffset - 6, this.uiY + 40, 0.0f, 0.0f, 48, 48, 48, 48);
            RenderSystem.disableBlend();
            guiGraphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
            if (mouseX > this.uiX + xOffset + 46 && mouseX < this.uiX + xOffset + 150 && mouseY > this.uiY + 57 && mouseY < this.uiY + 80) {
                ArrayList<MutableComponent> components = new ArrayList<MutableComponent>();
                components.add(Component.m_237113_((String)("Fastest Catch: " + (float)(fcc.fastestTicks() / 20) + "s")));
                components.add(Component.m_237113_((String)("Average: " + fcc.averageTicks() / 20.0f + "s")));
                guiGraphics.m_280677_(this.f_96547_, components, Optional.empty(), mouseX, mouseY);
            }
        }
        int yOffset = 110;
        if (fp.wr().dims().isEmpty()) {
            comp2 = Component.m_237115_((String)"gui.guide.no_restriction");
        } else if (fp.wr().dims().size() == 1) {
            comp2 = Component.m_237115_((String)("dimension." + fp.wr().dims().get(0).m_214298_()));
        } else {
            comp2 = Component.m_237115_((String)"gui.guide.hover");
            if (x > (double)xOffset && x < (double)(xOffset + 100) && y > (double)(yOffset - 2) && y < (double)(yOffset + 10)) {
                ArrayList<MutableComponent> c2 = new ArrayList<MutableComponent>();
                c2.add(Component.m_237115_((String)"gui.guide.dimensions"));
                for (int i = 0; i < fp.wr().dims().size(); ++i) {
                    c2.add(Component.m_237115_((String)("dimension." + fp.wr().dims().get(i).m_214298_())));
                }
                guiGraphics.m_280677_(this.f_96547_, c2, Optional.empty(), mouseX, mouseY);
            }
        }
        comp2 = fp.wr().dims().isEmpty() ? comp2.m_6881_().m_130948_(Style.f_131099_.m_178520_(43520)) : (fp.wr().dims().contains(this.level.m_46472_().m_135782_()) ? comp2.m_6881_().m_130948_(Style.f_131099_.m_178520_(43520)) : comp2.m_6881_().m_130948_(Style.f_131099_.m_178520_(0xAA0000)));
        MutableComponent start = Component.m_237115_((String)"gui.guide.dimension");
        guiGraphics.m_280614_(this.f_96547_, (Component)start.m_6881_().m_7220_((Component)comp2), this.uiX + xOffset, this.uiY + yOffset, 0, false);
        if (!fp.wr().dimsBlacklist().isEmpty()) {
            guiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237113_((String)"[!]").m_130948_(Style.f_131099_.m_178520_(0xAA0000)), this.uiX + xOffset + 160, this.uiY + yOffset, 0, false);
            if (x > (double)(xOffset + 155) && x < (double)(xOffset + 175) && y > (double)(yOffset - 4) && y < (double)(yOffset + 12)) {
                c = new ArrayList();
                c.add(Component.m_237115_((String)"gui.guide.blacklisted_dimensions"));
                for (int i = 0; i < fp.wr().dimsBlacklist().size(); ++i) {
                    c.add(Component.m_237113_((String)fp.wr().dimsBlacklist().get(i).toString()));
                }
                guiGraphics.m_280677_(this.f_96547_, (List)c, Optional.empty(), mouseX, mouseY);
            }
        }
        yOffset += 15;
        List<ResourceLocation> biomesBL = FishProperties.getBiomesBlacklistAsList(fp, (Level)this.level);
        List<ResourceLocation> biomes = FishProperties.getBiomesAsList(fp, (Level)this.level);
        if (biomes.isEmpty()) {
            comp = Component.m_237115_((String)"gui.guide.no_restriction");
            if (!biomesBL.isEmpty()) {
                comp.m_130946_("*");
            }
        } else if (biomes.size() == 1) {
            comp = Component.m_237115_((String)("biome." + biomes.get(0).m_214298_()));
        } else if (fp.wr().biomesTags().size() == 1) {
            comp = Component.m_237115_((String)("tag." + fp.wr().biomesTags().get(0).m_214298_()));
            if (x > (double)xOffset && x < (double)(xOffset + 100) && y > (double)(yOffset - 2) && y < (double)(yOffset + 10)) {
                ArrayList<MutableComponent> c3 = new ArrayList<MutableComponent>();
                if (!fp.wr().biomesTags().isEmpty()) {
                    c3.add(Component.m_237115_((String)"gui.guide.biome_tags").m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(true))));
                    for (ResourceLocation rl : fp.wr().biomesTags()) {
                        c3.add(Component.m_237115_((String)("tag." + rl.m_214298_())));
                    }
                    c3.add(Component.m_237119_());
                }
                c3.add(Component.m_237115_((String)"gui.guide.biomes").m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(true))));
                for (ResourceLocation rl : biomes) {
                    c3.add(Component.m_237115_((String)("biome." + rl.m_214298_())));
                }
                guiGraphics.m_280677_(this.f_96547_, c3, Optional.empty(), mouseX, mouseY);
            }
        } else {
            comp = Component.m_237115_((String)"gui.guide.hover");
            if (x > (double)xOffset && x < (double)(xOffset + 100) && y > (double)(yOffset - 2) && y < (double)(yOffset + 10)) {
                ArrayList<MutableComponent> c4 = new ArrayList<MutableComponent>();
                c4.add(Component.m_237115_((String)"gui.guide.biome"));
                for (ResourceLocation rl : biomes) {
                    c4.add(Component.m_237115_((String)("biome." + rl.m_214298_())));
                }
                guiGraphics.m_280677_(this.f_96547_, c4, Optional.empty(), mouseX, mouseY);
            }
        }
        ResourceLocation rl = FishingGuideScreen.getBiomeRL((Holder<Biome>)this.level.m_204166_(Minecraft.m_91087_().f_91074_.m_20183_()));
        comp = comp.m_6881_().m_130948_(Style.f_131099_.m_178520_(43520));
        if (!biomes.contains(rl) && !biomes.isEmpty()) {
            comp = comp.m_6881_().m_130948_(Style.f_131099_.m_178520_(0xAA0000));
        }
        if (biomesBL.contains(rl)) {
            comp = comp.m_6881_().m_130948_(Style.f_131099_.m_178520_(0xAA0000));
        }
        MutableComponent start2 = Component.m_237115_((String)"gui.guide.biome");
        guiGraphics.m_280614_(this.f_96547_, (Component)start2.m_6881_().m_7220_((Component)comp), this.uiX + xOffset, this.uiY + yOffset, 0, false);
        if (!biomesBL.isEmpty()) {
            guiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237113_((String)"[!]").m_130948_(Style.f_131099_.m_178520_(0xAA0000)), this.uiX + xOffset + 160, this.uiY + yOffset, 0, false);
            if (x > (double)(xOffset + 155) && x < (double)(xOffset + 175) && y > (double)(yOffset - 4) && y < (double)(yOffset + 12)) {
                ArrayList<MutableComponent> c5 = new ArrayList<MutableComponent>();
                if (!fp.wr().biomesBlacklistTags().isEmpty()) {
                    c5.add(Component.m_237115_((String)"gui.guide.blacklisted_biome_tags").m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(true))));
                    for (ResourceLocation rl2 : fp.wr().biomesBlacklistTags()) {
                        c5.add(Component.m_237115_((String)("tag." + rl2.m_214298_())));
                    }
                    c5.add(Component.m_237119_());
                }
                c5.add(Component.m_237115_((String)"gui.guide.blacklisted_biomes").m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(true))));
                for (ResourceLocation rl2 : biomesBL) {
                    c5.add(Component.m_237115_((String)("biome." + rl2.m_214298_())));
                }
                guiGraphics.m_280677_(this.f_96547_, c5, Optional.empty(), mouseX, mouseY);
            }
        }
        if (!fp.br().correctBait().isEmpty()) {
            yOffset += 15;
            ItemStack bait = new ItemStack((ItemLike)BuiltInRegistries.f_257033_.m_7745_(fp.br().correctBait().get(0)));
            int bonus = fp.br().correctBaitChanceAdded() / fp.baseChance() * 100;
            MutableComponent extra = Component.m_237113_((String)(" (+" + bonus + "%)"));
            if (bait.m_150930_((Item)ModItems.LEGENDARY_BAIT.get())) {
                guiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)"gui.guide.bait").m_7220_(Tooltips.RGBEachLetter(I18n.m_118938_((String)bait.m_41778_(), (Object[])new Object[0]))).m_7220_((Component)extra), this.uiX + xOffset, this.uiY + yOffset, 0, false);
            } else {
                guiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)"gui.guide.bait").m_7220_((Component)Component.m_237115_((String)bait.m_41778_())).m_7220_((Component)extra), this.uiX + xOffset, this.uiY + yOffset, 0, false);
            }
            if (x > (double)xOffset && x < (double)(xOffset + 100) && y > (double)(yOffset - 2) && y < (double)(yOffset + 10)) {
                guiGraphics.m_280153_(this.f_96547_, bait, mouseX, mouseY);
            }
        }
        yOffset += 15;
        if (fp.weather() == FishProperties.Weather.ALL) {
            comp = Component.m_237115_((String)"gui.guide.no_restriction").m_130948_(Style.f_131099_.m_178520_(43520));
        } else {
            comp = Component.m_237115_((String)"gui.guide.no_restriction");
            if (fp.weather() == FishProperties.Weather.RAIN) {
                comp = (double)this.level.m_46722_(0.0f) > 0.5 ? Component.m_237115_((String)"gui.guide.raining").m_130948_(Style.f_131099_.m_178520_(43520)) : Component.m_237115_((String)"gui.guide.raining").m_130948_(Style.f_131099_.m_178520_(0xAA0000));
            }
            if (fp.weather() == FishProperties.Weather.THUNDER) {
                comp = (double)this.level.m_46661_(0.0f) > 0.5 ? Component.m_237115_((String)"gui.guide.thundering").m_130948_(Style.f_131099_.m_178520_(43520)) : Component.m_237115_((String)"gui.guide.thundering").m_130948_(Style.f_131099_.m_178520_(0xAA0000));
            }
            if (fp.weather() == FishProperties.Weather.CLEAR) {
                comp = (double)this.level.m_46722_(0.0f) > 0.5 || (double)this.level.m_46661_(0.0f) > 0.5 ? Component.m_237115_((String)"gui.guide.clear").m_130948_(Style.f_131099_.m_178520_(0xAA0000)) : Component.m_237115_((String)"gui.guide.clear").m_130948_(Style.f_131099_.m_178520_(43520));
            }
        }
        MutableComponent start3 = Component.m_237115_((String)"gui.guide.weather");
        guiGraphics.m_280614_(this.f_96547_, (Component)start3.m_6881_().m_7220_((Component)comp), this.uiX + xOffset, this.uiY + yOffset, 0, false);
        yOffset += 15;
        if (fp.daytime() == FishProperties.Daytime.ALL) {
            comp = Component.m_237115_((String)"gui.guide.no_restriction").m_130948_(Style.f_131099_.m_178520_(43520));
        } else {
            long time = this.level.m_46468_() % 24000L;
            comp = switch (fp.daytime()) {
                case FishProperties.Daytime.DAY -> {
                    if (time <= 23000L && time >= 12700L) {
                        yield Component.m_237115_((String)"gui.guide.day").m_130948_(Style.f_131099_.m_178520_(0xAA0000));
                    }
                    yield Component.m_237115_((String)"gui.guide.day").m_130948_(Style.f_131099_.m_178520_(43520));
                }
                case FishProperties.Daytime.NOON -> {
                    if (time <= 3500L || time >= 8500L) {
                        yield Component.m_237115_((String)"gui.guide.noon").m_130948_(Style.f_131099_.m_178520_(0xAA0000));
                    }
                    yield Component.m_237115_((String)"gui.guide.noon").m_130948_(Style.f_131099_.m_178520_(43520));
                }
                case FishProperties.Daytime.NIGHT -> {
                    if (time >= 23000L || time <= 12700L) {
                        yield Component.m_237115_((String)"gui.guide.night").m_130948_(Style.f_131099_.m_178520_(0xAA0000));
                    }
                    yield Component.m_237115_((String)"gui.guide.night").m_130948_(Style.f_131099_.m_178520_(43520));
                }
                case FishProperties.Daytime.MIDNIGHT -> {
                    if (time <= 16500L || time >= 19500L) {
                        yield Component.m_237115_((String)"gui.guide.midnight").m_130948_(Style.f_131099_.m_178520_(0xAA0000));
                    }
                    yield Component.m_237115_((String)"gui.guide.midnight").m_130948_(Style.f_131099_.m_178520_(43520));
                }
                default -> Component.m_237119_();
            };
        }
        start = Component.m_237115_((String)"gui.guide.daytime");
        guiGraphics.m_280614_(this.f_96547_, (Component)start.m_6881_().m_7220_((Component)comp), this.uiX + xOffset, this.uiY + yOffset, 0, false);
        int above = fp.mustBeCaughtAboveY();
        int below = fp.mustBeCaughtBelowY();
        if (above != Integer.MIN_VALUE || below != Integer.MAX_VALUE) {
            yOffset += 15;
            MutableComponent belowAbove = Component.m_237119_();
            if (above != Integer.MIN_VALUE) {
                belowAbove.m_7220_((Component)Component.m_237115_((String)"gui.guide.above")).m_130946_("" + above);
            }
            if (above != Integer.MIN_VALUE && below != Integer.MAX_VALUE) {
                belowAbove.m_130946_(", ");
            }
            if (below != Integer.MAX_VALUE) {
                belowAbove.m_7220_((Component)Component.m_237115_((String)"gui.guide.below")).m_130946_("" + below);
            }
            MutableComponent comp3 = belowAbove;
            if (above == 100 && below == Integer.MAX_VALUE) {
                comp3 = Component.m_237115_((String)"gui.guide.mountain");
            } else if (above == 50 && below == 100) {
                comp3 = Component.m_237115_((String)"gui.guide.surface");
            } else if (above == 0 && below == Integer.MAX_VALUE) {
                comp3 = Component.m_237115_((String)"gui.guide.surface");
            } else if (above == Integer.MIN_VALUE && below == 50) {
                comp3 = Component.m_237115_((String)"gui.guide.underground");
            } else if (above == 0 && below == 50) {
                comp3 = Component.m_237115_((String)"gui.guide.caves");
            } else if (above == Integer.MIN_VALUE && below == 0) {
                comp3 = Component.m_237115_((String)"gui.guide.deepslate");
            }
            if (this.player.m_20186_() > (double)above && this.player.m_20186_() < (double)below) {
                comp3.m_130948_(Style.f_131099_.m_178520_(43520));
            } else {
                comp3.m_130948_(Style.f_131099_.m_178520_(0xAA0000));
            }
            if (x > (double)xOffset && x < (double)(xOffset + 140) && y > (double)(yOffset - 2) && y < (double)(yOffset + 10) && comp3 != belowAbove) {
                guiGraphics.m_280557_(this.f_96547_, (Component)belowAbove, mouseX, mouseY);
            }
            guiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)"gui.guide.elevation").m_7220_((Component)comp3), this.uiX + xOffset, this.uiY + yOffset, 0, false);
        }
        if (!(fluids = fp.wr().fluids()).equals(FishProperties.WorldRestrictions.DEFAULT.fluids())) {
            MutableComponent comp4;
            yOffset += 15;
            if (fluids.size() == 1) {
                comp4 = Component.m_237115_((String)("block." + fluids.get(0).m_214298_()));
            } else {
                comp4 = Component.m_237115_((String)"gui.guide.hover");
                if (x > (double)xOffset && x < (double)(xOffset + 100) && y > (double)(yOffset - 2) && y < (double)(yOffset + 10)) {
                    ArrayList<MutableComponent> c6 = new ArrayList<MutableComponent>();
                    c6.add(Component.m_237115_((String)"gui.guide.fluids"));
                    for (ResourceLocation rl3 : fluids) {
                        c6.add(Component.m_237115_((String)("block." + rl3.m_214298_())));
                    }
                    guiGraphics.m_280677_(this.f_96547_, c6, Optional.empty(), mouseX, mouseY);
                }
            }
            guiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)"gui.guide.fluids").m_7220_((Component)comp4), this.uiX + xOffset, this.uiY + yOffset, 0, false);
        }
    }

    private void renderImage(GuiGraphics guiGraphics, ResourceLocation rl) {
        guiGraphics.m_280163_(rl, this.uiX, this.uiY, 0.0f, 0.0f, 512, 256, 512, 256);
    }

    private void renderImage(GuiGraphics guiGraphics, ResourceLocation rl, int yOffset) {
        guiGraphics.m_280163_(rl, this.uiX, this.uiY + yOffset, 0.0f, 0.0f, 512, 256, 512, 256);
    }

    private void renderItem(ItemStack stack, int x, int y) {
        this.renderItem(stack, x, y, 3);
    }

    private void renderItem(ItemStack stack, int x, int y, int scale) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        LocalPlayer entity = Minecraft.m_91087_().f_91074_;
        if (!stack.m_41619_()) {
            boolean usesBlockLight;
            BakedModel bakedmodel = this.f_96541_.m_91291_().m_174264_(stack, (Level)level, (LivingEntity)entity, 234234);
            PoseStack pose = new PoseStack();
            pose.m_85836_();
            pose.m_252880_((float)(x + 8), (float)(y + 8), 150.0f);
            pose.m_85841_(16.0f * (float)scale, -16.0f * (float)scale, 16.0f * (float)scale);
            boolean bl = usesBlockLight = !bakedmodel.m_7547_();
            if (usesBlockLight) {
                Lighting.m_84930_();
            }
            this.f_96541_.m_91291_().m_115143_(stack, ItemDisplayContext.GUI, false, pose, (MultiBufferSource)Minecraft.m_91087_().m_91269_().m_110104_(), 0xF000F0, OverlayTexture.f_118083_, bakedmodel);
            RenderSystem.disableDepthTest();
            Minecraft.m_91087_().m_91269_().m_110104_().m_109911_();
            RenderSystem.enableDepthTest();
            if (usesBlockLight) {
                Lighting.m_84931_();
            }
            pose.m_85849_();
        }
    }

    public static ResourceLocation getBiomeRL(Holder<Biome> biome) {
        return ResourceLocation.parse((String)biome.m_203543_().map(p_316542_ -> p_316542_.m_135782_().toString()).orElse("starcatcher:error"));
    }

    public void m_7379_() {
        Minecraft.m_91087_().f_91066_.f_92125_ = this.advancedTooltips;
        ArrayList<ResourceLocation> notifRLs = new ArrayList<ResourceLocation>();
        Registry fishProperties = this.player.m_9236_().m_9598_().m_175515_(Starcatcher.FISH_REGISTRY);
        for (FishProperties fp : this.fpsSeen) {
            ResourceLocation rl = fishProperties.m_7981_((Object)fp);
            if (rl == null) {
                rl = Starcatcher.rl("missingno");
            }
            notifRLs.add(rl);
        }
        Payloads.CHANNEL.send(PacketDistributor.SERVER.with(null), (Object)new Payloads.FishesSeenPayload(notifRLs));
        super.m_7379_();
    }

    public boolean m_7043_() {
        return false;
    }

    protected boolean m_264396_() {
        return false;
    }

    public FishingGuideScreen() {
        super((Component)Component.m_237119_());
        this.all = new TrophyProperties.RarityProgress(0, DataAttachments.get((Player)Minecraft.m_91087_().f_91074_).fishesCaught().size() - 1);
        this.common = new TrophyProperties.RarityProgress(0, -1);
        this.uncommon = TrophyProperties.RarityProgress.DEFAULT;
        this.rare = TrophyProperties.RarityProgress.DEFAULT;
        this.epic = TrophyProperties.RarityProgress.DEFAULT;
        this.legendary = TrophyProperties.RarityProgress.DEFAULT;
        this.basics = new ItemStack((ItemLike)ModItems.ROD.get());
        this.treasures = new ItemStack((ItemLike)ModItems.WATERLOGGED_SATCHEL.get());
        this.ironHook = new ItemStack((ItemLike)ModItems.HOOK.get());
        this.shinyHook = new ItemStack((ItemLike)ModItems.SHINY_HOOK.get());
        this.goldHook = new ItemStack((ItemLike)ModItems.GOLD_HOOK.get());
        this.mossyHook = new ItemStack((ItemLike)ModItems.MOSSY_HOOK.get());
        this.crystalHook = new ItemStack((ItemLike)ModItems.CRYSTAL_HOOK.get());
        this.stoneHook = new ItemStack((ItemLike)ModItems.STONE_HOOK.get());
        this.splitHook = new ItemStack((ItemLike)ModItems.SPLIT_HOOK.get());
        this.frugalBobber = new ItemStack((ItemLike)ModItems.FRUGAL_BOBBER.get());
        this.creeperBobber = new ItemStack((ItemLike)ModItems.CREEPER_BOBBER.get());
        this.glitterBobber = new ItemStack((ItemLike)ModItems.GLITTER_BOBBER.get());
        this.colorfulBobber = new ItemStack((ItemLike)ModItems.COLORFUL_BOBBER.get());
        this.steadyBobber = new ItemStack((ItemLike)ModItems.STEADY_BOBBER.get());
        this.impatientBobber = new ItemStack((ItemLike)ModItems.IMPATIENT_BOBBER.get());
        this.frogBobber = new ItemStack((ItemLike)ModItems.FROG_BOBBER.get());
        this.cherryBait = new ItemStack((ItemLike)ModItems.CHERRY_BAIT.get());
        this.lushBait = new ItemStack((ItemLike)ModItems.LUSH_BAIT.get());
        this.sculkBait = new ItemStack((ItemLike)ModItems.SCULK_BAIT.get());
        this.dripstoneBait = new ItemStack((ItemLike)ModItems.DRIPSTONE_BAIT.get());
        this.murkwaterBait = new ItemStack((ItemLike)ModItems.MURKWATER_BAIT.get());
        this.legendaryBait = new ItemStack((ItemLike)ModItems.LEGENDARY_BAIT.get());
        this.meteorologicalBait = new ItemStack((ItemLike)ModItems.METEOROLOGICAL_BAIT.get());
        this.fishSpotter = new ItemStack((ItemLike)ModItems.FISH_SPOTTER.get());
        this.trophies = new ItemStack((ItemLike)ModItems.TROPHY_GOLD.get());
        this.secrets = new ItemStack((ItemLike)ModItems.WATERLOGGED_BOTTLE.get());
        this.advancedTooltips = Minecraft.m_91087_().f_91066_.f_92125_;
        Minecraft.m_91087_().f_91066_.f_92125_ = Minecraft.m_91087_().f_91074_.m_7500_() && this.advancedTooltips;
    }
}

